/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell.hbase.table.row;

import java.util.concurrent.Callable;
import org.apache.hadoop.gateway.shell.AbstractRequest;
import org.apache.hadoop.gateway.shell.EmptyResponse;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.hadoop.gateway.shell.hbase.table.row.Column;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.utils.URIBuilder;

public class DeleteRows {

    public static class Response
    extends EmptyResponse {
        Response(HttpResponse response) {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String rowsId;
        private String tableName;
        private Column column;
        private Long time;

        public Request(Hadoop session, String rowsId, String tableName) {
            super(session);
            this.rowsId = rowsId;
            this.tableName = tableName;
        }

        public Request column(String family, String qualifier) {
            this.column = new Column(family, qualifier);
            return this;
        }

        public Request column(String family) {
            this.column = new Column(family);
            return this;
        }

        public Request time(Long time) {
            this.time = time;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    String rowsIdToQuery = Request.this.rowsId;
                    if (rowsIdToQuery == null || rowsIdToQuery.isEmpty()) {
                        rowsIdToQuery = "*";
                    }
                    StringBuilder columnsURIPart = new StringBuilder("/");
                    if (Request.this.column != null) {
                        columnsURIPart.append(Request.this.column.toURIPart());
                    }
                    columnsURIPart.append("/");
                    String timeURIPart = "";
                    if (Request.this.time != null) {
                        timeURIPart = Request.this.time.toString();
                    }
                    URIBuilder uri = Request.this.uri(new String[]{"/hbase", "/", Request.this.tableName, "/", rowsIdToQuery, columnsURIPart.toString(), timeURIPart});
                    HttpDelete delete = new HttpDelete(uri.build());
                    return new Response((HttpResponse)Request.this.execute((HttpRequest)delete));
                }
            };
        }
    }
}

