/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.locator;

import java.util.List;
import org.pentaho.metaverse.api.IDocumentListener;
import org.pentaho.metaverse.api.MetaverseLocatorException;
import org.pentaho.metaverse.locator.BaseLocator;
import org.pentaho.metaverse.locator.RepositoryLocatorRunner;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.repository2.ClientRepositoryPaths;

public abstract class RepositoryLocator
extends BaseLocator<RepositoryFile> {
    private static final long serialVersionUID = 3308953622126327699L;
    private IUnifiedRepository unifiedRepository;

    protected RepositoryLocator() {
    }

    public RepositoryLocator(List<IDocumentListener> documentListeners) {
        super(documentListeners);
    }

    protected abstract IUnifiedRepository getUnifiedRepository(IPentahoSession var1) throws Exception;

    public void startScan() throws MetaverseLocatorException {
        if (this.unifiedRepository == null) {
            try {
                this.unifiedRepository = this.getUnifiedRepository(this.session);
            }
            catch (Exception e) {
                throw new MetaverseLocatorException(Messages.getString("ERROR.RepositoryLocator.ScanAbortedNoRepo"), (Throwable)e);
            }
        }
        RepositoryRequest request = new RepositoryRequest(ClientRepositoryPaths.getRootFolderPath(), Boolean.valueOf(true), Integer.valueOf(-1), null);
        RepositoryFileTree root = this.unifiedRepository.getTree(request);
        List children = root.getChildren();
        RepositoryLocatorRunner lr = new RepositoryLocatorRunner();
        lr.setRoot(children);
        this.startScan(lr);
    }
}

