/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.httppost;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.httppost.HTTPPOSTMeta;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPPostStepAnalyzer
extends ExternalResourceStepAnalyzer<HTTPPOSTMeta> {
    private Logger log = LoggerFactory.getLogger(HTTPPostStepAnalyzer.class);

    protected Set<StepField> getUsedFields(HTTPPOSTMeta stepMeta) {
        Object[] headerFields;
        Object[] parameterFields;
        HashSet<StepField> usedFields = new HashSet<StepField>();
        if (stepMeta.isUrlInField() && StringUtils.isNotEmpty((String)stepMeta.getUrlField())) {
            usedFields.addAll(this.createStepFields(stepMeta.getUrlField(), this.getInputs()));
        }
        if (ArrayUtils.isNotEmpty((Object[])(parameterFields = stepMeta.getQueryField()))) {
            for (Object paramField : parameterFields) {
                usedFields.addAll(this.createStepFields((String)paramField, this.getInputs()));
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(headerFields = stepMeta.getArgumentField()))) {
            for (Object headerField : headerFields) {
                usedFields.addAll(this.createStepFields((String)headerField, this.getInputs()));
            }
        }
        return usedFields;
    }

    protected Map<String, RowMetaInterface> getInputRowMetaInterfaces(HTTPPOSTMeta meta) {
        return this.getInputFields((BaseStepMeta)meta);
    }

    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        MetaverseComponentDescriptor componentDescriptor = new MetaverseComponentDescriptor(resource.getName(), this.getResourceInputNodeType(), this.descriptor.getNamespace(), this.descriptor.getContext());
        IMetaverseNode node = this.createNodeFromDescriptor((IComponentDescriptor)componentDescriptor);
        return node;
    }

    public String getResourceInputNodeType() {
        return "Web Service";
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    protected void setObjectFactory(IMetaverseObjectFactory objectFactory) {
        this.metaverseObjectFactory = objectFactory;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(HTTPPOSTMeta.class);
            }
        };
    }

    public IClonableStepAnalyzer newInstance() {
        return new HTTPPostStepAnalyzer();
    }
}

