/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.ObjectUtils;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.version.BuildVersion;
import org.pentaho.metaverse.api.IClonableDocumentAnalyzer;
import org.pentaho.metaverse.api.IDocumentAnalyzer;
import org.pentaho.metaverse.api.ILineageWriter;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.model.IExecutionEngine;
import org.pentaho.metaverse.api.model.IExecutionProfile;
import org.pentaho.metaverse.api.model.LineageHolder;
import org.pentaho.metaverse.impl.MetaverseConfig;
import org.pentaho.metaverse.impl.model.ExecutionEngine;
import org.pentaho.metaverse.impl.model.ExecutionProfile;
import org.pentaho.metaverse.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRuntimeExtensionPoint
implements ExtensionPointInterface {
    private static final Logger log = LoggerFactory.getLogger(BaseRuntimeExtensionPoint.class);
    private IDocumentAnalyzer documentAnalyzer;
    protected ILineageWriter lineageWriter;
    protected boolean runtimeEnabled;

    public void writeLineageInfo(LineageHolder holder) throws IOException {
        String strategy;
        if (this.lineageWriter != null && !"none".equals(strategy = this.lineageWriter.getOutputStrategy())) {
            if ("latest".equals(strategy)) {
                this.lineageWriter.cleanOutput(holder);
            }
            String id = holder.getExecutionProfile().getName();
            this.lineageWriter.outputExecutionProfile(holder);
            this.lineageWriter.outputLineageGraph(holder);
        }
    }

    public static IExecutionEngine getExecutionEngineInfo() {
        ExecutionEngine executionEngine = new ExecutionEngine();
        executionEngine.setName("Pentaho Data Integration");
        executionEngine.setVersion(BuildVersion.getInstance().getVersion());
        executionEngine.setDescription("Pentaho Data Integration (PDI) prepares and blends data to create a complete picture of your business that drives actionable insights.");
        return executionEngine;
    }

    public void addRuntimeLineageInfo(LineageHolder holder) {
        IMetaverseBuilder builder = holder.getMetaverseBuilder();
        IExecutionProfile profile = holder.getExecutionProfile();
    }

    public ILineageWriter getLineageWriter() {
        return this.lineageWriter;
    }

    public void setLineageWriter(ILineageWriter lineageWriter) {
        this.lineageWriter = lineageWriter;
    }

    public void setRuntimeEnabled(String runtimeEnabled) {
        this.runtimeEnabled = runtimeEnabled != null && runtimeEnabled.equalsIgnoreCase("on");
    }

    public void setRuntimeEnabled(boolean runtimeEnabled) {
        this.runtimeEnabled = runtimeEnabled;
    }

    public boolean isRuntimeEnabled() {
        return this.runtimeEnabled;
    }

    public boolean allowedAsync() {
        KettleClientEnvironment.ClientType client = KettleClientEnvironment.getInstance().getClient();
        return client != null && !ObjectUtils.equals((Object)client, (Object)KettleClientEnvironment.ClientType.KITCHEN) && !ObjectUtils.equals((Object)client, (Object)KettleClientEnvironment.ClientType.PAN);
    }

    public void setDocumentAnalyzer(IDocumentAnalyzer analyzer) {
        this.documentAnalyzer = analyzer;
    }

    public IDocumentAnalyzer getDocumentAnalyzer() {
        if (this.documentAnalyzer instanceof IClonableDocumentAnalyzer) {
            return ((IClonableDocumentAnalyzer)this.documentAnalyzer).cloneAnalyzer();
        }
        log.debug(Messages.getString("WARNING.CannotCloneAnalyzer"), (Object)this.documentAnalyzer);
        return this.documentAnalyzer;
    }

    protected IExecutionProfile createExecutionProfile(LogChannelInterface logChannelInterface, Object o) {
        LineageHolder holder = this.getLineageHolder(o);
        IExecutionProfile executionProfile = holder.getExecutionProfile();
        if (executionProfile == null) {
            executionProfile = new ExecutionProfile();
            executionProfile.getExecutionData().setStartTime((Date)new Timestamp(new Date().getTime()));
            if (logChannelInterface != null) {
                executionProfile.getExecutionData().setLoggingChannelId(logChannelInterface.getLogChannelId());
            }
            holder.setExecutionProfile(executionProfile);
        }
        return executionProfile;
    }

    protected abstract LineageHolder getLineageHolder(Object var1);

    public boolean shouldCreateGraph(Job job) {
        Job parentJob = job.getParentJob();
        Trans parentTrans = job.getParentTrans();
        return MetaverseConfig.generateSubGraphs() || parentJob == null && parentTrans == null;
    }

    public boolean shouldCreateGraph(Trans trans) {
        Job parentJob = trans.getParentJob();
        Trans parentTrans = trans.getParentTrans();
        return MetaverseConfig.generateSubGraphs() || parentJob == null && parentTrans == null;
    }
}

