/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.analyzer.kettle.BaseDocumentAnalyzer;
import org.pentaho.metaverse.analyzer.kettle.jobentry.GenericJobEntryMetaAnalyzer;
import org.pentaho.metaverse.api.IClonableDocumentAnalyzer;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.Namespace;
import org.pentaho.metaverse.api.PropertiesHolder;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IClonableJobEntryAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryAnalyzerProvider;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobAnalyzer
extends BaseDocumentAnalyzer {
    protected static final Set<String> defaultSupportedTypes = new HashSet<String>(){
        {
            this.add("kjb");
        }
    };
    private IJobEntryAnalyzerProvider jobEntryAnalyzerProvider;
    private static final Logger log = LoggerFactory.getLogger(JobAnalyzer.class);

    public synchronized IMetaverseNode analyze(IComponentDescriptor descriptor, IDocument document) throws MetaverseAnalyzerException {
        this.validateState(document);
        Object repoObject = document.getContent();
        JobMeta jobMeta = null;
        if (repoObject instanceof String) {
            try {
                String content = (String)repoObject;
                ByteArrayInputStream xmlStream = new ByteArrayInputStream(content.getBytes());
                jobMeta = new JobMeta((InputStream)xmlStream, null, null);
            }
            catch (KettleXMLException e) {
                throw new MetaverseAnalyzerException((Throwable)e);
            }
        } else if (repoObject instanceof JobMeta) {
            jobMeta = (JobMeta)repoObject;
        }
        jobMeta.setFilename(document.getStringID());
        MetaverseComponentDescriptor documentDescriptor = new MetaverseComponentDescriptor(document.getStringID(), "Job", (INamespace)new Namespace(descriptor.getLogicalId()), descriptor.getContext());
        IMetaverseNode jobNode = this.metaverseObjectFactory.createNodeObject(document.getNamespace(), jobMeta.getName(), "Job");
        jobNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DOCUMENT);
        return this.analyze((IComponentDescriptor)documentDescriptor, (AbstractMeta)jobMeta, jobNode, (String)document.getProperty("path"));
    }

    public synchronized IMetaverseNode analyze(IComponentDescriptor documentDescriptor, AbstractMeta meta, IMetaverseNode node, String documentPath) throws MetaverseAnalyzerException {
        String status;
        String version;
        String lastModifiedUser;
        Date lastModifiedDate;
        String createdUser;
        Date createdDate;
        String extendedDescription;
        JobMeta jobMeta = (JobMeta)meta;
        Job j = new Job(null, jobMeta);
        j.setInternalKettleVariables((VariableSpace)jobMeta);
        String description = jobMeta.getDescription();
        if (description != null) {
            node.setProperty("description", (Object)description);
        }
        if ((extendedDescription = jobMeta.getExtendedDescription()) != null) {
            node.setProperty("extendedDescription", (Object)extendedDescription);
        }
        if ((createdDate = jobMeta.getCreatedDate()) != null) {
            node.setProperty("created", (Object)Long.toString(createdDate.getTime()));
        }
        if ((createdUser = jobMeta.getCreatedUser()) != null) {
            node.setProperty("createdby", (Object)createdUser);
        }
        if ((lastModifiedDate = jobMeta.getModifiedDate()) != null) {
            node.setProperty("lastmodified", (Object)Long.toString(lastModifiedDate.getTime()));
        }
        if ((lastModifiedUser = jobMeta.getModifiedUser()) != null) {
            node.setProperty("lastmodifiedby", (Object)lastModifiedUser);
        }
        if ((version = jobMeta.getJobversion()) != null) {
            node.setProperty("version", (Object)version);
        }
        if ((status = Messages.getString("INFO.JobOrTrans.Status_" + Integer.toString(jobMeta.getJobstatus()))) != null && !status.startsWith("!")) {
            node.setProperty("status", (Object)status);
        }
        node.setProperty("path", (Object)documentPath);
        String[] parameters = jobMeta.listParameters();
        if (parameters != null) {
            for (String parameter : parameters) {
                try {
                    String defaultParameterValue = jobMeta.getParameterDefault(parameter);
                    String parameterValue = jobMeta.getParameterValue(parameter);
                    String parameterDescription = jobMeta.getParameterDescription(parameter);
                    PropertiesHolder paramProperties = new PropertiesHolder();
                    paramProperties.setProperty("defaultValue", (Object)defaultParameterValue);
                    paramProperties.setProperty("value", (Object)parameterValue);
                    paramProperties.setProperty("description", (Object)parameterDescription);
                    node.setProperty("parameter_" + parameter, (Object)paramProperties.toString());
                }
                catch (UnknownParamException upe) {
                    throw new MetaverseAnalyzerException((Throwable)upe);
                }
            }
        }
        for (int i = 0; i < jobMeta.nrJobEntries(); ++i) {
            JobEntryCopy entry = jobMeta.getJobEntry(i);
            try {
                if (entry == null) continue;
                entry.getEntry().setParentJob(j);
                IMetaverseNode jobEntryNode = null;
                JobEntryInterface jobEntryInterface = entry.getEntry();
                MetaverseComponentDescriptor entryDescriptor = new MetaverseComponentDescriptor(entry.getName(), "Job Entry", node, documentDescriptor.getContext());
                Set<IJobEntryAnalyzer> jobEntryAnalyzers = this.getJobEntryAnalyzers(jobEntryInterface);
                if (jobEntryAnalyzers != null && !jobEntryAnalyzers.isEmpty()) {
                    for (IJobEntryAnalyzer jobEntryAnalyzer : jobEntryAnalyzers) {
                        if (jobEntryAnalyzer instanceof IClonableJobEntryAnalyzer) {
                            jobEntryAnalyzer = ((IClonableJobEntryAnalyzer)jobEntryAnalyzer).cloneAnalyzer();
                            ((IClonableJobEntryAnalyzer)jobEntryAnalyzer).setDocumentAnalyzer((IClonableDocumentAnalyzer)this);
                            ((IClonableJobEntryAnalyzer)jobEntryAnalyzer).setDocumentDescriptor(documentDescriptor);
                            ((IClonableJobEntryAnalyzer)jobEntryAnalyzer).setDocumentPath(documentPath);
                        } else {
                            log.debug(Messages.getString("WARNING.CannotCloneAnalyzer"), (Object)jobEntryAnalyzer);
                        }
                        jobEntryAnalyzer.setMetaverseBuilder(this.metaverseBuilder);
                        jobEntryNode = (IMetaverseNode)jobEntryAnalyzer.analyze((IComponentDescriptor)entryDescriptor, (Object)entry.getEntry());
                    }
                } else {
                    GenericJobEntryMetaAnalyzer defaultJobEntryAnalyzer = new GenericJobEntryMetaAnalyzer();
                    defaultJobEntryAnalyzer.setMetaverseBuilder(this.metaverseBuilder);
                    jobEntryNode = defaultJobEntryAnalyzer.analyze((IComponentDescriptor)entryDescriptor, jobEntryInterface);
                }
                if (jobEntryNode == null) continue;
                this.metaverseBuilder.addLink(node, "contains", jobEntryNode);
                continue;
            }
            catch (Throwable mae) {
                log.warn(Messages.getString("ERROR.ErrorDuringAnalysis", entry.getName(), Const.NVL((String)mae.getLocalizedMessage(), (String)"Unspecified")));
                log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), mae);
            }
        }
        int numHops = jobMeta.nrJobHops();
        for (int i = 0; i < numHops; ++i) {
            JobHopMeta hop = jobMeta.getJobHop(i);
            JobEntryCopy fromEntry = hop.getFromEntry();
            JobEntryCopy toEntry = hop.getToEntry();
            Namespace childNs = new Namespace(node.getLogicalId());
            if (fromEntry == null || toEntry == null) continue;
            IMetaverseNode fromEntryNode = this.metaverseObjectFactory.createNodeObject((INamespace)childNs, fromEntry.getName(), "Job Entry");
            IMetaverseNode toEntryNode = this.metaverseObjectFactory.createNodeObject((INamespace)childNs, toEntry.getName(), "Job Entry");
            this.metaverseBuilder.addLink(fromEntryNode, "hops_to", toEntryNode);
        }
        this.metaverseBuilder.addNode(node);
        this.addParentLink(documentDescriptor, node);
        return node;
    }

    public Set<String> getSupportedTypes() {
        return defaultSupportedTypes;
    }

    public Set<IJobEntryAnalyzer> getJobEntryAnalyzers(JobEntryInterface jobEntryInterface) {
        HashSet<IJobEntryAnalyzer> jobEntryAnalyzers = new HashSet<IJobEntryAnalyzer>();
        this.jobEntryAnalyzerProvider = this.getJobEntryAnalyzerProvider();
        if (this.jobEntryAnalyzerProvider != null) {
            if (jobEntryInterface == null) {
                jobEntryAnalyzers.addAll(this.jobEntryAnalyzerProvider.getAnalyzers());
            } else {
                HashSet analyzerClassSet = new HashSet(1);
                analyzerClassSet.add(jobEntryInterface.getClass());
                jobEntryAnalyzers.addAll(this.jobEntryAnalyzerProvider.getAnalyzers(analyzerClassSet));
            }
        } else {
            jobEntryAnalyzers.add((IJobEntryAnalyzer)new GenericJobEntryMetaAnalyzer());
        }
        return jobEntryAnalyzers;
    }

    public void setJobEntryAnalyzerProvider(IJobEntryAnalyzerProvider jobEntryAnalyzerProvider) {
        this.jobEntryAnalyzerProvider = jobEntryAnalyzerProvider;
    }

    public IJobEntryAnalyzerProvider getJobEntryAnalyzerProvider() {
        if (this.jobEntryAnalyzerProvider != null) {
            return this.jobEntryAnalyzerProvider;
        }
        this.jobEntryAnalyzerProvider = (IJobEntryAnalyzerProvider)PentahoSystem.get(IJobEntryAnalyzerProvider.class);
        return this.jobEntryAnalyzerProvider;
    }

    @Override
    public IClonableDocumentAnalyzer newInstance() {
        return new JobAnalyzer();
    }
}

