/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.CE;
import ca.uhn.hl7v2.model.v21.datatype.CM;
import ca.uhn.hl7v2.model.v21.datatype.CN;
import ca.uhn.hl7v2.model.v21.datatype.CQ;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TN;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OBR
extends AbstractSegment {
    public OBR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "SET ID - OBSERVATION REQUEST");
            this.add(CM.class, false, 1, 75, new Object[]{this.getMessage(), new Integer(0)}, "PLACER ORDER #");
            this.add(CM.class, false, 1, 75, new Object[]{this.getMessage(), new Integer(0)}, "FILLER ORDER #");
            this.add(CE.class, true, 1, 200, new Object[]{this.getMessage(), new Integer(0)}, "UNIVERSAL SERVICE IDENT.");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "PRIORITY");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage(), new Integer(0)}, "REQUESTED DATE-TIME");
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage(), new Integer(0)}, "OBSERVATION DATE/TIME");
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage(), new Integer(0)}, "OBSERVATION END DATE/TIME");
            this.add(CQ.class, true, 1, 20, new Object[]{this.getMessage(), new Integer(36)}, "COLLECTION VOLUME");
            this.add(CN.class, false, 0, 60, new Object[]{this.getMessage(), new Integer(0)}, "COLLECTOR IDENTIFIER");
            this.add(ST.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(65)}, "SPECIMEN ACTION CODE");
            this.add(CM.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(47)}, "DANGER CODE");
            this.add(ST.class, false, 1, 300, new Object[]{this.getMessage(), new Integer(0)}, "RELEVANT CLINICAL INFO.");
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage(), new Integer(0)}, "SPECIMEN RECEIVED DATE/TIME");
            this.add(CM.class, false, 1, 300, new Object[]{this.getMessage(), new Integer(70)}, "SPECIMEN SOURCE");
            this.add(CN.class, false, 0, 60, new Object[]{this.getMessage(), new Integer(10)}, "ORDERING PROVIDER");
            this.add(TN.class, false, 2, 40, new Object[]{this.getMessage(), new Integer(0)}, "ORDER CALL-BACK PHONE NUM");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "PLACERS FIELD #1");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "PLACERS FIELD #2");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "FILLERS FIELD #1");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "FILLERS FIELD #2");
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage(), new Integer(0)}, "RESULTS RPT/STATUS CHNG - DATE/T");
            this.add(CM.class, false, 1, 40, new Object[]{this.getMessage(), new Integer(0)}, "CHARGE TO PRACTICE");
            this.add(ID.class, false, 1, 10, new Object[]{this.getMessage()}, "DIAGNOSTIC SERV SECT ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "RESULT STATUS");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage(), new Integer(0)}, "LINKED RESULTS");
            this.add(CM.class, false, 0, 200, new Object[]{this.getMessage(), new Integer(0)}, "QUANTITY/TIMING");
            this.add(CN.class, false, 5, 80, new Object[]{this.getMessage(), new Integer(0)}, "RESULT COPIES TO");
            this.add(CM.class, false, 1, 150, new Object[]{this.getMessage(), new Integer(0)}, "PARENT ACCESSION #");
            this.add(ID.class, false, 1, 20, new Object[]{this.getMessage()}, "TRANSPORTATION MODE");
            this.add(CE.class, false, 0, 300, new Object[]{this.getMessage(), new Integer(0)}, "REASON FOR STUDY");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "PRINCIPAL RESULT INTERPRETER");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "ASSISTANT RESULT INTERPRETER");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "TECHNICIAN");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "TRANSCRIPTIONIST");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage(), new Integer(0)}, "SCHEDULED - DATE/TIME");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OBR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSETIDOBSERVATIONREQUEST() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getObr1_SETIDOBSERVATIONREQUEST() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getPLACERORDER() {
        CM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getObr2_PLACERORDER() {
        CM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getFILLERORDER() {
        CM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getObr3_FILLERORDER() {
        CM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getUNIVERSALSERVICEIDENT() {
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getObr4_UNIVERSALSERVICEIDENT() {
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getPRIORITY() {
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObr5_PRIORITY() {
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getREQUESTEDDATETIME() {
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getObr6_REQUESTEDDATETIME() {
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getOBSERVATIONDATETIME() {
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getObr7_OBSERVATIONDATETIME() {
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getOBSERVATIONENDDATETIME() {
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getObr8_OBSERVATIONENDDATETIME() {
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getCOLLECTIONVOLUME() {
        CQ ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getObr9_COLLECTIONVOLUME() {
        CQ ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN[] getCOLLECTORIDENTIFIER() {
        CN[] ret = null;
        try {
            Type[] t = this.getField(10);
            ret = new CN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getCOLLECTORIDENTIFIER(int rep) {
        CN ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getObr10_COLLECTORIDENTIFIER(int rep) {
        CN ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN insertCOLLECTORIDENTIFIER(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(10, rep);
    }

    public CN insertObr10_COLLECTORIDENTIFIER(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(10, rep);
    }

    public CN removeCOLLECTORIDENTIFIER(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(10, rep);
    }

    public CN removeObr10_COLLECTORIDENTIFIER(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(10, rep);
    }

    public ST getSPECIMENACTIONCODE() {
        ST ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObr11_SPECIMENACTIONCODE() {
        ST ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getDANGERCODE() {
        CM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getObr12_DANGERCODE() {
        CM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getRELEVANTCLINICALINFO() {
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObr13_RELEVANTCLINICALINFO() {
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getSPECIMENRECEIVEDDATETIME() {
        TS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getObr14_SPECIMENRECEIVEDDATETIME() {
        TS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getSPECIMENSOURCE() {
        CM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getObr15_SPECIMENSOURCE() {
        CM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN[] getORDERINGPROVIDER() {
        CN[] ret = null;
        try {
            Type[] t = this.getField(16);
            ret = new CN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getORDERINGPROVIDER(int rep) {
        CN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getObr16_ORDERINGPROVIDER(int rep) {
        CN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN insertORDERINGPROVIDER(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(16, rep);
    }

    public CN insertObr16_ORDERINGPROVIDER(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(16, rep);
    }

    public CN removeORDERINGPROVIDER(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(16, rep);
    }

    public CN removeObr16_ORDERINGPROVIDER(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(16, rep);
    }

    public TN[] getORDERCALLBACKPHONENUM() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(17);
            ret = new TN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (TN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TN getORDERCALLBACKPHONENUM(int rep) {
        TN ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (TN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TN getObr17_ORDERCALLBACKPHONENUM(int rep) {
        TN ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (TN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TN insertORDERCALLBACKPHONENUM(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(17, rep);
    }

    public TN insertObr17_ORDERCALLBACKPHONENUM(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(17, rep);
    }

    public TN removeORDERCALLBACKPHONENUM(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(17, rep);
    }

    public TN removeObr17_ORDERCALLBACKPHONENUM(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(17, rep);
    }

    public ST getPLACERSFIELD1() {
        ST ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObr18_PLACERSFIELD1() {
        ST ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getPLACERSFIELD2() {
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObr19_PLACERSFIELD2() {
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getFILLERSFIELD1() {
        ST ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObr20_FILLERSFIELD1() {
        ST ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getFILLERSFIELD2() {
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObr21_FILLERSFIELD2() {
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getRESULTSRPTSTATUSCHNGDATET() {
        TS ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getObr22_RESULTSRPTSTATUSCHNGDATET() {
        TS ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getCHARGETOPRACTICE() {
        CM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getObr23_CHARGETOPRACTICE() {
        CM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getDIAGNOSTICSERVSECTID() {
        ID ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getObr24_DIAGNOSTICSERVSECTID() {
        ID ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getRESULTSTATUS() {
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getObr25_RESULTSTATUS() {
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getLINKEDRESULTS() {
        CE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getObr26_LINKEDRESULTS() {
        CE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM[] getQUANTITYTIMING() {
        CM[] ret = null;
        try {
            Type[] t = this.getField(27);
            ret = new CM[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CM)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getQUANTITYTIMING(int rep) {
        CM ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getObr27_QUANTITYTIMING(int rep) {
        CM ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM insertQUANTITYTIMING(int rep) throws HL7Exception {
        return (CM)super.insertRepetition(27, rep);
    }

    public CM insertObr27_QUANTITYTIMING(int rep) throws HL7Exception {
        return (CM)super.insertRepetition(27, rep);
    }

    public CM removeQUANTITYTIMING(int rep) throws HL7Exception {
        return (CM)super.removeRepetition(27, rep);
    }

    public CM removeObr27_QUANTITYTIMING(int rep) throws HL7Exception {
        return (CM)super.removeRepetition(27, rep);
    }

    public CN[] getRESULTCOPIESTO() {
        CN[] ret = null;
        try {
            Type[] t = this.getField(28);
            ret = new CN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getRESULTCOPIESTO(int rep) {
        CN ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getObr28_RESULTCOPIESTO(int rep) {
        CN ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN insertRESULTCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(28, rep);
    }

    public CN insertObr28_RESULTCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(28, rep);
    }

    public CN removeRESULTCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(28, rep);
    }

    public CN removeObr28_RESULTCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(28, rep);
    }

    public CM getPARENTACCESSION() {
        CM ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM getObr29_PARENTACCESSION() {
        CM ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getTRANSPORTATIONMODE() {
        ID ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getObr30_TRANSPORTATIONMODE() {
        ID ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE[] getREASONFORSTUDY() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(31);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getREASONFORSTUDY(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getObr31_REASONFORSTUDY(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE insertREASONFORSTUDY(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE insertObr31_REASONFORSTUDY(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE removeREASONFORSTUDY(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CE removeObr31_REASONFORSTUDY(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CN getPRINCIPALRESULTINTERPRETER() {
        CN ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getObr32_PRINCIPALRESULTINTERPRETER() {
        CN ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getASSISTANTRESULTINTERPRETER() {
        CN ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getObr33_ASSISTANTRESULTINTERPRETER() {
        CN ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getTECHNICIAN() {
        CN ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getObr34_TECHNICIAN() {
        CN ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getTRANSCRIPTIONIST() {
        CN ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getObr35_TRANSCRIPTIONIST() {
        CN ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getSCHEDULEDDATETIME() {
        TS ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getObr36_SCHEDULEDDATETIME() {
        TS ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CM(this.getMessage());
            }
            case 2: {
                return new CM(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new CQ(this.getMessage());
            }
            case 9: {
                return new CN(this.getMessage());
            }
            case 10: {
                return new ST(this.getMessage());
            }
            case 11: {
                return new CM(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new CM(this.getMessage());
            }
            case 15: {
                return new CN(this.getMessage());
            }
            case 16: {
                return new TN(this.getMessage());
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new TS(this.getMessage());
            }
            case 22: {
                return new CM(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(74));
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(123));
            }
            case 25: {
                return new CE(this.getMessage());
            }
            case 26: {
                return new CM(this.getMessage());
            }
            case 27: {
                return new CN(this.getMessage());
            }
            case 28: {
                return new CM(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(124));
            }
            case 30: {
                return new CE(this.getMessage());
            }
            case 31: {
                return new CN(this.getMessage());
            }
            case 32: {
                return new CN(this.getMessage());
            }
            case 33: {
                return new CN(this.getMessage());
            }
            case 34: {
                return new CN(this.getMessage());
            }
            case 35: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

