/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCPDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DbCPDataSourceProvider.class);
    static final String DBCP = "dbcp";
    private static final String CONNECTION_TIMEOUT_PROPERTY = "dbcp.maxWait";
    private static final String CONNECTION_MAX_IDLE_PROPERTY = "dbcp.maxIdle";
    private static final String CONNECTION_MIN_IDLE_PROPERTY = "dbcp.minIdle";
    private static final String CONNECTION_TEST_BORROW_PROPERTY = "dbcp.testOnBorrow";
    private static final String CONNECTION_MIN_EVICT_MILLIS_PROPERTY = "dbcp.minEvictableIdleTimeMillis";
    private static final String CONNECTION_TEST_IDLEPROPERTY = "dbcp.testWhileIdle";
    private static final String CONNECTION_TIME_BETWEEN_EVICTION_RUNS_MILLIS = "dbcp.timeBetweenEvictionRunsMillis";
    private static final String CONNECTION_NUM_TESTS_PER_EVICTION_RUN = "dbcp.numTestsPerEvictionRun";
    private static final String CONNECTION_TEST_ON_RETURN = "dbcp.testOnReturn";
    private static final String CONNECTION_SOFT_MIN_EVICTABLE_IDLE_TIME = "dbcp.softMinEvictableIdleTimeMillis";
    private static final String CONNECTION_LIFO = "dbcp.lifo";

    @Override
    public DataSource create(Configuration hdpConfig) throws SQLException {
        LOG.debug("Creating dbcp connection pool for the MetaStore");
        String driverUrl = DataSourceProvider.getMetastoreJdbcDriverUrl(hdpConfig);
        String user = DataSourceProvider.getMetastoreJdbcUser(hdpConfig);
        String passwd = DataSourceProvider.getMetastoreJdbcPasswd(hdpConfig);
        int maxPoolSize = HiveConf.getIntVar((Configuration)hdpConfig, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_CONNECTION_POOLING_MAX_CONNECTIONS);
        long connectionTimeout = hdpConfig.getLong(CONNECTION_TIMEOUT_PROPERTY, 30000L);
        int connectionMaxIlde = hdpConfig.getInt(CONNECTION_MAX_IDLE_PROPERTY, 8);
        int connectionMinIlde = hdpConfig.getInt(CONNECTION_MIN_IDLE_PROPERTY, 0);
        boolean testOnBorrow = hdpConfig.getBoolean(CONNECTION_TEST_BORROW_PROPERTY, false);
        long evictionTimeMillis = hdpConfig.getLong(CONNECTION_MIN_EVICT_MILLIS_PROPERTY, 1800000L);
        boolean testWhileIdle = hdpConfig.getBoolean(CONNECTION_TEST_IDLEPROPERTY, false);
        long timeBetweenEvictionRuns = hdpConfig.getLong(CONNECTION_TIME_BETWEEN_EVICTION_RUNS_MILLIS, -1L);
        int numTestsPerEvictionRun = hdpConfig.getInt(CONNECTION_NUM_TESTS_PER_EVICTION_RUN, 3);
        boolean testOnReturn = hdpConfig.getBoolean(CONNECTION_TEST_ON_RETURN, false);
        long softMinEvictableIdleTimeMillis = hdpConfig.getLong(CONNECTION_SOFT_MIN_EVICTABLE_IDLE_TIME, -1L);
        boolean lifo = hdpConfig.getBoolean(CONNECTION_LIFO, true);
        GenericObjectPool objectPool = new GenericObjectPool();
        objectPool.setMaxActive(maxPoolSize);
        objectPool.setMaxWait(connectionTimeout);
        objectPool.setMaxIdle(connectionMaxIlde);
        objectPool.setMinIdle(connectionMinIlde);
        objectPool.setTestOnBorrow(testOnBorrow);
        objectPool.setTestWhileIdle(testWhileIdle);
        objectPool.setMinEvictableIdleTimeMillis(evictionTimeMillis);
        objectPool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRuns);
        objectPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        objectPool.setTestOnReturn(testOnReturn);
        objectPool.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
        objectPool.setLifo(lifo);
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(driverUrl, user, passwd);
        new PoolableConnectionFactory((ConnectionFactory)connFactory, (ObjectPool)objectPool, null, null, false, true);
        return new PoolingDataSource((ObjectPool)objectPool);
    }

    @Override
    public boolean mayReturnClosedConnection() {
        return false;
    }

    @Override
    public boolean supports(Configuration configuration) {
        String poolingType = configuration.get(HiveConf.ConfVars.METASTORE_CONNECTION_POOLING_TYPE.varname);
        return DBCP.equalsIgnoreCase(poolingType);
    }
}

