/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.SettableSequenceId;
import org.apache.hadoop.hbase.codec.prefixtree.decode.DecoderFactory;
import org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeArraySearcher;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellScannerPosition;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PrefixTreeSeeker
implements DataBlockEncoder.EncodedSeeker {
    protected boolean includeMvccVersion;
    protected PrefixTreeArraySearcher ptSearcher;
    private static final boolean USE_POSITION_BEFORE = false;

    public PrefixTreeSeeker(boolean includeMvccVersion) {
        this.includeMvccVersion = includeMvccVersion;
    }

    public void setCurrentBuffer(ByteBuff fullBlockBuffer) {
        this.ptSearcher = DecoderFactory.checkOut(fullBlockBuffer, this.includeMvccVersion);
        this.rewind();
    }

    public void releaseCurrentSearcher() {
        DecoderFactory.checkIn(this.ptSearcher);
    }

    public Cell getKey() {
        return this.ptSearcher.current();
    }

    public ByteBuffer getValueShallowCopy() {
        return PrivateCellUtil.getValueBufferShallowCopy((Cell)this.ptSearcher.current());
    }

    public Cell getCell() {
        ByteBufferCell cell = (ByteBufferCell)this.ptSearcher.current();
        if (cell == null) {
            return null;
        }
        if (cell.getValueByteBuffer().hasArray()) {
            return new OnheapPrefixTreeCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength(), cell.getTimestamp(), cell.getTypeByte(), cell.getSequenceId());
        }
        return new OffheapPrefixTreeCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getValueByteBuffer(), cell.getValuePosition(), cell.getValueLength(), cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength(), cell.getTimestamp(), cell.getTypeByte(), cell.getSequenceId());
    }

    public Cell get() {
        return this.ptSearcher.current();
    }

    public void rewind() {
        this.ptSearcher.positionAtFirstCell();
    }

    public boolean next() {
        return this.ptSearcher.advance();
    }

    public boolean advance() {
        return this.ptSearcher.advance();
    }

    protected int seekToOrBeforeUsingPositionAtOrBefore(Cell kv, boolean seekBefore) {
        CellScannerPosition position = this.ptSearcher.seekForwardToOrBefore(kv);
        if (CellScannerPosition.AT == position) {
            if (seekBefore) {
                this.ptSearcher.previous();
                return 1;
            }
            return 0;
        }
        return 1;
    }

    protected int seekToOrBeforeUsingPositionAtOrAfter(Cell kv, boolean seekBefore) {
        CellScannerPosition position = this.ptSearcher.seekForwardToOrAfter(kv);
        if (CellScannerPosition.AT == position) {
            if (seekBefore) {
                this.ptSearcher.previous();
                return 1;
            }
            return 0;
        }
        if (CellScannerPosition.AFTER == position) {
            if (!this.ptSearcher.isBeforeFirst()) {
                this.ptSearcher.previous();
            }
            return 1;
        }
        if (position == CellScannerPosition.AFTER_LAST) {
            if (seekBefore) {
                this.ptSearcher.previous();
            }
            return 1;
        }
        throw new RuntimeException("unexpected CellScannerPosition:" + (Object)((Object)position));
    }

    public int seekToKeyInBlock(Cell key, boolean forceBeforeOnExactMatch) {
        return this.seekToOrBeforeUsingPositionAtOrAfter(key, forceBeforeOnExactMatch);
    }

    public int compareKey(CellComparator comparator, Cell key) {
        return comparator.compare(key, this.ptSearcher.current());
    }

    private static class OffheapPrefixTreeCell
    extends ByteBufferCell
    implements Cell,
    SettableSequenceId,
    HeapSize {
        private static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 5 * ClassSize.REFERENCE + 16 + 16 + 2 + 2 + 5 * ClassSize.BYTE_BUFFER));
        private ByteBuffer rowBuff;
        private short rowLength;
        private ByteBuffer famBuff;
        private byte famLength;
        private ByteBuffer qualBuff;
        private int qualLength;
        private ByteBuffer val;
        private int valOffset;
        private int valLength;
        private ByteBuffer tagBuff;
        private int tagsLength;
        private long ts;
        private long seqId;
        private byte type;

        public OffheapPrefixTreeCell(byte[] row, int rowOffset, short rowLength, byte[] fam, int famOffset, byte famLength, byte[] qual, int qualOffset, int qualLength, ByteBuffer val, int valOffset, int valLength, byte[] tag, int tagOffset, int tagLength, long ts, byte type, long seqId) {
            byte[] tmpRow = new byte[rowLength];
            System.arraycopy(row, rowOffset, tmpRow, 0, rowLength);
            this.rowBuff = ByteBuffer.wrap(tmpRow);
            this.rowLength = rowLength;
            byte[] tmpFam = new byte[famLength];
            System.arraycopy(fam, famOffset, tmpFam, 0, famLength);
            this.famBuff = ByteBuffer.wrap(tmpFam);
            this.famLength = famLength;
            byte[] tmpQual = new byte[qualLength];
            System.arraycopy(qual, qualOffset, tmpQual, 0, qualLength);
            this.qualBuff = ByteBuffer.wrap(tmpQual);
            this.qualLength = qualLength;
            byte[] tmpTag = new byte[tagLength];
            System.arraycopy(tag, tagOffset, tmpTag, 0, tagLength);
            this.tagBuff = ByteBuffer.wrap(tmpTag);
            this.tagsLength = tagLength;
            this.val = val;
            this.valLength = valLength;
            this.valOffset = valOffset;
            this.ts = ts;
            this.seqId = seqId;
            this.type = type;
        }

        public void setSequenceId(long seqId) {
            this.seqId = seqId;
        }

        public byte[] getRowArray() {
            return this.rowBuff.array();
        }

        public int getRowOffset() {
            return this.getRowPosition();
        }

        public short getRowLength() {
            return this.rowLength;
        }

        public byte[] getFamilyArray() {
            return this.famBuff.array();
        }

        public int getFamilyOffset() {
            return this.getFamilyPosition();
        }

        public byte getFamilyLength() {
            return this.famLength;
        }

        public byte[] getQualifierArray() {
            return this.qualBuff.array();
        }

        public int getQualifierOffset() {
            return this.getQualifierPosition();
        }

        public int getQualifierLength() {
            return this.qualLength;
        }

        public long getTimestamp() {
            return this.ts;
        }

        public byte getTypeByte() {
            return this.type;
        }

        public long getSequenceId() {
            return this.seqId;
        }

        public byte[] getValueArray() {
            byte[] tmpVal = new byte[this.valLength];
            ByteBufferUtils.copyFromBufferToArray((byte[])tmpVal, (ByteBuffer)this.val, (int)this.valOffset, (int)0, (int)this.valLength);
            return tmpVal;
        }

        public int getValueOffset() {
            return 0;
        }

        public int getValueLength() {
            return this.valLength;
        }

        public byte[] getTagsArray() {
            return this.tagBuff.array();
        }

        public int getTagsOffset() {
            return this.getTagsPosition();
        }

        public int getTagsLength() {
            return this.tagsLength;
        }

        public ByteBuffer getRowByteBuffer() {
            return this.rowBuff;
        }

        public int getRowPosition() {
            return 0;
        }

        public ByteBuffer getFamilyByteBuffer() {
            return this.famBuff;
        }

        public int getFamilyPosition() {
            return 0;
        }

        public ByteBuffer getQualifierByteBuffer() {
            return this.qualBuff;
        }

        public int getQualifierPosition() {
            return 0;
        }

        public ByteBuffer getTagsByteBuffer() {
            return this.tagBuff;
        }

        public int getTagsPosition() {
            return 0;
        }

        public ByteBuffer getValueByteBuffer() {
            return this.val;
        }

        public int getValuePosition() {
            return this.valOffset;
        }

        public long heapSize() {
            return FIXED_OVERHEAD;
        }

        public String toString() {
            String row = Bytes.toStringBinary((byte[])this.getRowArray(), (int)this.getRowOffset(), (int)this.getRowLength());
            String family = Bytes.toStringBinary((byte[])this.getFamilyArray(), (int)this.getFamilyOffset(), (int)this.getFamilyLength());
            String qualifier = Bytes.toStringBinary((byte[])this.getQualifierArray(), (int)this.getQualifierOffset(), (int)this.getQualifierLength());
            String timestamp = String.valueOf(this.getTimestamp());
            return row + "/" + family + (family != null && family.length() > 0 ? ":" : "") + qualifier + "/" + timestamp + "/" + KeyValue.Type.codeToType((byte)this.type);
        }
    }

    private static class OnheapPrefixTreeCell
    implements Cell,
    SettableSequenceId,
    HeapSize {
        private static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 5 * ClassSize.REFERENCE + 16 + 16 + 2 + 2 + 5 * ClassSize.ARRAY));
        private byte[] row;
        private short rowLength;
        private byte[] fam;
        private byte famLength;
        private byte[] qual;
        private int qualLength;
        private byte[] val;
        private int valOffset;
        private int valLength;
        private byte[] tag;
        private int tagsLength;
        private long ts;
        private long seqId;
        private byte type;

        public OnheapPrefixTreeCell(byte[] row, int rowOffset, short rowLength, byte[] fam, int famOffset, byte famLength, byte[] qual, int qualOffset, int qualLength, byte[] val, int valOffset, int valLength, byte[] tag, int tagOffset, int tagLength, long ts, byte type, long seqId) {
            this.row = new byte[rowLength];
            System.arraycopy(row, rowOffset, this.row, 0, rowLength);
            this.rowLength = rowLength;
            this.fam = new byte[famLength];
            System.arraycopy(fam, famOffset, this.fam, 0, famLength);
            this.famLength = famLength;
            this.qual = new byte[qualLength];
            System.arraycopy(qual, qualOffset, this.qual, 0, qualLength);
            this.qualLength = qualLength;
            this.tag = new byte[tagLength];
            System.arraycopy(tag, tagOffset, this.tag, 0, tagLength);
            this.tagsLength = tagLength;
            this.val = val;
            this.valLength = valLength;
            this.valOffset = valOffset;
            this.ts = ts;
            this.seqId = seqId;
            this.type = type;
        }

        public void setSequenceId(long seqId) {
            this.seqId = seqId;
        }

        public byte[] getRowArray() {
            return this.row;
        }

        public int getRowOffset() {
            return 0;
        }

        public short getRowLength() {
            return this.rowLength;
        }

        public byte[] getFamilyArray() {
            return this.fam;
        }

        public int getFamilyOffset() {
            return 0;
        }

        public byte getFamilyLength() {
            return this.famLength;
        }

        public byte[] getQualifierArray() {
            return this.qual;
        }

        public int getQualifierOffset() {
            return 0;
        }

        public int getQualifierLength() {
            return this.qualLength;
        }

        public long getTimestamp() {
            return this.ts;
        }

        public byte getTypeByte() {
            return this.type;
        }

        public long getSequenceId() {
            return this.seqId;
        }

        public byte[] getValueArray() {
            return this.val;
        }

        public int getValueOffset() {
            return this.valOffset;
        }

        public int getValueLength() {
            return this.valLength;
        }

        public byte[] getTagsArray() {
            return this.tag;
        }

        public int getTagsOffset() {
            return 0;
        }

        public int getTagsLength() {
            return this.tagsLength;
        }

        public String toString() {
            String row = Bytes.toStringBinary((byte[])this.getRowArray(), (int)this.getRowOffset(), (int)this.getRowLength());
            String family = Bytes.toStringBinary((byte[])this.getFamilyArray(), (int)this.getFamilyOffset(), (int)this.getFamilyLength());
            String qualifier = Bytes.toStringBinary((byte[])this.getQualifierArray(), (int)this.getQualifierOffset(), (int)this.getQualifierLength());
            String timestamp = String.valueOf(this.getTimestamp());
            return row + "/" + family + (family != null && family.length() > 0 ? ":" : "") + qualifier + "/" + timestamp + "/" + KeyValue.Type.codeToType((byte)this.type);
        }

        public long heapSize() {
            return FIXED_OVERHEAD + (long)this.rowLength + (long)this.famLength + (long)this.qualLength + (long)this.valLength + (long)this.tagsLength;
        }
    }
}

