/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.beans.PropertyEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.Messages;

public class BasicTextPropertyEditorDialog
extends CommonDialog {
    private PropertyEditor propertyEditor;
    private JTextArea textArea;
    private Object originalValue;

    public BasicTextPropertyEditorDialog() throws HeadlessException {
        this.init();
    }

    public BasicTextPropertyEditorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public BasicTextPropertyEditorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    @Override
    protected void init() {
        this.setModal(true);
        this.setTitle(Messages.getInstance().getString("TextAreaPropertyEditorDialog.Title"));
        this.textArea = this.createTextArea();
        super.init();
    }

    @Override
    protected String getDialogId() {
        return "LibSwing.TextAreaPropertyEditor";
    }

    protected JTextArea createTextArea() {
        JTextArea textArea = new JTextArea();
        textArea.setColumns(60);
        textArea.setRows(20);
        textArea.getDocument().addDocumentListener(new DocumentUpdateHandler());
        return textArea;
    }

    protected JTextArea getTextArea() {
        return this.textArea;
    }

    @Override
    protected Component createContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new JScrollPane(this.textArea), "Center");
        return contentPane;
    }

    public boolean performEdit(PropertyEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.propertyEditor = editor;
        this.originalValue = this.propertyEditor.getValue();
        if (this.originalValue == null) {
            this.textArea.setText("");
        } else {
            this.textArea.setText(this.propertyEditor.getAsText());
        }
        if (this.performEdit()) {
            try {
                this.propertyEditor.setAsText(this.textArea.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        try {
            this.propertyEditor.setValue(this.originalValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String performEdit(String originalValue) {
        this.originalValue = originalValue;
        if (originalValue == null) {
            this.textArea.setText("");
        } else {
            this.textArea.setText(originalValue);
        }
        if (this.performEdit()) {
            return this.textArea.getText();
        }
        return originalValue;
    }

    protected class DocumentUpdateHandler
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            if (BasicTextPropertyEditorDialog.this.propertyEditor != null) {
                try {
                    BasicTextPropertyEditorDialog.this.propertyEditor.setAsText(BasicTextPropertyEditorDialog.this.textArea.getText());
                    BasicTextPropertyEditorDialog.this.getConfirmAction().setEnabled(true);
                }
                catch (Exception ex) {
                    BasicTextPropertyEditorDialog.this.getConfirmAction().setEnabled(false);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }
    }
}

