/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

import org.pentaho.di.core.row.RowMetaInterface;

public class Shape {
    public static final int SHAPE_TYPE_NULL = 0;
    public static final int SHAPE_TYPE_POINT = 1;
    public static final int SHAPE_TYPE_POLYLINE = 3;
    public static final int SHAPE_TYPE_POLYGON = 5;
    public static final int SHAPE_TYPE_MULTIPOINT = 8;
    public static final int SHAPE_TYPE_POINTZ = 11;
    public static final int SHAPE_TYPE_POLYLINE_Z = 13;
    public static final int SHAPE_TYPE_POLYGON_Z = 15;
    public static final int SHAPE_TYPE_MULTIPOINT_Z = 18;
    public static final int SHAPE_TYPE_POINT_M = 21;
    public static final int SHAPE_TYPE_POLYLINE_M = 23;
    public static final int SHAPE_TYPE_POLYGON_M = 25;
    public static final int SHAPE_TYPE_MULTIPOINT_M = 28;
    public static final int SHAPE_TYPE_MULTIPATCH = 31;
    private Object[] dbfData;
    private RowMetaInterface dbfMeta;
    protected int type;

    public static final String getEsriTypeDesc(int type) {
        String retval = "Unknown";
        switch (type) {
            case 0: {
                retval = "Null Shape";
                break;
            }
            case 1: {
                retval = "Point";
                break;
            }
            case 3: {
                retval = "PolyLine";
                break;
            }
            case 5: {
                retval = "Polygon";
                break;
            }
            case 8: {
                retval = "MultiPoint";
                break;
            }
            case 11: {
                retval = "PointZ";
                break;
            }
            case 13: {
                retval = "PolyLineZ";
                break;
            }
            case 15: {
                retval = "PolygonZ";
                break;
            }
            case 18: {
                retval = "MultiPointZ";
                break;
            }
            case 21: {
                retval = "PointM";
                break;
            }
            case 23: {
                retval = "PolyLineM";
                break;
            }
            case 25: {
                retval = "PolygonM";
                break;
            }
            case 28: {
                retval = "MultiPointM";
                break;
            }
            case 31: {
                retval = "MultiPatch";
                break;
            }
        }
        return retval;
    }

    public Shape(int type) {
        this.setType(type);
        this.dbfData = null;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return Shape.getEsriTypeDesc(this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public Object[] getDbfData() {
        return this.dbfData;
    }

    public void setDbfData(Object[] dbfData) {
        this.dbfData = dbfData;
    }

    public RowMetaInterface getDbfMeta() {
        return this.dbfMeta;
    }

    public void setDbfMeta(RowMetaInterface dbfMeta) {
        this.dbfMeta = dbfMeta;
    }
}

