/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.components.XulSplitter;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.AbstractXulComponent;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.ScrollablePanel;
import org.pentaho.ui.xul.util.Align;
import org.pentaho.ui.xul.util.Orient;

public class SwingElement
extends AbstractXulComponent {
    private static final Log logger = LogFactory.getLog(SwingElement.class);
    protected JPanel container;
    protected Orient orientation;
    protected Orient orient = Orient.HORIZONTAL;
    protected GridBagConstraints gc = new GridBagConstraints();
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);

    public SwingElement(String tagName) {
        super(tagName);
    }

    public void resetContainer() {
    }

    public void layout() {
        super.layout();
        double totalFlex = 0.0;
        if (!this.isVisible()) {
            this.resetContainer();
            return;
        }
        for (Element comp : this.getChildNodes()) {
            if (((XulComponent)comp).getFlex() <= 0) continue;
            this.flexLayout = true;
            totalFlex += (double)((XulComponent)comp).getFlex();
        }
        double currentFlexTotal = 0.0;
        Align alignment = this.getAlign() != null ? Align.valueOf((String)this.getAlign().toUpperCase()) : null;
        for (int i = 0; i < this.getChildNodes().size(); ++i) {
            Object maybeComponent;
            XulComponent comp = (XulComponent)this.getChildNodes().get(i);
            this.gc.fill = 1;
            if (comp instanceof XulSplitter) {
                JPanel prevContainer = this.container;
                this.container = new ScrollablePanel(new GridBagLayout());
                this.container.setOpaque(false);
                final JSplitPane splitter = new JSplitPane(this.getOrientation() == Orient.VERTICAL ? 0 : 1, prevContainer, this.container);
                splitter.setContinuousLayout(true);
                final double splitterSize = currentFlexTotal / totalFlex;
                splitter.setResizeWeight(splitterSize);
                if (totalFlex > 0.0) {
                    splitter.addComponentListener(new ComponentListener(){

                        @Override
                        public void componentHidden(ComponentEvent arg0) {
                        }

                        @Override
                        public void componentMoved(ComponentEvent arg0) {
                        }

                        @Override
                        public void componentShown(ComponentEvent arg0) {
                        }

                        @Override
                        public void componentResized(ComponentEvent arg0) {
                            splitter.setDividerLocation(splitterSize);
                            splitter.removeComponentListener(this);
                        }
                    });
                }
                if (!this.flexLayout) {
                    if (this.getOrientation() == Orient.VERTICAL) {
                        this.gc.weighty = 1.0;
                    } else {
                        this.gc.weightx = 1.0;
                    }
                    prevContainer.add(Box.createGlue(), this.gc);
                }
                this.setManagedObject(splitter);
            }
            if ((maybeComponent = comp.getManagedObject()) == null || !(maybeComponent instanceof Component)) continue;
            if (this.getOrientation() == Orient.VERTICAL) {
                this.gc.gridheight = comp.getFlex() + 1;
                this.gc.gridwidth = 0;
                this.gc.weighty = totalFlex == 0.0 ? 0.0 : (double)comp.getFlex() / totalFlex;
            } else {
                this.gc.gridwidth = comp.getFlex() + 1;
                this.gc.gridheight = 0;
                this.gc.weightx = totalFlex == 0.0 ? 0.0 : (double)comp.getFlex() / totalFlex;
            }
            currentFlexTotal += (double)comp.getFlex();
            if (this.getOrientation() == Orient.VERTICAL) {
                if (alignment != null) {
                    this.gc.fill = 0;
                    switch (alignment) {
                        case START: {
                            this.gc.anchor = 17;
                            break;
                        }
                        case CENTER: {
                            this.gc.anchor = 10;
                            break;
                        }
                        case END: {
                            this.gc.anchor = 13;
                        }
                    }
                }
            } else if (alignment != null) {
                this.gc.fill = 0;
                switch (alignment) {
                    case START: {
                        this.gc.anchor = 11;
                        break;
                    }
                    case CENTER: {
                        this.gc.anchor = 10;
                        break;
                    }
                    case END: {
                        this.gc.anchor = 15;
                    }
                }
            }
            Component component = (Component)maybeComponent;
            if (comp.getWidth() > 0 || comp.getHeight() > 0) {
                Dimension minSize = component.getMinimumSize();
                Dimension prefSize = component.getPreferredSize();
                if (comp.getWidth() > 0) {
                    minSize.width = comp.getWidth();
                    prefSize.width = comp.getWidth();
                }
                if (comp.getHeight() > 0) {
                    minSize.height = comp.getHeight();
                    prefSize.height = comp.getHeight();
                }
                component.setMinimumSize(minSize);
                component.setPreferredSize(prefSize);
            }
            this.container.add(component, this.gc);
            if (i + 1 != this.getChildNodes().size() || this.flexLayout) continue;
            if (this.getOrientation() == Orient.VERTICAL) {
                this.gc.weighty = 1.0;
            } else {
                this.gc.weightx = 1.0;
            }
            this.container.add(Box.createGlue(), this.gc);
        }
    }

    public void setOrient(String orientation) {
        this.orientation = Orient.valueOf((String)orientation.toUpperCase());
    }

    public String getOrient() {
        return this.orientation.toString();
    }

    public Orient getOrientation() {
        return this.orientation;
    }

    public void addChild(Element e) {
        super.addChild(e);
        if (e instanceof AbstractSwingContainer) {
            AbstractSwingContainer container = (AbstractSwingContainer)e;
            if (!container.initialized) {
                container.layout();
            }
        }
        if (this.initialized) {
            this.resetContainer();
            this.layout();
        }
    }

    public void addChildAt(Element c, int pos) {
        super.addChildAt(c, pos);
        if (this.initialized) {
            this.resetContainer();
            this.layout();
        }
    }

    public void removeChild(Element ele) {
        super.removeChild(ele);
        if (this.initialized) {
            this.resetContainer();
            this.layout();
        }
    }

    public void replaceChild(XulComponent oldElement, XulComponent newElement) throws XulDomException {
        int idx = this.getChildNodes().indexOf(oldElement);
        if (idx == -1) {
            logger.error((Object)(oldElement.getName() + " not found in children"));
            throw new XulDomException(oldElement.getName() + " not found in children");
        }
        super.replaceChild(oldElement, newElement);
        this.container.removeAll();
        this.layout();
        this.container.revalidate();
    }

    public JComponent getJComponent() {
        return this.getManagedObject() instanceof JComponent ? (JComponent)this.getManagedObject() : null;
    }

    public void setOnblur(final String method) {
        super.setOnblur(method);
        if (this.getJComponent() != null) {
            this.getJComponent().addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    SwingElement.this.invoke(method);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void setDisabled(boolean disabled) {
        if (this.getJComponent() != null) {
            this.getJComponent().setEnabled(!disabled);
        }
    }

    public boolean isDisabled() {
        if (this.getJComponent() != null) {
            return !this.getJComponent().isEnabled();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getJComponent() != null) {
            this.getJComponent().setVisible(visible);
        }
    }

    public void adoptAttributes(XulComponent component) {
    }
}

