/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.plugins.JarFileAnnotationPlugin;
import org.pentaho.di.core.plugins.JarFileCache;
import org.pentaho.di.core.plugins.KettleURLClassLoader;
import org.pentaho.di.core.plugins.ParentFirst;
import org.pentaho.di.core.plugins.Plugin;
import org.pentaho.di.core.plugins.PluginExtraClassTypes;
import org.pentaho.di.core.plugins.PluginFolder;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.i18n.GlobalMessageUtil;
import org.scannotation.AnnotationDB;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class BasePluginType
implements PluginTypeInterface {
    protected static Class<?> PKG = BasePluginType.class;
    protected String id;
    protected String name;
    protected List<PluginFolderInterface> pluginFolders;
    protected PluginRegistry registry;
    protected LogChannel log;
    protected Map<Class<?>, String> objectTypes = new HashMap();
    protected boolean searchLibDir;
    Class<? extends Annotation> pluginType;

    public BasePluginType(Class<? extends Annotation> pluginType) {
        this.pluginFolders = new ArrayList<PluginFolderInterface>();
        this.log = new LogChannel("Plugin type");
        this.registry = PluginRegistry.getInstance();
        this.pluginType = pluginType;
    }

    public BasePluginType(Class<? extends Annotation> pluginType, String id, String name) {
        this(pluginType);
        this.id = id;
        this.name = name;
    }

    protected String getXmlPluginFile() {
        return null;
    }

    protected String getAlternativePluginFile() {
        return null;
    }

    protected String getMainTag() {
        return null;
    }

    protected String getSubTag() {
        return null;
    }

    protected String getPath() {
        return null;
    }

    protected boolean isReturn() {
        return false;
    }

    protected void populateFolders(String xmlSubfolder) {
        this.pluginFolders.addAll(PluginFolder.populateFolders(xmlSubfolder));
    }

    public Map<Class<?>, String> getAdditionalRuntimeObjectTypes() {
        return this.objectTypes;
    }

    @Override
    public void addObjectType(Class<?> clz, String xmlNodeName) {
        this.objectTypes.put(clz, xmlNodeName);
    }

    public String toString() {
        return this.name + "(" + this.id + ")";
    }

    @Override
    public void searchPlugins() throws KettlePluginException {
        this.registerNatives();
        this.registerPluginJars();
        this.registerXmlPlugins();
    }

    protected void registerNatives() throws KettlePluginException {
        String xmlFile = this.getXmlPluginFile();
        String alternative = null;
        if (!Utils.isEmpty(this.getAlternativePluginFile()) && !Utils.isEmpty(alternative = this.getPropertyExternal(this.getAlternativePluginFile(), null))) {
            xmlFile = alternative;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getResAsStreamExternal(xmlFile);
            if (inputStream == null) {
                inputStream = this.getResAsStreamExternal("/" + xmlFile);
            }
            if (!Utils.isEmpty(this.getAlternativePluginFile()) && inputStream == null && !Utils.isEmpty(alternative)) {
                try {
                    inputStream = this.getFileInputStreamExternal(xmlFile);
                }
                catch (Exception e) {
                    throw new KettlePluginException("Unable to load native plugins '" + xmlFile + "'", e);
                }
            }
            if (inputStream == null) {
                if (this.isReturn()) {
                    return;
                }
                throw new KettlePluginException("Unable to find native plugins definition file: " + xmlFile);
            }
            this.registerPlugins(inputStream);
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle XML config file: " + xmlFile, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @VisibleForTesting
    protected String getPropertyExternal(String key, String def) {
        return System.getProperty(key, def);
    }

    @VisibleForTesting
    protected InputStream getResAsStreamExternal(String name) {
        return this.getClass().getResourceAsStream(name);
    }

    @VisibleForTesting
    protected InputStream getFileInputStreamExternal(String name) throws FileNotFoundException {
        return new FileInputStream(name);
    }

    protected void registerPlugins(InputStream inputStream) throws KettlePluginException, KettleXMLException {
        Document document = XMLHandler.loadXMLFile(inputStream, null, true, false);
        Node repsNode = XMLHandler.getSubNode(document, this.getMainTag());
        List<Node> repsNodes = XMLHandler.getNodes(repsNode, this.getSubTag());
        for (Node repNode : repsNodes) {
            this.registerPluginFromXmlResource(repNode, this.getPath(), this.getClass(), true, null);
        }
    }

    protected abstract void registerXmlPlugins() throws KettlePluginException;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<PluginFolderInterface> getPluginFolders() {
        return this.pluginFolders;
    }

    public void setPluginFolders(List<PluginFolderInterface> pluginFolders) {
        this.pluginFolders = pluginFolders;
    }

    protected static String getCodedTranslation(String codedString) {
        if (codedString == null) {
            return null;
        }
        if (codedString.startsWith("i18n:")) {
            String[] parts = codedString.split(":");
            if (parts.length != 3) {
                return codedString;
            }
            return BaseMessages.getString(parts[1], parts[2]);
        }
        return codedString;
    }

    protected static String getTranslation(String string, String packageName, String altPackageName, Class<?> resourceClass) {
        String translation;
        if (string == null) {
            return null;
        }
        if (string.startsWith("i18n:")) {
            String[] parts = string.split(":");
            if (parts.length != 3) {
                return string;
            }
            return BaseMessages.getString(parts[1], parts[2]);
        }
        if (!Utils.isEmpty(packageName)) {
            LogLevel oldLogLevel = DefaultLogLevel.getLogLevel();
            DefaultLogLevel.setLogLevel(LogLevel.BASIC);
            translation = BaseMessages.getString(packageName, string, resourceClass, new String[0]);
            if (translation.startsWith("!") && translation.endsWith("!")) {
                translation = BaseMessages.getString(PKG, string, resourceClass, new String[0]);
            }
            DefaultLogLevel.setLogLevel(oldLogLevel);
            if (!Utils.isEmpty(altPackageName) && translation.startsWith("!") && translation.endsWith("!")) {
                translation = BaseMessages.getString(altPackageName, string, resourceClass, new String[0]);
            }
        } else {
            translation = string;
        }
        return translation;
    }

    protected List<JarFileAnnotationPlugin> findAnnotatedClassFiles(String annotationClassName) {
        JarFileCache jarFileCache = JarFileCache.getInstance();
        ArrayList<JarFileAnnotationPlugin> classFiles = new ArrayList<JarFileAnnotationPlugin>();
        for (PluginFolderInterface pluginFolder : this.getPluginFolders()) {
            if (!pluginFolder.isPluginAnnotationsFolder()) continue;
            try {
                FileObject[] fileObjects = jarFileCache.getFileObjects(pluginFolder);
                if (fileObjects == null) continue;
                for (FileObject fileObject : fileObjects) {
                    AnnotationDB annotationDB = jarFileCache.getAnnotationDB(fileObject);
                    Set impls = (Set)annotationDB.getAnnotationIndex().get(annotationClassName);
                    if (impls == null) continue;
                    for (String fil : impls) {
                        classFiles.add(new JarFileAnnotationPlugin(fil, fileObject.getURL(), fileObject.getParent().getURL()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classFiles;
    }

    protected List<FileObject> findPluginXmlFiles(String folder) {
        return this.findPluginFiles(folder, ".*\\/plugin\\.xml$");
    }

    protected List<FileObject> findPluginFiles(String folder, final String regex) {
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        try {
            FileObject folderObject = KettleVFS.getFileObject(folder);
            FileObject[] files = folderObject.findFiles(new FileSelector(){

                public boolean traverseDescendents(FileSelectInfo fileSelectInfo) throws Exception {
                    return true;
                }

                public boolean includeFile(FileSelectInfo fileSelectInfo) throws Exception {
                    return fileSelectInfo.getFile().toString().matches(regex);
                }
            });
            if (files != null) {
                Collections.addAll(list, files);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public void registerCustom(Class<?> clazz, String cat, String id, String name, String desc, String image) throws KettlePluginException {
        Class<?> pluginType = this.getClass();
        HashMap classMap = new HashMap();
        PluginMainClassType mainClassTypesAnnotation = pluginType.getAnnotation(PluginMainClassType.class);
        classMap.put(mainClassTypesAnnotation.value(), clazz.getName());
        Plugin stepPlugin = new Plugin(new String[]{id}, pluginType, mainClassTypesAnnotation.value(), cat, name, desc, image, false, false, classMap, new ArrayList<String>(), null, null, null, null, null);
        this.registry.registerPlugin(pluginType, stepPlugin);
    }

    protected PluginInterface registerPluginFromXmlResource(Node pluginNode, String path, Class<? extends PluginTypeInterface> pluginType, boolean nativePlugin, URL pluginFolder) throws KettlePluginException {
        try {
            String id = XMLHandler.getTagAttribute(pluginNode, "id");
            String description = this.getTagOrAttribute(pluginNode, "description");
            String iconfile = this.getTagOrAttribute(pluginNode, "iconfile");
            String tooltip = this.getTagOrAttribute(pluginNode, "tooltip");
            String category = this.getTagOrAttribute(pluginNode, "category");
            String classname = this.getTagOrAttribute(pluginNode, "classname");
            String errorHelpfile = this.getTagOrAttribute(pluginNode, "errorhelpfile");
            String documentationUrl = this.getTagOrAttribute(pluginNode, "documentation_url");
            String casesUrl = this.getTagOrAttribute(pluginNode, "cases_url");
            String forumUrl = this.getTagOrAttribute(pluginNode, "forum_url");
            String suggestion = this.getTagOrAttribute(pluginNode, "suggestion");
            Node libsnode = XMLHandler.getSubNode(pluginNode, "libraries");
            int nrlibs = XMLHandler.countNodes(libsnode, "library");
            ArrayList<String> jarFiles = new ArrayList<String>();
            if (path != null) {
                for (int j = 0; j < nrlibs; ++j) {
                    Node libnode = XMLHandler.getSubNodeByNr(libsnode, "library", j);
                    String jarfile = XMLHandler.getTagAttribute(libnode, "name");
                    jarFiles.add(new File(path + Const.FILE_SEPARATOR + jarfile).getAbsolutePath());
                }
            }
            Map<String, String> localizedCategories = this.readPluginLocale(pluginNode, "localized_category", "category");
            category = this.getAlternativeTranslation(category, localizedCategories);
            Map<String, String> localDescriptions = this.readPluginLocale(pluginNode, "localized_description", "description");
            description = this.getAlternativeTranslation(description, localDescriptions);
            description = description + this.addDeprecation(category);
            suggestion = this.getAlternativeTranslation(suggestion, localDescriptions);
            Map<String, String> localizedTooltips = this.readPluginLocale(pluginNode, "localized_tooltip", "tooltip");
            tooltip = this.getAlternativeTranslation(tooltip, localizedTooltips);
            String iconFilename = path == null ? iconfile : path + Const.FILE_SEPARATOR + iconfile;
            String errorHelpFileFull = errorHelpfile;
            if (!Utils.isEmpty(errorHelpfile)) {
                errorHelpFileFull = path == null ? errorHelpfile : path + Const.FILE_SEPARATOR + errorHelpfile;
            }
            HashMap classMap = new HashMap();
            PluginMainClassType mainClassTypesAnnotation = pluginType.getAnnotation(PluginMainClassType.class);
            classMap.put(mainClassTypesAnnotation.value(), classname);
            PluginExtraClassTypes classTypesAnnotation = pluginType.getAnnotation(PluginExtraClassTypes.class);
            if (classTypesAnnotation != null) {
                for (int i = 0; i < classTypesAnnotation.classTypes().length; ++i) {
                    Class<?> classType = classTypesAnnotation.classTypes()[i];
                    String className = this.getTagOrAttribute(pluginNode, classTypesAnnotation.xmlNodeNames()[i]);
                    classMap.put(classType, className);
                }
            }
            Map<Class<?>, String> objectMap = this.getAdditionalRuntimeObjectTypes();
            for (Map.Entry<Class<?>, String> entry : objectMap.entrySet()) {
                String clzName = this.getTagOrAttribute(pluginNode, entry.getValue());
                classMap.put(entry.getKey(), clzName);
            }
            Plugin pluginInterface = new Plugin(id.split(","), pluginType, mainClassTypesAnnotation.value(), category, description, tooltip, iconFilename, false, nativePlugin, classMap, jarFiles, errorHelpFileFull, pluginFolder, documentationUrl, casesUrl, forumUrl, suggestion);
            this.registry.registerPlugin(pluginType, pluginInterface);
            return pluginInterface;
        }
        catch (Throwable e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "BasePluginType.RuntimeError.UnableToReadPluginXML.PLUGIN0001", new String[0]), e);
        }
    }

    protected String getTagOrAttribute(Node pluginNode, String tag) {
        String string = XMLHandler.getTagValue(pluginNode, tag);
        if (string == null) {
            string = XMLHandler.getTagAttribute(pluginNode, tag);
        }
        return string;
    }

    protected String getAlternativeTranslation(String input, Map<String, String> localizedMap) {
        if (Utils.isEmpty(input)) {
            return null;
        }
        if (input.startsWith("i18n")) {
            return BasePluginType.getCodedTranslation(input);
        }
        for (Locale locale : GlobalMessageUtil.getActiveLocales()) {
            String alt = localizedMap.get(locale.toString().toLowerCase());
            if (Utils.isEmpty(alt)) continue;
            return alt;
        }
        return input;
    }

    protected Map<String, String> readPluginLocale(Node pluginNode, String localizedTag, String translationTag) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        Node locTipsNode = XMLHandler.getSubNode(pluginNode, localizedTag);
        int nrLocTips = XMLHandler.countNodes(locTipsNode, translationTag);
        for (int j = 0; j < nrLocTips; ++j) {
            Node locTipNode = XMLHandler.getSubNodeByNr(locTipsNode, translationTag, j);
            if (locTipNode == null) continue;
            String locale = XMLHandler.getTagAttribute(locTipNode, "locale");
            String locTip = XMLHandler.getNodeValue(locTipNode);
            if (Utils.isEmpty(locale) || Utils.isEmpty(locTip)) continue;
            map.put(locale.toLowerCase(), locTip);
        }
        return map;
    }

    protected URLClassLoader createUrlClassLoader(URL jarFileUrl, ClassLoader classLoader) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            String libFolderName = new File(URLDecoder.decode(jarFileUrl.getFile(), "UTF-8")).getParent() + Const.FILE_SEPARATOR + "lib";
            if (new File(libFolderName).exists()) {
                FileObject[] libFiles;
                PluginFolder pluginFolder = new PluginFolder(libFolderName, false, true, this.searchLibDir);
                for (FileObject libFile : libFiles = pluginFolder.findJarFiles(true)) {
                    urls.add(libFile.getURL());
                }
            }
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Unexpected error searching for jar files in lib/ folder next to '" + jarFileUrl + "'", e);
        }
        urls.add(jarFileUrl);
        return new KettleURLClassLoader(urls.toArray(new URL[urls.size()]), classLoader);
    }

    protected abstract String extractID(Annotation var1);

    protected abstract String extractName(Annotation var1);

    protected abstract String extractDesc(Annotation var1);

    protected abstract String extractCategory(Annotation var1);

    protected abstract String extractImageFile(Annotation var1);

    protected abstract boolean extractSeparateClassLoader(Annotation var1);

    protected abstract String extractI18nPackageName(Annotation var1);

    protected abstract String extractDocumentationUrl(Annotation var1);

    protected abstract String extractSuggestion(Annotation var1);

    protected abstract String extractCasesUrl(Annotation var1);

    protected abstract String extractForumUrl(Annotation var1);

    protected String extractClassLoaderGroup(Annotation annotation) {
        return null;
    }

    protected void setTransverseLibDirs(boolean transverseLibDirs) {
        this.searchLibDir = transverseLibDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerPluginJars() throws KettlePluginException {
        List<JarFileAnnotationPlugin> jarFilePlugins = this.findAnnotatedClassFiles(this.pluginType.getName());
        for (JarFileAnnotationPlugin jarFilePlugin : jarFilePlugins) {
            URLClassLoader urlClassLoader = this.createUrlClassLoader(jarFilePlugin.getJarFile(), this.getClass().getClassLoader());
            try {
                Class<?> clazz = urlClassLoader.loadClass(jarFilePlugin.getClassName());
                if (clazz == null) {
                    throw new KettlePluginException("Unable to load class: " + jarFilePlugin.getClassName());
                }
                List<String> libraries = Arrays.stream(urlClassLoader.getURLs()).map(URL::getFile).collect(Collectors.toList());
                Annotation annotation = clazz.getAnnotation(this.pluginType);
                this.handlePluginAnnotation(clazz, annotation, libraries, false, jarFilePlugin.getPluginFolder());
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Unexpected error registering jar plugin file: " + jarFilePlugin.getJarFile(), e);
            }
            finally {
                if (urlClassLoader == null || !(urlClassLoader instanceof KettleURLClassLoader)) continue;
                ((KettleURLClassLoader)urlClassLoader).closeClassLoader();
            }
        }
    }

    @Override
    public void handlePluginAnnotation(Class<?> clazz, Annotation annotation, List<String> libraries, boolean nativePluginType, URL pluginFolder) throws KettlePluginException {
        String idList = this.extractID(annotation);
        if (Utils.isEmpty(idList)) {
            throw new KettlePluginException("No ID specified for plugin with class: " + clazz.getName());
        }
        String[] ids = idList.split(",");
        String packageName = this.extractI18nPackageName(annotation);
        String altPackageName = clazz.getPackage().getName();
        String name = BasePluginType.getTranslation(this.extractName(annotation), packageName, altPackageName, clazz);
        String description = BasePluginType.getTranslation(this.extractDesc(annotation), packageName, altPackageName, clazz);
        String category = BasePluginType.getTranslation(this.extractCategory(annotation), packageName, altPackageName, clazz);
        String imageFile = this.extractImageFile(annotation);
        boolean separateClassLoader = this.extractSeparateClassLoader(annotation);
        String documentationUrl = this.extractDocumentationUrl(annotation);
        String casesUrl = this.extractCasesUrl(annotation);
        String forumUrl = this.extractForumUrl(annotation);
        String suggestion = BasePluginType.getTranslation(this.extractSuggestion(annotation), packageName, altPackageName, clazz);
        String classLoaderGroup = this.extractClassLoaderGroup(annotation);
        name = name + this.addDeprecation(category);
        HashMap classMap = new HashMap();
        PluginMainClassType mainType = this.getClass().getAnnotation(PluginMainClassType.class);
        classMap.put(mainType.value(), clazz.getName());
        this.addExtraClasses(classMap, clazz, annotation);
        Plugin plugin = new Plugin(ids, this.getClass(), mainType.value(), category, name, description, imageFile, separateClassLoader, classLoaderGroup, nativePluginType, classMap, libraries, null, pluginFolder, documentationUrl, casesUrl, forumUrl, suggestion);
        ParentFirst parentFirstAnnotation = clazz.getAnnotation(ParentFirst.class);
        if (parentFirstAnnotation != null) {
            this.registry.addParentClassLoaderPatterns(plugin, parentFirstAnnotation.patterns());
        }
        this.registry.registerPlugin(this.getClass(), plugin);
        if (libraries != null && libraries.size() > 0) {
            LogChannel.GENERAL.logDetailed("Plugin with id [" + ids[0] + "] has " + libraries.size() + " libaries in its private class path");
        }
    }

    protected abstract void addExtraClasses(Map<Class<?>, String> var1, Class<?> var2, Annotation var3);

    private String addDeprecation(String category) {
        String deprecated = BaseMessages.getString(PKG, "PluginRegistry.Category.Deprecated", new String[0]);
        if (deprecated.equals(category)) {
            return " (" + deprecated.toLowerCase() + ")";
        }
        return "";
    }
}

