/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.oozie.BinaryBlob;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.StringBlob;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonSLAEvent;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.service.SchemaCheckerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.Pair;
import org.apache.oozie.util.XLog;
import org.apache.openjpa.persistence.jdbc.Index;

public class SchemaCheckXCommand
extends XCommand<Void> {
    private XLog LOG = XLog.getLog(SchemaCheckXCommand.class);
    private String dbType;
    private String url;
    private String user;
    private String pass;
    private boolean ignoreExtras;

    public SchemaCheckXCommand(String dbType, String url, String user, String pass, boolean ignoreExtras) {
        super("schema-check", "schema-check", 0);
        this.dbType = dbType;
        this.url = url;
        this.user = user;
        this.pass = pass;
        this.ignoreExtras = ignoreExtras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute() throws CommandException {
        Connection conn = null;
        this.LOG.info("About to check database schema");
        Date startTime = new Date();
        boolean problem = false;
        try {
            conn = DriverManager.getConnection(this.url, this.user, this.pass);
            String catalog = conn.getCatalog();
            DatabaseMetaData metaData = conn.getMetaData();
            HashMap<String, Class<WorkflowJobBean>> tableClasses = new HashMap<String, Class<WorkflowJobBean>>();
            tableClasses.put(this.getTableName(BundleActionBean.class), BundleActionBean.class);
            tableClasses.put(this.getTableName(BundleJobBean.class), BundleJobBean.class);
            tableClasses.put(this.getTableName(CoordinatorActionBean.class), CoordinatorActionBean.class);
            tableClasses.put(this.getTableName(CoordinatorJobBean.class), CoordinatorJobBean.class);
            tableClasses.put(this.getTableName(JsonSLAEvent.class), JsonSLAEvent.class);
            tableClasses.put(this.getTableName(SLARegistrationBean.class), SLARegistrationBean.class);
            tableClasses.put(this.getTableName(SLASummaryBean.class), SLASummaryBean.class);
            tableClasses.put(this.getTableName(WorkflowActionBean.class), WorkflowActionBean.class);
            tableClasses.put(this.getTableName(WorkflowJobBean.class), WorkflowJobBean.class);
            boolean tableProblem = this.checkTables(metaData, catalog, tableClasses.keySet());
            problem |= tableProblem;
            if (!tableProblem) {
                for (Map.Entry table : tableClasses.entrySet()) {
                    TableInfo ti = new TableInfo((Class)table.getValue(), this.dbType);
                    boolean columnProblem = this.checkColumns(metaData, catalog, (String)table.getKey(), ti.columnTypes);
                    problem |= columnProblem;
                    if (columnProblem) continue;
                    boolean primaryKeyProblem = this.checkPrimaryKey(metaData, catalog, (String)table.getKey(), ti.primaryKeyColumn);
                    problem |= primaryKeyProblem;
                    boolean indexProblem = this.checkIndexes(metaData, catalog, (String)table.getKey(), ti.indexedColumns);
                    problem |= indexProblem;
                }
            }
            if (problem) {
                this.LOG.error("Database schema is BAD! Check previous error log messages for details");
            } else {
                this.LOG.info("Database schema is GOOD");
            }
        }
        catch (SQLException sqle) {
            this.LOG.error((Object)("An Exception occured while talking to the database: " + sqle.getMessage()), sqle);
            problem = true;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    this.LOG.error((Object)("An Exception occured while disconnecting from the database: " + e.getMessage()), e);
                }
            }
            Services.get().get(SchemaCheckerService.class).updateInstrumentation(problem, startTime);
        }
        return null;
    }

    private boolean checkTables(DatabaseMetaData metaData, String catalog, Collection<String> expectedTablesRaw) throws SQLException {
        boolean problem = false;
        HashSet<String> expectedTables = new HashSet<String>(expectedTablesRaw);
        expectedTables.add(this.caseTableName("oozie_sys"));
        expectedTables.add(this.caseTableName("openjpa_sequence_table"));
        expectedTables.add(this.caseTableName("validate_conn"));
        String schema = null;
        if (this.dbType.equals("oracle")) {
            schema = "OOZIE";
        }
        ResultSet rs = metaData.getTables(catalog, schema, null, new String[]{"TABLE"});
        HashSet<String> foundTables = new HashSet<String>();
        while (rs.next()) {
            String tabName = rs.getString("TABLE_NAME");
            if (tabName == null) continue;
            foundTables.add(tabName);
        }
        Collection missingTables = CollectionUtils.subtract(expectedTables, foundTables);
        if (!missingTables.isEmpty()) {
            this.LOG.error("Found [{0}] missing tables: {1}", missingTables.size(), Arrays.toString(missingTables.toArray()));
            problem = true;
        } else if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("No missing tables found: {0}", Arrays.toString(expectedTables.toArray()));
        }
        if (!this.ignoreExtras) {
            Collection extraTables = CollectionUtils.subtract(foundTables, expectedTables);
            if (!extraTables.isEmpty()) {
                this.LOG.error("Found [{0}] extra tables: {1}", extraTables.size(), Arrays.toString(extraTables.toArray()));
                problem = true;
            } else {
                this.LOG.debug("No extra tables found");
            }
        }
        return problem;
    }

    private boolean checkColumns(DatabaseMetaData metaData, String catalog, String table, Map<String, Integer> expectedColumnTypes) throws SQLException {
        boolean problem = false;
        HashMap<String, Pair<Integer, String>> foundColumns = new HashMap<String, Pair<Integer, String>>();
        ResultSet rs = metaData.getColumns(catalog, null, table, null);
        while (rs.next()) {
            String colName = rs.getString("COLUMN_NAME");
            Integer dataType = rs.getInt("DATA_TYPE");
            String colDef = rs.getString("COLUMN_DEF");
            if (colName == null) continue;
            foundColumns.put(colName, new Pair<Integer, String>(dataType, colDef));
        }
        Collection missingColumns = CollectionUtils.subtract(expectedColumnTypes.keySet(), foundColumns.keySet());
        if (!missingColumns.isEmpty()) {
            this.LOG.error("Found [{0}] missing columns in table [{1}]: {2}", missingColumns.size(), table, Arrays.toString(missingColumns.toArray()));
            problem = true;
        } else {
            for (Map.Entry<String, Integer> ent : expectedColumnTypes.entrySet()) {
                if (!((Integer)((Pair)foundColumns.get(ent.getKey())).getFist()).equals(ent.getValue())) {
                    this.LOG.error("Expected column [{0}] in table [{1}] to have type [{2}], but found type [{3}]", ent.getKey(), table, this.getSQLTypeFromInt(ent.getValue()), this.getSQLTypeFromInt((Integer)((Pair)foundColumns.get(ent.getKey())).getFist()));
                    problem = true;
                    continue;
                }
                if (((Pair)foundColumns.get(ent.getKey())).getSecond() != null) {
                    this.LOG.error("Expected column [{0}] in table [{1}] to have default value [NULL], but found default vale [{2}]", ent.getKey(), table, ((Pair)foundColumns.get(ent.getKey())).getSecond());
                    problem = true;
                    continue;
                }
                this.LOG.debug("Found column [{0}] in table [{1}] with type [{2}] and default value [NULL]", ent.getKey(), table, this.getSQLTypeFromInt(ent.getValue()));
            }
        }
        if (!this.ignoreExtras) {
            Collection extraColumns = CollectionUtils.subtract(foundColumns.keySet(), expectedColumnTypes.keySet());
            if (!extraColumns.isEmpty()) {
                this.LOG.error("Found [{0}] extra columns in table [{1}]: {2}", extraColumns.size(), table, Arrays.toString(extraColumns.toArray()));
                problem = true;
            } else {
                this.LOG.debug("No extra columns found in table [{0}]", table);
            }
        }
        return problem;
    }

    private boolean checkPrimaryKey(DatabaseMetaData metaData, String catalog, String table, String expectedPrimaryKeyColumn) throws SQLException {
        boolean problem = false;
        ResultSet rs = metaData.getPrimaryKeys(catalog, null, table);
        if (!rs.next()) {
            this.LOG.error("Expected column [{0}] to be the primary key in table [{1}], but none were found", expectedPrimaryKeyColumn, table);
            problem = true;
        } else {
            String foundPrimaryKeyColumn = rs.getString("COLUMN_NAME");
            if (!foundPrimaryKeyColumn.equals(expectedPrimaryKeyColumn)) {
                this.LOG.error("Expected column [{0}] to be the primary key in table [{1}], but found column [{2}] instead", expectedPrimaryKeyColumn, table, foundPrimaryKeyColumn);
                problem = true;
            } else {
                this.LOG.debug("Found column [{0}] to be the primary key in table [{1}]", expectedPrimaryKeyColumn, table);
            }
        }
        return problem;
    }

    private boolean checkIndexes(DatabaseMetaData metaData, String catalog, String table, Set<String> expectedIndexedColumns) throws SQLException {
        boolean problem = false;
        HashSet<String> foundIndexedColumns = new HashSet<String>();
        ResultSet rs = metaData.getIndexInfo(catalog, null, table, false, true);
        while (rs.next()) {
            String colName = rs.getString("COLUMN_NAME");
            if (colName == null) continue;
            foundIndexedColumns.add(colName);
        }
        Collection missingIndexColumns = CollectionUtils.subtract(expectedIndexedColumns, foundIndexedColumns);
        if (!missingIndexColumns.isEmpty()) {
            this.LOG.error("Found [{0}] missing indexes for columns in table [{1}]: {2}", missingIndexColumns.size(), table, Arrays.toString(missingIndexColumns.toArray()));
            problem = true;
        } else if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("No missing indexes found in table [{0}]: {1}", table, Arrays.toString(expectedIndexedColumns.toArray()));
        }
        if (!this.ignoreExtras) {
            Collection extraIndexColumns = CollectionUtils.subtract(foundIndexedColumns, expectedIndexedColumns);
            if (!extraIndexColumns.isEmpty()) {
                this.LOG.error("Found [{0}] extra indexes for columns in table [{1}]: {2}", extraIndexColumns.size(), table, Arrays.toString(extraIndexColumns.toArray()));
                problem = true;
            } else {
                this.LOG.debug("No extra indexes found in table [{0}]", table);
            }
        }
        return problem;
    }

    private String getTableName(Class<? extends JsonBean> clazz) {
        Table tabAnn = clazz.getAnnotation(Table.class);
        if (tabAnn != null) {
            return this.caseTableName(tabAnn.name());
        }
        return null;
    }

    private String caseTableName(String name) {
        if (this.dbType.equals("mysql") || this.dbType.equals("oracle")) {
            return name.toUpperCase();
        }
        if (this.dbType.equals("postgresql")) {
            return name.toLowerCase();
        }
        return name;
    }

    private String getSQLTypeFromInt(int t) {
        switch (t) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
            case 70: {
                return "DATALINK";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -8: {
                return "ROWID";
            }
            case -15: {
                return "NCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 2009: {
                return "SQLXML";
            }
        }
        return "unknown";
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    private static class TableInfo {
        String primaryKeyColumn;
        Map<String, Integer> columnTypes = new HashMap<String, Integer>();
        Set<String> indexedColumns = new HashSet<String>();

        public TableInfo(Class<? extends JsonBean> clazz, String dbType) {
            this.populate(clazz, dbType);
            if (clazz.equals(JsonSLAEvent.class)) {
                this.populate(SLAEventBean.class, dbType);
            }
        }

        private void populate(Class<? extends JsonBean> clazz, String dbType) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Column colAnn = field.getAnnotation(Column.class);
                if (colAnn != null) {
                    boolean isPrimaryKey;
                    boolean isIndex;
                    String name = TableInfo.caseColumnName(colAnn.name(), dbType);
                    boolean isLob = field.getAnnotation(Lob.class) != null;
                    Integer type = TableInfo.getSQLType(field.getType(), isLob, dbType);
                    this.columnTypes.put(name, type);
                    boolean bl = isIndex = field.getAnnotation(Index.class) != null;
                    if (isIndex) {
                        this.indexedColumns.add(name);
                    }
                    boolean bl2 = isPrimaryKey = field.getAnnotation(Id.class) != null;
                    if (!isPrimaryKey) continue;
                    this.indexedColumns.add(name);
                    this.primaryKeyColumn = name;
                    continue;
                }
                Id idAnn = field.getAnnotation(Id.class);
                if (idAnn == null) continue;
                String name = TableInfo.caseColumnName(field.getName(), dbType);
                boolean isLob = field.getAnnotation(Lob.class) != null;
                Integer type = TableInfo.getSQLType(field.getType(), isLob, dbType);
                this.columnTypes.put(name, type);
                this.indexedColumns.add(name);
                this.primaryKeyColumn = name;
            }
            DiscriminatorColumn discAnn = clazz.getAnnotation(DiscriminatorColumn.class);
            if (discAnn != null) {
                String name = TableInfo.caseColumnName(discAnn.name(), dbType);
                Integer type = TableInfo.getSQLType(discAnn.discriminatorType());
                this.columnTypes.put(name, type);
                this.indexedColumns.add(name);
            }
            if (dbType.equals("mysql") && clazz.equals(WorkflowActionBean.class)) {
                this.indexedColumns.remove("wf_id");
            }
        }

        private static Integer getSQLType(Class<?> clazz, boolean isLob, String dbType) {
            if (clazz.equals(String.class)) {
                if (dbType.equals("mysql") && isLob) {
                    return -1;
                }
                if (dbType.equals("oracle") && isLob) {
                    return 2005;
                }
                return 12;
            }
            if (clazz.equals(StringBlob.class) || clazz.equals(BinaryBlob.class)) {
                if (dbType.equals("mysql")) {
                    return -4;
                }
                if (dbType.equals("oracle")) {
                    return 2004;
                }
                return -2;
            }
            if (clazz.equals(Timestamp.class)) {
                return 93;
            }
            if (clazz.equals(Integer.TYPE)) {
                if (dbType.equals("oracle")) {
                    return 3;
                }
                return 4;
            }
            if (clazz.equals(Long.TYPE)) {
                if (dbType.equals("oracle")) {
                    return 3;
                }
                return -5;
            }
            if (clazz.equals(Byte.TYPE)) {
                if (dbType.equals("mysql")) {
                    return -6;
                }
                if (dbType.equals("oracle")) {
                    return 3;
                }
                return 5;
            }
            return null;
        }

        private static Integer getSQLType(DiscriminatorType discType) {
            switch (discType) {
                case STRING: {
                    return 12;
                }
                case CHAR: {
                    return 1;
                }
                case INTEGER: {
                    return 4;
                }
            }
            return null;
        }

        private static String caseColumnName(String name, String dbType) {
            if (dbType.equals("oracle")) {
                return name.toUpperCase();
            }
            if (dbType.equals("postgresql") || dbType.equals("mysql")) {
                return name.toLowerCase();
            }
            return name;
        }
    }
}

