/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalValues
extends Values {
    public LogicalValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        super(cluster, rowType, tuples, cluster.traitSetOf(Convention.NONE));
    }

    public LogicalValues(RelInput input) {
        super(input);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        assert (inputs.isEmpty());
        return new LogicalValues(this.getCluster(), this.rowType, (ImmutableList<ImmutableList<RexLiteral>>)this.tuples);
    }

    public static LogicalValues createEmpty(RelOptCluster cluster, RelDataType rowType) {
        return new LogicalValues(cluster, rowType, (ImmutableList<ImmutableList<RexLiteral>>)ImmutableList.of());
    }

    public static LogicalValues createOneRow(RelOptCluster cluster) {
        RelDataType rowType = cluster.getTypeFactory().builder().add("ZERO", SqlTypeName.INTEGER).nullable(false).build();
        ImmutableList tuples = ImmutableList.of((Object)ImmutableList.of((Object)cluster.getRexBuilder().makeExactLiteral(BigDecimal.ZERO, rowType.getFieldList().get(0).getType())));
        return new LogicalValues(cluster, rowType, (ImmutableList<ImmutableList<RexLiteral>>)tuples);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }
}

