/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JPingDS;
import com.ibm.as400.access.JPingEchoDS;
import com.ibm.as400.access.JPingEchoReplyDS;
import com.ibm.as400.access.PortMapper;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;

public class AS400JPing {
    public static final int ALL_SERVICES = 99;
    private String systemName_;
    private int service_ = 99;
    private int length_ = 10;
    private boolean echo_ = false;
    private SSLOptions useSSL_ = null;
    private long time_ = 20000L;
    private PrintWriter writer_;
    private SocketContainer sc_;
    private Socket s_;
    private Thread thread_;
    private JPingThread jpingThread;
    private SocketProperties socketProperties_ = new SocketProperties();
    private static ResourceBundleLoader loader_;

    public AS400JPing(String string) {
        this(string, 99, false);
    }

    public AS400JPing(String string, int n) {
        this(string, n, false);
    }

    public AS400JPing(String string, int n, boolean bl) {
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (n < 0 || n > 7 && n != 99) {
            throw new ExtendedIllegalArgumentException("service", 2);
        }
        this.systemName_ = string;
        this.service_ = n;
        this.useSSL_ = bl ? new SSLOptions() : null;
    }

    public boolean ping() {
        if (this.service_ == 99) {
            boolean bl = true;
            for (int i = 0; i <= 7; ++i) {
                boolean bl2 = bl = bl && this.ping(i);
                if (bl) continue;
                return bl;
            }
            return bl;
        }
        return this.ping(this.service_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean ping(int n) {
        try {
            if (Trace.isTraceOn()) {
                Trace.log(3, "Ping System:   " + this.systemName_);
                Trace.log(3, "Ping Service:  " + AS400.getServerName(n));
                Trace.log(3, "Packet Length: " + this.length_);
                Trace.log(3, "Echo Packet:   " + (this.echo_ ? "on" : "off"));
                Trace.log(3, "Ping SSL Port: " + (this.useSSL_ != null ? "yes" : "no"));
            }
            this.service_ = n;
            if (n == 5) {
                this.pingDDM();
            } else {
                this.jpingThread = new JPingThread();
                Object object = this;
                synchronized (object) {
                    block24: {
                        try {
                            if (Trace.isTraceOn()) {
                                Trace.log(3, "Ping Timeout:  " + this.time_ + "(ms)");
                            }
                            this.wait(this.time_);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!Trace.isTraceOn()) break block24;
                            Trace.log(2, "Unexpected exception.", (Throwable)interruptedException);
                        }
                    }
                }
                if (this.sc_ == null) {
                    this.thread_.stop();
                    throw new Exception("Ping timeout occurred.");
                }
                object = this.sc_.getInputStream();
                OutputStream outputStream = this.sc_.getOutputStream();
                byte[] byArray = new byte[this.length_];
                for (int i = 0; i < this.length_; ++i) {
                    byArray[i] = -35;
                }
                if (this.echo_) {
                    JPingEchoDS jPingEchoDS = new JPingEchoDS(n, byArray);
                    jPingEchoDS.write(outputStream);
                    outputStream.flush();
                    JPingEchoReplyDS jPingEchoReplyDS = new JPingEchoReplyDS(byArray.length);
                    if (jPingEchoReplyDS.read((InputStream)object) != this.length_) {
                        Trace.log(2, "Bytes echoed did not match then number of bytes sent.");
                        throw new ConnectionDroppedException(2);
                    }
                } else {
                    JPingDS jPingDS = new JPingDS(n, byArray);
                    jPingDS.write(outputStream);
                    outputStream.flush();
                }
                try {
                    outputStream.close();
                    ((InputStream)object).close();
                    this.sc_.close();
                }
                catch (Exception exception) {
                    Trace.log(2, "Problem closing the streams and socket connections.");
                }
            }
            if (this.writer_ != null) {
                this.writer_.println(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("PROP_NAME_AJP_SUCCESS"), new String[]{AS400.getServerName(n), this.useSSL_ != null ? "-s" : ""}));
            }
            return true;
        }
        catch (ServerStartupException serverStartupException) {
            if (this.writer_ != null) {
                this.writer_.println(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("PROP_NAME_AJP_FAILED"), new String[]{AS400.getServerName(n), this.useSSL_ != null ? "-s" : ""}));
            }
            if (Trace.isTraceOn()) {
                Trace.log(2, serverStartupException);
            }
            return false;
        }
        catch (Exception exception) {
            if (this.writer_ != null) {
                this.writer_.println(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("PROP_NAME_AJP_FAILED"), new String[]{AS400.getServerName(n), this.useSSL_ != null ? "-s" : ""}));
            }
            if (Trace.isTraceOn()) {
                Trace.log(2, exception);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingDDM() throws Exception {
        byte[] byArray = new byte[]{0, 117, -48, 1, 0, 0, 0, 111, 16, 65, 0, 11, 17, 71, 0, 7, 0, 9, -40, -63, -30, 0, 96, 20, 4, 20, 3, 0, 3, 20, 35, 0, 3, 20, 5, 0, 3, 20, 6, 0, 3, 20, 7, 0, 3, 20, 116, 0, 5, 20, 88, 0, 1, 20, 87, 0, 3, 20, 12, 0, 3, 20, 25, 0, 3, 20, 30, 0, 3, 20, 34, 0, 3, 36, 15, 0, 3, 20, 50, 0, 3, 20, 51, 0, 3, 20, 64, 0, 1, 20, 59, 0, 3, 36, 7, 0, 3, 20, 99, 0, 3, 20, 101, 0, 3, 20, 60, 0, 3, 20, 127, 0, 4, 20, -96, 0, 4};
        byte[] byArray2 = new byte[]{0, 113, -48, 3, 0, 0, 0, 107, 20, 67, 0, 7, 17, 71, -40, -63, -30, 0, 96, 20, 4, 20, 3, 0, 3, 20, 35, 0, 3, 20, 5, 0, 3, 20, 6, 0, 3, 20, 7, 0, 3, 20, 116, 0, 5, 20, 88, 0, 1, 20, 87, 0, 3, 20, 12, 0, 3, 20, 25, 0, 3, 20, 30, 0, 3, 20, 34, 0, 3, 36, 15, 0, 3, 20, -96, 0, 4, 20, 50, 0, 3, 20, 51, 0, 3, 20, 64, 0, 1, 20, 59, 0, 3, 36, 7, 0, 3, 20, 99, 0, 3, 20, 101, 0, 3, 20, 60, 0, 3, 20, 127, 0, 4};
        try {
            this.jpingThread = new JPingThread();
            Object object = this;
            synchronized (object) {
                block11: {
                    try {
                        if (Trace.isTraceOn()) {
                            Trace.log(3, "Ping Timeout:  " + this.time_ + "(ms)");
                        }
                        this.wait(this.time_);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!Trace.isTraceOn()) break block11;
                        Trace.log(2, "Unexpected exception.", (Throwable)interruptedException);
                    }
                }
            }
            if (this.s_ == null) {
                this.thread_.stop();
                throw new Exception("Ping Timeout occurred.");
            }
            object = this.s_.getOutputStream();
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).flush();
            InputStream inputStream = this.s_.getInputStream();
            byte[] byArray3 = new byte[113];
            inputStream.read(byArray3);
            inputStream.close();
            ((OutputStream)object).close();
            this.s_.close();
            for (int i = 0; i < 113; ++i) {
                if (byArray3[i] == byArray2[i]) continue;
                Trace.log(2, "Unexpected ddm server response.");
                throw new Exception();
            }
        }
        catch (Exception exception) {
            if (exception.getMessage().equals("Ping Timeout occurred.")) {
                throw exception;
            }
            throw new Exception("Unexpected exception.");
        }
    }

    public void setPrintWriter(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("stream");
        }
        this.writer_ = new PrintWriter(outputStream, true);
    }

    public void setTimeout(long l) {
        this.time_ = l;
    }

    void setLength(int n) {
        if (n < 1 || n > 1000) {
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        this.length_ = n;
    }

    void setUseEcho(boolean bl) {
        this.echo_ = bl;
    }

    private class JPingThread
    implements Runnable {
        JPingThread() {
            AS400JPing.this.thread_ = new Thread(this);
            AS400JPing.this.thread_.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: {
                try {
                    if (AS400JPing.this.service_ == 5) {
                        AS400JPing.this.s_ = new Socket(AS400JPing.this.systemName_, 446);
                    } else {
                        AS400JPing.this.sc_ = PortMapper.getServerSocket(AS400JPing.this.systemName_, AS400JPing.this.service_, AS400JPing.this.useSSL_, AS400JPing.this.socketProperties_, false);
                    }
                }
                catch (Exception exception) {
                    if (!Trace.isTraceOn()) break block7;
                    Trace.log(2, "Unexpected exception.", (Throwable)exception);
                }
            }
            AS400JPing aS400JPing = AS400JPing.this;
            synchronized (aS400JPing) {
                AS400JPing.this.notifyAll();
            }
        }
    }
}

