/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface MetadataStore
extends Closeable {
    public void initialize(FileSystem var1) throws IOException;

    public void initialize(Configuration var1) throws IOException;

    public void delete(Path var1) throws IOException;

    @VisibleForTesting
    public void forgetMetadata(Path var1) throws IOException;

    public void deleteSubtree(Path var1) throws IOException;

    public PathMetadata get(Path var1) throws IOException;

    public PathMetadata get(Path var1, boolean var2) throws IOException;

    public DirListingMetadata listChildren(Path var1) throws IOException;

    public void move(Collection<Path> var1, Collection<PathMetadata> var2) throws IOException;

    public void put(PathMetadata var1) throws IOException;

    public void put(DirListingMetadata var1) throws IOException;

    public void destroy() throws IOException;

    public void prune(long var1) throws IOException, UnsupportedOperationException;
}

