/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.Upload;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.s3a.BlockingThreadPoolExecutorService;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.fs.s3a.Listing;
import org.apache.hadoop.fs.s3a.ProgressableProgressListener;
import org.apache.hadoop.fs.s3a.RenameFailedException;
import org.apache.hadoop.fs.s3a.S3ABlockOutputStream;
import org.apache.hadoop.fs.s3a.S3ADataBlocks;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3AOutputStream;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.SemaphoredDelegatingExecutor;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.UploadInfo;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStoreListFilesIterator;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.fs.s3native.S3xLoginHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AFileSystem
extends FileSystem {
    public static final int DEFAULT_BLOCKSIZE = 0x2000000;
    private URI uri;
    private Path workingDir;
    private String username;
    private AmazonS3 s3;
    private String bucket;
    private int maxKeys;
    private Listing listing;
    private long partSize;
    private boolean enableMultiObjectsDelete;
    private TransferManager transfers;
    private ListeningExecutorService boundedThreadPool;
    private ExecutorService unboundedThreadPool;
    private long multiPartThreshold;
    public static final Logger LOG = LoggerFactory.getLogger(S3AFileSystem.class);
    private static final Logger PROGRESS = LoggerFactory.getLogger((String)"org.apache.hadoop.fs.s3a.S3AFileSystem.Progress");
    private LocalDirAllocator directoryAllocator;
    private CannedAccessControlList cannedACL;
    private S3AEncryptionMethods serverSideEncryptionAlgorithm;
    private S3AInstrumentation instrumentation;
    private S3AStorageStatistics storageStatistics;
    private long readAhead;
    private S3AInputPolicy inputPolicy;
    private static final AtomicBoolean warnedOfCoreThreadDeprecation = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private MetadataStore metadataStore;
    private boolean allowAuthoritative;
    private static final int MAX_ENTRIES_TO_DELETE = 1000;
    private boolean blockUploadEnabled;
    private String blockOutputBuffer;
    private S3ADataBlocks.BlockFactory blockFactory;
    private int blockOutputActiveBlocks;
    static final String DEPRECATED_ACCESS_KEY = "fs.s3a.awsAccessKeyId";
    static final String DEPRECATED_SECRET_KEY = "fs.s3a.awsSecretAccessKey";

    private static void addDeprecatedKeys() {
        Configuration.addDeprecations((Configuration.DeprecationDelta[])new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("fs.s3a.server-side-encryption-key", "fs.s3a.server-side-encryption.key")});
        Configuration.reloadExistingConfigurations();
    }

    public void initialize(URI name, Configuration originalConf) throws IOException {
        this.uri = S3xLoginHelper.buildFSURI(name);
        this.bucket = name.getHost();
        Configuration conf = S3AUtils.propagateBucketOptions(originalConf, this.bucket);
        S3AUtils.patchSecurityCredentialProviders(conf);
        super.initialize(name, conf);
        this.setConf(conf);
        try {
            int maxThreads;
            this.instrumentation = new S3AInstrumentation(name);
            this.username = UserGroupInformation.getCurrentUser().getShortUserName();
            this.workingDir = new Path("/user", this.username).makeQualified(this.uri, this.getWorkingDirectory());
            Class s3ClientFactoryClass = conf.getClass("fs.s3a.s3.client.factory.impl", Constants.DEFAULT_S3_CLIENT_FACTORY_IMPL, S3ClientFactory.class);
            this.s3 = ((S3ClientFactory)ReflectionUtils.newInstance((Class)s3ClientFactoryClass, (Configuration)conf)).createS3Client(name);
            this.maxKeys = S3AUtils.intOption(conf, "fs.s3a.paging.maximum", 5000, 1);
            this.listing = new Listing(this);
            this.partSize = S3AUtils.getMultipartSizeProperty(conf, "fs.s3a.multipart.size", 0x4000000L);
            this.multiPartThreshold = S3AUtils.getMultipartSizeProperty(conf, "fs.s3a.multipart.threshold", 0x8000000L);
            S3AUtils.longBytesOption(conf, "fs.s3a.block.size", 0x2000000L, 1L);
            this.enableMultiObjectsDelete = conf.getBoolean("fs.s3a.multiobjectdelete.enable", true);
            this.readAhead = S3AUtils.longBytesOption(conf, "fs.s3a.readahead.range", 65536L, 0L);
            this.storageStatistics = (S3AStorageStatistics)GlobalStorageStatistics.INSTANCE.put("S3AStorageStatistics", new GlobalStorageStatistics.StorageStatisticsProvider(){

                public StorageStatistics provide() {
                    return new S3AStorageStatistics();
                }
            });
            if (conf.get("fs.s3a.threads.core") != null && warnedOfCoreThreadDeprecation.compareAndSet(false, true)) {
                LoggerFactory.getLogger((String)"org.apache.hadoop.conf.Configuration.deprecation").warn("Unsupported option \"fs.s3a.threads.core\" will be ignored {}", (Object)conf.get("fs.s3a.threads.core"));
            }
            if ((maxThreads = conf.getInt("fs.s3a.threads.max", 10)) < 2) {
                LOG.warn("fs.s3a.threads.max must be at least 2: forcing to 2.");
                maxThreads = 2;
            }
            int totalTasks = S3AUtils.intOption(conf, "fs.s3a.max.total.tasks", 5, 1);
            long keepAliveTime = S3AUtils.longOption(conf, "fs.s3a.threads.keepalivetime", 60L, 0L);
            this.boundedThreadPool = BlockingThreadPoolExecutorService.newInstance(maxThreads, maxThreads + totalTasks, keepAliveTime, TimeUnit.SECONDS, "s3a-transfer-shared");
            this.unboundedThreadPool = new ThreadPoolExecutor(maxThreads, Integer.MAX_VALUE, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), BlockingThreadPoolExecutorService.newDaemonThreadFactory("s3a-transfer-unbounded"));
            this.initTransferManager();
            this.initCannedAcls(conf);
            this.verifyBucketExists();
            this.initMultipartUploads(conf);
            this.serverSideEncryptionAlgorithm = S3AUtils.getEncryptionAlgorithm(conf);
            this.inputPolicy = S3AInputPolicy.getPolicy(conf.getTrimmed("fs.s3a.experimental.input.fadvise", "normal"));
            this.blockUploadEnabled = conf.getBoolean("fs.s3a.fast.upload", false);
            if (this.blockUploadEnabled) {
                this.blockOutputBuffer = conf.getTrimmed("fs.s3a.fast.upload.buffer", "disk");
                this.partSize = S3AUtils.ensureOutputParameterInRange("fs.s3a.multipart.size", this.partSize);
                this.blockFactory = S3ADataBlocks.createFactory(this, this.blockOutputBuffer);
                this.blockOutputActiveBlocks = S3AUtils.intOption(conf, "fs.s3a.fast.upload.active.blocks", 4, 1);
                LOG.debug("Using S3ABlockOutputStream with buffer = {}; block={}; queue limit={}", new Object[]{this.blockOutputBuffer, this.partSize, this.blockOutputActiveBlocks});
            } else {
                LOG.debug("Using S3AOutputStream");
            }
            this.metadataStore = S3Guard.getMetadataStore(this);
            this.allowAuthoritative = conf.getBoolean("fs.s3a.metadatastore.authoritative", false);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("initializing ", new Path(name), e);
        }
    }

    protected void verifyBucketExists() throws FileNotFoundException, IOException {
        try {
            if (!this.s3.doesBucketExist(this.bucket)) {
                throw new FileNotFoundException("Bucket " + this.bucket + " does not exist");
            }
        }
        catch (AmazonS3Exception e) {
            LOG.warn(S3AUtils.stringify(e), (Throwable)e);
            throw S3AUtils.translateException("doesBucketExist", this.bucket, (AmazonClientException)((Object)e));
        }
        catch (AmazonServiceException e) {
            LOG.warn(S3AUtils.stringify(e), (Throwable)e);
            throw S3AUtils.translateException("doesBucketExist", this.bucket, (AmazonClientException)((Object)e));
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("doesBucketExist", this.bucket, e);
        }
    }

    public S3AInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    private void initTransferManager() {
        TransferManagerConfiguration transferConfiguration = new TransferManagerConfiguration();
        transferConfiguration.setMinimumUploadPartSize(this.partSize);
        transferConfiguration.setMultipartUploadThreshold(this.multiPartThreshold);
        transferConfiguration.setMultipartCopyPartSize(this.partSize);
        transferConfiguration.setMultipartCopyThreshold(this.multiPartThreshold);
        this.transfers = new TransferManager(this.s3, this.unboundedThreadPool);
        this.transfers.setConfiguration(transferConfiguration);
    }

    private void initCannedAcls(Configuration conf) {
        String cannedACLName = conf.get("fs.s3a.acl.default", "");
        this.cannedACL = !cannedACLName.isEmpty() ? CannedAccessControlList.valueOf((String)cannedACLName) : null;
    }

    private void initMultipartUploads(Configuration conf) throws IOException {
        boolean purgeExistingMultipart = conf.getBoolean("fs.s3a.multipart.purge", false);
        long purgeExistingMultipartAge = S3AUtils.longOption(conf, "fs.s3a.multipart.purge.age", 86400L, 0L);
        if (purgeExistingMultipart) {
            Date purgeBefore = new Date(new Date().getTime() - purgeExistingMultipartAge * 1000L);
            try {
                this.transfers.abortMultipartUploads(this.bucket, purgeBefore);
            }
            catch (AmazonServiceException e) {
                if (e.getStatusCode() == 403) {
                    this.instrumentation.errorIgnored();
                    LOG.debug("Failed to purging multipart uploads against {}, FS may be read only", (Object)this.bucket, (Object)e);
                }
                throw S3AUtils.translateException("purging multipart uploads", this.bucket, (AmazonClientException)((Object)e));
            }
        }
    }

    public String getScheme() {
        return "s3a";
    }

    public URI getUri() {
        return this.uri;
    }

    public int getDefaultPort() {
        return -1;
    }

    AmazonS3 getAmazonS3Client() {
        return this.s3;
    }

    public String getBucketLocation() throws IOException {
        return this.getBucketLocation(this.bucket);
    }

    public String getBucketLocation(String bucketName) throws IOException {
        try {
            return this.s3.getBucketLocation(bucketName);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("getBucketLocation()", bucketName, e);
        }
    }

    @VisibleForTesting
    long getReadAheadRange() {
        return this.readAhead;
    }

    @InterfaceStability.Unstable
    public S3AInputPolicy getInputPolicy() {
        return this.inputPolicy;
    }

    synchronized File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
        if (this.directoryAllocator == null) {
            String bufferDir = conf.get("fs.s3a.buffer.dir") != null ? "fs.s3a.buffer.dir" : "hadoop.tmp.dir";
            this.directoryAllocator = new LocalDirAllocator(bufferDir);
        }
        return this.directoryAllocator.createTmpFileForWrite(pathStr, size, conf);
    }

    public String getBucket() {
        return this.bucket;
    }

    @InterfaceStability.Unstable
    public void setInputPolicy(S3AInputPolicy inputPolicy) {
        Objects.requireNonNull(inputPolicy, "Null inputStrategy");
        LOG.debug("Setting input strategy: {}", (Object)inputPolicy);
        this.inputPolicy = inputPolicy;
    }

    @VisibleForTesting
    String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        return path.toUri().getPath().substring(1);
    }

    private String maybeAddTrailingSlash(String key) {
        if (!key.isEmpty() && !key.endsWith("/")) {
            return key + '/';
        }
        return key;
    }

    private Path keyToPath(String key) {
        return new Path("/" + key);
    }

    Path keyToQualifiedPath(String key) {
        return this.qualify(this.keyToPath(key));
    }

    public Path qualify(Path path) {
        return path.makeQualified(this.uri, this.workingDir);
    }

    public void checkPath(Path path) {
        S3xLoginHelper.checkPath(this.getConf(), this.getUri(), path, this.getDefaultPort());
    }

    protected URI canonicalizeUri(URI rawUri) {
        return S3xLoginHelper.canonicalizeUri(rawUri, this.getDefaultPort());
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        LOG.debug("Opening '{}' for reading.", (Object)f);
        FileStatus fileStatus = this.getFileStatus(f);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException("Can't open " + f + " because it is a directory");
        }
        return new FSDataInputStream((InputStream)((Object)new S3AInputStream(new S3ObjectAttributes(this.bucket, this.pathToKey(f), this.serverSideEncryptionAlgorithm, S3AUtils.getServerSideEncryptionKey(this.getConf())), fileStatus.getLen(), this.s3, this.statistics, this.instrumentation, this.readAhead, this.inputPolicy)));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        String key = this.pathToKey(f);
        FileStatus status = null;
        try {
            status = this.getFileStatus(f);
            if (status.isDirectory()) {
                throw new FileAlreadyExistsException(f + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(f + " already exists");
            }
            LOG.debug("Overwriting file {}", (Object)f);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        this.instrumentation.fileCreated();
        FSDataOutputStream output = this.blockUploadEnabled ? new FSDataOutputStream((OutputStream)new S3ABlockOutputStream(this, key, (ExecutorService)((Object)new SemaphoredDelegatingExecutor(this.boundedThreadPool, this.blockOutputActiveBlocks, true)), progress, this.partSize, this.blockFactory, this.instrumentation.newOutputStreamStatistics(this.statistics), new WriteOperationHelper(key)), null) : new FSDataOutputStream((OutputStream)new S3AOutputStream(this.getConf(), this, key, progress), null);
        return output;
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent = path.getParent();
        if (parent != null && !this.getFileStatus(parent).isDirectory()) {
            throw new FileAlreadyExistsException("Not a directory: " + parent);
        }
        return this.create(path, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        try {
            return this.innerRename(src, dst);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("rename(" + src + ", " + dst + ")", src, e);
        }
        catch (RenameFailedException e) {
            LOG.debug(e.getMessage());
            return e.getExitCode();
        }
        catch (FileNotFoundException e) {
            LOG.debug(e.toString());
            return false;
        }
    }

    private boolean innerRename(Path source, Path dest) throws RenameFailedException, FileNotFoundException, IOException, AmazonClientException {
        S3AFileStatus dstStatus;
        S3AFileStatus srcStatus;
        String dstKey;
        String srcKey;
        Path dst;
        Path src;
        block31: {
            src = this.qualify(source);
            dst = this.qualify(dest);
            LOG.debug("Rename path {} to {}", (Object)src, (Object)dst);
            this.incrementStatistic(Statistic.INVOCATION_RENAME);
            srcKey = this.pathToKey(src);
            dstKey = this.pathToKey(dst);
            if (srcKey.isEmpty()) {
                throw new RenameFailedException(src, dst, "source is root directory");
            }
            if (dstKey.isEmpty()) {
                throw new RenameFailedException(src, dst, "dest is root directory");
            }
            srcStatus = this.innerGetFileStatus(src, true);
            if (srcKey.equals(dstKey)) {
                LOG.debug("rename: src and dest refer to the same file or directory: {}", (Object)dst);
                throw new RenameFailedException(src, dst, "source and dest refer to the same file or directory").withExitCode(srcStatus.isFile());
            }
            dstStatus = null;
            try {
                dstStatus = this.innerGetFileStatus(dst, true);
                if (srcStatus.isDirectory()) {
                    if (dstStatus.isFile()) {
                        throw new RenameFailedException(src, dst, "source is a directory and dest is a file").withExitCode(srcStatus.isFile());
                    }
                    if (dstStatus.isEmptyDirectory() != Tristate.TRUE) {
                        throw new RenameFailedException(src, dst, "Destination is a non-empty directory").withExitCode(false);
                    }
                } else if (dstStatus.isFile()) {
                    throw new RenameFailedException(src, dst, "Cannot rename onto an existing file").withExitCode(false);
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug("rename: destination path {} not found", (Object)dst);
                Path parent = dst.getParent();
                if (this.pathToKey(parent).isEmpty()) break block31;
                try {
                    S3AFileStatus dstParentStatus = this.innerGetFileStatus(dst.getParent(), false);
                    if (!dstParentStatus.isDirectory()) {
                        throw new RenameFailedException(src, dst, "destination parent is not a directory");
                    }
                }
                catch (FileNotFoundException e2) {
                    throw new RenameFailedException(src, dst, "destination has no parent ");
                }
            }
        }
        HashSet<Path> srcPaths = null;
        ArrayList<PathMetadata> dstMetas = null;
        if (this.hasMetadataStore()) {
            srcPaths = new HashSet<Path>();
            dstMetas = new ArrayList<PathMetadata>();
        }
        if (srcStatus.isFile()) {
            LOG.debug("rename: renaming file {} to {}", (Object)src, (Object)dst);
            long length = srcStatus.getLen();
            if (dstStatus != null && dstStatus.isDirectory()) {
                String newDstKey = dstKey;
                if (!newDstKey.endsWith("/")) {
                    newDstKey = newDstKey + "/";
                }
                String filename = srcKey.substring(this.pathToKey(src.getParent()).length() + 1);
                newDstKey = newDstKey + filename;
                this.copyFile(srcKey, newDstKey, length);
                S3Guard.addMoveFile(this.metadataStore, srcPaths, dstMetas, src, this.keyToQualifiedPath(newDstKey), length, this.getDefaultBlockSize(dst), this.username);
            } else {
                this.copyFile(srcKey, dstKey, srcStatus.getLen());
                S3Guard.addMoveFile(this.metadataStore, srcPaths, dstMetas, src, dst, length, this.getDefaultBlockSize(dst), this.username);
            }
            this.innerDelete(srcStatus, false);
        } else {
            LOG.debug("rename: renaming directory {} to {}", (Object)src, (Object)dst);
            if (!dstKey.endsWith("/")) {
                dstKey = dstKey + "/";
            }
            if (!srcKey.endsWith("/")) {
                srcKey = srcKey + "/";
            }
            if (dstKey.startsWith(srcKey)) {
                throw new RenameFailedException(srcKey, dstKey, "cannot rename a directory to a subdirectory of itself ");
            }
            ArrayList<DeleteObjectsRequest.KeyVersion> keysToDelete = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            if (dstStatus != null && dstStatus.isEmptyDirectory() == Tristate.TRUE) {
                keysToDelete.add(new DeleteObjectsRequest.KeyVersion(dstKey));
            }
            Path parentPath = this.keyToPath(srcKey);
            RemoteIterator<LocatedFileStatus> iterator = this.listFilesAndEmptyDirectories(parentPath, true);
            while (iterator.hasNext()) {
                LocatedFileStatus status = (LocatedFileStatus)iterator.next();
                long length = status.getLen();
                String key = this.pathToKey(status.getPath());
                if (status.isDirectory() && !key.endsWith("/")) {
                    key = key + "/";
                }
                keysToDelete.add(new DeleteObjectsRequest.KeyVersion(key));
                String newDstKey = dstKey + key.substring(srcKey.length());
                this.copyFile(key, newDstKey, length);
                if (this.hasMetadataStore()) {
                    Path childSrc = this.keyToQualifiedPath(key);
                    Path childDst = this.keyToQualifiedPath(newDstKey);
                    if (S3AUtils.objectRepresentsDirectory(key, length)) {
                        S3Guard.addMoveDir(this.metadataStore, srcPaths, dstMetas, childSrc, childDst, this.username);
                    } else {
                        S3Guard.addMoveFile(this.metadataStore, srcPaths, dstMetas, childSrc, childDst, length, this.getDefaultBlockSize(childDst), this.username);
                    }
                    S3Guard.addMoveAncestors(this.metadataStore, srcPaths, dstMetas, this.keyToQualifiedPath(srcKey), childSrc, childDst, this.username);
                }
                if (keysToDelete.size() != 1000) continue;
                this.removeKeys(keysToDelete, true, false);
            }
            if (!keysToDelete.isEmpty()) {
                this.removeKeys(keysToDelete, false, false);
            }
            if (this.hasMetadataStore() && srcPaths != null && !srcPaths.contains(src)) {
                LOG.debug("To move the non-empty top-level dir src={} and dst={}", (Object)src, (Object)dst);
                S3Guard.addMoveDir(this.metadataStore, srcPaths, dstMetas, src, dst, this.username);
            }
        }
        this.metadataStore.move(srcPaths, dstMetas);
        if (src.getParent() != dst.getParent()) {
            this.deleteUnnecessaryFakeDirectories(dst.getParent());
            this.createFakeDirectoryIfNecessary(src.getParent());
        }
        return true;
    }

    @VisibleForTesting
    public ObjectMetadata getObjectMetadata(Path path) throws IOException {
        return this.getObjectMetadata(this.pathToKey(path));
    }

    public boolean hasMetadataStore() {
        return !S3Guard.isNullMetadataStore(this.metadataStore);
    }

    @VisibleForTesting
    MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    @VisibleForTesting
    void setMetadataStore(MetadataStore ms) {
        this.metadataStore = ms;
    }

    protected void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    protected void incrementStatistic(Statistic statistic, long count) {
        this.instrumentation.incrementCounter(statistic, count);
        this.storageStatistics.incrementCounter(statistic, count);
    }

    protected void decrementGauge(Statistic statistic, long count) {
        this.instrumentation.decrementGauge(statistic, count);
    }

    protected void incrementGauge(Statistic statistic, long count) {
        this.instrumentation.incrementGauge(statistic, count);
    }

    public S3AStorageStatistics getStorageStatistics() {
        return this.storageStatistics;
    }

    protected ObjectMetadata getObjectMetadata(String key) {
        this.incrementStatistic(Statistic.OBJECT_METADATA_REQUESTS);
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(this.bucket, key);
        if (S3AEncryptionMethods.SSE_C.equals((Object)this.serverSideEncryptionAlgorithm) && StringUtils.isNotBlank((String)S3AUtils.getServerSideEncryptionKey(this.getConf()))) {
            request.setSSECustomerKey(this.generateSSECustomerKey());
        }
        ObjectMetadata meta = this.s3.getObjectMetadata(request);
        this.incrementReadOperations();
        return meta;
    }

    protected ObjectListing listObjects(ListObjectsRequest request) {
        this.incrementStatistic(Statistic.OBJECT_LIST_REQUESTS);
        this.incrementReadOperations();
        return this.s3.listObjects(request);
    }

    protected ObjectListing continueListObjects(ObjectListing objects) {
        this.incrementStatistic(Statistic.OBJECT_CONTINUE_LIST_REQUESTS);
        this.incrementReadOperations();
        return this.s3.listNextBatchOfObjects(objects);
    }

    public void incrementReadOperations() {
        this.statistics.incrementReadOps(1);
    }

    public void incrementWriteOperations() {
        this.statistics.incrementWriteOps(1);
    }

    private void deleteObject(String key) throws InvalidRequestException {
        this.blockRootDelete(key);
        this.incrementWriteOperations();
        this.incrementStatistic(Statistic.OBJECT_DELETE_REQUESTS);
        this.s3.deleteObject(this.bucket, key);
    }

    private void blockRootDelete(String key) throws InvalidRequestException {
        if (key.isEmpty() || "/".equals(key)) {
            throw new InvalidRequestException("Bucket " + this.bucket + " cannot be deleted");
        }
    }

    private void deleteObjects(DeleteObjectsRequest deleteRequest) throws MultiObjectDeleteException, AmazonClientException {
        this.incrementWriteOperations();
        this.incrementStatistic(Statistic.OBJECT_DELETE_REQUESTS, 1L);
        try {
            this.s3.deleteObjects(deleteRequest);
        }
        catch (MultiObjectDeleteException e) {
            List errors = e.getErrors();
            LOG.error("Partial failure of delete, {} errors", (Object)errors.size(), (Object)e);
            for (MultiObjectDeleteException.DeleteError error : errors) {
                LOG.error("{}: \"{}\" - {}", new Object[]{error.getKey(), error.getCode(), error.getMessage()});
            }
            throw e;
        }
    }

    public PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, File srcfile) {
        Preconditions.checkNotNull((Object)srcfile);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, srcfile);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        putObjectRequest.setMetadata(metadata);
        return putObjectRequest;
    }

    private PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, inputStream, metadata);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        return putObjectRequest;
    }

    public ObjectMetadata newObjectMetadata() {
        ObjectMetadata om = new ObjectMetadata();
        this.setOptionalObjectMetadata(om);
        return om;
    }

    public ObjectMetadata newObjectMetadata(long length) {
        ObjectMetadata om = this.newObjectMetadata();
        if (length >= 0L) {
            om.setContentLength(length);
        }
        return om;
    }

    public UploadInfo putObject(PutObjectRequest putObjectRequest) {
        long len = putObjectRequest.getFile() != null ? putObjectRequest.getFile().length() : putObjectRequest.getMetadata().getContentLength();
        this.incrementPutStartStatistics(len);
        try {
            Upload upload = this.transfers.upload(putObjectRequest);
            this.incrementPutCompletedStatistics(true, len);
            return new UploadInfo(upload, len);
        }
        catch (AmazonClientException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    public PutObjectResult putObjectDirect(PutObjectRequest putObjectRequest) throws AmazonClientException {
        long len = putObjectRequest.getFile() != null ? putObjectRequest.getFile().length() : putObjectRequest.getMetadata().getContentLength();
        this.incrementPutStartStatistics(len);
        try {
            PutObjectResult result = this.s3.putObject(putObjectRequest);
            this.incrementPutCompletedStatistics(true, len);
            return result;
        }
        catch (AmazonClientException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    public UploadPartResult uploadPart(UploadPartRequest request) throws AmazonClientException {
        long len = request.getPartSize();
        this.incrementPutStartStatistics(len);
        try {
            UploadPartResult uploadPartResult = this.s3.uploadPart(request);
            this.incrementPutCompletedStatistics(true, len);
            return uploadPartResult;
        }
        catch (AmazonClientException e) {
            this.incrementPutCompletedStatistics(false, len);
            throw e;
        }
    }

    public void incrementPutStartStatistics(long bytes) {
        LOG.debug("PUT start {} bytes", (Object)bytes);
        this.incrementWriteOperations();
        this.incrementStatistic(Statistic.OBJECT_PUT_REQUESTS);
        this.incrementGauge(Statistic.OBJECT_PUT_REQUESTS_ACTIVE, 1L);
        if (bytes > 0L) {
            this.incrementGauge(Statistic.OBJECT_PUT_BYTES_PENDING, bytes);
        }
    }

    public void incrementPutCompletedStatistics(boolean success, long bytes) {
        LOG.debug("PUT completed success={}; {} bytes", (Object)success, (Object)bytes);
        this.incrementWriteOperations();
        if (bytes > 0L) {
            this.incrementStatistic(Statistic.OBJECT_PUT_BYTES, bytes);
            this.decrementGauge(Statistic.OBJECT_PUT_BYTES_PENDING, bytes);
        }
        this.incrementStatistic(Statistic.OBJECT_PUT_REQUESTS_COMPLETED);
        this.decrementGauge(Statistic.OBJECT_PUT_REQUESTS_ACTIVE, 1L);
    }

    public void incrementPutProgressStatistics(String key, long bytes) {
        PROGRESS.debug("PUT {}: {} bytes", (Object)key, (Object)bytes);
        this.incrementWriteOperations();
        if (bytes > 0L) {
            this.statistics.incrementBytesWritten(bytes);
        }
    }

    @VisibleForTesting
    void removeKeys(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean clearKeys, boolean deleteFakeDir) throws MultiObjectDeleteException, AmazonClientException, InvalidRequestException {
        if (keysToDelete.isEmpty()) {
            return;
        }
        for (DeleteObjectsRequest.KeyVersion keyVersion : keysToDelete) {
            this.blockRootDelete(keyVersion.getKey());
        }
        if (this.enableMultiObjectsDelete) {
            this.deleteObjects(new DeleteObjectsRequest(this.bucket).withKeys(keysToDelete));
        } else {
            for (DeleteObjectsRequest.KeyVersion keyVersion : keysToDelete) {
                this.deleteObject(keyVersion.getKey());
            }
        }
        if (!deleteFakeDir) {
            this.instrumentation.fileDeleted(keysToDelete.size());
        } else {
            this.instrumentation.fakeDirsDeleted(keysToDelete.size());
        }
        if (clearKeys) {
            keysToDelete.clear();
        }
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        try {
            return this.innerDelete(this.innerGetFileStatus(f, true), recursive);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Couldn't delete {} - does not exist", (Object)f);
            this.instrumentation.errorIgnored();
            return false;
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("delete", f, e);
        }
    }

    private boolean innerDelete(S3AFileStatus status, boolean recursive) throws IOException, AmazonClientException {
        Path f = status.getPath();
        LOG.debug("Delete path {} - recursive {}", (Object)f, (Object)recursive);
        String key = this.pathToKey(f);
        if (status.isDirectory()) {
            LOG.debug("delete: Path is a directory: {}", (Object)f);
            Preconditions.checkArgument((status.isEmptyDirectory() != Tristate.UNKNOWN ? 1 : 0) != 0, (Object)"File status must have directory emptiness computed");
            if (!key.endsWith("/")) {
                key = key + "/";
            }
            if (key.equals("/")) {
                return this.rejectRootDirectoryDelete(status, recursive);
            }
            if (!recursive && status.isEmptyDirectory() == Tristate.FALSE) {
                throw new PathIsNotEmptyDirectoryException(f.toString());
            }
            if (status.isEmptyDirectory() == Tristate.TRUE) {
                LOG.debug("Deleting fake empty directory {}", (Object)key);
                this.deleteObject(key);
                this.metadataStore.delete(f);
                this.instrumentation.directoryDeleted();
            } else {
                LOG.debug("Getting objects for directory prefix {} to delete", (Object)key);
                ListObjectsRequest request = this.createListObjectsRequest(key, null);
                ObjectListing objects = this.listObjects(request);
                ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>(objects.getObjectSummaries().size());
                while (true) {
                    for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                        keys.add(new DeleteObjectsRequest.KeyVersion(summary.getKey()));
                        LOG.debug("Got object to delete {}", (Object)summary.getKey());
                        if (keys.size() != 1000) continue;
                        this.removeKeys(keys, true, false);
                    }
                    if (!objects.isTruncated()) break;
                    objects = this.continueListObjects(objects);
                }
                if (!keys.isEmpty()) {
                    this.removeKeys(keys, false, false);
                }
            }
            this.metadataStore.deleteSubtree(f);
        } else {
            LOG.debug("delete: Path is a file");
            this.instrumentation.fileDeleted(1);
            this.deleteObject(key);
            this.metadataStore.delete(f);
        }
        Path parent = f.getParent();
        if (parent != null) {
            this.createFakeDirectoryIfNecessary(parent);
        }
        return true;
    }

    private boolean rejectRootDirectoryDelete(S3AFileStatus status, boolean recursive) throws IOException {
        boolean emptyRoot;
        LOG.info("s3a delete the {} root directory of {}", (Object)this.bucket, (Object)recursive);
        boolean bl = emptyRoot = status.isEmptyDirectory() == Tristate.TRUE;
        if (emptyRoot) {
            return true;
        }
        if (recursive) {
            return false;
        }
        throw new PathIOException(this.bucket, "Cannot delete root path");
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException, AmazonClientException {
        String key = this.pathToKey(f);
        if (!key.isEmpty() && !this.s3Exists(f)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            this.createFakeDirectory(key);
        }
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        try {
            return this.innerListStatus(f);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("listStatus", f, e);
        }
    }

    public FileStatus[] innerListStatus(Path f) throws FileNotFoundException, IOException, AmazonClientException {
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        LOG.debug("List status for path: {}", (Object)path);
        this.incrementStatistic(Statistic.INVOCATION_LIST_STATUS);
        FileStatus fileStatus = this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            if (!key.isEmpty()) {
                key = key + '/';
            }
            DirListingMetadata dirMeta = this.metadataStore.listChildren(path);
            if (this.allowAuthoritative && dirMeta != null && dirMeta.isAuthoritative()) {
                return S3Guard.dirMetaToStatuses(dirMeta);
            }
            ListObjectsRequest request = this.createListObjectsRequest(key, "/");
            LOG.debug("listStatus: doing listObjects for directory {}", (Object)key);
            Listing.FileStatusListingIterator files = this.listing.createFileStatusListingIterator(path, request, Listing.ACCEPT_ALL, new Listing.AcceptAllButSelfAndS3nDirs(path));
            ArrayList<FileStatus> result = new ArrayList<FileStatus>(files.getBatchSize());
            while (files.hasNext()) {
                result.add(files.next());
            }
            return S3Guard.dirListingUnion(this.metadataStore, path, result, dirMeta, this.allowAuthoritative);
        }
        LOG.debug("Adding: rd (not a dir): {}", (Object)path);
        FileStatus[] stats = new FileStatus[]{fileStatus};
        return stats;
    }

    private ListObjectsRequest createListObjectsRequest(String key, String delimiter) {
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(this.bucket);
        request.setMaxKeys(Integer.valueOf(this.maxKeys));
        request.setPrefix(key);
        if (delimiter != null) {
            request.setDelimiter(delimiter);
        }
        return request;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException, FileAlreadyExistsException {
        try {
            return this.innerMkdirs(path, permission);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("innerMkdirs", path, e);
        }
    }

    private DirectoryStatus checkPathForDirectory(Path path) throws IOException {
        try {
            if (path.isRoot()) {
                return DirectoryStatus.EXISTS_AND_IS_DIRECTORY_ON_METADATASTORE;
            }
            String key = this.pathToKey(path);
            FileStatus status = null;
            PathMetadata pm = this.metadataStore.get(path, false);
            if (pm != null) {
                if (pm.isDeleted()) {
                    return DirectoryStatus.DOES_NOT_EXIST;
                }
                status = pm.getFileStatus();
                if (status != null && status.isDirectory()) {
                    return DirectoryStatus.EXISTS_AND_IS_DIRECTORY_ON_METADATASTORE;
                }
            }
            if ((status = this.s3GetFileStatus(path, key, null)).isDirectory()) {
                return DirectoryStatus.EXISTS_AND_IS_DIRECTORY_ON_S3_ONLY;
            }
        }
        catch (FileNotFoundException e) {
            return DirectoryStatus.DOES_NOT_EXIST;
        }
        return DirectoryStatus.EXISTS_AND_IS_FILE;
    }

    private boolean innerMkdirs(Path p, FsPermission permission) throws IOException, FileAlreadyExistsException, AmazonClientException {
        DirectoryStatus status;
        boolean createOnS3 = false;
        Path f = this.qualify(p);
        LOG.debug("Making directory: {}", (Object)f);
        this.incrementStatistic(Statistic.INVOCATION_MKDIRS);
        ArrayList<Path> metadataStoreDirs = null;
        if (this.hasMetadataStore()) {
            metadataStoreDirs = new ArrayList<Path>();
        }
        if ((status = this.checkPathForDirectory(f)) == DirectoryStatus.DOES_NOT_EXIST) {
            createOnS3 = true;
            if (metadataStoreDirs != null) {
                metadataStoreDirs.add(f);
            }
        } else if (status == DirectoryStatus.EXISTS_AND_IS_DIRECTORY_ON_S3_ONLY) {
            if (metadataStoreDirs != null) {
                metadataStoreDirs.add(f);
            }
        } else {
            if (status == DirectoryStatus.EXISTS_AND_IS_DIRECTORY_ON_METADATASTORE) {
                return true;
            }
            if (status == DirectoryStatus.EXISTS_AND_IS_FILE) {
                throw new FileAlreadyExistsException("Path is a file: " + f);
            }
        }
        Path fPart = f.getParent();
        do {
            if ((status = this.checkPathForDirectory(fPart)) == DirectoryStatus.DOES_NOT_EXIST || status == DirectoryStatus.EXISTS_AND_IS_DIRECTORY_ON_S3_ONLY) {
                if (metadataStoreDirs == null) continue;
                metadataStoreDirs.add(fPart);
                continue;
            }
            if (status == DirectoryStatus.EXISTS_AND_IS_DIRECTORY_ON_METADATASTORE) break;
            if (status != DirectoryStatus.EXISTS_AND_IS_FILE) continue;
            throw new FileAlreadyExistsException("Path is a file: " + f);
        } while ((fPart = fPart.getParent()) != null);
        if (createOnS3) {
            String key = this.pathToKey(f);
            this.createFakeDirectory(key);
        }
        S3Guard.makeDirsOrdered(this.metadataStore, metadataStoreDirs, this.username);
        return true;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.innerGetFileStatus(f, false);
    }

    @VisibleForTesting
    S3AFileStatus innerGetFileStatus(Path f, boolean needEmptyDirectoryFlag) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_GET_FILE_STATUS);
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        LOG.debug("Getting path status for {}  ({})", (Object)path, (Object)key);
        PathMetadata pm = this.metadataStore.get(path, needEmptyDirectoryFlag);
        Set<Path> tombstones = Collections.EMPTY_SET;
        if (pm != null) {
            S3AFileStatus s3FileStatus;
            if (pm.isDeleted()) {
                throw new FileNotFoundException("Path " + f + " is recorded as " + "deleted by S3Guard");
            }
            FileStatus msStatus = pm.getFileStatus();
            if (needEmptyDirectoryFlag && msStatus.isDirectory()) {
                if (pm.isEmptyDirectory() != Tristate.UNKNOWN) {
                    return S3AFileStatus.fromFileStatus(msStatus, pm.isEmptyDirectory());
                }
                DirListingMetadata children = this.metadataStore.listChildren(path);
                if (children != null) {
                    tombstones = children.listTombstones();
                }
            } else {
                return S3AFileStatus.fromFileStatus(msStatus, pm.isEmptyDirectory());
            }
            LOG.debug("MetadataStore doesn't know if dir is empty, using S3.");
            try {
                s3FileStatus = this.s3GetFileStatus(path, key, tombstones);
            }
            catch (FileNotFoundException e) {
                return S3AFileStatus.fromFileStatus(msStatus, Tristate.TRUE);
            }
            return S3Guard.putAndReturn(this.metadataStore, s3FileStatus, this.instrumentation);
        }
        return S3Guard.putAndReturn(this.metadataStore, this.s3GetFileStatus(path, key, tombstones), this.instrumentation);
    }

    private S3AFileStatus s3GetFileStatus(Path path, String key, Set<Path> tombstones) throws IOException {
        if (!key.isEmpty()) {
            try {
                ObjectMetadata meta = this.getObjectMetadata(key);
                if (S3AUtils.objectRepresentsDirectory(key, meta.getContentLength())) {
                    LOG.debug("Found exact file: fake directory");
                    return new S3AFileStatus(Tristate.TRUE, path, this.username);
                }
                LOG.debug("Found exact file: normal file");
                return new S3AFileStatus(meta.getContentLength(), S3AUtils.dateToLong(meta.getLastModified()), path, this.getDefaultBlockSize(path), this.username);
            }
            catch (AmazonServiceException e) {
                if (e.getStatusCode() != 404) {
                    throw S3AUtils.translateException("getFileStatus", path, (AmazonClientException)((Object)e));
                }
            }
            catch (AmazonClientException e) {
                throw S3AUtils.translateException("getFileStatus", path, e);
            }
            if (!key.endsWith("/")) {
                String newKey = key + "/";
                try {
                    ObjectMetadata meta = this.getObjectMetadata(newKey);
                    if (S3AUtils.objectRepresentsDirectory(newKey, meta.getContentLength())) {
                        LOG.debug("Found file (with /): fake directory");
                        return new S3AFileStatus(Tristate.TRUE, path, this.username);
                    }
                    LOG.warn("Found file (with /): real file? should not happen: {}", (Object)key);
                    return new S3AFileStatus(meta.getContentLength(), S3AUtils.dateToLong(meta.getLastModified()), path, this.getDefaultBlockSize(path), this.username);
                }
                catch (AmazonServiceException e) {
                    if (e.getStatusCode() != 404) {
                        throw S3AUtils.translateException("getFileStatus", newKey, (AmazonClientException)((Object)e));
                    }
                }
                catch (AmazonClientException e) {
                    throw S3AUtils.translateException("getFileStatus", newKey, e);
                }
            }
        }
        try {
            key = this.maybeAddTrailingSlash(key);
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName(this.bucket);
            request.setPrefix(key);
            request.setDelimiter("/");
            request.setMaxKeys(Integer.valueOf(1));
            ObjectListing objects = this.listObjects(request);
            List prefixes = objects.getCommonPrefixes();
            List summaries = objects.getObjectSummaries();
            if (!this.isEmptyOfKeys(prefixes, tombstones) || !this.isEmptyOfObjects(summaries, tombstones)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found path as directory (with /): {}/{}", (Object)prefixes.size(), (Object)summaries.size());
                    for (S3ObjectSummary summary : summaries) {
                        LOG.debug("Summary: {} {}", (Object)summary.getKey(), (Object)summary.getSize());
                    }
                    for (String prefix : prefixes) {
                        LOG.debug("Prefix: {}", (Object)prefix);
                    }
                }
                return new S3AFileStatus(Tristate.FALSE, path, this.username);
            }
            if (key.isEmpty()) {
                LOG.debug("Found root directory");
                return new S3AFileStatus(Tristate.TRUE, path, this.username);
            }
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() != 404) {
                throw S3AUtils.translateException("getFileStatus", key, (AmazonClientException)((Object)e));
            }
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("getFileStatus", key, e);
        }
        LOG.debug("Not Found: {}", (Object)path);
        throw new FileNotFoundException("No such file or directory: " + path);
    }

    private boolean isEmptyOfKeys(Collection<String> keys, Set<Path> tombstones) {
        if (tombstones == null) {
            return keys.isEmpty();
        }
        for (String key : keys) {
            Path qualified = this.keyToQualifiedPath(key);
            if (tombstones.contains(qualified)) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyOfObjects(Collection<S3ObjectSummary> summaries, Set<Path> tombstones) {
        if (tombstones == null) {
            return summaries.isEmpty();
        }
        ArrayList<String> stringCollection = new ArrayList<String>(summaries.size());
        for (S3ObjectSummary summary : summaries) {
            stringCollection.add(summary.getKey());
        }
        return this.isEmptyOfKeys(stringCollection, tombstones);
    }

    private boolean s3Exists(Path f) throws IOException {
        Path path = this.qualify(f);
        String key = this.pathToKey(path);
        try {
            return this.s3GetFileStatus(path, key, null) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        try {
            this.innerCopyFromLocalFile(delSrc, overwrite, src, dst);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("copyFromLocalFile(" + src + ", " + dst + ")", src, e);
        }
    }

    private void innerCopyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException, FileAlreadyExistsException, AmazonClientException {
        this.incrementStatistic(Statistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        String key = this.pathToKey(dst);
        if (!overwrite && this.exists(dst)) {
            throw new FileAlreadyExistsException(dst + " already exists");
        }
        LOG.debug("Copying local file from {} to {}", (Object)src, (Object)dst);
        LocalFileSystem local = S3AFileSystem.getLocal((Configuration)this.getConf());
        File srcfile = local.pathToFile(src);
        ObjectMetadata om = this.newObjectMetadata(srcfile.length());
        PutObjectRequest putObjectRequest = this.newPutObjectRequest(key, om, srcfile);
        UploadInfo info = this.putObject(putObjectRequest);
        Upload upload = info.getUpload();
        ProgressableProgressListener listener = new ProgressableProgressListener(this, key, upload, null);
        upload.addProgressListener((ProgressListener)listener);
        try {
            upload.waitForUploadResult();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted copying " + src + " to " + dst + ", cancelling");
        }
        listener.uploadCompleted();
        this.finishedWrite(key, info.getLength());
        if (delSrc) {
            local.delete(src, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        try {
            super.close();
        }
        finally {
            if (this.transfers != null) {
                this.transfers.shutdownNow(true);
                this.transfers = null;
            }
            if (this.metadataStore != null) {
                this.metadataStore.close();
                this.metadataStore = null;
            }
            IOUtils.closeQuietly((Closeable)this.instrumentation);
            this.instrumentation = null;
        }
    }

    public String getCanonicalServiceName() {
        return null;
    }

    private void copyFile(String srcKey, String dstKey, long size) throws IOException, InterruptedIOException, AmazonClientException {
        LOG.debug("copyFile {} -> {} ", (Object)srcKey, (Object)dstKey);
        try {
            ObjectMetadata srcom = this.getObjectMetadata(srcKey);
            ObjectMetadata dstom = this.cloneObjectMetadata(srcom);
            this.setOptionalObjectMetadata(dstom);
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucket, srcKey, this.bucket, dstKey);
            this.setOptionalCopyObjectRequestParameters(copyObjectRequest);
            copyObjectRequest.setCannedAccessControlList(this.cannedACL);
            copyObjectRequest.setNewObjectMetadata(dstom);
            ProgressListener progressListener = new ProgressListener(){

                public void progressChanged(ProgressEvent progressEvent) {
                    switch (progressEvent.getEventType()) {
                        case TRANSFER_PART_COMPLETED_EVENT: {
                            S3AFileSystem.this.incrementWriteOperations();
                            break;
                        }
                    }
                }
            };
            Copy copy = this.transfers.copy(copyObjectRequest);
            copy.addProgressListener(progressListener);
            try {
                copy.waitForCopyResult();
                this.incrementWriteOperations();
                this.instrumentation.filesCopied(1, size);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted copying " + srcKey + " to " + dstKey + ", cancelling");
            }
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("copyFile(" + srcKey + ", " + dstKey + ")", srcKey, e);
        }
    }

    protected void setOptionalMultipartUploadRequestParameters(InitiateMultipartUploadRequest req) {
        switch (this.serverSideEncryptionAlgorithm) {
            case SSE_KMS: {
                req.setSSEAwsKeyManagementParams(this.generateSSEAwsKeyParams());
                break;
            }
            case SSE_C: {
                if (!StringUtils.isNotBlank((String)S3AUtils.getServerSideEncryptionKey(this.getConf()))) break;
                req.setSSECustomerKey(this.generateSSECustomerKey());
                break;
            }
        }
    }

    protected void setOptionalCopyObjectRequestParameters(CopyObjectRequest copyObjectRequest) throws IOException {
        switch (this.serverSideEncryptionAlgorithm) {
            case SSE_KMS: {
                copyObjectRequest.setSSEAwsKeyManagementParams(this.generateSSEAwsKeyParams());
                break;
            }
            case SSE_C: {
                if (!StringUtils.isNotBlank((String)S3AUtils.getServerSideEncryptionKey(this.getConf()))) break;
                SSECustomerKey customerKey = this.generateSSECustomerKey();
                copyObjectRequest.setSourceSSECustomerKey(customerKey);
                copyObjectRequest.setDestinationSSECustomerKey(customerKey);
                break;
            }
        }
    }

    private void setOptionalPutRequestParameters(PutObjectRequest request) {
        switch (this.serverSideEncryptionAlgorithm) {
            case SSE_KMS: {
                request.setSSEAwsKeyManagementParams(this.generateSSEAwsKeyParams());
                break;
            }
            case SSE_C: {
                if (!StringUtils.isNotBlank((String)S3AUtils.getServerSideEncryptionKey(this.getConf()))) break;
                request.setSSECustomerKey(this.generateSSECustomerKey());
                break;
            }
        }
    }

    private void setOptionalObjectMetadata(ObjectMetadata metadata) {
        if (S3AEncryptionMethods.SSE_S3.equals((Object)this.serverSideEncryptionAlgorithm)) {
            metadata.setSSEAlgorithm(this.serverSideEncryptionAlgorithm.getMethod());
        }
    }

    private SSEAwsKeyManagementParams generateSSEAwsKeyParams() {
        SSEAwsKeyManagementParams sseAwsKeyManagementParams = new SSEAwsKeyManagementParams();
        if (StringUtils.isNotBlank((String)S3AUtils.getServerSideEncryptionKey(this.getConf()))) {
            sseAwsKeyManagementParams = new SSEAwsKeyManagementParams(S3AUtils.getServerSideEncryptionKey(this.getConf()));
        }
        return sseAwsKeyManagementParams;
    }

    private SSECustomerKey generateSSECustomerKey() {
        SSECustomerKey customerKey = new SSECustomerKey(S3AUtils.getServerSideEncryptionKey(this.getConf()));
        return customerKey;
    }

    public void finishedWrite(String key, long length) {
        LOG.debug("Finished write to {}, len {}", (Object)key, (Object)length);
        Path p = this.keyToQualifiedPath(key);
        this.deleteUnnecessaryFakeDirectories(p.getParent());
        try {
            if (this.hasMetadataStore()) {
                S3AFileStatus status = S3AUtils.createUploadFileStatus(p, S3AUtils.objectRepresentsDirectory(key, length), length, this.getDefaultBlockSize(p), this.username);
                S3Guard.putAndReturn(this.metadataStore, status, this.instrumentation);
            }
        }
        catch (IOException e) {
            LOG.error("s3guard: Error updating MetadataStore for write to {}:", (Object)key, (Object)e);
            this.instrumentation.errorIgnored();
        }
    }

    private void deleteUnnecessaryFakeDirectories(Path path) {
        block4: {
            ArrayList<DeleteObjectsRequest.KeyVersion> keysToRemove = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            while (!path.isRoot()) {
                String key = this.pathToKey(path);
                key = key.endsWith("/") ? key : key + "/";
                keysToRemove.add(new DeleteObjectsRequest.KeyVersion(key));
                path = path.getParent();
            }
            try {
                this.removeKeys(keysToRemove, false, true);
            }
            catch (AmazonClientException | InvalidRequestException e) {
                this.instrumentation.errorIgnored();
                if (!LOG.isDebugEnabled()) break block4;
                StringBuilder sb = new StringBuilder();
                for (DeleteObjectsRequest.KeyVersion kv : keysToRemove) {
                    sb.append(kv.getKey()).append(",");
                }
                LOG.debug("While deleting keys {} ", (Object)sb.toString(), (Object)e);
            }
        }
    }

    private void createFakeDirectory(String objectName) throws AmazonClientException, AmazonServiceException, InterruptedIOException {
        if (!objectName.endsWith("/")) {
            this.createEmptyObject(objectName + "/");
        } else {
            this.createEmptyObject(objectName);
        }
    }

    private void createEmptyObject(String objectName) throws AmazonClientException, AmazonServiceException, InterruptedIOException {
        InputStream im = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        PutObjectRequest putObjectRequest = this.newPutObjectRequest(objectName, this.newObjectMetadata(0L), im);
        UploadInfo info = this.putObject(putObjectRequest);
        try {
            info.getUpload().waitForUploadResult();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted creating " + objectName);
        }
        this.incrementPutProgressStatistics(objectName, 0L);
        this.instrumentation.directoryCreated();
    }

    private ObjectMetadata cloneObjectMetadata(ObjectMetadata source) {
        ObjectMetadata ret = this.newObjectMetadata(source.getContentLength());
        if (source.getCacheControl() != null) {
            ret.setCacheControl(source.getCacheControl());
        }
        if (source.getContentDisposition() != null) {
            ret.setContentDisposition(source.getContentDisposition());
        }
        if (source.getContentEncoding() != null) {
            ret.setContentEncoding(source.getContentEncoding());
        }
        if (source.getContentMD5() != null) {
            ret.setContentMD5(source.getContentMD5());
        }
        if (source.getContentType() != null) {
            ret.setContentType(source.getContentType());
        }
        if (source.getExpirationTime() != null) {
            ret.setExpirationTime(source.getExpirationTime());
        }
        if (source.getExpirationTimeRuleId() != null) {
            ret.setExpirationTimeRuleId(source.getExpirationTimeRuleId());
        }
        if (source.getHttpExpiresDate() != null) {
            ret.setHttpExpiresDate(source.getHttpExpiresDate());
        }
        if (source.getLastModified() != null) {
            ret.setLastModified(source.getLastModified());
        }
        if (source.getOngoingRestore() != null) {
            ret.setOngoingRestore(source.getOngoingRestore().booleanValue());
        }
        if (source.getRestoreExpirationTime() != null) {
            ret.setRestoreExpirationTime(source.getRestoreExpirationTime());
        }
        if (source.getSSEAlgorithm() != null) {
            ret.setSSEAlgorithm(source.getSSEAlgorithm());
        }
        if (source.getSSECustomerAlgorithm() != null) {
            ret.setSSECustomerAlgorithm(source.getSSECustomerAlgorithm());
        }
        if (source.getSSECustomerKeyMd5() != null) {
            ret.setSSECustomerKeyMd5(source.getSSECustomerKeyMd5());
        }
        for (Map.Entry e : source.getUserMetadata().entrySet()) {
            ret.addUserMetadata((String)e.getKey(), (String)e.getValue());
        }
        return ret;
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return this.getConf().getLongBytes("fs.s3a.block.size", 0x2000000L);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("S3AFileSystem{");
        sb.append("uri=").append(this.uri);
        sb.append(", workingDir=").append(this.workingDir);
        sb.append(", inputPolicy=").append((Object)this.inputPolicy);
        sb.append(", partSize=").append(this.partSize);
        sb.append(", enableMultiObjectsDelete=").append(this.enableMultiObjectsDelete);
        sb.append(", maxKeys=").append(this.maxKeys);
        if (this.cannedACL != null) {
            sb.append(", cannedACL=").append(this.cannedACL.toString());
        }
        sb.append(", readAhead=").append(this.readAhead);
        sb.append(", blockSize=").append(this.getDefaultBlockSize());
        sb.append(", multiPartThreshold=").append(this.multiPartThreshold);
        if (this.serverSideEncryptionAlgorithm != null) {
            sb.append(", serverSideEncryptionAlgorithm='").append((Object)this.serverSideEncryptionAlgorithm).append('\'');
        }
        if (this.blockFactory != null) {
            sb.append(", blockFactory=").append(this.blockFactory);
        }
        sb.append(", authoritative=").append(this.allowAuthoritative);
        sb.append(", boundedExecutor=").append(this.boundedThreadPool);
        sb.append(", unboundedExecutor=").append(this.unboundedThreadPool);
        sb.append(", statistics {").append(this.statistics).append("}");
        sb.append(", metrics {").append(this.instrumentation.dump("{", "=", "} ", true)).append("}");
        sb.append('}');
        return sb.toString();
    }

    public long getPartitionSize() {
        return this.partSize;
    }

    public long getMultiPartThreshold() {
        return this.multiPartThreshold;
    }

    int getMaxKeys() {
        return this.maxKeys;
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_GLOB_STATUS);
        return super.globStatus(pathPattern, filter);
    }

    public boolean exists(Path f) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_EXISTS);
        return super.exists(f);
    }

    public boolean isDirectory(Path f) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_IS_DIRECTORY);
        return super.isDirectory(f);
    }

    public boolean isFile(Path f) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_IS_FILE);
        return super.isFile(f);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        return this.innerListFiles(f, recursive, new Listing.AcceptFilesOnly(this.qualify(f)));
    }

    public RemoteIterator<LocatedFileStatus> listFilesAndEmptyDirectories(Path f, boolean recursive) throws IOException {
        return this.innerListFiles(f, recursive, new Listing.AcceptAllButS3nDirs());
    }

    private RemoteIterator<LocatedFileStatus> innerListFiles(Path f, boolean recursive, Listing.FileStatusAcceptor acceptor) throws IOException {
        this.incrementStatistic(Statistic.INVOCATION_LIST_FILES);
        Path path = this.qualify(f);
        LOG.debug("listFiles({}, {})", (Object)path, (Object)recursive);
        try {
            Object cachedFilesIterator;
            Set<Path> tombstones;
            FileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                LOG.debug("Path is a file");
                return new Listing.SingleStatusRemoteIterator(this.toLocatedFileStatus(fileStatus));
            }
            String key = this.maybeAddTrailingSlash(this.pathToKey(path));
            String delimiter = recursive ? null : "/";
            LOG.debug("Requesting all entries under {} with delimiter '{}'", (Object)key, (Object)delimiter);
            if (recursive) {
                PathMetadata pm = this.metadataStore.get(path, true);
                MetadataStoreListFilesIterator metadataStoreListFilesIterator = new MetadataStoreListFilesIterator(this.metadataStore, pm, this.allowAuthoritative);
                tombstones = metadataStoreListFilesIterator.listTombstones();
                cachedFilesIterator = metadataStoreListFilesIterator;
            } else {
                DirListingMetadata meta = this.metadataStore.listChildren(path);
                tombstones = meta != null ? meta.listTombstones() : null;
                cachedFilesIterator = this.listing.createProvidedFileStatusIterator(S3Guard.dirMetaToStatuses(meta), Listing.ACCEPT_ALL, acceptor);
                if (this.allowAuthoritative && meta != null && meta.isAuthoritative()) {
                    return this.listing.createLocatedFileStatusIterator((RemoteIterator<FileStatus>)cachedFilesIterator);
                }
            }
            return this.listing.createTombstoneReconcilingIterator(this.listing.createLocatedFileStatusIterator(this.listing.createFileStatusListingIterator(path, this.createListObjectsRequest(key, delimiter), Listing.ACCEPT_ALL, acceptor, (RemoteIterator<FileStatus>)cachedFilesIterator)), tombstones);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("listFiles", path, e);
        }
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, Listing.ACCEPT_ALL);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        this.incrementStatistic(Statistic.INVOCATION_LIST_LOCATED_STATUS);
        Path path = this.qualify(f);
        LOG.debug("listLocatedStatus({}, {}", (Object)path, (Object)filter);
        try {
            FileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                LOG.debug("Path is a file");
                return new Listing.SingleStatusRemoteIterator(filter.accept(path) ? this.toLocatedFileStatus(fileStatus) : null);
            }
            String key = this.maybeAddTrailingSlash(this.pathToKey(path));
            Listing.AcceptAllButSelfAndS3nDirs acceptor = new Listing.AcceptAllButSelfAndS3nDirs(path);
            DirListingMetadata meta = this.metadataStore.listChildren(path);
            Listing.ProvidedFileStatusIterator cachedFileStatusIterator = this.listing.createProvidedFileStatusIterator(S3Guard.dirMetaToStatuses(meta), filter, acceptor);
            return this.allowAuthoritative && meta != null && meta.isAuthoritative() ? this.listing.createLocatedFileStatusIterator(cachedFileStatusIterator) : this.listing.createLocatedFileStatusIterator(this.listing.createFileStatusListingIterator(path, this.createListObjectsRequest(key, "/"), filter, acceptor, cachedFileStatusIterator));
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("listLocatedStatus", path, e);
        }
    }

    LocatedFileStatus toLocatedFileStatus(FileStatus status) throws IOException {
        return new LocatedFileStatus(status, status.isFile() ? this.getFileBlockLocations(status, 0L, status.getLen()) : null);
    }

    static {
        S3AFileSystem.addDeprecatedKeys();
    }

    final class WriteOperationHelper {
        private final String key;

        private WriteOperationHelper(String key) {
            this.key = key;
        }

        PutObjectRequest newPutRequest(InputStream inputStream, long length) {
            PutObjectRequest request = S3AFileSystem.this.newPutObjectRequest(this.key, this.newObjectMetadata(length), inputStream);
            return request;
        }

        PutObjectRequest newPutRequest(File sourceFile) {
            int length = (int)sourceFile.length();
            PutObjectRequest request = S3AFileSystem.this.newPutObjectRequest(this.key, this.newObjectMetadata(length), sourceFile);
            return request;
        }

        void writeSuccessful(long length) {
            S3AFileSystem.this.finishedWrite(this.key, length);
        }

        void writeFailed(Exception e) {
            LOG.debug("Write to {} failed", (Object)this, (Object)e);
        }

        public ObjectMetadata newObjectMetadata(long length) {
            return S3AFileSystem.this.newObjectMetadata(length);
        }

        String initiateMultiPartUpload() throws IOException {
            LOG.debug("Initiating Multipart upload");
            InitiateMultipartUploadRequest initiateMPURequest = new InitiateMultipartUploadRequest(S3AFileSystem.this.bucket, this.key, this.newObjectMetadata(-1L));
            initiateMPURequest.setCannedACL(S3AFileSystem.this.cannedACL);
            S3AFileSystem.this.setOptionalMultipartUploadRequestParameters(initiateMPURequest);
            try {
                return S3AFileSystem.this.s3.initiateMultipartUpload(initiateMPURequest).getUploadId();
            }
            catch (AmazonClientException ace) {
                throw S3AUtils.translateException("initiate MultiPartUpload", this.key, ace);
            }
        }

        CompleteMultipartUploadResult completeMultipartUpload(String uploadId, List<PartETag> partETags) throws AmazonClientException {
            Preconditions.checkNotNull((Object)uploadId);
            Preconditions.checkNotNull(partETags);
            Preconditions.checkArgument((!partETags.isEmpty() ? 1 : 0) != 0, (Object)"No partitions have been uploaded");
            LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
            return S3AFileSystem.this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(S3AFileSystem.this.bucket, this.key, uploadId, new ArrayList<PartETag>(partETags)));
        }

        void abortMultipartUpload(String uploadId) throws AmazonClientException {
            LOG.debug("Aborting multipart upload {}", (Object)uploadId);
            S3AFileSystem.this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(S3AFileSystem.this.bucket, this.key, uploadId));
        }

        UploadPartRequest newUploadPartRequest(String uploadId, int partNumber, int size, InputStream uploadStream, File sourceFile) {
            Preconditions.checkNotNull((Object)uploadId);
            Preconditions.checkArgument((boolean)(uploadStream != null ^ sourceFile != null), (Object)"Data source");
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Invalid partition size %s", (Object[])new Object[]{size});
            Preconditions.checkArgument((partNumber > 0 && partNumber <= 10000 ? 1 : 0) != 0, (String)"partNumber must be between 1 and 10000 inclusive, but is %s", (Object[])new Object[]{partNumber});
            LOG.debug("Creating part upload request for {} #{} size {}", new Object[]{uploadId, partNumber, size});
            UploadPartRequest request = new UploadPartRequest().withBucketName(S3AFileSystem.this.bucket).withKey(this.key).withUploadId(uploadId).withPartNumber(partNumber).withPartSize((long)size);
            if (uploadStream != null) {
                request.setInputStream(uploadStream);
            } else {
                request.setFile(sourceFile);
            }
            return request;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{bucket=").append(S3AFileSystem.this.bucket);
            sb.append(", key='").append(this.key).append('\'');
            sb.append('}');
            return sb.toString();
        }

        PutObjectResult putObject(PutObjectRequest putObjectRequest) throws IOException {
            try {
                return S3AFileSystem.this.putObjectDirect(putObjectRequest);
            }
            catch (AmazonClientException e) {
                throw S3AUtils.translateException("put", putObjectRequest.getKey(), e);
            }
        }
    }

    private static enum DirectoryStatus {
        DOES_NOT_EXIST,
        EXISTS_AND_IS_DIRECTORY_ON_S3_ONLY,
        EXISTS_AND_IS_DIRECTORY_ON_METADATASTORE,
        EXISTS_AND_IS_FILE;

    }
}

