/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.verticabulkload;

import com.google.common.annotations.VisibleForTesting;
import com.vertica.jdbc.VerticaConnection;
import com.vertica.jdbc.VerticaCopyStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.DelegatingConnection;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.verticabulkload.VerticaBulkLoaderData;
import org.pentaho.di.verticabulkload.VerticaBulkLoaderMeta;
import org.pentaho.di.verticabulkload.nativebinary.ColumnSpec;
import org.pentaho.di.verticabulkload.nativebinary.ColumnType;
import org.pentaho.di.verticabulkload.nativebinary.StreamEncoder;

public class VerticaBulkLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = VerticaBulkLoader.class;
    private VerticaBulkLoaderMeta meta;
    private VerticaBulkLoaderData data;

    public VerticaBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (VerticaBulkLoaderMeta)smi;
        this.data = (VerticaBulkLoaderData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            try {
                this.data.close();
            }
            catch (IOException ioe) {
                throw new KettleStepException("Error releasing resources", (Throwable)ioe);
            }
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this);
            RowMetaInterface tableMeta = this.meta.getTableRowMetaInterface();
            if (!this.meta.specifyFields()) {
                this.data.insertRowMeta = this.getInputRowMeta().clone();
                this.data.selectedRowFieldIndices = new int[this.data.insertRowMeta.size()];
                this.data.colSpecs = new ArrayList<ColumnSpec>(this.data.insertRowMeta.size());
                for (int insertFieldIdx = 0; insertFieldIdx < this.data.insertRowMeta.size(); ++insertFieldIdx) {
                    this.data.selectedRowFieldIndices[insertFieldIdx] = insertFieldIdx;
                    ValueMetaInterface inputValueMeta = this.data.insertRowMeta.getValueMeta(insertFieldIdx);
                    ValueMetaInterface insertValueMeta = inputValueMeta.clone();
                    ValueMetaInterface targetValueMeta = tableMeta.getValueMeta(insertFieldIdx);
                    insertValueMeta.setName(targetValueMeta.getName());
                    this.data.insertRowMeta.setValueMeta(insertFieldIdx, insertValueMeta);
                    ColumnSpec cs = this.getColumnSpecFromField(inputValueMeta, insertValueMeta, targetValueMeta);
                    this.data.colSpecs.add(insertFieldIdx, cs);
                }
            } else {
                int numberOfInsertFields = this.meta.getFieldDatabase().length;
                this.data.insertRowMeta = new RowMeta();
                this.data.colSpecs = new ArrayList<ColumnSpec>(numberOfInsertFields);
                this.data.selectedRowFieldIndices = new int[numberOfInsertFields];
                for (int insertFieldIdx = 0; insertFieldIdx < numberOfInsertFields; ++insertFieldIdx) {
                    String inputFieldName = this.meta.getFieldStream()[insertFieldIdx];
                    int inputFieldIdx = this.getInputRowMeta().indexOfValue(inputFieldName);
                    if (inputFieldIdx < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"VerticaBulkLoader.Exception.FieldRequired", (String[])new String[]{inputFieldName}));
                    }
                    this.data.selectedRowFieldIndices[insertFieldIdx] = inputFieldIdx;
                    String insertFieldName = this.meta.getFieldDatabase()[insertFieldIdx];
                    ValueMetaInterface inputValueMeta = this.getInputRowMeta().getValueMeta(inputFieldIdx);
                    if (inputValueMeta == null) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"VerticaBulkLoader.Exception.FailedToFindField", (String[])new String[]{this.meta.getFieldStream()[insertFieldIdx]}));
                    }
                    ValueMetaInterface insertValueMeta = inputValueMeta.clone();
                    insertValueMeta.setName(insertFieldName);
                    this.data.insertRowMeta.addValueMeta(insertValueMeta);
                    ValueMetaInterface targetValueMeta = tableMeta.searchValueMeta(insertFieldName);
                    ColumnSpec cs = this.getColumnSpecFromField(inputValueMeta, insertValueMeta, targetValueMeta);
                    this.data.colSpecs.add(insertFieldIdx, cs);
                }
            }
            try {
                this.data.pipedInputStream = new PipedInputStream();
                if (this.data.colSpecs == null || this.data.colSpecs.isEmpty()) {
                    return false;
                }
                this.data.encoder = this.createStreamEncoder(this.data.colSpecs, this.data.pipedInputStream);
                this.initializeWorker();
                this.data.encoder.writeHeader();
            }
            catch (IOException ioe) {
                throw new KettleStepException("Error creating stream encoder", (Throwable)ioe);
            }
        }
        try {
            Object[] outputRowData = this.writeToOutputStream(r);
            if (outputRowData != null) {
                this.putRow(this.data.outputRowMeta, outputRowData);
                this.incrementLinesOutput();
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic("linenr " + this.getLinesRead());
            }
        }
        catch (KettleException e) {
            this.logError("Because of an error, this step can't continue: ", e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private ColumnSpec getColumnSpecFromField(ValueMetaInterface inputValueMeta, ValueMetaInterface insertValueMeta, ValueMetaInterface targetValueMeta) {
        this.logBasic("Mapping input field " + inputValueMeta.getName() + " (" + inputValueMeta.getTypeDesc() + ") to target column " + insertValueMeta.getName() + " (" + targetValueMeta.getOriginalColumnTypeName() + ") ");
        String targetColumnTypeName = targetValueMeta.getOriginalColumnTypeName().toUpperCase();
        if (targetColumnTypeName.equals("INTEGER") || targetColumnTypeName.equals("BIGINT")) {
            return new ColumnSpec(ColumnSpec.ConstantWidthType.INTEGER_64);
        }
        if (targetColumnTypeName.equals("BOOLEAN")) {
            return new ColumnSpec(ColumnSpec.ConstantWidthType.BOOLEAN);
        }
        if (targetColumnTypeName.equals("FLOAT") || targetColumnTypeName.equals("DOUBLE PRECISION")) {
            return new ColumnSpec(ColumnSpec.ConstantWidthType.FLOAT);
        }
        if (targetColumnTypeName.equals("CHAR")) {
            return new ColumnSpec(ColumnSpec.UserDefinedWidthType.CHAR, targetValueMeta.getLength());
        }
        if (targetColumnTypeName.equals("VARCHAR")) {
            return new ColumnSpec(ColumnSpec.VariableWidthType.VARCHAR, targetValueMeta.getLength());
        }
        if (targetColumnTypeName.equals("DATE")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException("Field " + inputValueMeta.getName() + " must be a Date compatible type to match target column " + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.DATE);
        }
        if (targetColumnTypeName.equals("TIME")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException("Field " + inputValueMeta.getName() + " must be a Date compatible type to match target column " + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.TIME);
        }
        if (targetColumnTypeName.equals("TIMETZ")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException("Field " + inputValueMeta.getName() + " must be a Date compatible type to match target column " + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.TIMETZ);
        }
        if (targetColumnTypeName.equals("TIMESTAMP")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException("Field " + inputValueMeta.getName() + " must be a Date compatible type to match target column " + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.TIMESTAMP);
        }
        if (targetColumnTypeName.equals("TIMESTAMPTZ")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException("Field " + inputValueMeta.getName() + " must be a Date compatible type to match target column " + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.TIMESTAMPTZ);
        }
        if (targetColumnTypeName.equals("INTERVAL") || targetColumnTypeName.equals("INTERVAL DAY TO SECOND")) {
            if (!inputValueMeta.isDate()) {
                throw new IllegalArgumentException("Field " + inputValueMeta.getName() + " must be a Date compatible type to match target column " + insertValueMeta.getName());
            }
            return new ColumnSpec(ColumnSpec.ConstantWidthType.INTERVAL);
        }
        if (targetColumnTypeName.equals("BINARY")) {
            return new ColumnSpec(ColumnSpec.VariableWidthType.VARBINARY, targetValueMeta.getLength());
        }
        if (targetColumnTypeName.equals("VARBINARY")) {
            return new ColumnSpec(ColumnSpec.VariableWidthType.VARBINARY, targetValueMeta.getLength());
        }
        if (targetColumnTypeName.equals("NUMERIC")) {
            return new ColumnSpec(ColumnSpec.PrecisionScaleWidthType.NUMERIC, targetValueMeta.getLength(), targetValueMeta.getPrecision());
        }
        throw new IllegalArgumentException("Column type " + targetColumnTypeName + " not supported.");
    }

    private void initializeWorker() {
        final String dml = this.buildCopyStatementSqlString();
        this.data.workerThread = Executors.defaultThreadFactory().newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    VerticaCopyStream stream = VerticaBulkLoader.this.createVerticaCopyStream(dml);
                    stream.start();
                    stream.addStream((InputStream)((VerticaBulkLoader)VerticaBulkLoader.this).data.pipedInputStream);
                    VerticaBulkLoader.this.setLinesRejected(stream.getRejects().size());
                    stream.execute();
                    long rowsLoaded = stream.finish();
                    if (VerticaBulkLoader.this.getLinesOutput() != rowsLoaded) {
                        VerticaBulkLoader.this.logMinimal(String.format("%d records loaded out of %d records sent.", rowsLoaded, VerticaBulkLoader.this.getLinesOutput()));
                    }
                    ((VerticaBulkLoader)VerticaBulkLoader.this).data.db.disconnect();
                }
                catch (IllegalStateException | SQLException e) {
                    if (e.getCause() instanceof InterruptedIOException) {
                        VerticaBulkLoader.this.logBasic("SQL statement interrupted by halt of transformation");
                    }
                    VerticaBulkLoader.this.logError("SQL Error during statement execution.", e);
                    VerticaBulkLoader.this.setErrors(1L);
                    VerticaBulkLoader.this.stopAll();
                    VerticaBulkLoader.this.setOutputDone();
                }
            }
        });
        this.data.workerThread.start();
    }

    private String buildCopyStatementSqlString() {
        DatabaseMeta databaseMeta = this.data.db.getDatabaseMeta();
        StringBuilder sb = new StringBuilder(150);
        sb.append("COPY ");
        sb.append(databaseMeta.getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName())));
        sb.append(" (");
        RowMetaInterface fields = this.data.insertRowMeta;
        block3: for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            ColumnType columnType = this.data.colSpecs.get((int)i).type;
            ValueMetaInterface valueMeta = fields.getValueMeta(i);
            switch (columnType) {
                case NUMERIC: {
                    sb.append("TMPFILLERCOL").append(i).append(" FILLER VARCHAR(1000), ");
                    sb.append(databaseMeta.getStartQuote() + valueMeta.getName() + databaseMeta.getEndQuote());
                    sb.append(" AS CAST(").append("TMPFILLERCOL").append(i).append(" AS NUMERIC");
                    sb.append(")");
                    continue block3;
                }
                default: {
                    sb.append(databaseMeta.getStartQuote() + valueMeta.getName() + databaseMeta.getEndQuote());
                }
            }
        }
        sb.append(")");
        sb.append(" FROM STDIN NATIVE ");
        if (!Const.isEmpty((String)this.meta.getExceptionsFileName())) {
            sb.append("EXCEPTIONS E'").append(this.meta.getExceptionsFileName().replace("'", "\\'")).append("' ");
        }
        if (!Const.isEmpty((String)this.meta.getRejectedDataFileName())) {
            sb.append("REJECTED DATA E'").append(this.meta.getRejectedDataFileName().replace("'", "\\'")).append("' ");
        }
        sb.append("ENFORCELENGTH ");
        if (this.meta.isAbortOnError()) {
            sb.append("ABORT ON ERROR ");
        }
        if (this.meta.isDirect()) {
            sb.append("DIRECT ");
        }
        if (!Const.isEmpty((String)this.meta.getStreamName())) {
            sb.append("STREAM NAME E'").append(this.environmentSubstitute(this.meta.getStreamName()).replace("'", "\\'")).append("' ");
        }
        this.logDebug("copy stmt: " + sb.toString());
        return sb.toString();
    }

    private Object[] writeToOutputStream(Object[] r) throws KettleException, IOException {
        Object[] outputRowData;
        block5: {
            assert (r != null);
            Object[] insertRowData = r;
            outputRowData = r;
            if (this.meta.specifyFields()) {
                insertRowData = new Object[this.data.selectedRowFieldIndices.length];
                for (int idx = 0; idx < this.data.selectedRowFieldIndices.length; ++idx) {
                    insertRowData[idx] = r[this.data.selectedRowFieldIndices[idx]];
                }
            }
            try {
                this.data.encoder.writeRow(this.data.insertRowMeta, insertRowData);
            }
            catch (IOException e) {
                if (this.data.isStopped()) break block5;
                throw new KettleException("I/O Error during row write.", (Throwable)e);
            }
        }
        return outputRowData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (VerticaBulkLoaderMeta)smi;
        this.data = (VerticaBulkLoaderData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.databaseMeta = this.meta.getDatabaseMeta();
                this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.db.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isBasic()) {
                    this.logBasic("Connected to database [" + this.meta.getDatabaseMeta() + "]");
                }
                this.data.db.setAutoCommit(false);
                return true;
            }
            catch (KettleException e) {
                this.logError("An error occurred intialising this step: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        this.setStopped(true);
        if (this.data.workerThread != null) {
            Thread thread = this.data.workerThread;
            synchronized (thread) {
                if (this.data.workerThread.isAlive() && !this.data.workerThread.isInterrupted()) {
                    try {
                        this.data.workerThread.interrupt();
                        this.data.workerThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        super.stopRunning(stepMetaInterface, stepDataInterface);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (VerticaBulkLoaderMeta)smi;
        this.data = (VerticaBulkLoaderData)sdi;
        this.data.colSpecs = null;
        this.data.encoder = null;
        this.setOutputDone();
        try {
            if (this.getErrors() > 0L) {
                this.data.db.rollback();
            }
        }
        catch (KettleDatabaseException e) {
            this.logError("Unexpected error rolling back the database connection.", e);
        }
        if (this.data.workerThread != null) {
            try {
                this.data.workerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    @VisibleForTesting
    StreamEncoder createStreamEncoder(List<ColumnSpec> colSpecs, PipedInputStream pipedInputStream) throws IOException {
        return new StreamEncoder(colSpecs, pipedInputStream);
    }

    @VisibleForTesting
    VerticaCopyStream createVerticaCopyStream(String dml) throws SQLException {
        return new VerticaCopyStream(this.getVerticaConnection(), dml);
    }

    @VisibleForTesting
    VerticaConnection getVerticaConnection() throws SQLException {
        Connection conn = this.data.db.getConnection();
        if (conn != null) {
            if (conn instanceof VerticaConnection) {
                return (VerticaConnection)conn;
            }
            Connection underlyingConn = null;
            if (conn instanceof DelegatingConnection) {
                DelegatingConnection pooledConn = (DelegatingConnection)conn;
                underlyingConn = pooledConn.getInnermostDelegate();
            } else if (conn instanceof PooledConnection) {
                PooledConnection pooledConn = (PooledConnection)((Object)conn);
                underlyingConn = pooledConn.getConnection();
            } else {
                try {
                    if (conn.isWrapperFor(VerticaConnection.class)) {
                        VerticaConnection vc = conn.unwrap(VerticaConnection.class);
                        return vc;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (underlyingConn != null && underlyingConn instanceof VerticaConnection) {
                return (VerticaConnection)underlyingConn;
            }
            throw new IllegalStateException("Could not retrieve a VerticaConnection from " + conn.getClass().getName());
        }
        throw new IllegalStateException("Could not retrieve a VerticaConnection from null");
    }
}

