/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.karaf.bundle.core.BundleState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.pentaho.osgi.api.BlueprintStateService;
import org.pentaho.osgi.api.IKarafBlueprintWatcher;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;
import org.pentaho.platform.servicecoordination.api.IServiceBarrierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafBlueprintWatcherImpl
implements IKarafBlueprintWatcher {
    private BundleContext bundleContext;
    private long timeout;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String KARAF_TIMEOUT_PROPERTY = "karafWaitForBoot";

    public KarafBlueprintWatcherImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.timeout = PentahoSystem.getApplicationContext().getProperty(KARAF_TIMEOUT_PROPERTY) == null ? 120000L : Long.valueOf(PentahoSystem.getApplicationContext().getProperty(KARAF_TIMEOUT_PROPERTY));
    }

    public void waitForBlueprint() throws IKarafBlueprintWatcher.BlueprintWatcherException {
        long entryTime = System.currentTimeMillis();
        ServiceTracker serviceTracker = new ServiceTracker(this.bundleContext, BlueprintStateService.class.getName(), null);
        serviceTracker.open();
        try {
            serviceTracker.waitForService(this.timeout);
        }
        catch (InterruptedException e) {
            this.logger.debug("BlueprintStateService ServiceTracker Interrupted");
        }
        ServiceReference serviceReference = this.bundleContext.getServiceReference(BlueprintStateService.class);
        if (serviceReference != null) {
            BlueprintStateService blueprintStateService = (BlueprintStateService)this.bundleContext.getService(serviceReference);
            ArrayList<Object> unloadedAndFailedBlueprints = new ArrayList<Bundle>();
            try {
                while (true) {
                    ArrayList<String> unloadedBlueprints = new ArrayList<String>();
                    for (Bundle bundle : this.bundleContext.getBundles()) {
                        if (bundle.getState() != 4) {
                            this.logger.debug("Blueprint check was skipped for bundle {} as it's not in the 'Resolved' state", (Object)bundle.getSymbolicName());
                            continue;
                        }
                        long bundleId = bundle.getBundleId();
                        if (!blueprintStateService.hasBlueprint(bundleId).booleanValue() || blueprintStateService.isBlueprintLoaded(bundleId).booleanValue()) continue;
                        unloadedAndFailedBlueprints.add(bundle);
                        if (blueprintStateService.isBlueprintFailed(bundleId).booleanValue() || !blueprintStateService.isBlueprintTryingToLoad(bundleId).booleanValue()) continue;
                        unloadedBlueprints.add(bundle.getSymbolicName());
                    }
                    if (unloadedBlueprints.size() > 0) {
                        if (System.currentTimeMillis() - this.timeout > entryTime) {
                            IServiceBarrier serviceBarrier = IServiceBarrierManager.LOCATOR.getManager().getServiceBarrier("KarafFeatureWatcherBarrier");
                            if (serviceBarrier == null || serviceBarrier.isAvailable()) {
                                throw new IKarafBlueprintWatcher.BlueprintWatcherException("Timed out waiting for blueprints to load: " + StringUtils.join(unloadedBlueprints, (String)","));
                            }
                            entryTime = System.currentTimeMillis();
                        }
                        this.logger.debug("KarafBlueprintWatcher is waiting for the following blueprints to load: " + StringUtils.join(unloadedBlueprints, (String)","));
                        Thread.sleep(100L);
                        unloadedAndFailedBlueprints = new ArrayList();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new IKarafBlueprintWatcher.BlueprintWatcherException("Unknown error in KarafBlueprintWatcher", (Throwable)e);
            }
            finally {
                if (unloadedAndFailedBlueprints.size() > 0) {
                    this.logger.debug(System.lineSeparator() + this.getBlueprintsReport(blueprintStateService, unloadedAndFailedBlueprints));
                }
                serviceTracker.close();
            }
        }
    }

    private String getBlueprintsReport(BlueprintStateService blueprintStateService, List<Bundle> bundles) {
        String bundlesReport = "--------- Karaf Blueprint Watcher Report Begin ---------";
        bundlesReport = bundlesReport + System.lineSeparator() + "Blueprint Bundle(s) not loaded:";
        for (Bundle bundle : bundles) {
            bundlesReport = bundlesReport + System.lineSeparator() + "\t" + this.getBlueprintReport(blueprintStateService, bundle).replaceAll("\n", "\n \t");
        }
        return bundlesReport + System.lineSeparator() + "--------- Karaf Blueprint Watcher Report End ---------";
    }

    private String getBlueprintReport(BlueprintStateService blueprintStateService, Bundle bundle) {
        long bundleId = bundle.getBundleId();
        String bundleName = bundle.getSymbolicName();
        BundleState bundleState = blueprintStateService.getBundleState(bundleId);
        String[] missingDependencies = blueprintStateService.getBundleMissDependencies(bundleId);
        Throwable failureCause = blueprintStateService.getBundleFailureCause(bundleId);
        String bundleReport = "Blueprint Bundle '" + bundleName + "':" + System.lineSeparator() + "\t Blueprint Bundle State: " + bundleState + System.lineSeparator() + "\t Blueprint Bundle ID: " + bundleId;
        if (missingDependencies != null) {
            bundleReport = bundleReport + System.lineSeparator() + "\t Missing Dependencies:";
            for (String missDependency : missingDependencies) {
                bundleReport = bundleReport + System.lineSeparator() + "\t \t" + missDependency;
            }
        }
        if (failureCause != null) {
            bundleReport = bundleReport + System.lineSeparator() + "\t This blueprint state was caused by: " + System.lineSeparator() + "\t \t" + this.getStackTraceString(failureCause).replaceAll("\n", "\n \t \t");
        }
        return bundleReport;
    }

    private String getStackTraceString(Throwable throwable) {
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)throwable);
        int index = stackTrace.lastIndexOf("\n");
        if (index < 0) {
            return stackTrace;
        }
        if (stackTrace.length() <= index + 1 || stackTrace.substring(index + 1).trim().isEmpty()) {
            String newStackTrace = stackTrace.substring(0, index);
            if (newStackTrace.endsWith("\r")) {
                newStackTrace = newStackTrace.substring(0, newStackTrace.length() - 1);
            }
            return newStackTrace;
        }
        return stackTrace;
    }
}

