/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pdi.jobentry.dummy;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.regex.Pattern;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.util.Utils;

public class DummyJob {
    private String _wildcard;
    private String _targetDir;
    private String _sourceDir;

    public DummyJob(String source, String target, String wildcard) {
        this._sourceDir = source;
        this._targetDir = target;
        this._wildcard = wildcard;
    }

    public long process() throws KettleJobException, FileNotFoundException {
        LogChannel log = new LogChannel((Object)this);
        File srcDir = this.getDir(this._sourceDir);
        Pattern pattern = null;
        if (!Utils.isEmpty((CharSequence)this._wildcard)) {
            pattern = Pattern.compile(this._wildcard);
        }
        final Pattern fpat = pattern;
        FileFilter regexFiler = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (fpat == null) {
                    return true;
                }
                return fpat.matcher(pathname.getName()).matches();
            }
        };
        long files = 0L;
        File[] allFiles = srcDir.listFiles(regexFiler);
        File outDir = new File(this._targetDir);
        outDir.mkdirs();
        for (int i = 0; i < allFiles.length; ++i) {
            File cFile = allFiles[i];
            log.logDetailed(this.toString(), new Object[]{"processing file '" + cFile + "'"});
            this.processFile(cFile, outDir);
        }
        return files;
    }

    public File getDir(String dirname) throws KettleJobException {
        File fl = new File(dirname);
        if (!fl.isDirectory()) {
            throw new KettleJobException("'" + dirname + "' is not a directory");
        }
        return fl;
    }

    public void processFile(File fl, File outDir) throws FileNotFoundException {
    }
}

