/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.event.listener;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class ZKConnectionListener
implements ConnectionStateListener {
    private XLog LOG = XLog.getLog(this.getClass());
    private static ConnectionState connectionState;
    public static final String CONF_SHUTDOWN_ON_TIMEOUT = "oozie.zookeeper.server.shutdown.ontimeout";

    public ZKConnectionListener() {
        this.LOG.info("ZKConnectionListener started");
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        connectionState = newState;
        this.LOG.trace("ZK connection status  = " + newState.toString());
        if (newState == ConnectionState.SUSPENDED) {
            this.LOG.warn("ZK connection is suspended, waiting to reconnect.");
        }
        if (newState == ConnectionState.RECONNECTED) {
            this.LOG.warn("ZK connection is reestablished");
        }
        if (newState == ConnectionState.LOST) {
            this.LOG.fatal("ZK is not reconnected");
            if (ConfigurationService.getBoolean(CONF_SHUTDOWN_ON_TIMEOUT)) {
                this.LOG.fatal("Shutting down Oozie server");
                Services.get().destroy();
                System.exit(1);
            }
        }
    }

    public static ConnectionState getZKConnectionState() {
        return connectionState;
    }
}

