/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.KillTransitionXCommand;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.coord.CoordPushDependencyCheckXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.dependency.DependencyChecker;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionsNotCompletedJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;

public class CoordKillXCommand
extends KillTransitionXCommand {
    private final String jobId;
    private CoordinatorJobBean coordJob;
    private List<CoordinatorActionBean> actionList;
    private JPAService jpaService = null;
    private Job.Status prevStatus = null;

    public CoordKillXCommand(String id) {
        super("coord_kill", "coord_kill", 2);
        this.jobId = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_SUSPEND_KILL, this.jobId);
            this.actionList = this.jpaService.execute(new CoordJobGetActionsNotCompletedJPAExecutor(this.jobId));
            this.prevStatus = this.coordJob.getStatus();
            LogUtils.setLogInfo(this.coordJob);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (StatusUtils.isV1CoordjobKillable(this.coordJob)) {
            return;
        }
        if (this.coordJob.getStatus() == Job.Status.SUCCEEDED || this.coordJob.getStatus() == Job.Status.FAILED || this.coordJob.getStatus() == Job.Status.DONEWITHERROR || this.coordJob.getStatus() == Job.Status.KILLED || this.coordJob.getStatus() == Job.Status.IGNORED) {
            this.LOG.info("CoordKillXCommand not killed - job either finished SUCCEEDED, FAILED, KILLED, DONEWITHERROR or IGNORED,job id = " + this.jobId + ", status = " + this.coordJob.getStatus());
            throw new PreconditionException(ErrorCode.E1020, this.jobId);
        }
    }

    private void updateCoordAction(CoordinatorActionBean action, boolean makePending) {
        CoordinatorAction.Status prevStatus = action.getStatus();
        action.setStatus(CoordinatorAction.Status.KILLED);
        if (makePending) {
            action.incrementAndGetPending();
        } else {
            action.setPending(0);
        }
        if (EventHandlerService.isEnabled() && prevStatus != CoordinatorAction.Status.RUNNING && prevStatus != CoordinatorAction.Status.SUSPENDED) {
            CoordinatorXCommand.generateEvent(action, this.coordJob.getUser(), this.coordJob.getAppName(), null);
        }
        action.setLastModifiedTime(new Date());
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordActionQueryExecutor.CoordActionQuery>(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, action));
    }

    @Override
    public void killChildren() throws CommandException {
        if (this.actionList != null) {
            for (CoordinatorActionBean action : this.actionList) {
                String pushMissingDeps;
                if (action.getExternalId() != null) {
                    this.queue(new KillXCommand(action.getExternalId()));
                    this.updateCoordAction(action, true);
                    this.LOG.debug("Killed coord action = [{0}], new status = [{1}], pending = [{2}] and queue KillXCommand for [{3}]", action.getId(), action.getStatus(), action.getPending(), action.getExternalId());
                } else {
                    this.updateCoordAction(action, false);
                    this.LOG.debug("Killed coord action = [{0}], current status = [{1}], pending = [{2}]", action.getId(), action.getStatus(), action.getPending());
                }
                if ((pushMissingDeps = action.getPushMissingDependencies()) == null) continue;
                CoordPushDependencyCheckXCommand.unregisterMissingDependencies(Arrays.asList(DependencyChecker.dependenciesAsArray(pushMissingDeps)), action.getId());
            }
        }
        this.coordJob.setDoneMaterialization();
        this.coordJob.setLastModifiedTime(new Date());
        this.LOG.debug("Killed coord actions for the coordinator=[{0}]", this.jobId);
    }

    @Override
    public void notifyParent() throws CommandException {
        if (this.coordJob.getBundleId() != null) {
            BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.prevStatus);
            bundleStatusUpdate.call();
        }
    }

    @Override
    public void updateJob() throws CommandException {
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING_TIME, this.coordJob));
    }

    @Override
    public void performWrites() throws CommandException {
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, null);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public Job getJob() {
        return this.coordJob;
    }
}

