/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.gateway.shell.AbstractCredentialCollector;
import org.apache.hadoop.gateway.shell.CredentialCollectionException;
import org.apache.hadoop.gateway.util.JsonUtils;

public class KnoxTokenCredentialCollector
extends AbstractCredentialCollector {
    private static final String KNOXTOKENCACHE = ".knoxtokencache";
    public static final String COLLECTOR_TYPE = "KnoxToken";
    public String targetUrl = null;

    @Override
    public void collect() throws CredentialCollectionException {
        String userDir = System.getProperty("user.home");
        File knoxtoken = new File(userDir, KNOXTOKENCACHE);
        if (knoxtoken.exists()) {
            Path path = Paths.get(knoxtoken.toURI());
            try {
                List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                Map attrs = JsonUtils.getMapFromJsonString((String)lines.get(0));
                this.value = (String)attrs.get("access_token");
                this.targetUrl = (String)attrs.get("target_url");
                Date expires = new Date(Long.parseLong((String)attrs.get("expires_in")));
                if (expires.before(new Date())) {
                    System.out.println("Cached knox token has expired. Please relogin through knoxinit.");
                    System.exit(1);
                }
            }
            catch (IOException e) {
                System.out.println("Cached knox token cannot be read. Please login through knoxinit.");
                System.exit(1);
                e.printStackTrace();
            }
        } else {
            System.out.println("Cached knox token cannot be found. Please login through knoxinit.");
            System.exit(1);
        }
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    @Override
    public String type() {
        return COLLECTOR_TYPE;
    }
}

