/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Relationship {
    private static final int ONE_TO_ONE_FLAG = 1;
    private static final int NO_REFERENTIAL_INTEGRITY_FLAG = 2;
    private static final int CASCADE_UPDATES_FLAG = 256;
    private static final int CASCADE_DELETES_FLAG = 4096;
    private static final int LEFT_OUTER_JOIN_FLAG = 0x1000000;
    private static final int RIGHT_OUTER_JOIN_FLAG = 0x2000000;
    private final String _name;
    private final Table _fromTable;
    private final Table _toTable;
    private List<Column> _toColumns;
    private List<Column> _fromColumns;
    private final int _flags;

    public Relationship(String name, Table fromTable, Table toTable, int flags, int numCols) {
        this._name = name;
        this._fromTable = fromTable;
        this._fromColumns = new ArrayList<Column>(Collections.nCopies(numCols, null));
        this._toTable = toTable;
        this._toColumns = new ArrayList<Column>(Collections.nCopies(numCols, null));
        this._flags = flags;
    }

    public String getName() {
        return this._name;
    }

    public Table getFromTable() {
        return this._fromTable;
    }

    public List<Column> getFromColumns() {
        return this._fromColumns;
    }

    public Table getToTable() {
        return this._toTable;
    }

    public List<Column> getToColumns() {
        return this._toColumns;
    }

    public int getFlags() {
        return this._flags;
    }

    public boolean isOneToOne() {
        return this.hasFlag(1);
    }

    public boolean hasReferentialIntegrity() {
        return !this.hasFlag(2);
    }

    public boolean cascadeUpdates() {
        return this.hasFlag(256);
    }

    public boolean cascadeDeletes() {
        return this.hasFlag(4096);
    }

    public boolean isLeftOuterJoin() {
        return this.hasFlag(0x1000000);
    }

    public boolean isRightOuterJoin() {
        return this.hasFlag(0x2000000);
    }

    private boolean hasFlag(int flagMask) {
        return (this.getFlags() & flagMask) != 0;
    }

    public String toString() {
        StringBuilder rtn = new StringBuilder();
        rtn.append("\tName: " + this._name);
        rtn.append("\n\tFromTable: " + this._fromTable.getName());
        rtn.append("\n\tFromColumns: " + this._fromColumns);
        rtn.append("\n\tToTable: " + this._toTable.getName());
        rtn.append("\n\tToColumns: " + this._toColumns);
        rtn.append("\n\tFlags: " + Integer.toHexString(this._flags));
        rtn.append("\n\n");
        return rtn.toString();
    }
}

