/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.NamespaceQuotaSnapshotStore;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSnapshotStore;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifier;
import org.apache.hadoop.hbase.quotas.TableQuotaSnapshotStore;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

public class QuotaObserverChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(QuotaObserverChore.class);
    static final String VIOLATION_OBSERVER_CHORE_PERIOD_KEY = "hbase.master.quotas.violation.observer.chore.period";
    static final int VIOLATION_OBSERVER_CHORE_PERIOD_DEFAULT = 60000;
    static final String VIOLATION_OBSERVER_CHORE_DELAY_KEY = "hbase.master.quotas.violation.observer.chore.delay";
    static final long VIOLATION_OBSERVER_CHORE_DELAY_DEFAULT = 15000L;
    static final String VIOLATION_OBSERVER_CHORE_TIMEUNIT_KEY = "hbase.master.quotas.violation.observer.chore.timeunit";
    static final String VIOLATION_OBSERVER_CHORE_TIMEUNIT_DEFAULT = TimeUnit.MILLISECONDS.name();
    static final String VIOLATION_OBSERVER_CHORE_REPORT_PERCENT_KEY = "hbase.master.quotas.violation.observer.report.percent";
    static final double VIOLATION_OBSERVER_CHORE_REPORT_PERCENT_DEFAULT = 0.95;
    static final String REGION_REPORT_RETENTION_DURATION_KEY = "hbase.master.quotas.region.report.retention.millis";
    static final long REGION_REPORT_RETENTION_DURATION_DEFAULT = 600000L;
    private final HMaster master;
    private final MasterQuotaManager quotaManager;
    private final SpaceQuotaSnapshotNotifier snapshotNotifier;
    private final Map<TableName, SpaceQuotaSnapshot> tableQuotaViolationStates;
    private final Map<String, SpaceQuotaSnapshot> namespaceQuotaViolationStates;
    private final long regionReportLifetimeMillis;
    private QuotaSnapshotStore<TableName> tableViolationStore;
    private QuotaSnapshotStore<String> namespaceViolationStore;

    public QuotaObserverChore(HMaster master) {
        this(master, master.getSpaceQuotaViolationNotifier());
    }

    QuotaObserverChore(HMaster master, SpaceQuotaSnapshotNotifier violationNotifier) {
        super(QuotaObserverChore.class.getSimpleName(), (Stoppable)master, QuotaObserverChore.getPeriod(master.getConfiguration()), QuotaObserverChore.getInitialDelay(master.getConfiguration()), QuotaObserverChore.getTimeUnit(master.getConfiguration()));
        this.master = master;
        this.quotaManager = this.master.getMasterQuotaManager();
        this.snapshotNotifier = violationNotifier;
        this.tableQuotaViolationStates = new HashMap<TableName, SpaceQuotaSnapshot>();
        this.namespaceQuotaViolationStates = new HashMap<String, SpaceQuotaSnapshot>();
        this.regionReportLifetimeMillis = master.getConfiguration().getLong(REGION_REPORT_RETENTION_DURATION_KEY, 600000L);
    }

    protected void chore() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Refreshing space quotas in RegionServer");
            }
            this._chore();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to process quota reports and update quota violation state. Will retry.", (Throwable)e);
        }
    }

    void _chore() throws IOException {
        TablesWithQuotas tablesWithQuotas = this.fetchAllTablesWithQuotasDefined();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found following tables with quotas: " + tablesWithQuotas));
        }
        Map<HRegionInfo, Long> reportedRegionSpaceUse = this.quotaManager.snapshotRegionSizes();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Using " + reportedRegionSpaceUse.size() + " region space use reports"));
        }
        this.pruneOldRegionReports();
        this.initializeViolationStores(reportedRegionSpaceUse);
        Set<TableName> tablesInLimbo = tablesWithQuotas.filterInsufficientlyReportedTables(this.tableViolationStore);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Filtered insufficiently reported tables, left with " + reportedRegionSpaceUse.size() + " regions reported"));
        }
        for (TableName tableInLimbo : tablesInLimbo) {
            SpaceQuotaSnapshot currentSnapshot = this.tableViolationStore.getCurrentState(tableInLimbo);
            if (!currentSnapshot.getQuotaStatus().isInViolation()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Moving " + tableInLimbo + " out of violation because fewer region sizes were" + " reported than required."));
            }
            SpaceQuotaSnapshot targetSnapshot = new SpaceQuotaSnapshot(SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation(), currentSnapshot.getUsage(), currentSnapshot.getLimit());
            this.snapshotNotifier.transitionTable(tableInLimbo, targetSnapshot);
            this.tableViolationStore.setCurrentState(tableInLimbo, targetSnapshot);
        }
        Set<TableName> tablesWithTableQuotas = tablesWithQuotas.getTableQuotaTables();
        for (TableName table : tablesWithTableQuotas) {
            QuotaProtos.SpaceQuota spaceQuota = this.tableViolationStore.getSpaceQuota(table);
            if (null == spaceQuota) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unexpectedly did not find a space quota for " + table + ", maybe it was recently deleted."));
                continue;
            }
            SpaceQuotaSnapshot currentSnapshot = this.tableViolationStore.getCurrentState(table);
            SpaceQuotaSnapshot targetSnapshot = this.tableViolationStore.getTargetState(table, spaceQuota);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Processing " + table + " with current=" + currentSnapshot + ", target=" + targetSnapshot));
            }
            this.updateTableQuota(table, currentSnapshot, targetSnapshot);
        }
        Set<String> namespacesWithQuotas = tablesWithQuotas.getNamespacesWithQuotas();
        Multimap<String, TableName> tablesByNamespace = tablesWithQuotas.getTablesByNamespace();
        for (String namespace : namespacesWithQuotas) {
            QuotaProtos.SpaceQuota spaceQuota = this.namespaceViolationStore.getSpaceQuota(namespace);
            if (null == spaceQuota) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Could not get Namespace space quota for " + namespace + ", maybe it was recently deleted."));
                continue;
            }
            SpaceQuotaSnapshot currentSnapshot = this.namespaceViolationStore.getCurrentState(namespace);
            SpaceQuotaSnapshot targetSnapshot = this.namespaceViolationStore.getTargetState(namespace, spaceQuota);
            this.updateNamespaceQuota(namespace, currentSnapshot, targetSnapshot, tablesByNamespace);
        }
    }

    void updateTableQuota(TableName table, SpaceQuotaSnapshot currentSnapshot, SpaceQuotaSnapshot targetSnapshot) throws IOException {
        SpaceQuotaSnapshot.SpaceQuotaStatus currentStatus = currentSnapshot.getQuotaStatus();
        SpaceQuotaSnapshot.SpaceQuotaStatus targetStatus = targetSnapshot.getQuotaStatus();
        if (!currentSnapshot.equals((Object)targetSnapshot)) {
            if (!targetStatus.isInViolation()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(table + " moving into observance of table space quota."));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(table + " moving into violation of table space quota with policy of " + targetStatus.getPolicy()));
            }
            this.snapshotNotifier.transitionTable(table, targetSnapshot);
            this.tableViolationStore.setCurrentState(table, targetSnapshot);
        } else if (LOG.isTraceEnabled()) {
            if (!currentStatus.isInViolation()) {
                LOG.trace((Object)(table + " remains in observance of quota."));
            } else {
                LOG.trace((Object)(table + " remains in violation of quota."));
            }
        }
    }

    void updateNamespaceQuota(String namespace, SpaceQuotaSnapshot currentSnapshot, SpaceQuotaSnapshot targetSnapshot, Multimap<String, TableName> tablesByNamespace) throws IOException {
        block9: {
            block10: {
                SpaceQuotaSnapshot.SpaceQuotaStatus targetStatus;
                block8: {
                    targetStatus = targetSnapshot.getQuotaStatus();
                    if (currentSnapshot.equals((Object)targetSnapshot)) break block8;
                    if (!targetStatus.isInViolation()) {
                        for (TableName tableInNS : tablesByNamespace.get((Object)namespace)) {
                            if (this.tableViolationStore.getCurrentState(tableInNS).getQuotaStatus().isInViolation()) {
                                if (!LOG.isTraceEnabled()) continue;
                                LOG.trace((Object)("Not activating Namespace violation policy because a Table violation policy is already in effect for " + tableInNS));
                                continue;
                            }
                            LOG.info((Object)(tableInNS + " moving into observance of namespace space quota"));
                            this.snapshotNotifier.transitionTable(tableInNS, targetSnapshot);
                        }
                    } else {
                        for (TableName tableInNS : tablesByNamespace.get((Object)namespace)) {
                            boolean hasTableQuota;
                            SpaceQuotaSnapshot tableQuotaSnapshot = this.tableViolationStore.getCurrentState(tableInNS);
                            boolean bl = hasTableQuota = QuotaSnapshotStore.NO_QUOTA != tableQuotaSnapshot;
                            if (hasTableQuota && tableQuotaSnapshot.getQuotaStatus().isInViolation()) {
                                if (!LOG.isTraceEnabled()) continue;
                                LOG.trace((Object)("Not activating Namespace violation policy because a Table violation policy is already in effect for " + tableInNS));
                                continue;
                            }
                            LOG.info((Object)(tableInNS + " moving into violation of namespace space quota with policy " + targetStatus.getPolicy()));
                            this.snapshotNotifier.transitionTable(tableInNS, targetSnapshot);
                        }
                    }
                    break block9;
                }
                if (targetStatus.isInViolation()) break block10;
                if (!LOG.isTraceEnabled()) break block9;
                LOG.trace((Object)(namespace + " remains in observance of quota."));
                break block9;
            }
            for (TableName tableInNS : tablesByNamespace.get((Object)namespace)) {
                if (this.tableViolationStore.getCurrentState(tableInNS).getQuotaStatus().isInViolation()) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Not activating Namespace violation policy because Table violation policy is already in effect for " + tableInNS));
                    continue;
                }
                LOG.info((Object)(tableInNS + " moving into violation of namespace space quota"));
                this.snapshotNotifier.transitionTable(tableInNS, targetSnapshot);
            }
        }
    }

    void pruneOldRegionReports() {
        long now = EnvironmentEdgeManager.currentTime();
        long pruneTime = now - this.regionReportLifetimeMillis;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Pruning Region size reports older than " + pruneTime));
        }
        int numRemoved = this.quotaManager.pruneEntriesOlderThan(pruneTime);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removed " + numRemoved + " old region size reports."));
        }
    }

    void initializeViolationStores(Map<HRegionInfo, Long> regionSizes) {
        Map<HRegionInfo, Long> immutableRegionSpaceUse = Collections.unmodifiableMap(regionSizes);
        this.tableViolationStore = new TableQuotaSnapshotStore((Connection)this.master.getConnection(), this, immutableRegionSpaceUse);
        this.namespaceViolationStore = new NamespaceQuotaSnapshotStore((Connection)this.master.getConnection(), this, immutableRegionSpaceUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TablesWithQuotas fetchAllTablesWithQuotasDefined() throws IOException {
        Scan scan = QuotaTableUtil.makeScan(null);
        QuotaRetriever scanner = new QuotaRetriever();
        TablesWithQuotas tablesWithQuotas = new TablesWithQuotas((Connection)this.master.getConnection(), this.master.getConfiguration());
        try {
            scanner.init((Connection)this.master.getConnection(), scan);
            for (QuotaSettings quotaSettings : scanner) {
                String namespace = quotaSettings.getNamespace();
                TableName tableName = quotaSettings.getTableName();
                if (QuotaType.SPACE != quotaSettings.getQuotaType()) continue;
                if (null != namespace) {
                    TableName[] tablesInNS;
                    assert (null == quotaSettings.getTableName());
                    for (TableName tableUnderNs : tablesInNS = this.master.getConnection().getAdmin().listTableNamesByNamespace(namespace)) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Adding " + tableUnderNs + " under " + namespace + " as having a namespace quota"));
                        }
                        tablesWithQuotas.addNamespaceQuotaTable(tableUnderNs);
                    }
                    continue;
                }
                assert (null != tableName);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Adding " + tableName + " as having table quota."));
                }
                tablesWithQuotas.addTableQuotaTable(tableName);
            }
            TablesWithQuotas tablesWithQuotas2 = tablesWithQuotas;
            return tablesWithQuotas2;
        }
        finally {
            if (null != scanner) {
                scanner.close();
            }
        }
    }

    @VisibleForTesting
    QuotaSnapshotStore<TableName> getTableViolationStore() {
        return this.tableViolationStore;
    }

    @VisibleForTesting
    QuotaSnapshotStore<String> getNamespaceViolationStore() {
        return this.namespaceViolationStore;
    }

    SpaceQuotaSnapshot getTableQuotaViolation(TableName table) {
        SpaceQuotaSnapshot state = this.tableQuotaViolationStates.get(table);
        if (null == state) {
            return QuotaSnapshotStore.NO_QUOTA;
        }
        return state;
    }

    void setTableQuotaViolation(TableName table, SpaceQuotaSnapshot snapshot) {
        this.tableQuotaViolationStates.put(table, snapshot);
    }

    SpaceQuotaSnapshot getNamespaceQuotaViolation(String namespace) {
        SpaceQuotaSnapshot state = this.namespaceQuotaViolationStates.get(namespace);
        if (null == state) {
            return QuotaSnapshotStore.NO_QUOTA;
        }
        return state;
    }

    void setNamespaceQuotaViolation(String namespace, SpaceQuotaSnapshot snapshot) {
        this.namespaceQuotaViolationStates.put(namespace, snapshot);
    }

    static int getPeriod(Configuration conf) {
        return conf.getInt(VIOLATION_OBSERVER_CHORE_PERIOD_KEY, 60000);
    }

    static long getInitialDelay(Configuration conf) {
        return conf.getLong(VIOLATION_OBSERVER_CHORE_DELAY_KEY, 15000L);
    }

    static TimeUnit getTimeUnit(Configuration conf) {
        return TimeUnit.valueOf(conf.get(VIOLATION_OBSERVER_CHORE_TIMEUNIT_KEY, VIOLATION_OBSERVER_CHORE_TIMEUNIT_DEFAULT));
    }

    static Double getRegionReportPercent(Configuration conf) {
        return conf.getDouble(VIOLATION_OBSERVER_CHORE_REPORT_PERCENT_KEY, 0.95);
    }

    static class TablesWithQuotas {
        private final Set<TableName> tablesWithTableQuotas = new HashSet<TableName>();
        private final Set<TableName> tablesWithNamespaceQuotas = new HashSet<TableName>();
        private final Connection conn;
        private final Configuration conf;

        public TablesWithQuotas(Connection conn, Configuration conf) {
            this.conn = Objects.requireNonNull(conn);
            this.conf = Objects.requireNonNull(conf);
        }

        Configuration getConfiguration() {
            return this.conf;
        }

        public void addTableQuotaTable(TableName tn) {
            this.tablesWithTableQuotas.add(tn);
        }

        public void addNamespaceQuotaTable(TableName tn) {
            this.tablesWithNamespaceQuotas.add(tn);
        }

        public boolean hasTableQuota(TableName tn) {
            return this.tablesWithTableQuotas.contains(tn);
        }

        public boolean hasNamespaceQuota(TableName tn) {
            return this.tablesWithNamespaceQuotas.contains(tn);
        }

        public Set<TableName> getTableQuotaTables() {
            return Collections.unmodifiableSet(this.tablesWithTableQuotas);
        }

        public Set<TableName> getNamespaceQuotaTables() {
            return Collections.unmodifiableSet(this.tablesWithNamespaceQuotas);
        }

        public Set<String> getNamespacesWithQuotas() {
            HashSet<String> namespaces = new HashSet<String>();
            for (TableName tn : this.tablesWithNamespaceQuotas) {
                namespaces.add(tn.getNamespaceAsString());
            }
            return namespaces;
        }

        public Multimap<String, TableName> getTablesByNamespace() {
            HashMultimap tablesByNS = HashMultimap.create();
            for (TableName tn : this.tablesWithNamespaceQuotas) {
                tablesByNS.put((Object)tn.getNamespaceAsString(), (Object)tn);
            }
            return tablesByNS;
        }

        public Set<TableName> filterInsufficientlyReportedTables(QuotaSnapshotStore<TableName> tableStore) throws IOException {
            double percentRegionsReportedThreshold = QuotaObserverChore.getRegionReportPercent(this.getConfiguration());
            HashSet<TableName> tablesToRemove = new HashSet<TableName>();
            for (TableName table : Iterables.concat(this.tablesWithTableQuotas, this.tablesWithNamespaceQuotas)) {
                if (tablesToRemove.contains(table)) continue;
                int numRegionsInTable = this.getNumRegions(table);
                if (0 == numRegionsInTable) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Filtering " + table + " because no regions were reported."));
                    }
                    tablesToRemove.add(table);
                    continue;
                }
                int reportedRegionsInQuota = this.getNumReportedRegions(table, tableStore);
                double ratioReported = (double)reportedRegionsInQuota / (double)numRegionsInTable;
                if (ratioReported < percentRegionsReportedThreshold) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Filtering " + table + " because " + reportedRegionsInQuota + " of " + numRegionsInTable + " regions were reported."));
                    }
                    tablesToRemove.add(table);
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Retaining " + table + " because " + reportedRegionsInQuota + " of " + numRegionsInTable + " regions were reported."));
            }
            for (TableName tableToRemove : tablesToRemove) {
                this.tablesWithTableQuotas.remove(tableToRemove);
                this.tablesWithNamespaceQuotas.remove(tableToRemove);
            }
            return tablesToRemove;
        }

        int getNumRegions(TableName table) throws IOException {
            List regions = this.conn.getAdmin().getTableRegions(table);
            if (null == regions) {
                return 0;
            }
            return regions.size();
        }

        int getNumReportedRegions(TableName table, QuotaSnapshotStore<TableName> tableStore) throws IOException {
            return Iterables.size(tableStore.filterBySubject(table));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append(this.getClass().getSimpleName()).append(": tablesWithTableQuotas=").append(this.tablesWithTableQuotas).append(", tablesWithNamespaceQuotas=").append(this.tablesWithNamespaceQuotas);
            return sb.toString();
        }
    }
}

