/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.master;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupCopyService;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupRestoreServerFactory;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.HBackupFileSystem;
import org.apache.hadoop.hbase.backup.impl.BackupException;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.impl.BackupManifest;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.backup.util.BackupServerUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.protobuf.generated.BackupProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class FullTableBackupProcedure
extends StateMachineProcedure<MasterProcedureEnv, BackupProtos.FullTableBackupState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(FullTableBackupProcedure.class);
    private static final String SNAPSHOT_BACKUP_MAX_ATTEMPTS_KEY = "hbase.backup.snapshot.attempts.max";
    private static final int DEFAULT_SNAPSHOT_BACKUP_MAX_ATTEMPTS = 10;
    private static final String SNAPSHOT_BACKUP_ATTEMPTS_DELAY_KEY = "hbase.backup.snapshot.attempts.delay";
    private static final int DEFAULT_SNAPSHOT_BACKUP_ATTEMPTS_DELAY = 10000;
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private Configuration conf;
    private String backupId;
    private List<TableName> tableList;
    private String targetRootDir;
    HashMap<String, Long> newTimestamps = null;
    private BackupManager backupManager;
    private BackupInfo backupInfo;

    public FullTableBackupProcedure() {
    }

    public FullTableBackupProcedure(MasterProcedureEnv env, String backupId, List<TableName> tableList, String targetRootDir, int workers, long bandwidth) throws IOException {
        this.backupManager = new BackupManager(env.getMasterConfiguration());
        this.backupId = backupId;
        this.tableList = tableList;
        this.targetRootDir = targetRootDir;
        this.backupInfo = this.backupManager.createBackupInfo(backupId, BackupType.FULL, tableList, targetRootDir, workers, bandwidth);
        if (tableList == null || tableList.isEmpty()) {
            this.tableList = new ArrayList<TableName>(this.backupInfo.getTables());
        }
    }

    public byte[] getResult() {
        return this.backupId.getBytes();
    }

    static void beginBackup(BackupManager backupManager, BackupInfo backupInfo) throws IOException {
        backupManager.setBackupInfo(backupInfo);
        long startTs = EnvironmentEdgeManager.currentTime();
        backupInfo.setStartTs(startTs);
        backupInfo.setState(BackupInfo.BackupState.RUNNING);
        LOG.info((Object)("Backup " + backupInfo.getBackupId() + " started at " + startTs + "."));
        backupManager.updateBackupInfo(backupInfo);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Backup session " + backupInfo.getBackupId() + " has been started."));
        }
    }

    private static String getMessage(Exception e) {
        String msg = e.getMessage();
        if (msg == null || msg.equals("")) {
            msg = e.getClass().getName();
        }
        return msg;
    }

    private static void deleteSnapshot(MasterProcedureEnv env, BackupInfo backupCtx, Configuration conf) throws IOException {
        LOG.debug((Object)"Trying to delete snapshot for full backup.");
        for (String snapshotName : backupCtx.getSnapshotNames()) {
            if (snapshotName == null) continue;
            LOG.debug((Object)("Trying to delete snapshot: " + snapshotName));
            HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
            builder.setName(snapshotName);
            try {
                env.getMasterServices().getSnapshotManager().deleteSnapshot(builder.build());
            }
            catch (IOException ioe) {
                LOG.debug((Object)("when deleting snapshot " + snapshotName), (Throwable)ioe);
            }
            LOG.debug((Object)("Deleting the snapshot " + snapshotName + " for backup " + backupCtx.getBackupId() + " succeeded."));
        }
    }

    private static void cleanupExportSnapshotLog(Configuration conf) throws IOException {
        Path stagingDir;
        FileSystem fs = FSUtils.getCurrentFileSystem(conf);
        FileStatus[] files = FSUtils.listStatus(fs, stagingDir = new Path(conf.get("snapshot.export.staging.root", fs.getWorkingDirectory().toString())));
        if (files == null) {
            return;
        }
        for (FileStatus file : files) {
            if (!file.getPath().getName().startsWith("exportSnapshot-")) continue;
            LOG.debug((Object)("Delete log files of exporting snapshot: " + file.getPath().getName()));
            if (FSUtils.delete(fs, file.getPath(), true)) continue;
            LOG.warn((Object)("Can not delete " + file.getPath()));
        }
    }

    static void cleanupTargetDir(BackupInfo backupInfo, Configuration conf) {
        try {
            LOG.debug((Object)("Trying to cleanup up target dir. Current backup phase: " + backupInfo.getPhase()));
            if (backupInfo.getPhase().equals((Object)BackupInfo.BackupPhase.SNAPSHOTCOPY) || backupInfo.getPhase().equals((Object)BackupInfo.BackupPhase.INCREMENTAL_COPY) || backupInfo.getPhase().equals((Object)BackupInfo.BackupPhase.STORE_MANIFEST)) {
                FileSystem outputFs = FileSystem.get((URI)new Path(backupInfo.getTargetRootDir()).toUri(), (Configuration)conf);
                for (TableName table : backupInfo.getTables()) {
                    Path tableDir;
                    FileStatus[] backups;
                    Path targetDirPath = new Path(HBackupFileSystem.getTableBackupDir(backupInfo.getTargetRootDir(), backupInfo.getBackupId(), table));
                    if (outputFs.delete(targetDirPath, true)) {
                        LOG.info((Object)("Cleaning up uncompleted backup data at " + targetDirPath.toString() + " done."));
                    } else {
                        LOG.info((Object)("No data has been copied to " + targetDirPath.toString() + "."));
                    }
                    if ((backups = FSUtils.listStatus(outputFs, tableDir = targetDirPath.getParent())) != null && backups.length != 0) continue;
                    outputFs.delete(tableDir, true);
                    LOG.debug((Object)(tableDir.toString() + " is empty, remove it."));
                }
            }
        }
        catch (IOException e1) {
            LOG.error((Object)("Cleaning up uncompleted backup data of " + backupInfo.getBackupId() + " at " + backupInfo.getTargetRootDir() + " failed due to " + e1.getMessage() + "."));
        }
    }

    static void failBackup(MasterProcedureEnv env, BackupInfo backupInfo, BackupManager backupManager, Exception e, String msg, BackupType type, Configuration conf) throws IOException {
        LOG.error((Object)(msg + FullTableBackupProcedure.getMessage(e)), (Throwable)e);
        backupInfo.setEndTs(EnvironmentEdgeManager.currentTime());
        backupInfo.setFailedMsg(e.getMessage());
        backupInfo.setState(BackupInfo.BackupState.FAILED);
        String backupFailedData = "BackupId=" + backupInfo.getBackupId() + ",startts=" + backupInfo.getStartTs() + ",failedts=" + backupInfo.getEndTs() + ",failedphase=" + backupInfo.getPhase() + ",failedmessage=" + backupInfo.getFailedMsg();
        LOG.error((Object)backupFailedData);
        backupManager.updateBackupInfo(backupInfo);
        if (type == BackupType.FULL) {
            FullTableBackupProcedure.deleteSnapshot(env, backupInfo, conf);
            FullTableBackupProcedure.cleanupExportSnapshotLog(conf);
        }
        FullTableBackupProcedure.cleanupTargetDir(backupInfo, conf);
        LOG.info((Object)("Backup " + backupInfo.getBackupId() + " failed."));
    }

    private void snapshotCopy(BackupInfo backupInfo) throws Exception {
        LOG.info((Object)"Snapshot copy is starting.");
        backupInfo.setPhase(BackupInfo.BackupPhase.SNAPSHOTCOPY);
        BackupCopyService copyService = BackupRestoreServerFactory.getBackupCopyService(this.conf);
        float numOfSnapshots = backupInfo.getSnapshotNames().size();
        LOG.debug((Object)("There are " + (int)numOfSnapshots + " snapshots to be copied."));
        for (TableName table : backupInfo.getTables()) {
            int res = 0;
            String[] args = new String[]{"-snapshot", backupInfo.getSnapshotName(table), "-copy-to", backupInfo.getBackupStatus(table).getTargetDir()};
            LOG.debug((Object)("Copy snapshot " + args[1] + " to " + args[3]));
            res = copyService.copy(backupInfo, this.backupManager, this.conf, BackupCopyService.Type.FULL, args);
            if (res != 0) {
                LOG.error((Object)("Exporting Snapshot " + args[1] + " failed with return code: " + res + "."));
                throw new IOException("Failed of exporting snapshot " + args[1] + " to " + args[3] + " with reason code " + res);
            }
            LOG.info((Object)("Snapshot copy " + args[1] + " finished."));
        }
    }

    private static void addManifest(BackupInfo backupInfo, BackupManager backupManager, BackupType type, Configuration conf) throws IOException, BackupException {
        BackupManifest manifest;
        backupInfo.setPhase(BackupInfo.BackupPhase.STORE_MANIFEST);
        for (TableName table : backupInfo.getTables()) {
            manifest = new BackupManifest(backupInfo, table);
            ArrayList<BackupManifest.BackupImage> ancestors = backupManager.getAncestors(backupInfo, table);
            for (BackupManifest.BackupImage image : ancestors) {
                manifest.addDependentImage(image);
            }
            if (type == BackupType.INCREMENTAL) {
                HashMap<TableName, HashMap<String, Long>> tableTimestampMap = new HashMap<TableName, HashMap<String, Long>>();
                tableTimestampMap.put(table, (HashMap<String, Long>)backupInfo.getIncrTimestampMap().get(table));
                manifest.setIncrTimestampMap(tableTimestampMap);
                ArrayList<BackupManifest.BackupImage> ancestorss = backupManager.getAncestors(backupInfo);
                for (BackupManifest.BackupImage image : ancestorss) {
                    manifest.addDependentImage(image);
                }
            }
            manifest.store(conf);
        }
        if (type == BackupType.INCREMENTAL) {
            manifest = new BackupManifest(backupInfo);
            manifest.setIncrTimestampMap(backupInfo.getIncrTimestampMap());
            ArrayList<BackupManifest.BackupImage> ancestors = backupManager.getAncestors(backupInfo);
            for (BackupManifest.BackupImage image : ancestors) {
                manifest.addDependentImage(image);
            }
            manifest.store(conf);
        }
    }

    private static String obtainBackupMetaDataStr(BackupInfo backupInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append("type=" + backupInfo.getType() + ",tablelist=");
        for (TableName table : backupInfo.getTables()) {
            sb.append(table + ";");
        }
        if (sb.lastIndexOf(";") > 0) {
            sb.delete(sb.lastIndexOf(";"), sb.lastIndexOf(";") + 1);
        }
        sb.append(",targetRootDir=" + backupInfo.getTargetRootDir());
        return sb.toString();
    }

    private static void cleanupDistCpLog(BackupInfo backupInfo, Configuration conf) throws IOException {
        Path rootPath = new Path(backupInfo.getHLogTargetDir()).getParent();
        FileSystem fs = FileSystem.get((URI)rootPath.toUri(), (Configuration)conf);
        FileStatus[] files = FSUtils.listStatus(fs, rootPath);
        if (files == null) {
            return;
        }
        for (FileStatus file : files) {
            if (!file.getPath().getName().startsWith("_distcp_logs")) continue;
            LOG.debug((Object)("Delete log files of DistCp: " + file.getPath().getName()));
            FSUtils.delete(fs, file.getPath(), true);
        }
    }

    static void completeBackup(MasterProcedureEnv env, BackupInfo backupInfo, BackupManager backupManager, BackupType type, Configuration conf) throws IOException {
        backupInfo.setEndTs(EnvironmentEdgeManager.currentTime());
        backupInfo.setState(BackupInfo.BackupState.COMPLETE);
        backupInfo.setProgress(100);
        FullTableBackupProcedure.addManifest(backupInfo, backupManager, type, conf);
        LOG.debug((Object)"in-fly convert code here, provided by future jira");
        String backupCompleteData = FullTableBackupProcedure.obtainBackupMetaDataStr(backupInfo) + ",startts=" + backupInfo.getStartTs() + ",completets=" + backupInfo.getEndTs() + ",bytescopied=" + backupInfo.getTotalBytesCopied();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Backup " + backupInfo.getBackupId() + " finished: " + backupCompleteData));
        }
        backupManager.updateBackupInfo(backupInfo);
        if (type == BackupType.FULL) {
            FullTableBackupProcedure.deleteSnapshot(env, backupInfo, conf);
            FullTableBackupProcedure.cleanupExportSnapshotLog(conf);
        } else if (type == BackupType.INCREMENTAL) {
            FullTableBackupProcedure.cleanupDistCpLog(backupInfo, conf);
        }
        LOG.info((Object)("Backup " + backupInfo.getBackupId() + " completed."));
    }

    static HBaseProtos.SnapshotDescription wrapSnapshotDescription(TableName tableName, String snapshotName) {
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        builder.setTable(tableName.getNameAsString());
        builder.setName(snapshotName);
        HBaseProtos.SnapshotDescription backupSnapshot = builder.build();
        LOG.debug((Object)("Wrapped a SnapshotDescription " + backupSnapshot.getName() + " from backupInfo to request snapshot for backup."));
        return backupSnapshot;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, BackupProtos.FullTableBackupState state) {
        if (this.conf == null) {
            this.conf = env.getMasterConfiguration();
        }
        if (this.backupManager == null) {
            try {
                this.backupManager = new BackupManager(env.getMasterConfiguration());
            }
            catch (IOException ioe) {
                this.setFailure("full backup", ioe);
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case PRE_SNAPSHOT_TABLE: {
                    FullTableBackupProcedure.beginBackup(this.backupManager, this.backupInfo);
                    String savedStartCode = null;
                    boolean firstBackup = false;
                    try {
                        savedStartCode = this.backupManager.readBackupStartCode();
                        boolean bl = firstBackup = savedStartCode == null || Long.parseLong(savedStartCode) == 0L;
                        if (firstBackup) {
                            this.backupManager.writeBackupStartCode(0L);
                        }
                        LOG.info((Object)"Execute roll log procedure for full backup ...");
                        MasterProcedureManager mpm = env.getMasterServices().getMasterProcedureManagerHost().getProcedureManager("rolllog-proc");
                        HashMap<String, String> props = new HashMap<String, String>();
                        props.put("backupRoot", this.backupInfo.getTargetRootDir());
                        long waitTime = MasterProcedureUtil.execProcedure(mpm, "rolllog-proc", "rolllog", props);
                        MasterProcedureUtil.waitForProcedure(mpm, "rolllog-proc", "rolllog", props, waitTime, this.conf.getInt("hbase.client.retries.number", 31), this.conf.getLong("hbase.client.pause", 100L));
                        this.newTimestamps = this.backupManager.readRegionServerLastLogRollResult();
                        if (firstBackup) {
                            List<String> logFiles = BackupServerUtil.getWALFilesOlderThan(this.conf, this.newTimestamps);
                            this.backupManager.recordWALFiles(logFiles);
                        }
                    }
                    catch (BackupException e) {
                        this.setFailure("Failure in full-backup: pre-snapshot phase", e);
                        FullTableBackupProcedure.failBackup(env, this.backupInfo, this.backupManager, (Exception)((Object)e), "Unexpected BackupException : ", BackupType.FULL, this.conf);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(BackupProtos.FullTableBackupState.SNAPSHOT_TABLES);
                    break;
                }
                case SNAPSHOT_TABLES: {
                    for (TableName tableName : this.tableList) {
                        String snapshotName = "snapshot_" + Long.toString(EnvironmentEdgeManager.currentTime()) + "_" + tableName.getNamespaceAsString() + "_" + tableName.getQualifierAsString();
                        HBaseProtos.SnapshotDescription backupSnapshot = FullTableBackupProcedure.wrapSnapshotDescription(tableName, snapshotName);
                        try {
                            env.getMasterServices().getSnapshotManager().deleteSnapshot(backupSnapshot);
                        }
                        catch (IOException e) {
                            LOG.debug((Object)("Unable to delete " + snapshotName), (Throwable)e);
                        }
                        this.snapshotTable(env, backupSnapshot);
                        this.backupInfo.setSnapshotName(tableName, backupSnapshot.getName());
                    }
                    this.setNextState(BackupProtos.FullTableBackupState.SNAPSHOT_COPY);
                    break;
                }
                case SNAPSHOT_COPY: {
                    LOG.debug((Object)("snapshot copy for " + this.backupId));
                    try {
                        this.snapshotCopy(this.backupInfo);
                    }
                    catch (Exception e) {
                        this.setFailure("Failure in full-backup: snapshot copy phase" + this.backupId, e);
                        FullTableBackupProcedure.failBackup(env, this.backupInfo, this.backupManager, e, "Unexpected BackupException : ", BackupType.FULL, this.conf);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.backupManager.addIncrementalBackupTableSet(this.backupInfo.getTables());
                    this.setNextState(BackupProtos.FullTableBackupState.BACKUP_COMPLETE);
                    break;
                }
                case BACKUP_COMPLETE: {
                    this.backupInfo.setState(BackupInfo.BackupState.COMPLETE);
                    this.backupManager.writeRegionServerLogTimestamp(this.backupInfo.getTables(), this.newTimestamps);
                    HashMap<TableName, HashMap<String, Long>> newTableSetTimestampMap = this.backupManager.readLogTimestampMap();
                    Long newStartCode = BackupClientUtil.getMinValue(BackupServerUtil.getRSLogTimestampMins(newTableSetTimestampMap));
                    this.backupManager.writeBackupStartCode(newStartCode);
                    FullTableBackupProcedure.completeBackup(env, this.backupInfo, this.backupManager, BackupType.FULL, this.conf);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Backup failed in " + state));
            this.setFailure("snapshot-table", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void snapshotTable(MasterProcedureEnv env, HBaseProtos.SnapshotDescription backupSnapshot) throws IOException {
        int maxAttempts = env.getMasterConfiguration().getInt(SNAPSHOT_BACKUP_MAX_ATTEMPTS_KEY, 10);
        int delay = env.getMasterConfiguration().getInt(SNAPSHOT_BACKUP_ATTEMPTS_DELAY_KEY, 10000);
        int attempts = 0;
        while (attempts++ < maxAttempts) {
            try {
                env.getMasterServices().getSnapshotManager().takeSnapshot(backupSnapshot);
                long waitTime = SnapshotDescriptionUtils.getMaxMasterTimeout(env.getMasterConfiguration(), backupSnapshot.getType(), 300000L);
                BackupServerUtil.waitForSnapshot(backupSnapshot, waitTime, env.getMasterServices().getSnapshotManager(), env.getMasterConfiguration());
                break;
            }
            catch (Exception ee) {
                LOG.warn((Object)("Snapshot attempt " + attempts + " failed for table " + backupSnapshot.getTable() + ", sleeping for " + delay + "ms"), (Throwable)ee);
                if (attempts >= maxAttempts) continue;
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected void rollbackState(MasterProcedureEnv env, BackupProtos.FullTableBackupState state) throws IOException {
        if (state != BackupProtos.FullTableBackupState.PRE_SNAPSHOT_TABLE) {
            FullTableBackupProcedure.deleteSnapshot(env, this.backupInfo, this.conf);
            FullTableBackupProcedure.cleanupExportSnapshotLog(this.conf);
        }
        if (state == BackupProtos.FullTableBackupState.SNAPSHOT_COPY) {
            FullTableBackupProcedure.cleanupTargetDir(this.backupInfo, this.conf);
        }
    }

    protected BackupProtos.FullTableBackupState getState(int stateId) {
        return BackupProtos.FullTableBackupState.valueOf((int)stateId);
    }

    protected int getStateId(BackupProtos.FullTableBackupState state) {
        return state.getNumber();
    }

    protected BackupProtos.FullTableBackupState getInitialState() {
        return BackupProtos.FullTableBackupState.PRE_SNAPSHOT_TABLE;
    }

    protected void setNextState(BackupProtos.FullTableBackupState state) {
        if (this.aborted.get()) {
            this.setAbortFailure("backup-table", "abort requested");
        } else {
            super.setNextState((Object)state);
        }
    }

    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (targetRootDir=");
        sb.append(this.targetRootDir);
        sb.append("; backupId=").append(this.backupId);
        sb.append("; tables=");
        int len = this.tableList.size();
        for (int i = 0; i < len - 1; ++i) {
            sb.append(this.tableList.get(i)).append(",");
        }
        if (len >= 1) {
            sb.append(this.tableList.get(len - 1));
        }
        sb.append(")");
    }

    BackupProtos.BackupProcContext toBackupInfo() {
        BackupProtos.BackupProcContext.Builder ctxBuilder = BackupProtos.BackupProcContext.newBuilder();
        ctxBuilder.setCtx(this.backupInfo.toProtosBackupInfo());
        if (this.newTimestamps != null && !this.newTimestamps.isEmpty()) {
            BackupProtos.ServerTimestamp.Builder tsBuilder = BackupProtos.ServerTimestamp.newBuilder();
            for (Map.Entry<String, Long> entry : this.newTimestamps.entrySet()) {
                tsBuilder.clear().setServer(entry.getKey()).setTimestamp(entry.getValue().longValue());
                ctxBuilder.addServerTimestamp(tsBuilder.build());
            }
        }
        return ctxBuilder.build();
    }

    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        BackupProtos.BackupProcContext backupProcCtx = this.toBackupInfo();
        backupProcCtx.writeDelimitedTo(stream);
    }

    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        BackupProtos.BackupProcContext proto = BackupProtos.BackupProcContext.parseDelimitedFrom((InputStream)stream);
        this.backupInfo = BackupInfo.fromProto((BackupProtos.BackupInfo)proto.getCtx());
        this.backupId = this.backupInfo.getBackupId();
        this.targetRootDir = this.backupInfo.getTargetRootDir();
        this.tableList = this.backupInfo.getTableNames();
        List svrTimestamps = proto.getServerTimestampList();
        if (svrTimestamps != null && !svrTimestamps.isEmpty()) {
            this.newTimestamps = new HashMap();
            for (BackupProtos.ServerTimestamp ts : svrTimestamps) {
                this.newTimestamps.put(ts.getServer(), ts.getTimestamp());
            }
        }
    }

    @Override
    public TableName getTableName() {
        return TableName.BACKUP_TABLE_NAME;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.BACKUP;
    }

    protected boolean acquireLock(MasterProcedureEnv env) {
        if (!env.isInitialized() && !this.getTableName().isSystemTable()) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableWrite(this.getTableName(), "full backup");
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableWrite(this.getTableName());
    }
}

