/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.plugins.common.ui;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.runtime.test.RuntimeTestStatus;
import org.pentaho.runtime.test.action.RuntimeTestAction;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.pentaho.runtime.test.module.RuntimeTestModuleResults;
import org.pentaho.runtime.test.result.RuntimeTestResult;
import org.pentaho.runtime.test.result.RuntimeTestResultEntry;

public class ClusterTestResultsDialog
extends Dialog {
    private static final Class<?> PKG = ClusterTestResultsDialog.class;
    private Shell shell;
    private PropsUI props;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTestStatus clusterTestStatus;
    protected LogChannel log;

    public ClusterTestResultsDialog(Shell parent, RuntimeTestActionService runtimeTestActionService, RuntimeTestStatus clusterTestStatus) throws KettleException {
        super(parent);
        this.runtimeTestActionService = runtimeTestActionService;
        this.clusterTestStatus = clusterTestStatus;
        this.props = PropsUI.getInstance();
        this.log = new LogChannel((Object)clusterTestStatus);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3313);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        int margin = 5;
        String docUrl = Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"ClusterTestResultsDialog.Shell.Doc", (String[])new String[0]));
        HelpUtils.createHelpButton((Composite)this.shell, (String)BaseMessages.getString(PKG, (String)"ClusterTestResultsDialog.Shell.Doc.Title", (String[])new String[0]), (String)docUrl, (String)BaseMessages.getString(PKG, (String)"ClusterTestResultsDialog.Shell.Doc.Header", (String[])new String[0]));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = margin;
        formLayout.marginHeight = margin;
        int shellWidth = 585;
        int shellHeight = 490;
        this.shell.setSize(585, 490);
        this.shell.setMinimumSize(585, 490);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ClusterTestResultsDialog.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        this.shell.setBackgroundMode(2);
        Label clusterResultsLabel = new Label((Composite)this.shell, 0);
        clusterResultsLabel.setText(BaseMessages.getString(PKG, (String)"ClusterTestResultsDialog.ClusterTestResults.Label", (String[])new String[0]));
        clusterResultsLabel.setForeground(GUIResource.getInstance().getColorCrystalTextPentaho());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, -margin);
        clusterResultsLabel.setLayoutData((Object)fd);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.shell, 2560);
        fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, -margin);
        fd.bottom = new FormAttachment(100, -50);
        fd.top = new FormAttachment((Control)clusterResultsLabel, margin);
        scrolledComposite.setLayoutData((Object)fd);
        Composite mainComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)mainComposite);
        scrolledComposite.setExpandHorizontal(true);
        FormLayout layout = new FormLayout();
        mainComposite.setLayout((Layout)layout);
        ClassLoader myClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Label separator = null;
        for (RuntimeTestModuleResults moduleResults : this.clusterTestStatus.getModuleResults()) {
            for (RuntimeTestResult testResult : moduleResults.getRuntimeTestResults()) {
                RuntimeTestResultEntry summary = testResult.getOverallStatusEntry();
                Label image = new Label(mainComposite, 0);
                switch (summary.getSeverity()) {
                    case DEBUG: 
                    case INFO: {
                        image.setImage(GUIResource.getInstance().getImage("ui/images/success_green.svg", myClassLoader, 22, 22));
                        break;
                    }
                    case WARNING: 
                    case SKIPPED: {
                        image.setImage(GUIResource.getInstance().getImage("ui/images/warning_yellow.svg", myClassLoader, 22, 22));
                        break;
                    }
                    case ERROR: 
                    case FATAL: {
                        image.setImage(GUIResource.getInstance().getImage("ui/images/error_red.svg", myClassLoader, 22, 22));
                    }
                }
                FormData imageLayoutData = new FormData();
                imageLayoutData.left = new FormAttachment(0, margin);
                imageLayoutData.top = separator != null ? new FormAttachment(separator, margin) : new FormAttachment(0, margin);
                image.setLayoutData((Object)imageLayoutData);
                Label testName = new Label(mainComposite, 0);
                testName.setText(testResult.getRuntimeTest().getName());
                FormData layoutData = new FormData();
                layoutData.left = new FormAttachment((Control)image, margin);
                layoutData.right = new FormAttachment(100, -margin);
                layoutData.top = separator != null ? new FormAttachment(separator, margin) : new FormAttachment(0, margin);
                testName.setLayoutData((Object)layoutData);
                Label description = new Label(mainComposite, 64);
                description.setForeground(GUIResource.getInstance().getColorDarkGray());
                description.setText(summary.getDescription());
                layoutData = new FormData();
                layoutData.left = new FormAttachment((Control)image, margin);
                layoutData.right = new FormAttachment(100, -margin);
                layoutData.top = new FormAttachment((Control)testName, margin);
                description.setLayoutData((Object)layoutData);
                Label linkOrNot = description;
                final RuntimeTestAction runtimeTestAction = summary.getAction();
                if (runtimeTestAction != null) {
                    Link link = new Link(mainComposite, 0);
                    link.setText("<a>" + runtimeTestAction.getName() + "</a>");
                    link.setToolTipText(runtimeTestAction.getDescription());
                    link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            ClusterTestResultsDialog.this.runtimeTestActionService.handle(runtimeTestAction);
                        }
                    });
                    layoutData = new FormData();
                    layoutData.left = new FormAttachment((Control)image, margin);
                    layoutData.right = new FormAttachment(100, -margin);
                    layoutData.top = new FormAttachment((Control)description, margin);
                    link.setLayoutData((Object)layoutData);
                    linkOrNot = link;
                }
                separator = new Label(mainComposite, 258);
                separator.setForeground(GUIResource.getInstance().getColorLightGray());
                layoutData = new FormData();
                layoutData.left = new FormAttachment(0, margin);
                layoutData.right = new FormAttachment(100, -margin);
                layoutData.top = new FormAttachment((Control)linkOrNot, margin);
                separator.setLayoutData((Object)layoutData);
            }
        }
        mainComposite.setSize(mainComposite.computeSize(-1, -1));
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        wOk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ClusterTestResultsDialog.this.ok();
            }
        });
        Button[] buttons = new Button[]{wOk};
        BaseStepDialog.positionBottomRightButtons((Composite)this.shell, (Button[])buttons, (int)margin, null);
        Rectangle shellBounds = Spoon.getInstance().getShell().getBounds();
        this.shell.pack();
        this.shell.open();
        this.shell.setLocation(shellBounds.x + (shellBounds.width - 585) / 2, shellBounds.y + (shellBounds.height - 490) / 2);
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return null;
    }

    private void ok() {
        this.dispose();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }
}

