/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.RootRef;
import org.pentaho.di.ui.repository.pur.services.ITrashService;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;

public class UnifiedRepositoryTrashService
implements ITrashService {
    private final IUnifiedRepository pur;
    private final RootRef rootRef;

    public UnifiedRepositoryTrashService(IUnifiedRepository pur, RootRef rootRef) {
        this.pur = pur;
        this.rootRef = rootRef;
    }

    @Override
    public void delete(List<ObjectId> ids) throws KettleException {
        for (ObjectId id : ids) {
            this.pur.deleteFile((Serializable)((Object)id.getId()), true, null);
        }
        this.rootRef.clearRef();
    }

    @Override
    public void undelete(List<ObjectId> ids) throws KettleException {
        for (ObjectId id : ids) {
            this.pur.undeleteFile((Serializable)((Object)id.getId()), null);
        }
        this.rootRef.clearRef();
    }

    @Override
    public List<ITrashService.IDeletedObject> getTrash() throws KettleException {
        ArrayList<ITrashService.IDeletedObject> trash = new ArrayList<ITrashService.IDeletedObject>();
        List deletedChildren = this.pur.getDeletedFiles();
        for (final RepositoryFile file : deletedChildren) {
            trash.add(new ITrashService.IDeletedObject(){

                @Override
                public String getOriginalParentPath() {
                    return file.getOriginalParentFolderPath();
                }

                @Override
                public Date getDeletedDate() {
                    return file.getDeletedDate();
                }

                @Override
                public String getType() {
                    if (file.getName().endsWith(RepositoryObjectType.TRANSFORMATION.getExtension())) {
                        return RepositoryObjectType.TRANSFORMATION.name();
                    }
                    if (file.getName().endsWith(RepositoryObjectType.JOB.getExtension())) {
                        return RepositoryObjectType.JOB.name();
                    }
                    return null;
                }

                @Override
                public ObjectId getId() {
                    return new StringObjectId(file.getId().toString());
                }

                @Override
                public String getName() {
                    return file.getTitle();
                }

                @Override
                public String getOwner() {
                    return file.getCreatorId();
                }
            });
        }
        return trash;
    }
}

