/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.AttributesInterface;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.missing.MissingEntry;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryAttributeInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.AbstractDelegate;
import org.pentaho.di.repository.pur.AttributesMapUtil;
import org.pentaho.di.repository.pur.ISharedObjectsTransformer;
import org.pentaho.di.repository.pur.PurRepositoryAttribute;
import org.pentaho.di.repository.pur.RepositoryProxy;
import org.pentaho.di.repository.pur.UnifiedRepositoryConnectionAclService;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.ui.repository.pur.services.IConnectionAclService;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataNodeRef;
import org.w3c.dom.Node;

public class JobDelegate
extends AbstractDelegate
implements ISharedObjectsTransformer,
Serializable {
    private static final long serialVersionUID = -1006715561242639895L;
    private static final Class<?> PKG = JobDelegate.class;
    private static final String PROP_SHARED_FILE = "SHARED_FILE";
    public static final String PROP_USE_LOGFIELD = "USE_LOGFIELD";
    public static final String PROP_PASS_BATCH_ID = "PASS_BATCH_ID";
    public static final String PROP_USE_BATCH_ID = "USE_BATCH_ID";
    private static final String PROP_MODIFIED_DATE = "MODIFIED_DATE";
    private static final String PROP_MODIFIED_USER = "MODIFIED_USER";
    private static final String PROP_CREATED_DATE = "CREATED_DATE";
    private static final String PROP_CREATED_USER = "CREATED_USER";
    private static final String PROP_TABLE_NAME_LOG = "TABLE_NAME_LOG";
    private static final String PROP_DATABASE_LOG = "DATABASE_LOG";
    public static final String PROP_JOB_STATUS = "JOB_STATUS";
    private static final String PROP_JOB_VERSION = "JOB_VERSION";
    private static final String PROP_EXTENDED_DESCRIPTION = "EXTENDED_DESCRIPTION";
    public static final String NODE_PARAMETERS = "parameters";
    public static final String PROP_NR_PARAMETERS = "NR_PARAMETERS";
    public static final String PROP_NR_HOPS = "NR_HOPS";
    public static final String NODE_HOPS = "hops";
    public static final String NODE_CUSTOM = "custom";
    public static final String PROP_JOBENTRY_TYPE = "JOBENTRY_TYPE";
    public static final String PROP_PARALLEL = "PARALLEL";
    public static final String PROP_GUI_DRAW = "GUI_DRAW";
    public static final String PROP_GUI_LOCATION_Y = "GUI_LOCATION_Y";
    public static final String PROP_GUI_LOCATION_X = "GUI_LOCATION_X";
    public static final String PROP_NR = "NR";
    public static final String PROP_NR_JOB_ENTRY_COPIES = "NR_JOB_ENTRY_COPIES";
    public static final String PROP_NR_NOTES = "NR_NOTES";
    private static final String NODE_JOB = "job";
    static final String NODE_JOB_PRIVATE_DATABASES = "jobPrivateDatabases";
    static final String PROP_JOB_PRIVATE_DATABASE_NAMES = "PROP_JOB_PRIVATE_DATABASE_NAMES";
    static final String JOB_PRIVATE_DATABASE_DELIMITER = "\t";
    public static final String NODE_NOTES = "notes";
    private static final String NOTE_PREFIX = "__NOTE__#";
    private static final String PROP_XML = "XML";
    public static final String NODE_ENTRIES = "entries";
    private static final String EXT_JOB_ENTRY_COPY = ".kjc";
    private static final String JOB_HOP_FROM = "JOB_HOP_FROM";
    private static final String JOB_HOP_FROM_NR = "JOB_HOP_FROM_NR";
    private static final String JOB_HOP_TO = "JOB_HOP_TO";
    private static final String JOB_HOP_TO_NR = "JOB_HOP_TO_NR";
    private static final String JOB_HOP_ENABLED = "JOB_HOP_ENABLED";
    private static final String JOB_HOP_EVALUATION = "JOB_HOP_EVALUATION";
    private static final String JOB_HOP_UNCONDITIONAL = "JOB_HOP_UNCONDITIONAL";
    private static final String JOB_HOP_PREFIX = "__JOB_HOP__#";
    private static final String PARAM_PREFIX = "__PARAM_#";
    private static final String PARAM_KEY = "KEY";
    private static final String PARAM_DESC = "DESC";
    private static final String PARAM_DEFAULT = "DEFAULT";
    private static final String PROP_LOG_SIZE_LIMIT = "LOG_SIZE_LIMIT";
    public static final String PROP_ATTRIBUTES_JOB_ENTRY_COPY = "ATTRIBUTE_GROUPS.kjc";
    private final Repository repo;
    private final IConnectionAclService unifiedRepositoryConnectionAclService;

    public JobDelegate(Repository repo, IUnifiedRepository pur) {
        this.repo = repo;
        this.unifiedRepositoryConnectionAclService = new UnifiedRepositoryConnectionAclService(pur);
    }

    @Override
    public SharedObjects loadSharedObjects(RepositoryElementInterface element, Map<RepositoryObjectType, List<? extends SharedObjectInterface>> sharedObjectsByType) throws KettleException {
        JobMeta jobMeta = (JobMeta)element;
        jobMeta.setSharedObjects(jobMeta.readSharedObjects());
        this.readDatabases(jobMeta, true, sharedObjectsByType.get(RepositoryObjectType.DATABASE));
        this.readSlaves(jobMeta, true, sharedObjectsByType.get(RepositoryObjectType.SLAVE_SERVER));
        return jobMeta.getSharedObjects();
    }

    @Override
    public void saveSharedObjects(RepositoryElementInterface element, String versionComment) throws KettleException {
        JobMeta jobMeta = (JobMeta)element;
        for (DatabaseMeta databaseMeta : jobMeta.getDatabases()) {
            if (!databaseMeta.hasChanged() && databaseMeta.getObjectId() != null) continue;
            if (databaseMeta.getObjectId() == null || this.unifiedRepositoryConnectionAclService.hasAccess(databaseMeta.getObjectId(), RepositoryFilePermission.WRITE)) {
                this.repo.save((RepositoryElementInterface)databaseMeta, versionComment, null);
                continue;
            }
            this.log.logError(BaseMessages.getString(PKG, (String)"PurRepository.ERROR_0004_DATABASE_UPDATE_ACCESS_DENIED", (String[])new String[]{databaseMeta.getName()}));
        }
        for (SlaveServer slaveServer : jobMeta.getSlaveServers()) {
            if (!slaveServer.hasChanged() && slaveServer.getObjectId() != null) continue;
            this.repo.save((RepositoryElementInterface)slaveServer, versionComment, null);
        }
    }

    @Override
    public RepositoryElementInterface dataNodeToElement(DataNode rootNode) throws KettleException {
        JobMeta jobMeta = new JobMeta();
        this.dataNodeToElement(rootNode, (RepositoryElementInterface)jobMeta);
        return jobMeta;
    }

    @Override
    public void dataNodeToElement(DataNode rootNode, RepositoryElementInterface element) throws KettleException {
        JobMeta jobMeta = (JobMeta)element;
        HashSet<Object> privateDatabases = null;
        DataNode privateDbsNode = rootNode.getNode(NODE_JOB_PRIVATE_DATABASES);
        if (privateDbsNode != null) {
            privateDatabases = new HashSet<Object>();
            if (privateDbsNode.hasProperty(PROP_JOB_PRIVATE_DATABASE_NAMES)) {
                for (String privateDatabaseName : this.getString(privateDbsNode, PROP_JOB_PRIVATE_DATABASE_NAMES).split(JOB_PRIVATE_DATABASE_DELIMITER)) {
                    if (privateDatabaseName.isEmpty()) continue;
                    privateDatabases.add(privateDatabaseName);
                }
            } else {
                for (DataNode privateDatabase : privateDbsNode.getNodes()) {
                    privateDatabases.add(privateDatabase.getName());
                }
            }
        }
        jobMeta.setPrivateDatabases(privateDatabases);
        jobMeta.setSharedObjectsFile(this.getString(rootNode, PROP_SHARED_FILE));
        ArrayList<JobEntryInterface> jobentries = new ArrayList<JobEntryInterface>();
        DataNode entriesNode = rootNode.getNode(NODE_ENTRIES);
        int nrCopies = (int)entriesNode.getProperty(PROP_NR_JOB_ENTRY_COPIES).getLong();
        for (DataNode copyNode : entriesNode.getNodes()) {
            JobEntryInterface jobEntry = this.readJobEntry(copyNode, jobMeta, jobentries);
            JobEntryCopy copy = new JobEntryCopy(jobEntry);
            copy.setName(this.getString(copyNode, "NAME"));
            copy.setDescription(this.getString(copyNode, "DESCRIPTION"));
            copy.setObjectId((ObjectId)new StringObjectId(copyNode.getId().toString()));
            copy.setNr((int)copyNode.getProperty(PROP_NR).getLong());
            int x = (int)copyNode.getProperty(PROP_GUI_LOCATION_X).getLong();
            int y = (int)copyNode.getProperty(PROP_GUI_LOCATION_Y).getLong();
            copy.setLocation(x, y);
            copy.setDrawn(copyNode.getProperty(PROP_GUI_DRAW).getBoolean());
            copy.setLaunchingInParallel(copyNode.getProperty(PROP_PARALLEL).getBoolean());
            if (jobEntry instanceof JobEntryBase) {
                AttributesMapUtil.loadAttributesMap(copyNode, (AttributesInterface)((JobEntryBase)jobEntry));
            }
            AttributesMapUtil.loadAttributesMap(copyNode, (AttributesInterface)copy, PROP_ATTRIBUTES_JOB_ENTRY_COPY);
            jobMeta.getJobCopies().add(copy);
        }
        if (jobMeta.getJobCopies().size() != nrCopies) {
            throw new KettleException("The number of job entry copies read [" + jobMeta.getJobCopies().size() + "] was not the number we expected [" + nrCopies + "]");
        }
        DataNode notesNode = rootNode.getNode(NODE_NOTES);
        int nrNotes = (int)notesNode.getProperty(PROP_NR_NOTES).getLong();
        for (DataNode noteNode : notesNode.getNodes()) {
            String xml = this.getString(noteNode, PROP_XML);
            jobMeta.addNote(new NotePadMeta(XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)xml), (String)"notepad")));
        }
        if (jobMeta.nrNotes() != nrNotes) {
            throw new KettleException("The number of notes read [" + jobMeta.nrNotes() + "] was not the number we expected [" + nrNotes + "]");
        }
        DataNode hopsNode = rootNode.getNode(NODE_HOPS);
        int nrHops = (int)hopsNode.getProperty(PROP_NR_HOPS).getLong();
        for (DataNode hopNode : hopsNode.getNodes()) {
            String copyFromName = this.getString(hopNode, JOB_HOP_FROM);
            int copyFromNr = (int)hopNode.getProperty(JOB_HOP_FROM_NR).getLong();
            String copyToName = this.getString(hopNode, JOB_HOP_TO);
            int copyToNr = (int)hopNode.getProperty(JOB_HOP_TO_NR).getLong();
            boolean enabled = true;
            if (hopNode.hasProperty(JOB_HOP_ENABLED)) {
                enabled = hopNode.getProperty(JOB_HOP_ENABLED).getBoolean();
            }
            boolean evaluation = true;
            if (hopNode.hasProperty(JOB_HOP_EVALUATION)) {
                evaluation = hopNode.getProperty(JOB_HOP_EVALUATION).getBoolean();
            }
            boolean unconditional = true;
            if (hopNode.hasProperty(JOB_HOP_UNCONDITIONAL)) {
                unconditional = hopNode.getProperty(JOB_HOP_UNCONDITIONAL).getBoolean();
            }
            JobEntryCopy copyFrom = jobMeta.findJobEntry(copyFromName, copyFromNr, true);
            JobEntryCopy copyTo = jobMeta.findJobEntry(copyToName, copyToNr, true);
            JobHopMeta jobHopMeta = new JobHopMeta(copyFrom, copyTo);
            jobHopMeta.setEnabled(enabled);
            jobHopMeta.setEvaluation(evaluation);
            jobHopMeta.setUnconditional(unconditional);
            jobMeta.addJobHop(jobHopMeta);
        }
        if (jobMeta.nrJobHops() != nrHops) {
            throw new KettleException("The number of hops read [" + jobMeta.nrJobHops() + "] was not the number we expected [" + nrHops + "]");
        }
        this.loadJobMetaDetails(rootNode, jobMeta);
        jobMeta.eraseParameters();
        DataNode paramsNode = rootNode.getNode(NODE_PARAMETERS);
        int count = (int)paramsNode.getProperty(PROP_NR_PARAMETERS).getLong();
        for (int idx = 0; idx < count; ++idx) {
            DataNode paramNode = paramsNode.getNode(PARAM_PREFIX + idx);
            String key = this.getString(paramNode, PARAM_KEY);
            String def = this.getString(paramNode, PARAM_DEFAULT);
            String desc = this.getString(paramNode, PARAM_DESC);
            jobMeta.addParameterDefinition(key, def, desc);
        }
    }

    protected void loadJobMetaDetails(DataNode rootNode, JobMeta jobMeta) throws KettleException {
        try {
            jobMeta.setExtendedDescription(this.getString(rootNode, PROP_EXTENDED_DESCRIPTION));
            jobMeta.setJobversion(this.getString(rootNode, PROP_JOB_VERSION));
            jobMeta.setJobstatus((int)rootNode.getProperty(PROP_JOB_STATUS).getLong());
            jobMeta.getJobLogTable().setTableName(this.getString(rootNode, PROP_TABLE_NAME_LOG));
            jobMeta.setCreatedUser(this.getString(rootNode, PROP_CREATED_USER));
            jobMeta.setCreatedDate(this.getDate(rootNode, PROP_CREATED_DATE));
            jobMeta.setModifiedUser(this.getString(rootNode, PROP_MODIFIED_USER));
            jobMeta.setModifiedDate(this.getDate(rootNode, PROP_MODIFIED_DATE));
            if (rootNode.hasProperty(PROP_DATABASE_LOG)) {
                String id = rootNode.getProperty(PROP_DATABASE_LOG).getRef().getId().toString();
                DatabaseMeta conn = DatabaseMeta.findDatabase((List)jobMeta.getDatabases(), (ObjectId)new StringObjectId(id));
                jobMeta.getJobLogTable().setConnectionName(conn.getName());
            }
            jobMeta.getJobLogTable().setBatchIdUsed(rootNode.getProperty(PROP_USE_BATCH_ID).getBoolean());
            jobMeta.setBatchIdPassed(rootNode.getProperty(PROP_PASS_BATCH_ID).getBoolean());
            jobMeta.getJobLogTable().setLogFieldUsed(rootNode.getProperty(PROP_USE_LOGFIELD).getBoolean());
            jobMeta.getJobLogTable().setLogSizeLimit(this.getString(rootNode, PROP_LOG_SIZE_LIMIT));
            PurRepositoryAttribute attributeInterface = new PurRepositoryAttribute(rootNode, jobMeta.getDatabases());
            for (LogTableInterface logTable : jobMeta.getLogTables()) {
                logTable.loadFromRepository((RepositoryAttributeInterface)attributeInterface);
            }
            AttributesMapUtil.loadAttributesMap(rootNode, (AttributesInterface)jobMeta);
        }
        catch (Exception e) {
            throw new KettleException("Error loading job details", (Throwable)e);
        }
    }

    protected JobEntryInterface readJobEntry(DataNode copyNode, JobMeta jobMeta, List<JobEntryInterface> jobentries) throws KettleException {
        try {
            boolean isMissing;
            String name = this.getString(copyNode, "NAME");
            for (JobEntryInterface entry : jobentries) {
                if (!entry.getName().equalsIgnoreCase(name)) continue;
                return entry;
            }
            String typeId = this.getString(copyNode, PROP_JOBENTRY_TYPE);
            PluginRegistry registry = PluginRegistry.getInstance();
            PluginInterface jobPlugin = registry.findPluginWithId(JobEntryPluginType.class, typeId);
            JobEntryInterface jobMetaInterface = null;
            boolean bl = isMissing = jobPlugin == null;
            if (!isMissing) {
                jobMetaInterface = (JobEntryInterface)registry.loadClass(jobPlugin);
            } else {
                MissingEntry missingEntry = new MissingEntry(jobMeta.getName(), typeId);
                jobMeta.addMissingEntry(missingEntry);
                jobMetaInterface = missingEntry;
            }
            jobMetaInterface.setName(name);
            jobMetaInterface.setDescription(this.getString(copyNode, "DESCRIPTION"));
            jobMetaInterface.setObjectId((ObjectId)new StringObjectId(copyNode.getId().toString()));
            RepositoryProxy proxy = new RepositoryProxy(copyNode.getNode(NODE_CUSTOM));
            jobMetaInterface.setMetaStore(jobMeta.getMetaStore());
            if (!isMissing) {
                this.compatibleJobEntryLoadRep(jobMetaInterface, (Repository)proxy, null, jobMeta.getDatabases(), jobMeta.getSlaveServers());
                jobMetaInterface.loadRep((Repository)proxy, jobMeta.getMetaStore(), null, jobMeta.getDatabases(), jobMeta.getSlaveServers());
            }
            jobentries.add(jobMetaInterface);
            return jobMetaInterface;
        }
        catch (Exception e) {
            throw new KettleException("Unable to read job entry interface information from repository", (Throwable)e);
        }
    }

    private void compatibleJobEntryLoadRep(JobEntryInterface jobEntry, Repository repository, ObjectId id_jobentry_type, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        jobEntry.loadRep(repository, id_jobentry_type, databases, slaveServers);
    }

    @Override
    public DataNode elementToDataNode(RepositoryElementInterface element) throws KettleException {
        JobMeta jobMeta = (JobMeta)element;
        DataNode rootNode = new DataNode(NODE_JOB);
        if (jobMeta.getPrivateDatabases() != null) {
            String privateDatabaseNames = StringUtils.join((Collection)jobMeta.getPrivateDatabases(), (String)JOB_PRIVATE_DATABASE_DELIMITER);
            DataNode privateDatabaseNode = rootNode.addNode(NODE_JOB_PRIVATE_DATABASES);
            privateDatabaseNode.setProperty(PROP_JOB_PRIVATE_DATABASE_NAMES, privateDatabaseNames);
        }
        DataNode notesNode = rootNode.addNode(NODE_NOTES);
        notesNode.setProperty(PROP_NR_NOTES, (long)jobMeta.nrNotes());
        for (int i = 0; i < jobMeta.nrNotes(); ++i) {
            NotePadMeta note = jobMeta.getNote(i);
            DataNode noteNode = notesNode.addNode(NOTE_PREFIX + i);
            noteNode.setProperty(PROP_XML, note.getXML());
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(this.toString(), new Object[]{"Saving " + jobMeta.nrJobEntries() + " Job entry copies to repository..."});
        }
        DataNode entriesNode = rootNode.addNode(NODE_ENTRIES);
        entriesNode.setProperty(PROP_NR_JOB_ENTRY_COPIES, (long)jobMeta.nrJobEntries());
        for (int i = 0; i < jobMeta.nrJobEntries(); ++i) {
            JobEntryCopy copy = jobMeta.getJobEntry(i);
            JobEntryInterface entry = copy.getEntry();
            DataNode copyNode = entriesNode.addNode(this.sanitizeNodeName(copy.getName()) + "_" + (i + 1) + EXT_JOB_ENTRY_COPY);
            copyNode.setProperty("NAME", copy.getName());
            copyNode.setProperty("DESCRIPTION", copy.getDescription());
            copyNode.setProperty(PROP_NR, (long)copy.getNr());
            copyNode.setProperty(PROP_GUI_LOCATION_X, (long)copy.getLocation().x);
            copyNode.setProperty(PROP_GUI_LOCATION_Y, (long)copy.getLocation().y);
            copyNode.setProperty(PROP_GUI_DRAW, copy.isDrawn());
            copyNode.setProperty(PROP_PARALLEL, copy.isLaunchingInParallel());
            if (entry instanceof JobEntryBase) {
                AttributesMapUtil.saveAttributesMap(copyNode, (AttributesInterface)((JobEntryBase)entry));
            }
            AttributesMapUtil.saveAttributesMap(copyNode, (AttributesInterface)copy, PROP_ATTRIBUTES_JOB_ENTRY_COPY);
            copyNode.setProperty(PROP_JOBENTRY_TYPE, entry.getPluginId());
            DataNode customNode = new DataNode(NODE_CUSTOM);
            RepositoryProxy proxy = new RepositoryProxy(customNode);
            entry.saveRep((Repository)proxy, proxy.getMetaStore(), null);
            this.compatibleEntrySaveRep(entry, (Repository)proxy, null);
            copyNode.addNode(customNode);
        }
        DataNode hopsNode = rootNode.addNode(NODE_HOPS);
        hopsNode.setProperty(PROP_NR_HOPS, (long)jobMeta.nrJobHops());
        for (int i = 0; i < jobMeta.nrJobHops(); ++i) {
            JobHopMeta hop = jobMeta.getJobHop(i);
            DataNode hopNode = hopsNode.addNode(JOB_HOP_PREFIX + i);
            hopNode.setProperty(JOB_HOP_FROM, hop.getFromEntry().getName());
            hopNode.setProperty(JOB_HOP_FROM_NR, (long)hop.getFromEntry().getNr());
            hopNode.setProperty(JOB_HOP_TO, hop.getToEntry().getName());
            hopNode.setProperty(JOB_HOP_TO_NR, (long)hop.getToEntry().getNr());
            hopNode.setProperty(JOB_HOP_ENABLED, hop.isEnabled());
            hopNode.setProperty(JOB_HOP_EVALUATION, hop.getEvaluation());
            hopNode.setProperty(JOB_HOP_UNCONDITIONAL, hop.isUnconditional());
        }
        String[] paramKeys = jobMeta.listParameters();
        DataNode paramsNode = rootNode.addNode(NODE_PARAMETERS);
        paramsNode.setProperty(PROP_NR_PARAMETERS, paramKeys == null ? 0L : (long)paramKeys.length);
        for (int idx = 0; idx < paramKeys.length; ++idx) {
            DataNode paramNode = paramsNode.addNode(PARAM_PREFIX + idx);
            String key = paramKeys[idx];
            String description = jobMeta.getParameterDescription(paramKeys[idx]);
            String defaultValue = jobMeta.getParameterDefault(paramKeys[idx]);
            paramNode.setProperty(PARAM_KEY, key != null ? key : "");
            paramNode.setProperty(PARAM_DEFAULT, defaultValue != null ? defaultValue : "");
            paramNode.setProperty(PARAM_DESC, description != null ? description : "");
        }
        this.saveJobDetails(rootNode, jobMeta);
        return rootNode;
    }

    private void compatibleEntrySaveRep(JobEntryInterface entry, Repository repository, ObjectId id_job) throws KettleException {
        entry.saveRep(repository, id_job);
    }

    private void saveJobDetails(DataNode rootNode, JobMeta jobMeta) throws KettleException {
        rootNode.setProperty(PROP_EXTENDED_DESCRIPTION, jobMeta.getExtendedDescription());
        rootNode.setProperty(PROP_JOB_VERSION, jobMeta.getJobversion());
        rootNode.setProperty(PROP_JOB_STATUS, jobMeta.getJobstatus() < 0 ? -1L : (long)jobMeta.getJobstatus());
        if (jobMeta.getJobLogTable().getDatabaseMeta() != null) {
            DataNodeRef ref = new DataNodeRef((Serializable)((Object)jobMeta.getJobLogTable().getDatabaseMeta().getObjectId().getId()));
            rootNode.setProperty(PROP_DATABASE_LOG, ref);
        }
        rootNode.setProperty(PROP_TABLE_NAME_LOG, jobMeta.getJobLogTable().getTableName());
        rootNode.setProperty(PROP_CREATED_USER, jobMeta.getCreatedUser());
        rootNode.setProperty(PROP_CREATED_DATE, jobMeta.getCreatedDate());
        rootNode.setProperty(PROP_MODIFIED_USER, jobMeta.getModifiedUser());
        rootNode.setProperty(PROP_MODIFIED_DATE, jobMeta.getModifiedDate());
        rootNode.setProperty(PROP_USE_BATCH_ID, jobMeta.getJobLogTable().isBatchIdUsed());
        rootNode.setProperty(PROP_PASS_BATCH_ID, jobMeta.isBatchIdPassed());
        rootNode.setProperty(PROP_USE_LOGFIELD, jobMeta.getJobLogTable().isLogFieldUsed());
        rootNode.setProperty(PROP_SHARED_FILE, jobMeta.getSharedObjectsFile());
        rootNode.setProperty(PROP_LOG_SIZE_LIMIT, jobMeta.getJobLogTable().getLogSizeLimit());
        PurRepositoryAttribute attributeInterface = new PurRepositoryAttribute(rootNode, jobMeta.getDatabases());
        for (LogTableInterface logTable : jobMeta.getLogTables()) {
            logTable.saveToRepository((RepositoryAttributeInterface)attributeInterface);
        }
        AttributesMapUtil.saveAttributesMap(rootNode, (AttributesInterface)jobMeta);
    }

    protected void readDatabases(JobMeta jobMeta, boolean overWriteShared, List<DatabaseMeta> databaseMetas) {
        for (DatabaseMeta databaseMeta : databaseMetas) {
            if (!overWriteShared && jobMeta.findDatabase(databaseMeta.getName()) != null || databaseMeta.getName() == null) continue;
            databaseMeta.shareVariablesWith((VariableSpace)jobMeta);
            jobMeta.addOrReplaceDatabase(databaseMeta);
            if (overWriteShared) continue;
            databaseMeta.setChanged(false);
        }
        jobMeta.clearChanged();
    }

    protected void readSlaves(JobMeta jobMeta, boolean overWriteShared, List<SlaveServer> slaveServers) {
        for (SlaveServer slaveServer : slaveServers) {
            if (!overWriteShared && jobMeta.findSlaveServer(slaveServer.getName()) != null || Utils.isEmpty((CharSequence)slaveServer.getName())) continue;
            slaveServer.shareVariablesWith((VariableSpace)jobMeta);
            jobMeta.addOrReplaceSlaveServer(slaveServer);
            if (overWriteShared) continue;
            slaveServer.setChanged(false);
        }
    }
}

