/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="max", value="_FUNC_(expr) - Returns the maximum value of expr (vectorized, type: timestamp)")
public class VectorUDAFMaxTimestamp
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private VectorExpression inputExpression;
    private transient VectorExpressionWriter resultWriter;

    public VectorUDAFMaxTimestamp(VectorExpression inputExpression) {
        this();
        this.inputExpression = inputExpression;
    }

    public VectorUDAFMaxTimestamp() {
    }

    @Override
    public void init(AggregationDesc desc) throws HiveException {
        this.resultWriter = VectorExpressionWriterFactory.genVectorExpressionWritable(desc.getParameters().get(0));
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregrateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColVector, batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColVector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColVector, batchSize);
            }
        } else if (inputColVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColVector, batchSize, batch.selected, inputColVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColVector, batchSize, inputColVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColVector, batchSize, batch.selected, inputColVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColVector, batchSize, inputColVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, TimestampColumnVector inputColVector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(inputColVector, 0);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, TimestampColumnVector inputColVector, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(inputColVector, selection[i]);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, TimestampColumnVector inputColVector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(inputColVector, i);
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, TimestampColumnVector inputColVector, int batchSize, int[] selection, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[selection[i]]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(inputColVector, 0);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(inputColVector, 0);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, TimestampColumnVector inputColVector, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, j);
            myagg.checkValue(inputColVector, i);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(inputColVector, i);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls && (myagg.isNull || inputColVector.compareTo(myagg.value, 0) < 0)) {
                myagg.isNull = false;
                inputColVector.timestampUpdate(myagg.value, 0);
            }
            return;
        }
        if (!batch.selectedInUse && inputColVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, inputColVector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, inputColVector, batchSize, inputColVector.isNull);
        } else if (inputColVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, inputColVector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, inputColVector, batchSize, inputColVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            if (myagg.isNull) {
                myagg.isNull = false;
                inputColVector.timestampUpdate(myagg.value, i);
                continue;
            }
            if (inputColVector.compareTo(myagg.value, i) >= 0) continue;
            inputColVector.timestampUpdate(myagg.value, i);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            inputColVector.timestampUpdate(myagg.value, selected[0]);
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            int sel = selected[i];
            if (inputColVector.compareTo(myagg.value, sel) >= 0) continue;
            inputColVector.timestampUpdate(myagg.value, sel);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            if (myagg.isNull) {
                inputColVector.timestampUpdate(myagg.value, i);
                myagg.isNull = false;
                continue;
            }
            if (inputColVector.compareTo(myagg.value, i) >= 0) continue;
            inputColVector.timestampUpdate(myagg.value, i);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize) {
        if (myagg.isNull) {
            inputColVector.timestampUpdate(myagg.value, 0);
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            if (inputColVector.compareTo(myagg.value, i) >= 0) continue;
            inputColVector.timestampUpdate(myagg.value, i);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public Object evaluateOutput(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull) {
            return null;
        }
        return this.resultWriter.writeValue(myagg.value);
    }

    @Override
    public ObjectInspector getOutputObjectInspector() {
        return this.resultWriter.getObjectInspector();
    }

    @Override
    public int getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp((int)(model.object() + model.primitive2()), (int)model.memoryAlign());
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public void setInputExpression(VectorExpression inputExpression) {
        this.inputExpression = inputExpression;
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private final transient Timestamp value = new Timestamp(0L);
        private transient boolean isNull = true;

        public void checkValue(TimestampColumnVector colVector, int index) {
            if (this.isNull) {
                this.isNull = false;
                colVector.timestampUpdate(this.value, index);
            } else if (colVector.compareTo(this.value, index) < 0) {
                colVector.timestampUpdate(this.value, index);
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.value.setTime(0L);
        }
    }
}

