/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorPartitionConversion;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VectorDeserializeRow<T extends DeserializeRead> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorDeserializeRow.class);
    private T deserializeRead;
    private TypeInfo[] sourceTypeInfos;
    boolean[] isConvert;
    int[] projectionColumnNums;
    ObjectInspector.Category[] sourceCategories;
    PrimitiveObjectInspector.PrimitiveCategory[] sourcePrimitiveCategories;
    int[] maxLengths;
    Writable[] convertSourceWritables;
    VectorAssignRow convertVectorAssignRow;

    public VectorDeserializeRow(T deserializeRead) {
        this();
        this.deserializeRead = deserializeRead;
        this.sourceTypeInfos = deserializeRead.typeInfos();
    }

    private VectorDeserializeRow() {
    }

    private void allocateArrays(int count) {
        this.isConvert = new boolean[count];
        this.projectionColumnNums = new int[count];
        this.sourceCategories = new ObjectInspector.Category[count];
        this.sourcePrimitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[count];
        this.maxLengths = new int[count];
    }

    private void allocateConvertArrays(int count) {
        this.convertSourceWritables = new Writable[count];
    }

    private void initSourceEntry(int logicalColumnIndex, int projectionColumnNum, TypeInfo sourceTypeInfo) {
        ObjectInspector.Category sourceCategory;
        this.isConvert[logicalColumnIndex] = false;
        this.projectionColumnNums[logicalColumnIndex] = projectionColumnNum;
        this.sourceCategories[logicalColumnIndex] = sourceCategory = sourceTypeInfo.getCategory();
        if (sourceCategory == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector.PrimitiveCategory sourcePrimitiveCategory;
            PrimitiveTypeInfo sourcePrimitiveTypeInfo = (PrimitiveTypeInfo)sourceTypeInfo;
            this.sourcePrimitiveCategories[logicalColumnIndex] = sourcePrimitiveCategory = sourcePrimitiveTypeInfo.getPrimitiveCategory();
            switch (sourcePrimitiveCategory) {
                case CHAR: {
                    this.maxLengths[logicalColumnIndex] = ((CharTypeInfo)sourcePrimitiveTypeInfo).getLength();
                    break;
                }
                case VARCHAR: {
                    this.maxLengths[logicalColumnIndex] = ((VarcharTypeInfo)sourcePrimitiveTypeInfo).getLength();
                    break;
                }
            }
        } else {
            Preconditions.checkState((boolean)false);
        }
    }

    private void initConvertTargetEntry(int logicalColumnIndex) {
        this.isConvert[logicalColumnIndex] = true;
        if (this.sourceCategories[logicalColumnIndex] == ObjectInspector.Category.PRIMITIVE) {
            this.convertSourceWritables[logicalColumnIndex] = VectorizedBatchUtil.getPrimitiveWritable(this.sourcePrimitiveCategories[logicalColumnIndex]);
        } else {
            Preconditions.checkState((boolean)false);
        }
    }

    public void init(int[] outputColumns) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns[i];
            this.initSourceEntry(i, outputColumn, this.sourceTypeInfos[i]);
        }
    }

    public void init(List<Integer> outputColumns) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns.get(i);
            this.initSourceEntry(i, outputColumn, this.sourceTypeInfos[i]);
        }
    }

    public void init(int startColumn) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = startColumn + i;
            this.initSourceEntry(i, outputColumn, this.sourceTypeInfos[i]);
        }
    }

    public void init(boolean[] columnsToIncludeTruncated) throws HiveException {
        if (columnsToIncludeTruncated != null) {
            this.deserializeRead.setColumnsToInclude(columnsToIncludeTruncated);
        }
        int columnCount = columnsToIncludeTruncated == null ? this.sourceTypeInfos.length : columnsToIncludeTruncated.length;
        this.allocateArrays(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            if (columnsToIncludeTruncated != null && !columnsToIncludeTruncated[i]) continue;
            this.initSourceEntry(i, i, this.sourceTypeInfos[i]);
        }
    }

    public int initConversion(TypeInfo[] targetTypeInfos, boolean[] columnsToIncludeTruncated) throws HiveException {
        if (columnsToIncludeTruncated != null) {
            this.deserializeRead.setColumnsToInclude(columnsToIncludeTruncated);
        }
        int targetColumnCount = columnsToIncludeTruncated == null ? targetTypeInfos.length : Math.min(targetTypeInfos.length, columnsToIncludeTruncated.length);
        int sourceColumnCount = Math.min(this.sourceTypeInfos.length, targetColumnCount);
        this.allocateArrays(sourceColumnCount);
        this.allocateConvertArrays(sourceColumnCount);
        boolean atLeastOneConvert = false;
        for (int i = 0; i < sourceColumnCount; ++i) {
            if (columnsToIncludeTruncated != null && !columnsToIncludeTruncated[i]) continue;
            TypeInfo sourceTypeInfo = this.sourceTypeInfos[i];
            TypeInfo targetTypeInfo = targetTypeInfos[i];
            if (!sourceTypeInfo.equals((Object)targetTypeInfo)) {
                if (VectorPartitionConversion.isImplicitVectorColumnConversion(sourceTypeInfo, targetTypeInfo)) {
                    this.initSourceEntry(i, i, sourceTypeInfo);
                    continue;
                }
                this.initSourceEntry(i, i, sourceTypeInfo);
                this.initConvertTargetEntry(i);
                atLeastOneConvert = true;
                continue;
            }
            this.initSourceEntry(i, i, sourceTypeInfo);
        }
        if (atLeastOneConvert) {
            this.convertVectorAssignRow = new VectorAssignRow();
            this.convertVectorAssignRow.initConversion(this.sourceTypeInfos, targetTypeInfos, columnsToIncludeTruncated);
        }
        return sourceColumnCount;
    }

    public void init() throws HiveException {
        this.init(0);
    }

    private void deserializeRowColumn(VectorizedRowBatch batch, int batchIndex, int logicalColumnIndex) throws IOException {
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        if (this.deserializeRead.readCheckNull()) {
            VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
            return;
        }
        ObjectInspector.Category sourceCategory = this.sourceCategories[logicalColumnIndex];
        if (sourceCategory == null) {
            return;
        }
        block0 : switch (sourceCategory) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory sourcePrimitiveCategory = this.sourcePrimitiveCategories[logicalColumnIndex];
                switch (sourcePrimitiveCategory) {
                    case VOID: {
                        VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                        return;
                    }
                    case BOOLEAN: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentBoolean ? 1 : 0;
                        break block0;
                    }
                    case BYTE: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentByte;
                        break block0;
                    }
                    case SHORT: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentShort;
                        break block0;
                    }
                    case INT: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentInt;
                        break block0;
                    }
                    case LONG: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentLong;
                        break block0;
                    }
                    case TIMESTAMP: {
                        ((TimestampColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, ((DeserializeRead)this.deserializeRead).currentTimestampWritable.getTimestamp());
                        break block0;
                    }
                    case DATE: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentDateWritable.getDays();
                        break block0;
                    }
                    case FLOAT: {
                        ((DoubleColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentFloat;
                        break block0;
                    }
                    case DOUBLE: {
                        ((DoubleColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentDouble;
                        break block0;
                    }
                    case BINARY: 
                    case STRING: {
                        ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                        break block0;
                    }
                    case VARCHAR: {
                        int adjustedLength = StringExpr.truncate((byte[])((DeserializeRead)this.deserializeRead).currentBytes, (int)((DeserializeRead)this.deserializeRead).currentBytesStart, (int)((DeserializeRead)this.deserializeRead).currentBytesLength, (int)this.maxLengths[logicalColumnIndex]);
                        ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, adjustedLength);
                        break block0;
                    }
                    case CHAR: {
                        int adjustedLength = StringExpr.rightTrimAndTruncate((byte[])((DeserializeRead)this.deserializeRead).currentBytes, (int)((DeserializeRead)this.deserializeRead).currentBytesStart, (int)((DeserializeRead)this.deserializeRead).currentBytesLength, (int)this.maxLengths[logicalColumnIndex]);
                        ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, adjustedLength);
                        break block0;
                    }
                    case DECIMAL: {
                        ((DecimalColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, ((DeserializeRead)this.deserializeRead).currentHiveDecimalWritable.getHiveDecimal());
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentHiveIntervalYearMonthWritable.getHiveIntervalYearMonth().getTotalMonths();
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        ((IntervalDayTimeColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, ((DeserializeRead)this.deserializeRead).currentHiveIntervalDayTimeWritable.getHiveIntervalDayTime());
                        break block0;
                    }
                }
                throw new RuntimeException("Primitive category " + sourcePrimitiveCategory.name() + " not supported");
            }
            default: {
                throw new RuntimeException("Category " + sourceCategory.name() + " not supported");
            }
        }
        batch.cols[projectionColumnNum].isNull[batchIndex] = false;
    }

    private void deserializeConvertRowColumn(VectorizedRowBatch batch, int batchIndex, int logicalColumnIndex) throws IOException {
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        if (this.deserializeRead.readCheckNull()) {
            VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
            return;
        }
        ObjectInspector.Category sourceCategory = this.sourceCategories[logicalColumnIndex];
        if (sourceCategory == null) {
            return;
        }
        Writable convertSourceWritable = this.convertSourceWritables[logicalColumnIndex];
        block0 : switch (sourceCategory) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory sourcePrimitiveCategory = this.sourcePrimitiveCategories[logicalColumnIndex];
                switch (sourcePrimitiveCategory) {
                    case VOID: {
                        convertSourceWritable = null;
                        break block0;
                    }
                    case BOOLEAN: {
                        ((BooleanWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentBoolean);
                        break block0;
                    }
                    case BYTE: {
                        ((ByteWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentByte);
                        break block0;
                    }
                    case SHORT: {
                        ((ShortWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentShort);
                        break block0;
                    }
                    case INT: {
                        ((IntWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentInt);
                        break block0;
                    }
                    case LONG: {
                        ((LongWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentLong);
                        break block0;
                    }
                    case TIMESTAMP: {
                        ((TimestampWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentTimestampWritable);
                        break block0;
                    }
                    case DATE: {
                        ((DateWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentDateWritable);
                        break block0;
                    }
                    case FLOAT: {
                        ((FloatWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentFloat);
                        break block0;
                    }
                    case DOUBLE: {
                        ((DoubleWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentDouble);
                        break block0;
                    }
                    case BINARY: {
                        if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                            LOG.info("null binary entry: batchIndex " + batchIndex + " projection column num " + projectionColumnNum);
                        }
                        ((BytesWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                        break block0;
                    }
                    case STRING: {
                        if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                            throw new RuntimeException("null string entry: batchIndex " + batchIndex + " projection column num " + projectionColumnNum);
                        }
                        ((Text)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                        break block0;
                    }
                    case VARCHAR: {
                        if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                            throw new RuntimeException("null varchar entry: batchIndex " + batchIndex + " projection column num " + projectionColumnNum);
                        }
                        int adjustedLength = StringExpr.truncate((byte[])((DeserializeRead)this.deserializeRead).currentBytes, (int)((DeserializeRead)this.deserializeRead).currentBytesStart, (int)((DeserializeRead)this.deserializeRead).currentBytesLength, (int)this.maxLengths[logicalColumnIndex]);
                        ((HiveVarcharWritable)convertSourceWritable).set(new String(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, adjustedLength, Charsets.UTF_8), -1);
                        break block0;
                    }
                    case CHAR: {
                        if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                            throw new RuntimeException("null char entry: batchIndex " + batchIndex + " projection column num " + projectionColumnNum);
                        }
                        int adjustedLength = StringExpr.rightTrimAndTruncate((byte[])((DeserializeRead)this.deserializeRead).currentBytes, (int)((DeserializeRead)this.deserializeRead).currentBytesStart, (int)((DeserializeRead)this.deserializeRead).currentBytesLength, (int)this.maxLengths[logicalColumnIndex]);
                        ((HiveCharWritable)convertSourceWritable).set(new String(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, adjustedLength, Charsets.UTF_8), -1);
                        break block0;
                    }
                    case DECIMAL: {
                        ((HiveDecimalWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentHiveDecimalWritable);
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        ((HiveIntervalYearMonthWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentHiveIntervalYearMonthWritable);
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        ((HiveIntervalDayTimeWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentHiveIntervalDayTimeWritable);
                        break block0;
                    }
                }
                throw new RuntimeException("Primitive category " + sourcePrimitiveCategory.name() + " not supported");
            }
            default: {
                throw new RuntimeException("Category " + sourceCategory.name() + " not supported");
            }
        }
        this.convertVectorAssignRow.assignConvertRowColumn(batch, batchIndex, logicalColumnIndex, convertSourceWritable);
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        this.deserializeRead.set(bytes, offset, length);
    }

    public void deserialize(VectorizedRowBatch batch, int batchIndex) throws IOException {
        int count = this.isConvert.length;
        for (int i = 0; i < count; ++i) {
            if (this.isConvert[i]) {
                this.deserializeConvertRowColumn(batch, batchIndex, i);
                continue;
            }
            this.deserializeRowColumn(batch, batchIndex, i);
        }
        this.deserializeRead.extraFieldsCheck();
    }

    public String getDetailedReadPositionString() {
        return this.deserializeRead.getDetailedReadPositionString();
    }
}

