/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.menu;

import org.eclipse.swt.graphics.Image;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.menu.DataServiceTreeDelegateExtension;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.tree.TreeNode;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;

public class DataServiceFolderProvider
extends TreeFolderProvider {
    private static final Class<?> PKG = DataServiceTreeDelegateExtension.class;
    public static final String STRING_DATA_SERVICES = BaseMessages.getString(PKG, (String)"DataServicePopupMenu.TITLE", (String[])new String[0]);
    private DataServiceDelegate dataServiceDelegate;

    public DataServiceFolderProvider(DataServiceDelegate dataServiceDelegate) {
        this.dataServiceDelegate = dataServiceDelegate;
    }

    public void refresh(AbstractMeta meta, TreeNode treeNode, String filter) {
        for (DataServiceMeta dataService : this.dataServiceDelegate.getDataServices((TransMeta)meta)) {
            if (!this.filterMatch(dataService.getName(), filter)) continue;
            this.createTreeNode(treeNode, dataService.getName(), this.getDataServiceImage(GUIResource.getInstance(), dataService));
        }
    }

    private Image getDataServiceImage(GUIResource guiResource, DataServiceMeta dataService) {
        String image = dataService.isStreaming() ? "images/data-services-streaming_padding.svg" : "images/data-services_padding.svg";
        return guiResource.getImage(image, ((Object)((Object)this)).getClass().getClassLoader(), 24, 24);
    }

    public String getTitle() {
        return STRING_DATA_SERVICES;
    }
}

