/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.streaming.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import io.reactivex.BackpressureOverflowStrategy;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Observer;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.streaming.execution.StreamExecutionListener;
import org.pentaho.di.trans.dataservice.streaming.execution.StreamingServiceTransExecutor;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;

public class StreamingGeneratedTransExecution
implements Runnable {
    private static final Log logger = LogFactory.getLog(StreamingGeneratedTransExecution.class);
    private final StreamingServiceTransExecutor serviceExecutor;
    private final Trans genTrans;
    private final String injectorStepName;
    private final String resultStepName;
    private final BehaviorSubject<List<RowMetaAndData>> genTransCachePublishSubject = BehaviorSubject.createDefault(new ArrayList());
    private final String query;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private StreamExecutionListener stream;
    private final AtomicInteger consumersCount = new AtomicInteger(0);
    private final PublishSubject<List<RowMetaAndData>> generatedDataObservable;
    private IDataServiceClientService.StreamingMode windowMode;
    private long windowSize;
    private long windowEvery;
    private long windowLimit;
    private String streamingGeneratedTransCacheKey;

    public StreamingGeneratedTransExecution(StreamingServiceTransExecutor serviceExecutor, Trans genTrans, Observer<List<RowMetaAndData>> rowConsumer, boolean pollingMode, String injectorStepName, String resultStepName, String query, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit, String streamingGeneratedTransCacheKey) {
        this.serviceExecutor = serviceExecutor;
        this.genTrans = genTrans;
        this.injectorStepName = injectorStepName;
        this.resultStepName = resultStepName;
        this.query = query;
        this.windowMode = windowMode;
        this.windowSize = windowSize;
        this.windowEvery = windowEvery;
        this.windowLimit = windowLimit;
        this.streamingGeneratedTransCacheKey = streamingGeneratedTransCacheKey;
        this.generatedDataObservable = PublishSubject.create();
        this.addNewRowConsumer(rowConsumer, pollingMode);
    }

    @VisibleForTesting
    protected Consumer<List<RowMetaAndData>> getWindowConsumer() {
        return rowMetaAndDataList -> this.getGeneratedDataObservable().onNext(rowMetaAndDataList);
    }

    @Override
    public void run() {
        this.getGeneratedDataObservable().toFlowable(BackpressureStrategy.LATEST).onBackpressureBuffer(1L, () -> {}, BackpressureOverflowStrategy.DROP_OLDEST).doOnError(t -> logger.error((Object)"Error receiving data from the service transformation observable", t)).doOnNext(rowMetaAndDataList -> {
            if (this.consumersCount.get() > 0) {
                this.serviceExecutor.touchServiceListener(this.streamingGeneratedTransCacheKey);
            }
        }).subscribe(rowMetaAndDataList -> this.runGenTrans((List<RowMetaAndData>)rowMetaAndDataList));
        if (this.stream == null) {
            this.stream = this.serviceExecutor.getBuffer(this.query, this.getWindowConsumer(), this.windowMode, this.windowSize, this.windowEvery, this.windowLimit);
        }
        try {
            if (this.stream == null) {
                this.runGenTrans(Collections.emptyList());
            }
        }
        catch (KettleStepException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void runGenTrans(List<RowMetaAndData> rowIterator) throws KettleStepException {
        if (this.isRunning.compareAndSet(false, true)) {
            try {
                RowProducer rowProducer;
                LogChannelInterface log = this.genTrans.getLogChannel();
                this.genTrans.getTransListeners().clear();
                this.genTrans.cleanup();
                Trans trans = this.serviceExecutor.getServiceTrans();
                synchronized (trans) {
                    block12: {
                        if (!Thread.currentThread().isInterrupted()) break block12;
                        return;
                    }
                    this.genTrans.prepareExecution(null);
                    rowProducer = this.genTrans.addRowProducer(this.injectorStepName, 0);
                    this.genTrans.startThreads();
                }
                StepInterface resultStep = this.genTrans.findRunThread(this.resultStepName);
                resultStep.cleanup();
                ArrayList<RowMetaAndData> rowsList = new ArrayList<RowMetaAndData>();
                RowAdapter rowListener = this.getRowWrittenListener(rowsList);
                resultStep.addRowListener((RowListener)rowListener);
                this.injectRows(rowIterator, log, rowProducer);
                rowProducer.finished();
                this.waitForGeneratedTransToFinnish();
                this.genTrans.stopAll();
                resultStep.removeRowListener((RowListener)rowListener);
                if (!this.genTransCachePublishSubject.hasComplete()) {
                    this.genTransCachePublishSubject.onNext(Collections.unmodifiableList(rowsList));
                }
                log.logDetailed("Generated transformation stopped");
            }
            catch (KettleException e) {
                throw new KettleStepException((Throwable)e);
            }
            finally {
                this.isRunning.set(false);
                this.genTrans.setRunning(false);
                this.genTrans.setStopped(true);
            }
        }
    }

    @VisibleForTesting
    protected void waitForGeneratedTransToFinnish() {
        try {
            this.genTrans.waitUntilFinished();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof InterruptedException) {
                logger.debug((Object)"The generated transformation was stopped, which resulted in an interruption of the generated transformation wait until finished call");
            }
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    protected RowAdapter getRowWrittenListener(final List<RowMetaAndData> tempList) {
        return new RowAdapter(){

            public void rowWrittenEvent(RowMetaInterface rowMetaInterface, Object[] objects) throws KettleStepException {
                tempList.add(new RowMetaAndData(rowMetaInterface, objects));
            }
        };
    }

    @VisibleForTesting
    protected void injectRows(List<RowMetaAndData> rowIterator, LogChannelInterface log, RowProducer rowProducer) {
        for (RowMetaAndData injectRows : rowIterator) {
            while (!rowProducer.putRowWait(injectRows.getRowMeta(), injectRows.getData(), 1L, TimeUnit.SECONDS) && this.genTrans.isRunning()) {
                log.logRowlevel("Row buffer is full, trying again");
            }
        }
    }

    public void addNewRowConsumer(Observer<List<RowMetaAndData>> consumer, boolean pollingMode) {
        if (pollingMode) {
            this.genTransCachePublishSubject.safeSubscribe(consumer);
        } else {
            this.genTransCachePublishSubject.doOnDispose(() -> this.consumersCount.decrementAndGet()).safeSubscribe(consumer);
            this.consumersCount.incrementAndGet();
        }
    }

    public void clearRowConsumers() {
        this.genTransCachePublishSubject.onComplete();
        this.consumersCount.set(0);
    }

    @VisibleForTesting
    protected PublishSubject<List<RowMetaAndData>> getGeneratedDataObservable() {
        return this.generatedDataObservable;
    }
}

