/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.widgets.callEndpointTabs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.pentaho.di.baserver.utils.CallEndpointMeta;
import org.pentaho.di.baserver.utils.inspector.Endpoint;
import org.pentaho.di.baserver.utils.inspector.Inspector;
import org.pentaho.di.baserver.utils.web.Http;
import org.pentaho.di.baserver.utils.widgets.BrowserBuilder;
import org.pentaho.di.baserver.utils.widgets.ButtonBuilder;
import org.pentaho.di.baserver.utils.widgets.GroupBuilder;
import org.pentaho.di.baserver.utils.widgets.LabelBuilder;
import org.pentaho.di.baserver.utils.widgets.RadioBuilder;
import org.pentaho.di.baserver.utils.widgets.callEndpointTabs.ServerTab;
import org.pentaho.di.baserver.utils.widgets.callEndpointTabs.Tab;
import org.pentaho.di.baserver.utils.widgets.fields.ComboVarFieldBuilder;
import org.pentaho.di.baserver.utils.widgets.fields.Field;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ComboVar;

public class EndpointTab
extends Tab {
    public static final int FIELD_WIDTH = 250;
    public static final int BOTTOM_PLACEMENT = 100;
    private static final String HTML_DOC = "<html>\n<head>\n<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' /><style>{0}</style></head>\n<body>{1}</body>\n</html>";
    private final TransMeta transMeta;
    private final String stepName;
    private final LogChannel log;
    private final ServerTab serverTab;
    private final Button getEndpointButton;
    private ComboVar serverModule;
    private ComboVar resourcePath;
    private ComboVar httpMethod;
    private Browser resourcePathDetailsField;
    private final Button fromServerRadio;
    private final Button fieldsUpstreamRadio;
    private boolean showNonSupportedEndpoints;

    public EndpointTab(CTabFolder tabFolder, PropsUI props, TransMeta transMeta, ModifyListener modifyListener, SelectionListener selectionListener, String stepName, LogChannel log, ServerTab serverTab) {
        super(tabFolder, BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Endpoint.Title", (String[])new String[0]), props);
        this.transMeta = transMeta;
        this.stepName = stepName;
        this.log = log;
        this.serverTab = serverTab;
        this.showNonSupportedEndpoints = this.isShowingNonSupportedEndpoints();
        Group endpointLocationGroup = (Group)new GroupBuilder(this, props).setText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Endpoint.EndpointLocation", (String[])new String[0])).setLeftPlacement(0).setRightPlacement(100).build();
        this.fromServerRadio = (Button)new RadioBuilder((Composite)endpointLocationGroup, props).setText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Endpoint.FromServer", (String[])new String[0])).addSelectionListener(selectionListener).setLeftPlacement(0).build();
        this.getEndpointButton = (Button)new ButtonBuilder((Composite)endpointLocationGroup, props).setLabelText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Endpoint.GetEndpoint", (String[])new String[0])).setLeft((Control)this.fromServerRadio).build();
        ((FormData)this.getEndpointButton.getLayoutData()).top = new FormAttachment((Control)this.fromServerRadio, 0, 0x1000000);
        this.getEndpointButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                EndpointTab.this.refreshEndpoints();
            }
        });
        this.fieldsUpstreamRadio = (Button)new RadioBuilder((Composite)endpointLocationGroup, props).setText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Endpoint.FieldsUpstream", (String[])new String[0])).addSelectionListener(selectionListener).setLeftPlacement(0).setTop((Control)this.fromServerRadio).setTopMargin(10).build();
        SelectionAdapter switchEndpointLocation = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                if (!EndpointTab.this.fromServerRadio.getSelection()) {
                    EndpointTab.this.getEndpointButton.setEnabled(false);
                } else {
                    EndpointTab.this.getEndpointButton.setEnabled(true);
                }
                EndpointTab.this.updateModuleNamesComboBox();
                EndpointTab.this.updateEndpointPathsComboBox();
                EndpointTab.this.updateHttpMethodsComboBox();
                EndpointTab.this.updateEndpointPathsDetailsField();
            }
        };
        this.fromServerRadio.addSelectionListener((SelectionListener)switchEndpointLocation);
        this.fieldsUpstreamRadio.addSelectionListener((SelectionListener)switchEndpointLocation);
        this.fromServerRadio.setSelection(true);
        Group wsEndpointGroup = (Group)new GroupBuilder(this, props).setText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Endpoint.WebServiceEndpoint", (String[])new String[0])).setTop((Control)endpointLocationGroup).setTopMargin(15).setLeftPlacement(0).setRightPlacement(50).setBottomPlacement(100).build();
        Field serverModuleField = (Field)((Object)new ComboVarFieldBuilder((Composite)wsEndpointGroup, props).setVariableSpace((VariableSpace)transMeta).addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                if (EndpointTab.this.fromServerRadio.getSelection()) {
                    EndpointTab.this.updateEndpointPathsComboBox();
                    EndpointTab.this.updateHttpMethodsComboBox();
                    EndpointTab.this.updateEndpointPathsDetailsField();
                }
            }
        }).addModifyListener(modifyListener).setLabel(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Endpoint.BAServerModule", (String[])new String[0])).setTopMargin(10).setLeftPlacement(0).setWidth(250).build());
        this.serverModule = (ComboVar)serverModuleField.getControl();
        Field resourcePathField = (Field)((Object)new ComboVarFieldBuilder((Composite)wsEndpointGroup, props).setVariableSpace((VariableSpace)transMeta).addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                if (EndpointTab.this.fromServerRadio.getSelection()) {
                    EndpointTab.this.updateHttpMethodsComboBox();
                    EndpointTab.this.updateEndpointPathsDetailsField();
                }
            }
        }).addModifyListener(modifyListener).setLabel(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Endpoint.ResourcePath", (String[])new String[0])).setTop((Control)serverModuleField).setTopMargin(10).setLeftPlacement(0).setWidth(250).build());
        this.resourcePath = (ComboVar)resourcePathField.getControl();
        Field httpMethodField = (Field)((Object)new ComboVarFieldBuilder((Composite)wsEndpointGroup, props).setVariableSpace((VariableSpace)transMeta).addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                if (EndpointTab.this.fromServerRadio.getSelection()) {
                    EndpointTab.this.updateEndpointPathsDetailsField();
                }
            }
        }).addModifyListener(modifyListener).setLabel(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Endpoint.HTTPMethod", (String[])new String[0])).setTop((Control)resourcePathField).setTopMargin(10).setLeftPlacement(0).setWidth(250).build());
        this.httpMethod = (ComboVar)httpMethodField.getControl();
        Label lab = (Label)new LabelBuilder(this, props).setText(BaseMessages.getString((Class)PKG, (String)"CallEndpointDialog.TabItem.Endpoint.ResourcePathDetails", (String[])new String[0])).setTop((Control)endpointLocationGroup).setTopMargin(15).setLeft((Control)wsEndpointGroup).setLeftMargin(15).setRightMargin(0).build();
        this.resourcePathDetailsField = (Browser)new BrowserBuilder(this, props).setTop((Control)lab).setTopMargin(5).setLeft((Control)wsEndpointGroup).setLeftMargin(15).setRightPlacement(100).setBottomPlacement(100).build();
    }

    @Override
    public void loadData(CallEndpointMeta meta) {
        this.fromServerRadio.setSelection(!meta.isEndpointFromField());
        this.getEndpointButton.setEnabled(!meta.isEndpointFromField());
        this.fieldsUpstreamRadio.setSelection(meta.isEndpointFromField());
        this.serverModule.setText(meta.getModuleName());
        this.resourcePath.setText(meta.getEndpointPath());
        this.httpMethod.setText(meta.getHttpMethod());
    }

    public void refreshEndpoints() {
        String serverUrl = this.serverTab.getServerUrl();
        String userName = this.serverTab.getUserName();
        String password = this.serverTab.getPassword();
        if (this.serverTab.testConnection(false) && Inspector.getInstance().inspectServer(serverUrl, userName, password)) {
            this.updateModuleNamesComboBox();
            this.updateEndpointPathsComboBox();
            this.updateHttpMethodsComboBox();
            this.updateEndpointPathsDetailsField();
        }
    }

    @Override
    public void saveData(CallEndpointMeta meta) {
        meta.setEndpointFromField(!this.fromServerRadio.getSelection());
        meta.setModuleName(this.serverModule.getText());
        meta.setEndpointPath(this.resourcePath.getText());
        meta.setHttpMethod(this.httpMethod.getText());
    }

    @Override
    public boolean isValid() {
        return !Const.isEmpty((String)this.serverModule.getText()) && !Const.isEmpty((String)this.resourcePath.getText()) && !Const.isEmpty((String)this.httpMethod.getText());
    }

    private void updateModuleNamesComboBox() {
        String moduleName = this.transMeta.environmentSubstitute(this.serverModule.getText());
        this.serverModule.removeAll();
        if (this.fromServerRadio.getSelection()) {
            this.serverModule.removeAll();
            for (String item : Inspector.getInstance().getModuleNames()) {
                this.serverModule.add(item);
            }
            if (moduleName.isEmpty()) {
                moduleName = Inspector.getInstance().getDefaultModuleName();
            }
            this.serverModule.setText(moduleName);
        } else {
            this.serverModule.setItems(this.getFieldNames());
        }
    }

    private void updateEndpointPathsComboBox() {
        String endpointPath = this.transMeta.environmentSubstitute(this.resourcePath.getText());
        this.resourcePath.removeAll();
        Inspector inspector = Inspector.getInstance();
        if (this.fromServerRadio.getSelection()) {
            String moduleName = this.transMeta.environmentSubstitute(this.serverModule.getText());
            for (String path : inspector.getEndpointPaths(moduleName)) {
                List<Endpoint> endpoints = inspector.getEndpoints(moduleName, path);
                boolean add = false;
                for (Endpoint endpoint : endpoints) {
                    if (!endpoint.isSupported() && !this.showNonSupportedEndpoints) continue;
                    add = true;
                    if (!endpointPath.isEmpty()) continue;
                    endpointPath = path;
                }
                if (!add && endpointPath.equals(path)) {
                    endpointPath = "";
                    continue;
                }
                if (!add) continue;
                this.resourcePath.add(path);
            }
            ArrayList<String> endpointPaths = new ArrayList<String>(Arrays.asList(this.resourcePath.getItems()));
            if (endpointPaths.size() == 0) {
                endpointPath = "";
            } else if (endpointPaths.indexOf(endpointPath) < 0) {
                endpointPath = (String)endpointPaths.get(0);
            }
            this.resourcePath.setText(endpointPath);
        } else {
            this.resourcePath.setItems(this.getFieldNames());
        }
    }

    private void updateHttpMethodsComboBox() {
        String httpMethod = this.transMeta.environmentSubstitute(this.httpMethod.getText());
        this.httpMethod.removeAll();
        if (this.fromServerRadio.getSelection()) {
            String moduleName = this.transMeta.environmentSubstitute(this.serverModule.getText());
            String endpointPath = this.transMeta.environmentSubstitute(this.resourcePath.getText());
            List<Endpoint> endpoints = Inspector.getInstance().getEndpoints(moduleName, endpointPath);
            for (Endpoint endpoint : endpoints) {
                if (!endpoint.isSupported() && !this.showNonSupportedEndpoints) continue;
                this.httpMethod.add(endpoint.getHttpMethod().name());
                if (!httpMethod.isEmpty()) continue;
                httpMethod = endpoint.getHttpMethod().name();
            }
            ArrayList<String> httpMethods = new ArrayList<String>(Arrays.asList(this.httpMethod.getItems()));
            if (httpMethods.size() == 0) {
                httpMethod = "";
            } else if (httpMethods.indexOf(endpointPath) < 0) {
                httpMethod = (String)httpMethods.get(0);
            }
            this.httpMethod.setText(httpMethod);
        } else {
            this.httpMethod.setItems(this.getFieldNames());
        }
    }

    private boolean isShowingNonSupportedEndpoints() {
        String value = Variables.getADefaultVariableSpace().environmentSubstitute("${ShowNonSupportedEndpoints}");
        if (value == null) {
            return false;
        }
        return new Boolean(value);
    }

    private void updateEndpointPathsDetailsField() {
        String newValue = "";
        if (this.fromServerRadio.getSelection()) {
            String moduleName = this.transMeta.environmentSubstitute(this.serverModule.getText());
            String endpointPath = this.transMeta.environmentSubstitute(this.resourcePath.getText());
            String method = this.transMeta.environmentSubstitute(this.httpMethod.getText());
            List<Endpoint> endpoints = Inspector.getInstance().getEndpoints(moduleName, endpointPath);
            for (Endpoint endpoint : endpoints) {
                if (!method.isEmpty() && !endpoint.getHttpMethod().equals((Object)Http.valueOf(method))) continue;
                if (endpoint.isDeprecated()) {
                    newValue = BaseMessages.getString(CallEndpointMeta.class, (String)"WadlParser.endpoint.deprecated", (String[])new String[0]) + "<br/>";
                }
                if (endpoint.isSupported()) {
                    String documentation = endpoint.getDocumentation();
                    newValue = newValue + (documentation != null ? documentation : "");
                    break;
                }
                if (!this.showNonSupportedEndpoints) break;
                newValue = newValue + BaseMessages.getString(CallEndpointMeta.class, (String)"WadlParser.endpoint.not.supported", (String[])new String[0]);
                break;
            }
        }
        if (newValue.isEmpty()) {
            newValue = BaseMessages.getString(CallEndpointMeta.class, (String)"WadlParser.endpoint.no.details", (String[])new String[0]);
        }
        newValue = MessageFormat.format(HTML_DOC, BaseMessages.getString(CallEndpointMeta.class, (String)"WadlParser.endpoint.style", (String[])new String[0]), newValue);
        this.resourcePathDetailsField.setText(newValue);
    }

    private String[] getFieldNames() {
        StepMeta stepMeta = this.transMeta.findStep(this.stepName);
        ArrayList<String> entries = null;
        if (stepMeta != null) {
            try {
                RowMetaInterface row = this.transMeta.getPrevStepFields(stepMeta);
                entries = new ArrayList<String>();
                for (int i = 0; i < row.size(); ++i) {
                    entries.add(row.getValueMeta(i).getName());
                }
                Collections.sort(entries);
            }
            catch (KettleException e) {
                this.log.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
            }
        }
        return entries == null ? new String[]{} : entries.toArray(new String[entries.size()]);
    }
}

