/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.data.BinInterSedes;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.BufferedPositionedInputStream;

public class InterRecordReader
extends RecordReader<Text, Tuple> {
    private long start;
    private long lastDataPos;
    private long end;
    private BufferedPositionedInputStream in;
    private Tuple value = null;
    private DataInputStream inData = null;
    private static InterSedes sedes = InterSedesFactory.getInterSedesInstance();
    private byte[] syncMarker;
    private long lastSyncPos = -1L;
    private long syncMarkerInterval;
    private long dataBytesSeen = 0L;

    public InterRecordReader(int syncMarkerLength, long syncMarkerInterval) {
        this.syncMarker = new byte[syncMarkerLength];
        this.syncMarkerInterval = syncMarkerInterval;
    }

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        FileSplit split = (FileSplit)genericSplit;
        Configuration job = context.getConfiguration();
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(job);
        FSDataInputStream fileIn = fs.open(split.getPath());
        if (this.start != 0L || this.end != 0L) {
            fileIn.readFully(0L, this.syncMarker, 0, this.syncMarker.length);
        }
        fileIn.seek(this.start);
        this.in = new BufferedPositionedInputStream((InputStream)fileIn, this.start);
        this.inData = new DataInputStream(this.in);
    }

    private boolean skipUntilMarkerOrSplitEndOrEOF() throws IOException {
        int b = Integer.MIN_VALUE;
        block0: while (b != -1) {
            if (b != this.syncMarker[0]) {
                if (this.in.getPosition() >= this.end) {
                    return false;
                }
                b = this.in.read();
                if ((byte)b != this.syncMarker[0] && b != -1) continue;
                if (b == -1) {
                    return false;
                }
            }
            for (int i = 1; i < this.syncMarker.length; ++i) {
                b = this.in.read();
                if (b == -1) {
                    return false;
                }
                if ((byte)b == this.syncMarker[i]) continue;
                if (this.in.getPosition() <= this.end) continue block0;
                return false;
            }
            this.lastSyncPos = this.in.getPosition();
            return true;
        }
        return false;
    }

    private boolean readSyncFullyOrEOF() throws IOException {
        int b = this.in.read();
        if (b == -1) {
            return false;
        }
        if ((byte)b != this.syncMarker[0]) {
            throw new IOException("Corrupt data file, expected sync marker at position " + this.in.getPosition());
        }
        for (int i = 1; i < this.syncMarker.length; ++i) {
            b = this.in.read();
            if ((byte)b == this.syncMarker[i]) continue;
            throw new IOException("Corrupt data file, expected sync marker at position " + this.in.getPosition());
        }
        this.lastSyncPos = this.in.getPosition();
        return true;
    }

    private boolean readDataOrEOF() throws IOException {
        long preDataPos = this.in.getPosition();
        int b = this.in.read();
        if (!BinInterSedes.isTupleByte((byte)b)) {
            if (b == -1) {
                return false;
            }
            throw new IOException("Corrupt data file, expected tuple type byte, but seen " + b);
        }
        this.value = (Tuple)sedes.readDatum(this.inData, (byte)b);
        this.lastDataPos = this.in.getPosition();
        this.dataBytesSeen += this.lastDataPos - preDataPos;
        return true;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.lastSyncPos == -1L && !this.skipUntilMarkerOrSplitEndOrEOF()) {
            return false;
        }
        if (this.dataBytesSeen >= this.syncMarkerInterval) {
            boolean isEOF;
            boolean bl = isEOF = !this.readSyncFullyOrEOF();
            if (isEOF) {
                return false;
            }
            this.dataBytesSeen = 0L;
            if (this.in.getPosition() - (long)this.syncMarker.length >= this.end) {
                return false;
            }
        }
        return this.readDataOrEOF();
    }

    public Text getCurrentKey() {
        return null;
    }

    public Tuple getCurrentValue() {
        return this.value;
    }

    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.lastDataPos - this.start) / (float)(this.end - this.start));
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

