/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.ActionEndXCommand;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.LogUtils;

public class ActionCheckXCommand
extends ActionXCommand<Void> {
    public static final String EXEC_DATA_MISSING = "EXEC_DATA_MISSING";
    private String actionId;
    private String jobId;
    private int actionCheckDelay;
    private WorkflowJobBean wfJob = null;
    private WorkflowActionBean wfAction = null;
    private ActionExecutor executor = null;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private boolean generateEvent = false;

    public ActionCheckXCommand(String actionId) {
        this(actionId, -1);
    }

    public ActionCheckXCommand(String actionId, int priority, int checkDelay) {
        super("action.check", "action.check", priority);
        this.actionId = actionId;
        this.actionCheckDelay = checkDelay;
        this.jobId = Services.get().get(UUIDService.class).getId(actionId);
    }

    public ActionCheckXCommand(String actionId, int checkDelay) {
        this(actionId, 0, checkDelay);
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.actionId);
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        try {
            this.wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_STATUS, this.jobId);
            this.wfAction = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_ID_TYPE_LASTCHECK, this.actionId);
            LogUtils.setLogInfo(this.wfJob);
            LogUtils.setLogInfo(this.wfAction);
        }
        catch (JPAExecutorException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfJob == null) {
            throw new PreconditionException(ErrorCode.E0604, this.jobId);
        }
        if (this.wfAction == null) {
            throw new PreconditionException(ErrorCode.E0605, this.actionId);
        }
        if (this.actionCheckDelay > 0) {
            Timestamp actionCheckTs = new Timestamp(System.currentTimeMillis() - (long)(this.actionCheckDelay * 1000));
            Timestamp actionLmt = this.wfAction.getLastCheckTimestamp();
            if (actionLmt.after(actionCheckTs)) {
                throw new PreconditionException(ErrorCode.E0817, this.actionId);
            }
        }
        this.executor = Services.get().get(ActionService.class).getExecutor(this.wfAction.getType());
        if (this.executor == null) {
            throw new CommandException(ErrorCode.E0802, this.wfAction.getType());
        }
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_ACTION_OP, this.jobId);
            this.wfAction = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_CHECK, this.actionId);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.wfJob);
        LogUtils.setLogInfo(this.wfAction);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (!this.wfAction.isPending() || this.wfAction.getStatus() != WorkflowAction.Status.RUNNING) {
            throw new PreconditionException(ErrorCode.E0815, this.wfAction.isPending(), this.wfAction.getStatusStr());
        }
        if (this.wfJob.getStatus() != WorkflowJob.Status.RUNNING && this.wfJob.getStatus() != WorkflowJob.Status.SUSPENDED) {
            this.wfAction.setLastCheckTime(new Date());
            try {
                WorkflowActionQueryExecutor.getInstance().executeUpdate(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_FOR_LAST_CHECKED_TIME, this.wfAction);
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
            throw new PreconditionException(ErrorCode.E0818, this.wfAction.getId(), this.wfJob.getId(), this.wfJob.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED ActionCheckXCommand for wf actionId=" + this.actionId + " priority =" + this.getPriority());
        ActionXCommand.ActionExecutorContext context = null;
        boolean execSynchronous = false;
        try {
            boolean isRetry = false;
            if (this.wfAction.getRetries() > 0) {
                isRetry = true;
            }
            boolean isUserRetry = false;
            context = new ActionXCommand.ActionExecutorContext(this.wfJob, this.wfAction, isRetry, isUserRetry);
            this.incrActionCounter(this.wfAction.getType(), 1);
            Instrumentation.Cron cron = new Instrumentation.Cron();
            cron.start();
            this.executor.check(context, this.wfAction);
            cron.stop();
            this.addActionCron(this.wfAction.getType(), cron);
            if (this.wfAction.isExecutionComplete()) {
                if (!context.isExecuted()) {
                    this.LOG.warn(4, "Action Completed, ActionExecutor [{0}] must call setExecutionData()", this.executor.getType());
                    this.wfAction.setErrorInfo(EXEC_DATA_MISSING, "Execution Complete, but Execution Data Missing from Action");
                    this.failJob(context);
                    this.generateEvent = true;
                } else {
                    this.wfAction.setPending();
                    execSynchronous = true;
                }
            }
            this.wfAction.setLastCheckTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_CHECK, this.wfAction));
            this.wfJob.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, this.wfJob));
        }
        catch (ActionExecutorException ex) {
            this.LOG.warn("Exception while executing check(). Error Code [{0}], Message[{1}]", ex.getErrorCode(), ex.getMessage(), ex);
            this.wfAction.setErrorInfo(ex.getErrorCode(), ex.getMessage());
            switch (ex.getErrorType()) {
                case ERROR: {
                    if (this.handleUserRetry(this.wfAction, this.wfJob)) break;
                }
                case FAILED: {
                    this.failJob(context, this.wfAction);
                    this.generateEvent = true;
                    break;
                }
                case TRANSIENT: {
                    if (this.handleTransient(context, this.executor, WorkflowAction.Status.RUNNING)) break;
                    this.handleNonTransient(context, this.executor, WorkflowAction.Status.START_MANUAL);
                    this.generateEvent = true;
                    this.wfAction.setPendingAge(new Date());
                    this.wfAction.setRetries(0);
                    this.wfAction.setStartTime(null);
                }
            }
            this.wfAction.setLastCheckTime(new Date());
            this.updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_CHECK, this.wfAction));
            this.wfJob.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, this.wfJob));
        }
        finally {
            try {
                BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, null);
                if (this.generateEvent && EventHandlerService.isEnabled()) {
                    this.generateEvent(this.wfAction, this.wfJob.getUser());
                }
                if (execSynchronous) {
                    new ActionEndXCommand(this.wfAction.getId(), this.wfAction.getType()).call();
                }
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
        }
        this.LOG.debug("ENDED ActionCheckXCommand for wf actionId=" + this.actionId + ", jobId=" + this.jobId);
        return null;
    }

    protected long getRetryInterval() {
        return this.executor != null ? this.executor.getRetryInterval() : 60L;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.actionId;
    }
}

