/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.io.orc.ConvertTreeReaderFactory;
import org.apache.hadoop.hive.ql.io.orc.TypeDescription;

public class SchemaEvolution {
    private final TypeDescription[] readerFileTypes;
    private final boolean[] readerIncluded;
    private final int readerColumnOffset;
    private final boolean[] fileIncluded;
    private final TypeDescription readerSchema;
    private boolean hasConversion;
    private static final Log LOG = LogFactory.getLog(SchemaEvolution.class);
    public static final List<String> acidEventFieldNames = new ArrayList<String>();

    public SchemaEvolution(TypeDescription fileSchema, boolean[] included) throws IOException {
        this(fileSchema, null, included);
    }

    public SchemaEvolution(TypeDescription fileSchema, TypeDescription readerSchema, boolean[] included) throws IOException {
        this.readerIncluded = included == null ? null : Arrays.copyOf(included, included.length);
        this.fileIncluded = new boolean[fileSchema.getMaximumId() + 1];
        boolean isAcid = SchemaEvolution.checkAcidSchema(fileSchema);
        int n = this.readerColumnOffset = isAcid ? acidEventFieldNames.size() : 0;
        if (readerSchema != null) {
            this.readerSchema = isAcid ? SchemaEvolution.createEventSchema(readerSchema) : readerSchema;
            if (this.readerIncluded != null && this.readerIncluded.length + this.readerColumnOffset != this.readerSchema.getMaximumId() + 1) {
                throw new IllegalArgumentException("Include vector the wrong length: " + this.readerSchema.toJson() + " with include length " + this.readerIncluded.length);
            }
            this.readerFileTypes = new TypeDescription[this.readerSchema.getMaximumId() + 1];
            this.buildConversionFileTypesArray(fileSchema, this.readerSchema);
        } else {
            this.readerSchema = fileSchema;
            this.readerFileTypes = new TypeDescription[this.readerSchema.getMaximumId() + 1];
            if (this.readerIncluded != null && this.readerIncluded.length + this.readerColumnOffset != this.readerSchema.getMaximumId() + 1) {
                throw new IllegalArgumentException("Include vector the wrong length: " + this.readerSchema.toJson() + " with include length " + this.readerIncluded.length);
            }
            this.buildSameSchemaFileTypesArray();
        }
    }

    public TypeDescription getReaderSchema() {
        return this.readerSchema;
    }

    public TypeDescription getReaderBaseSchema() {
        return this.readerSchema.findSubtype(this.readerColumnOffset);
    }

    public boolean hasConversion() {
        return this.hasConversion;
    }

    public TypeDescription getFileType(TypeDescription readerType) {
        return this.getFileType(readerType.getId());
    }

    public TypeDescription getFileType(int id) {
        return this.readerFileTypes[id];
    }

    public boolean[] getReaderIncluded() {
        return this.readerIncluded;
    }

    public boolean[] getFileIncluded() {
        return this.fileIncluded;
    }

    public boolean includeReaderColumn(int readerId) {
        return this.readerIncluded == null || readerId <= this.readerColumnOffset || this.readerIncluded[readerId - this.readerColumnOffset];
    }

    void buildConversionFileTypesArray(TypeDescription fileType, TypeDescription readerType) throws IOException {
        boolean isOk;
        int readerId;
        block19: {
            block18: {
                readerId = readerType.getId();
                if (!this.includeReaderColumn(readerId)) {
                    return;
                }
                isOk = true;
                if (fileType.getCategory() != readerType.getCategory()) break block18;
                switch (readerType.getCategory()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case DOUBLE: 
                    case FLOAT: 
                    case STRING: 
                    case TIMESTAMP: 
                    case BINARY: 
                    case DATE: {
                        break block19;
                    }
                    case CHAR: 
                    case VARCHAR: {
                        if (fileType.getMaxLength() != readerType.getMaxLength()) {
                            this.hasConversion = true;
                        }
                        break block19;
                    }
                    case DECIMAL: {
                        if (fileType.getPrecision() != readerType.getPrecision() || fileType.getScale() != readerType.getScale()) {
                            this.hasConversion = true;
                        }
                        break block19;
                    }
                    case UNION: 
                    case MAP: 
                    case LIST: {
                        List<TypeDescription> fileChildren = fileType.getChildren();
                        List<TypeDescription> readerChildren = readerType.getChildren();
                        if (fileChildren.size() == readerChildren.size()) {
                            for (int i = 0; i < fileChildren.size(); ++i) {
                                this.buildConversionFileTypesArray(fileChildren.get(i), readerChildren.get(i));
                            }
                        } else {
                            isOk = false;
                        }
                        break block19;
                    }
                    case STRUCT: {
                        List<TypeDescription> fileChildren = fileType.getChildren();
                        List<TypeDescription> readerChildren = readerType.getChildren();
                        if (fileChildren.size() != readerChildren.size()) {
                            this.hasConversion = true;
                        }
                        int jointSize = Math.min(fileChildren.size(), readerChildren.size());
                        for (int i = 0; i < jointSize; ++i) {
                            this.buildConversionFileTypesArray(fileChildren.get(i), readerChildren.get(i));
                        }
                        break block19;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + readerType);
                    }
                }
            }
            isOk = ConvertTreeReaderFactory.canConvert(fileType, readerType);
            this.hasConversion = true;
        }
        if (isOk) {
            if (this.readerFileTypes[readerId] != null) {
                throw new RuntimeException("reader to file type entry already assigned");
            }
        } else {
            throw new IOException(String.format("ORC does not support type conversion from file type %s (%d) to reader type %s (%d)", fileType.toString(), fileType.getId(), readerType.toString(), readerId));
        }
        this.readerFileTypes[readerId] = fileType;
        this.fileIncluded[fileType.getId()] = true;
    }

    private void buildSameSchemaFileTypesArray() {
        this.buildSameSchemaFileTypesArrayRecurse(this.readerSchema);
    }

    void buildSameSchemaFileTypesArrayRecurse(TypeDescription readerType) {
        int id = readerType.getId();
        if (!this.includeReaderColumn(id)) {
            return;
        }
        if (this.readerFileTypes[id] != null) {
            throw new RuntimeException("reader to file type entry already assigned");
        }
        this.readerFileTypes[id] = readerType;
        this.fileIncluded[id] = true;
        List<TypeDescription> children = readerType.getChildren();
        if (children != null) {
            for (TypeDescription child : children) {
                this.buildSameSchemaFileTypesArrayRecurse(child);
            }
        }
    }

    private static boolean checkAcidSchema(TypeDescription type) {
        List<String> rootFields;
        return type.getCategory().equals((Object)TypeDescription.Category.STRUCT) && acidEventFieldNames.equals(rootFields = type.getFieldNames());
    }

    public static TypeDescription createEventSchema(TypeDescription typeDescr) {
        TypeDescription result = TypeDescription.createStruct().addField("operation", TypeDescription.createInt()).addField("originalTransaction", TypeDescription.createLong()).addField("bucket", TypeDescription.createInt()).addField("rowId", TypeDescription.createLong()).addField("currentTransaction", TypeDescription.createLong()).addField("row", typeDescr.clone());
        return result;
    }

    static {
        acidEventFieldNames.add("operation");
        acidEventFieldNames.add("originalTransaction");
        acidEventFieldNames.add("bucket");
        acidEventFieldNames.add("rowId");
        acidEventFieldNames.add("currentTransaction");
        acidEventFieldNames.add("row");
    }
}

