/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class BundleActionsDeleteForPurgeJPAExecutor
implements JPAExecutor<Integer> {
    private String bundleId = null;

    public BundleActionsDeleteForPurgeJPAExecutor(String bundleId) {
        ParamChecker.notNull(bundleId, "bundleId");
        this.bundleId = bundleId;
    }

    @Override
    public String getName() {
        return "BundleActionsDeleteForPurgeJPAExecutor";
    }

    @Override
    public Integer execute(EntityManager em) throws JPAExecutorException {
        int actionsDeleted = 0;
        try {
            Query g = em.createNamedQuery("DELETE_COMPLETED_ACTIONS_FOR_BUNDLE");
            g.setParameter("bundleId", (Object)this.bundleId);
            actionsDeleted = g.executeUpdate();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
        return actionsDeleted;
    }
}

