/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.mapping;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInputMeta;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.messages.Messages;

public abstract class BaseMappingAnalyzer<T extends StepWithMappingMeta>
extends StepAnalyzer<StepWithMappingMeta> {
    private static final Logger LOGGER = LogManager.getLogger(BaseMappingAnalyzer.class);
    private static final String MAPPING_INPUT_SPEC = BaseMessages.getString(MappingInputMeta.class, (String)"MappingInputDialog.Shell.Title", (String[])new String[0]);
    private static final String MAPPING_OUTPUT_SPEC = BaseMessages.getString(MappingOutput.class, (String)"MappingOutputDialog.Shell.Title", (String[])new String[0]);

    protected Set<StepField> getUsedFields(StepWithMappingMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        return usedFields;
    }

    protected void customAnalyze(StepWithMappingMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        KettleAnalyzerUtil.analyze((StepAnalyzer)this, (TransMeta)this.parentTransMeta, (ISubTransAwareMeta)((ISubTransAwareMeta)meta), (IMetaverseNode)rootNode);
    }

    public void postAnalyze(StepWithMappingMeta meta) throws MetaverseAnalyzerException {
        String transformationPath = this.parentTransMeta.environmentSubstitute(meta.getFileName());
        TransMeta subTransMeta = KettleAnalyzerUtil.getSubTransMeta((ISubTransAwareMeta)((ISubTransAwareMeta)meta));
        subTransMeta.setFilename(transformationPath);
        Vertex stepVertex = this.findStepVertex(this.parentTransMeta, this.parentStepMeta.getName());
        ArrayList<String> verboseProps = new ArrayList<String>();
        this.processInputMappings(subTransMeta, stepVertex, meta.getInputMappings(), verboseProps);
        this.processOutputMappings(subTransMeta, stepVertex, meta.getOutputMappings(), verboseProps);
        this.createLinks(subTransMeta, meta);
        List outputFieldVertices = IteratorUtils.toList(stepVertex.getVertices(Direction.OUT, new String[]{"outputs"}).iterator());
        for (Vertex outputFieldVertex : outputFieldVertices) {
            outputFieldVertex.remove();
        }
        this.setPropertySafely(stepVertex, "verboseDetails", StringUtils.join(verboseProps, (String)","));
    }

    private boolean shouldRenameFields(StepWithMappingMeta meta) {
        for (MappingIODefinition inputMapping : meta.getInputMappings()) {
            if (!inputMapping.isRenamingOnOutput()) continue;
            return true;
        }
        return false;
    }

    private Vertex getInputSourceStepVertex(TransMeta transMeta, MappingIODefinition mapping) {
        String stepName = null;
        if (mapping != null) {
            if (mapping.isMainDataPath()) {
                stepName = ArrayUtils.isEmpty((Object[])this.prevStepNames) ? null : this.prevStepNames[0];
                LOGGER.warn((Object)Messages.getString((String)"WARN.MultiplePreviousSteps", (String)this.getStepName(), (String)Arrays.toString(this.prevStepNames), (String)stepName));
            } else {
                stepName = mapping.getInputStepname();
            }
        }
        return this.findStepVertex(transMeta, stepName);
    }

    private Vertex getInputTargetStepVertex(TransMeta transMeta, MappingIODefinition mapping) {
        HashMap<String, String> propsLookupMap = new HashMap<String, String>();
        propsLookupMap.put("stepType", MAPPING_INPUT_SPEC);
        if (mapping != null && !mapping.isMainDataPath()) {
            propsLookupMap.put("name", mapping.getOutputStepname());
        }
        return this.findStepVertex(transMeta, propsLookupMap);
    }

    private Vertex getOutputSourceStepVertex(TransMeta transMeta, MappingIODefinition mapping) {
        HashMap<String, String> propsLookupMap = new HashMap<String, String>();
        propsLookupMap.put("stepType", MAPPING_OUTPUT_SPEC);
        if (mapping != null && !mapping.isMainDataPath()) {
            propsLookupMap.put("name", mapping.getInputStepname());
        }
        return this.findStepVertex(transMeta, propsLookupMap);
    }

    private Vertex getOutputTargetStepVertex(TransMeta transMeta, MappingIODefinition mapping) {
        HashMap<String, String> propsLookupMap = new HashMap<String, String>();
        propsLookupMap.put("type", "Transformation Step");
        if (mapping != null && !mapping.isMainDataPath()) {
            propsLookupMap.put("name", mapping.getOutputStepname());
        } else {
            Vertex thisVertex = this.findStepVertex(this.parentTransMeta, this.parentStepMeta.getName());
            Iterator targetVertices = thisVertex.getVertices(Direction.OUT, new String[]{"hops_to"}).iterator();
            if (targetVertices.hasNext()) {
                propsLookupMap.put("name", ((Vertex)targetVertices.next()).getProperty("name").toString());
            }
        }
        return this.findStepVertex(transMeta, propsLookupMap);
    }

    private void createLinks(TransMeta subTransMeta, StepWithMappingMeta meta) {
        MappingValueRename renameMapping;
        boolean renameFields = this.shouldRenameFields(meta);
        HashMap<String, String> fieldRenames = new HashMap<String, String>();
        for (MappingIODefinition inputMapping : meta.getInputMappings()) {
            Vertex inputSourceVertex = this.getInputSourceStepVertex(this.parentTransMeta, inputMapping);
            Vertex inputTargetVertex = this.getInputTargetStepVertex(subTransMeta, inputMapping);
            String inputTargetName = (String)inputTargetVertex.getProperty("name");
            List renames = inputMapping.getValueRenames();
            for (MappingValueRename rename2 : renames) {
                fieldRenames.put(rename2.getTargetValueName(), rename2.getSourceValueName());
            }
            for (Vertex inputSourceOutputField : inputSourceVertex.getVertices(Direction.OUT, new String[]{"outputs"})) {
                String inputSourceOutputFieldName = (String)inputSourceOutputField.getProperty("name");
                renameMapping = inputMapping.getValueRenames().stream().filter(rename -> inputSourceOutputFieldName.equals(rename.getSourceValueName())).findAny().orElse(null);
                String derivedFieldName = renameMapping == null ? inputSourceOutputFieldName : renameMapping.getTargetValueName();
                Vertex derivedField = this.findFieldVertex(subTransMeta, inputTargetName, derivedFieldName);
                this.metaverseBuilder.addLink(inputSourceOutputField, "inputs", inputTargetVertex);
                this.metaverseBuilder.addLink(inputSourceOutputField, "derives", derivedField);
            }
        }
        for (MappingIODefinition outputMapping : meta.getOutputMappings()) {
            Vertex outputSourceVertex = this.getOutputSourceStepVertex(subTransMeta, outputMapping);
            Vertex outputTargetVertex = this.getOutputTargetStepVertex(this.parentTransMeta, outputMapping);
            String outputTargetName = (String)outputTargetVertex.getProperty("name");
            for (Vertex outputSourceField : outputSourceVertex.getVertices(Direction.OUT, new String[]{"outputs"})) {
                String outputSourceFieldName;
                String derivedFieldName = outputSourceFieldName = (String)outputSourceField.getProperty("name");
                renameMapping = outputMapping.getValueRenames().stream().filter(rename -> outputSourceFieldName.equals(rename.getSourceValueName())).findAny().orElse(null);
                if (renameMapping != null) {
                    derivedFieldName = renameMapping.getTargetValueName();
                } else if (renameFields && fieldRenames.containsKey(outputSourceFieldName)) {
                    derivedFieldName = (String)fieldRenames.get(outputSourceFieldName);
                }
                Vertex derivedField = this.findFieldVertex(this.parentTransMeta, outputTargetName, derivedFieldName);
                this.metaverseBuilder.addLink(outputSourceField, "inputs", outputTargetVertex);
                this.metaverseBuilder.addLink(outputSourceField, "derives", derivedField);
                List allOutputTargetInputFields = IteratorUtils.toList(outputTargetVertex.getVertices(Direction.IN, new String[]{"inputs"}).iterator());
                for (Vertex outputTargetInputField : allOutputTargetInputFields) {
                    if (!"true".equals(outputTargetInputField.getProperty("virtual").toString())) continue;
                    Iterator parentSteps = outputTargetInputField.getVertices(Direction.IN, new String[]{"outputs"}).iterator();
                    boolean hasParent = false;
                    if (parentSteps.hasNext()) {
                        hasParent = true;
                    }
                    if (hasParent) continue;
                    outputTargetInputField.remove();
                }
            }
        }
    }

    private void processInputMappings(TransMeta subTransMeta, Vertex stepVertex, List<MappingIODefinition> inputMappings, List<String> verboseProps) {
        int mappingIdx = 1;
        for (MappingIODefinition mapping : inputMappings) {
            String mappingKey = "input [" + mappingIdx + "]";
            verboseProps.add(mappingKey);
            String sourceStep = this.getSourceStepName(subTransMeta, mapping, true, true);
            String targetStep = this.getTargetStepName(subTransMeta, mapping, true, true);
            StringBuilder mappingStr = new StringBuilder();
            if (sourceStep != null && targetStep != null) {
                mappingStr.append(sourceStep).append(" > ").append(targetStep);
            }
            if (!mapping.isMainDataPath()) {
                String descriptionKey = mappingKey + " description";
                verboseProps.add(descriptionKey);
                this.setPropertySafely(stepVertex, descriptionKey, mapping.getDescription());
            }
            this.setCommonProps(stepVertex, mappingKey, mapping, mappingStr, verboseProps);
            ++mappingIdx;
        }
    }

    private void processOutputMappings(TransMeta subTransMeta, Vertex stepVertex, List<MappingIODefinition> mappings, List<String> verboseProps) {
        int mappingIdx = 1;
        for (MappingIODefinition mapping : mappings) {
            String mappingKey = "output [" + mappingIdx + "]";
            verboseProps.add(mappingKey);
            String sourceStep = this.getSourceStepName(subTransMeta, mapping, true, false);
            String targetStep = this.getTargetStepName(subTransMeta, mapping, true, false);
            StringBuilder mappingStr = new StringBuilder();
            if (sourceStep != null && targetStep != null) {
                mappingStr.append(sourceStep).append(" > ").append(targetStep);
            }
            if (!mapping.isMainDataPath()) {
                String descriptionKey = mappingKey + " description";
                verboseProps.add(descriptionKey);
                this.setPropertySafely(stepVertex, descriptionKey, mapping.getDescription());
            }
            this.setCommonProps(stepVertex, mappingKey, mapping, mappingStr, verboseProps);
            ++mappingIdx;
        }
    }

    private String getSourceStepName(TransMeta subTransMeta, MappingIODefinition mapping, boolean includeSubTransPrefix, boolean input) {
        String sourceStep = null;
        if (mapping != null) {
            if (input) {
                sourceStep = mapping.isMainDataPath() ? (this.prevStepNames.length > 0 ? this.prevStepNames[0] : null) : mapping.getInputStepname();
            } else {
                String sourceStepName = mapping.getInputStepname();
                if (mapping.isMainDataPath()) {
                    Vertex sourceVertex = this.getOutputSourceStepVertex(subTransMeta, mapping);
                    sourceStepName = sourceVertex.getProperty("name").toString();
                }
                sourceStep = (includeSubTransPrefix ? "[" + subTransMeta.getName() + "] " : "") + sourceStepName;
            }
        }
        return sourceStep;
    }

    private String getTargetStepName(TransMeta subTransMeta, MappingIODefinition mapping, boolean includeSubTransPrefix, boolean input) {
        String targetStep = null;
        if (mapping != null) {
            if (input) {
                String targetStepName = mapping.getOutputStepname();
                if (mapping.isMainDataPath()) {
                    Vertex targetVertex = this.getInputTargetStepVertex(subTransMeta, mapping);
                    targetStepName = targetVertex.getProperty("name").toString();
                }
                targetStep = (includeSubTransPrefix ? "[" + subTransMeta.getName() + "] " : "") + targetStepName;
            } else if (mapping.isMainDataPath()) {
                List hops = this.parentTransMeta.getTransHops();
                for (TransHopMeta hop : hops) {
                    if (!hop.getFromStep().equals((Object)this.parentStepMeta)) continue;
                    targetStep = hop.getToStep().getName();
                    break;
                }
            } else {
                targetStep = mapping.getOutputStepname();
            }
        }
        return targetStep;
    }

    public void setCommonProps(Vertex stepVertex, String mappingKey, MappingIODefinition mapping, StringBuilder mappingStr, List<String> verboseProps) {
        this.setPropertySafely(stepVertex, mappingKey, mappingStr.toString());
        String updateFieldnamesKey = mappingKey + " update field names";
        verboseProps.add(updateFieldnamesKey);
        this.setPropertySafely(stepVertex, updateFieldnamesKey, Boolean.toString(mapping.isRenamingOnOutput()));
        int renameIdx = 1;
        for (MappingValueRename valueRename : mapping.getValueRenames()) {
            String renameKey = mappingKey + " rename [" + renameIdx++ + "]";
            verboseProps.add(renameKey);
            this.setPropertySafely(stepVertex, renameKey, valueRename.getSourceValueName() + " > " + valueRename.getTargetValueName());
        }
    }
}

