/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.httpclient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.http.HTTP;
import org.pentaho.di.trans.steps.http.HTTPMeta;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.analyzer.kettle.step.BaseStepExternalResourceConsumer;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.pentaho.metaverse.api.model.WebServiceResourceInfo;

public class HTTPClientExternalResourceConsumer
extends BaseStepExternalResourceConsumer<HTTP, HTTPMeta> {
    public boolean isDataDriven(HTTPMeta meta) {
        return true;
    }

    public Collection<IExternalResourceInfo> getResourcesFromMeta(HTTPMeta meta, IAnalysisContext context) {
        String[] urls;
        TransMeta parentTransMeta;
        StepMeta parentStepMeta;
        List<IExternalResourceInfo> resources = Collections.emptyList();
        if (!meta.isUrlInField() && (parentStepMeta = meta.getParentStepMeta()) != null && (parentTransMeta = parentStepMeta.getParentTransMeta()) != null && (urls = new String[]{meta.getUrl()}) != null) {
            resources = new ArrayList<IExternalResourceInfo>(urls.length);
            for (String url : urls) {
                if (Const.isEmpty((String)url)) continue;
                try {
                    IExternalResourceInfo resource = ExternalResourceInfoFactory.createURLResource((String)url, (boolean)true);
                    if (resource == null) {
                        throw new KettleFileException("Error getting file resource!");
                    }
                    resources.add(resource);
                }
                catch (KettleFileException kettleFileException) {
                    // empty catch block
                }
            }
        }
        return resources;
    }

    public Collection<IExternalResourceInfo> getResourcesFromRow(HTTP httpClientInput, RowMetaInterface rowMeta, Object[] row) {
        LinkedList<IExternalResourceInfo> resources = new LinkedList<IExternalResourceInfo>();
        HTTPMeta meta = (HTTPMeta)httpClientInput.getStepMetaInterface();
        if (meta == null) {
            meta = (HTTPMeta)httpClientInput.getStepMeta().getStepMetaInterface();
        }
        if (meta != null) {
            try {
                String url = meta.isUrlInField() ? rowMeta.getString(row, meta.getUrlField(), null) : meta.getUrl();
                if (!Const.isEmpty((String)url)) {
                    String label;
                    String field;
                    int i;
                    WebServiceResourceInfo resourceInfo = (WebServiceResourceInfo)ExternalResourceInfoFactory.createURLResource((String)url, (boolean)true);
                    if (ArrayUtils.isNotEmpty((Object[])meta.getHeaderField())) {
                        for (i = 0; i < meta.getHeaderField().length; ++i) {
                            field = meta.getHeaderField()[i];
                            label = meta.getHeaderParameter()[i];
                            resourceInfo.addHeader(label, (Object)rowMeta.getString(row, field, null));
                        }
                    }
                    if (ArrayUtils.isNotEmpty((Object[])meta.getArgumentField())) {
                        for (i = 0; i < meta.getArgumentField().length; ++i) {
                            field = meta.getArgumentField()[i];
                            label = meta.getArgumentParameter()[i];
                            resourceInfo.addParameter(label, (Object)rowMeta.getString(row, field, null));
                        }
                    }
                    resources.add((IExternalResourceInfo)resourceInfo);
                }
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
        }
        return resources;
    }

    public Class<HTTPMeta> getMetaClass() {
        return HTTPMeta.class;
    }
}

