/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.ui;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.context.JmsProvider;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.AuthComposite;
import org.pentaho.di.ui.core.widget.CheckBoxTableCombo;

class JmsDialogSecurityLayout {
    private final PropsUI props;
    private final CTabFolder wTabFolder;
    private final ModifyListener lsMod;
    private final TransMeta transMeta;
    private Map<String, String> sslConfig;
    private final JmsDelegate jmsDelegate;
    private final String SSL_TRUST_STORE_TYPE;
    private final String SSL_TRUST_STORE_PATH;
    private final String SSL_TRUST_STORE_PASSWORD;
    private final String SSL_KEY_STORE_TYPE;
    private final String SSL_KEY_STORE_PATH;
    private final String SSL_KEY_STORE_PASS;
    private final String SSL_CONTEXT_ALGORITHM;
    private final String SSL_CIPHER_SUITE;
    private final String SSL_IBM_FIPS_REQUIRED;
    private final String SSL_AMQ_PROVIDER;
    private final String SSL_AMQ_TRUST_ALL;
    private final String SSL_AMQ_VERIFY_HOST;
    private CheckBoxTableCombo checkBoxTableCombo;
    private AuthComposite activeMqAuthComposite;
    private AuthComposite ibmMqAuthComposite;
    private Composite wSslGroup;

    JmsDialogSecurityLayout(PropsUI props, CTabFolder wTabFolder, ModifyListener lsMod, TransMeta transMeta, boolean sslEnabled, JmsDelegate jmsDelegate) {
        Preconditions.checkNotNull((Object)props);
        Preconditions.checkNotNull((Object)wTabFolder);
        Preconditions.checkNotNull((Object)lsMod);
        Preconditions.checkNotNull((Object)transMeta);
        this.props = props;
        this.wTabFolder = wTabFolder;
        this.lsMod = lsMod;
        this.transMeta = transMeta;
        this.jmsDelegate = jmsDelegate;
        this.jmsDelegate.sslEnabled = sslEnabled;
        this.sslConfig = new HashMap<String, String>();
        this.SSL_TRUST_STORE_TYPE = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_TRUST_STORE_TYPE", (String[])new String[0]);
        this.SSL_TRUST_STORE_PATH = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_TRUST_STORE_PATH", (String[])new String[0]);
        this.SSL_TRUST_STORE_PASSWORD = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_TRUST_STORE_PASSWORD", (String[])new String[0]);
        this.SSL_KEY_STORE_TYPE = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_KEY_STORE_TYPE", (String[])new String[0]);
        this.SSL_KEY_STORE_PATH = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_KEY_STORE_PATH", (String[])new String[0]);
        this.SSL_KEY_STORE_PASS = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_KEY_STORE_PASS", (String[])new String[0]);
        this.SSL_CONTEXT_ALGORITHM = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_CONTEXT_ALGORITHM", (String[])new String[0]);
        this.SSL_CIPHER_SUITE = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_CIPHER_SUITE", (String[])new String[0]);
        this.SSL_IBM_FIPS_REQUIRED = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_IBM_FIPS_REQUIRED", (String[])new String[0]);
        this.SSL_AMQ_PROVIDER = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_AMQ_PROVIDER", (String[])new String[0]);
        this.SSL_AMQ_TRUST_ALL = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_AMQ_TRUST_ALL", (String[])new String[0]);
        this.SSL_AMQ_VERIFY_HOST = BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSL_AMQ_VERIFY_HOST", (String[])new String[0]);
    }

    protected void buildSecurityTab() {
        CTabItem wSecurityTab = new CTabItem(this.wTabFolder, 0, 1);
        wSecurityTab.setText(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.Tab", (String[])new String[0]));
        Composite wSecurityComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wSecurityComp);
        FormLayout securityLayout = new FormLayout();
        securityLayout.marginHeight = 15;
        securityLayout.marginWidth = 15;
        wSecurityComp.setLayout((Layout)securityLayout);
        FormData fdAuthComposite = new FormDataBuilder().fullWidth().result();
        this.ibmMqAuthComposite = new AuthComposite(wSecurityComp, 0, this.props, this.lsMod, this.transMeta, BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Authentication", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsUser", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsPassword", (String[])new String[0]));
        this.ibmMqAuthComposite.setLayoutData((Object)fdAuthComposite);
        this.activeMqAuthComposite = new AuthComposite(wSecurityComp, 0, this.props, this.lsMod, this.transMeta, BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Authentication", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsUser", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.JmsPassword", (String[])new String[0]));
        this.activeMqAuthComposite.setLayoutData((Object)fdAuthComposite);
        this.wSslGroup = new Composite(wSecurityComp, 0);
        FormLayout flSsl = new FormLayout();
        flSsl.marginHeight = 0;
        flSsl.marginWidth = 0;
        this.wSslGroup.setLayout((Layout)flSsl);
        FormData fdSslGroup = new FormData();
        fdSslGroup.left = new FormAttachment(0, 0);
        fdSslGroup.top = new FormAttachment((Control)this.activeMqAuthComposite, 15);
        fdSslGroup.right = new FormAttachment(100, 0);
        fdSslGroup.bottom = new FormAttachment(100, 0);
        fdSslGroup.width = 350;
        this.wSslGroup.setLayoutData((Object)fdSslGroup);
        this.props.setLook((Control)this.wSslGroup);
        this.checkBoxTableCombo = new CheckBoxTableCombo(this.wSslGroup, this.props, this.lsMod, this.transMeta, this.sslConfig, BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSLButton", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.SSLTable", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.Column.Name", (String[])new String[0]), BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDialog.Security.Column.Value", (String[])new String[0]), this.jmsDelegate.sslEnabled);
        FormData fdSecurityComp = new FormData();
        wSecurityComp.setLayoutData((Object)fdSecurityComp);
        wSecurityTab.setControl((Control)wSecurityComp);
        this.activeMqAuthComposite.setUsername(this.jmsDelegate.amqUsername);
        this.activeMqAuthComposite.setPassword(this.jmsDelegate.amqPassword);
        this.ibmMqAuthComposite.setUsername(this.jmsDelegate.ibmUsername);
        this.ibmMqAuthComposite.setPassword(this.jmsDelegate.ibmPassword);
        this.toggleVisibility(JmsProvider.ConnectionType.valueOf(this.jmsDelegate.connectionType));
    }

    protected void saveTableValues() {
        Map tableValues = this.checkBoxTableCombo.getPropertiesData();
        this.jmsDelegate.sslEnabled = this.checkBoxTableCombo.getIsEnabled();
        this.jmsDelegate.sslTruststoreType = (String)tableValues.get(this.SSL_TRUST_STORE_TYPE);
        this.jmsDelegate.sslTruststorePath = (String)tableValues.get(this.SSL_TRUST_STORE_PATH);
        this.jmsDelegate.sslTruststorePassword = (String)tableValues.get(this.SSL_TRUST_STORE_PASSWORD);
        this.jmsDelegate.sslKeystoreType = (String)tableValues.get(this.SSL_KEY_STORE_TYPE);
        this.jmsDelegate.sslKeystorePath = (String)tableValues.get(this.SSL_KEY_STORE_PATH);
        this.jmsDelegate.sslKeystorePassword = (String)tableValues.get(this.SSL_KEY_STORE_PASS);
        this.jmsDelegate.sslContextAlgorithm = (String)tableValues.get(this.SSL_CONTEXT_ALGORITHM);
        this.jmsDelegate.sslCipherSuite = (String)tableValues.get(this.SSL_CIPHER_SUITE);
        this.jmsDelegate.ibmSslFipsRequired = (String)tableValues.get(this.SSL_IBM_FIPS_REQUIRED);
        this.jmsDelegate.amqSslProvider = (String)tableValues.get(this.SSL_AMQ_PROVIDER);
        this.jmsDelegate.amqSslTrustAll = (String)tableValues.get(this.SSL_AMQ_TRUST_ALL);
        this.jmsDelegate.amqSslVerifyHost = (String)tableValues.get(this.SSL_AMQ_VERIFY_HOST);
    }

    protected void saveAuthentication() {
        this.jmsDelegate.amqUsername = this.activeMqAuthComposite.getUsername();
        this.jmsDelegate.amqPassword = this.activeMqAuthComposite.getPassword();
        this.jmsDelegate.ibmUsername = this.ibmMqAuthComposite.getUsername();
        this.jmsDelegate.ibmPassword = this.ibmMqAuthComposite.getPassword();
    }

    protected void populateTableIbm() {
        this.sslConfig = new HashMap<String, String>();
        this.sslConfig.put(this.SSL_TRUST_STORE_TYPE, this.jmsDelegate.sslTruststoreType);
        this.sslConfig.put(this.SSL_TRUST_STORE_PATH, this.jmsDelegate.sslTruststorePath);
        this.sslConfig.put(this.SSL_TRUST_STORE_PASSWORD, this.jmsDelegate.sslTruststorePassword);
        this.sslConfig.put(this.SSL_KEY_STORE_TYPE, this.jmsDelegate.sslKeystoreType);
        this.sslConfig.put(this.SSL_KEY_STORE_PATH, this.jmsDelegate.sslKeystorePath);
        this.sslConfig.put(this.SSL_KEY_STORE_PASS, this.jmsDelegate.sslKeystorePassword);
        this.sslConfig.put(this.SSL_CONTEXT_ALGORITHM, this.jmsDelegate.sslContextAlgorithm);
        this.sslConfig.put(this.SSL_CIPHER_SUITE, this.jmsDelegate.sslCipherSuite);
        this.sslConfig.put(this.SSL_IBM_FIPS_REQUIRED, this.jmsDelegate.ibmSslFipsRequired);
        this.checkBoxTableCombo.updateDataMap(this.sslConfig);
    }

    protected void populateTableActiveMq() {
        this.sslConfig = new HashMap<String, String>();
        this.sslConfig.put(this.SSL_TRUST_STORE_PATH, this.jmsDelegate.sslTruststorePath);
        this.sslConfig.put(this.SSL_TRUST_STORE_PASSWORD, this.jmsDelegate.sslTruststorePassword);
        this.sslConfig.put(this.SSL_KEY_STORE_PATH, this.jmsDelegate.sslKeystorePath);
        this.sslConfig.put(this.SSL_KEY_STORE_PASS, this.jmsDelegate.sslKeystorePassword);
        this.sslConfig.put(this.SSL_CONTEXT_ALGORITHM, this.jmsDelegate.sslContextAlgorithm);
        this.sslConfig.put(this.SSL_CIPHER_SUITE, this.jmsDelegate.sslCipherSuite);
        this.sslConfig.put(this.SSL_AMQ_PROVIDER, this.jmsDelegate.amqSslProvider);
        this.sslConfig.put(this.SSL_AMQ_TRUST_ALL, this.jmsDelegate.amqSslTrustAll);
        this.sslConfig.put(this.SSL_AMQ_VERIFY_HOST, this.jmsDelegate.amqSslVerifyHost);
        this.checkBoxTableCombo.updateDataMap(this.sslConfig);
    }

    protected void toggleVisibility(JmsProvider.ConnectionType type) {
        switch (type) {
            case WEBSPHERE: {
                this.activeMqAuthComposite.setVisible(false);
                this.ibmMqAuthComposite.setVisible(true);
                this.populateTableIbm();
                break;
            }
            case ACTIVEMQ: {
                this.ibmMqAuthComposite.setVisible(false);
                this.activeMqAuthComposite.setVisible(true);
                this.populateTableActiveMq();
            }
        }
    }
}

