/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.context;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.context.JmsProvider;

public class WebsphereMQProvider
implements JmsProvider {
    @Override
    public boolean supports(JmsProvider.ConnectionType type) {
        return type == JmsProvider.ConnectionType.WEBSPHERE;
    }

    @Override
    public String getConnectionDetails(JmsDelegate meta) {
        StringBuilder connDetails = new StringBuilder();
        MQUrlResolver resolver = new MQUrlResolver(meta);
        connDetails.append("Hostname: ").append(resolver.host);
        connDetails.append("\nPort: ").append(resolver.port);
        connDetails.append("\nChannel: ").append(resolver.channel);
        connDetails.append("\nQueueManager: ").append(resolver.queueManager);
        connDetails.append("\nUser Name: ").append(meta.ibmUsername);
        connDetails.append("\nPassword: ").append(meta.ibmPassword);
        if (meta.sslEnabled) {
            connDetails.append("\nSSL Enabled: true");
            connDetails.append("\nKey Store: ").append(meta.sslKeystorePath);
            connDetails.append("\nKey Store Pass: ").append(meta.sslKeystorePassword);
            connDetails.append("\nKey Store Type: ").append(meta.sslKeystoreType);
            connDetails.append("\nTrust Store: ").append(meta.sslTruststorePath);
            connDetails.append("\nTrust Store Pass: ").append(meta.sslTruststorePassword);
            connDetails.append("\nTrust Store Type: ").append(meta.sslTruststoreType);
            connDetails.append("\nSSL Context Algorithm: ").append(meta.sslContextAlgorithm);
            connDetails.append("\nCipher Suite: ").append(meta.sslCipherSuite);
            connDetails.append("\nFIPS Required: ").append(meta.ibmSslFipsRequired);
        }
        return connDetails.toString();
    }

    @Override
    public JMSContext getContext(JmsDelegate meta) {
        MQUrlResolver resolver = new MQUrlResolver(meta);
        MQQueueConnectionFactory connFactory = this.isQueue(meta) ? new MQQueueConnectionFactory() : new MQTopicConnectionFactory();
        connFactory.setHostName(resolver.host);
        if (meta.sslEnabled) {
            try {
                KeyStore trustStore = KeyStore.getInstance(meta.sslTruststoreType);
                trustStore.load(new FileInputStream(meta.sslTruststorePath), Strings.isNullOrEmpty((String)meta.sslTruststorePassword) ? null : meta.sslTruststorePassword.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
                KeyManagerFactory keyManagerFactory = null;
                if (!Strings.isNullOrEmpty((String)meta.sslKeystorePath)) {
                    KeyStore keyStore = KeyStore.getInstance(meta.sslKeystoreType);
                    keyStore.load(new FileInputStream(meta.sslKeystorePath), meta.sslKeystorePassword.toCharArray());
                    keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, meta.sslKeystorePassword.toCharArray());
                }
                SSLContext sslContext = SSLContext.getInstance(meta.sslContextAlgorithm);
                sslContext.init(null == keyManagerFactory ? null : keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                connFactory.setSSLFipsRequired(meta.ibmSslFipsRequired.toLowerCase().startsWith("t") || meta.ibmSslFipsRequired.toLowerCase().startsWith("y"));
                connFactory.setSSLSocketFactory((Object)sslSocketFactory);
                connFactory.setSSLCipherSuite(meta.sslCipherSuite);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            connFactory.setPort(resolver.port);
            connFactory.setQueueManager(resolver.queueManager);
            connFactory.setChannel(resolver.channel);
            connFactory.setTransportType(1);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        return connFactory.createContext(meta.ibmUsername, meta.ibmPassword);
    }

    @Override
    public Destination getDestination(JmsDelegate meta) {
        Preconditions.checkNotNull((Object)meta.destinationName, (Object)BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsWebsphereMQ.DestinationNameRequired", (String[])new String[0]));
        try {
            String destName = meta.destinationName;
            return this.isQueue(meta) ? new MQQueue(destName) : new MQTopic(destName);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    static class MQUrlResolver {
        private final JmsDelegate meta;
        private final Pattern pattern = Pattern.compile("mq://([\\p{Alnum}\\x2D\\x2E]*)(:(\\p{Digit}*))?/([\\p{Alnum}\\x2E]*)(\\x3F(channel=([^\\s=\\x26]*)))?");
        private String host = null;
        private String queueManager = "default";
        private int port = 1414;
        private String channel = "SYSTEM.DEF.SVRCONN";

        MQUrlResolver(JmsDelegate meta) {
            this.meta = meta;
            this.resolve();
        }

        void resolve() {
            Matcher matcher = this.pattern.matcher(this.meta.ibmUrl.trim());
            if (matcher.matches()) {
                this.host = matcher.group(1);
                this.queueManager = matcher.group(4);
                String value = matcher.group(3);
                if (value != null) {
                    this.port = Integer.parseInt(value);
                }
                if ((value = matcher.group(7)) != null) {
                    this.channel = value;
                }
            }
        }
    }
}

