/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms.context;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.jms.Destination;
import javax.jms.JMSContext;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.step.jms.context.JmsProvider;

public class ActiveMQProvider
implements JmsProvider {
    private final String urlCharEncoding = "UTF-8";

    @Override
    public boolean supports(JmsProvider.ConnectionType type) {
        return type == JmsProvider.ConnectionType.ACTIVEMQ;
    }

    @Override
    public JMSContext getContext(JmsDelegate delegate) {
        String finalUrl = this.buildUrl(delegate);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(finalUrl);
        return factory.createContext(delegate.amqUsername, delegate.amqPassword);
    }

    @Override
    public String getConnectionDetails(JmsDelegate meta) {
        return "User Name: " + (Strings.isNullOrEmpty((String)meta.amqUsername) ? "" : meta.amqUsername) + "\nPassword: " + (Strings.isNullOrEmpty((String)meta.amqPassword) ? "" : meta.amqPassword) + "\nURL: " + this.buildUrl(meta);
    }

    protected String buildUrl(JmsDelegate delegate) {
        StringBuilder finalUrl = new StringBuilder(delegate.amqUrl.trim());
        if (delegate.sslEnabled && !finalUrl.toString().contains("sslEnabled")) {
            StringBuilder urlQuery = new StringBuilder();
            try {
                if (!finalUrl.toString().contains("?")) {
                    urlQuery.append("?");
                } else if (!finalUrl.toString().endsWith("&")) {
                    urlQuery.append("&");
                }
                urlQuery.append("sslEnabled=true");
                if (!Strings.isNullOrEmpty((String)delegate.sslKeystorePath)) {
                    Preconditions.checkNotNull((Object)delegate.sslKeystorePassword, (Object)"SSL keystore password must be specified if keystore path is specified");
                    urlQuery.append("&keyStorePath=").append(this.urlEncode(delegate.sslKeystorePath.trim()));
                    urlQuery.append("&keyStorePassword=").append(this.urlEncode(delegate.sslKeystorePassword.trim()));
                }
                urlQuery.append("&trustStorePath=").append(this.urlEncode(delegate.sslTruststorePath.trim()));
                if (!Strings.isNullOrEmpty((String)delegate.sslTruststorePassword)) {
                    urlQuery.append("&trustStorePassword=").append(this.urlEncode(delegate.sslTruststorePassword.trim()));
                }
                if (!Strings.isNullOrEmpty((String)delegate.sslCipherSuite)) {
                    urlQuery.append("&enabledCipherSuites=").append(this.urlEncode(delegate.sslCipherSuite.trim()));
                }
                if (!Strings.isNullOrEmpty((String)delegate.sslContextAlgorithm)) {
                    urlQuery.append("&enabledProtocols=").append(this.urlEncode(delegate.sslContextAlgorithm.trim()));
                }
                if (!Strings.isNullOrEmpty((String)delegate.amqSslVerifyHost)) {
                    urlQuery.append("&verifyHost=").append(this.urlEncode(delegate.amqSslVerifyHost.trim()));
                }
                if (!Strings.isNullOrEmpty((String)delegate.amqSslTrustAll)) {
                    urlQuery.append("&trustAll=").append(this.urlEncode(delegate.amqSslTrustAll.trim()));
                }
                if (!Strings.isNullOrEmpty((String)delegate.amqSslProvider)) {
                    urlQuery.append("&sslProvider=").append(this.urlEncode(delegate.amqSslProvider.trim()));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            finalUrl.append(urlQuery.toString());
        }
        return finalUrl.toString();
    }

    private String urlEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }

    @Override
    public Destination getDestination(JmsDelegate delegate) {
        Preconditions.checkNotNull((Object)delegate.destinationName, (Object)BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsWebsphereMQ.DestinationNameRequired", (String[])new String[0]));
        String destName = delegate.destinationName;
        return this.isQueue(delegate) ? new ActiveMQQueue(destName) : new ActiveMQTopic(destName);
    }
}

