/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.DateTimeCalc;
import mondrian.calc.DimensionCalc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.IntegerCalc;
import mondrian.calc.IterCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.ParameterSlot;
import mondrian.calc.ResultStyle;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractBooleanCalc;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.AbstractHierarchyCalc;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.IterableListCalc;
import mondrian.calc.impl.MemberValueCalc;
import mondrian.calc.impl.TupleValueCalc;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Category;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Literal;
import mondrian.olap.Parameter;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.CastFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.HierarchyCurrentMemberFunDef;
import mondrian.olap.fun.HierarchyDimensionFunDef;
import mondrian.olap.fun.LevelHierarchyFunDef;
import mondrian.olap.fun.MemberHierarchyFunDef;
import mondrian.olap.fun.MemberLevelFunDef;
import mondrian.olap.type.BooleanType;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NullType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class AbstractExpCompiler
implements ExpCompiler {
    private final Evaluator evaluator;
    private final Validator validator;
    private final Map<Parameter, ParameterSlotImpl> parameterSlots = new HashMap<Parameter, ParameterSlotImpl>();
    private List<ResultStyle> resultStyles;

    public AbstractExpCompiler(Evaluator evaluator, Validator validator) {
        this(evaluator, validator, ResultStyle.ANY_LIST);
    }

    public AbstractExpCompiler(Evaluator evaluator, Validator validator, List<ResultStyle> resultStyles) {
        this.evaluator = evaluator;
        this.validator = validator;
        this.resultStyles = resultStyles == null ? ResultStyle.ANY_LIST : resultStyles;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public Validator getValidator() {
        return this.validator;
    }

    @Override
    public Calc compile(Exp exp) {
        return exp.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Calc compileAs(Exp exp, Type resultType, List<ResultStyle> preferredResultTypes) {
        assert (preferredResultTypes != null);
        int substitutions = 0;
        if (Util.Retrowoven) {
            ArrayList<ResultStyle> tmp = new ArrayList<ResultStyle>(preferredResultTypes.size());
            for (ResultStyle preferredResultType : preferredResultTypes) {
                if (preferredResultType == ResultStyle.ITERABLE) {
                    preferredResultType = ResultStyle.LIST;
                    ++substitutions;
                }
                tmp.add(preferredResultType);
            }
            preferredResultTypes = tmp;
        }
        List<ResultStyle> save = this.resultStyles;
        try {
            this.resultStyles = preferredResultTypes;
            if (resultType != null && resultType != exp.getType()) {
                Object object;
                if (resultType instanceof MemberType) {
                    object = this.compileMember(exp);
                    return object;
                }
                if (resultType instanceof LevelType) {
                    object = this.compileLevel(exp);
                    return object;
                }
                if (resultType instanceof HierarchyType) {
                    object = this.compileHierarchy(exp);
                    return object;
                }
                if (resultType instanceof DimensionType) {
                    object = this.compileDimension(exp);
                    return object;
                }
                if (resultType instanceof ScalarType) {
                    object = this.compileScalar(exp, false);
                    return object;
                }
            }
            Calc calc = this.compile(exp);
            if (substitutions > 0) {
                IterCalc iterCalc = (IterCalc)calc;
                if (iterCalc == null) {
                    this.resultStyles = Collections.singletonList(ResultStyle.ITERABLE);
                    Calc calc2 = this.compile(exp);
                    return calc2;
                }
                IterCalc iterCalc2 = iterCalc;
                return iterCalc2;
            }
            Calc calc3 = calc;
            return calc3;
        }
        finally {
            this.resultStyles = save;
        }
    }

    @Override
    public MemberCalc compileMember(Exp exp) {
        Type type = exp.getType();
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return this.hierarchyToMember(hierarchyCalc);
        }
        if (type instanceof NullType) {
            throw MondrianResource.instance().NullNotSupported.ex();
        }
        if (type instanceof DimensionType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return this.hierarchyToMember(hierarchyCalc);
        }
        assert (type instanceof MemberType) : type;
        return (MemberCalc)this.compile(exp);
    }

    private MemberCalc hierarchyToMember(HierarchyCalc hierarchyCalc) {
        Hierarchy hierarchy = hierarchyCalc.getType().getHierarchy();
        if (hierarchy != null) {
            return new HierarchyCurrentMemberFunDef.FixedCalcImpl((Exp)new DummyExp(TypeUtil.toMemberType(hierarchyCalc.getType())), hierarchy);
        }
        return new HierarchyCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(TypeUtil.toMemberType(hierarchyCalc.getType())), hierarchyCalc);
    }

    @Override
    public LevelCalc compileLevel(Exp exp) {
        Type type = exp.getType();
        if (type instanceof MemberType) {
            MemberCalc memberCalc = this.compileMember(exp);
            return new MemberLevelFunDef.CalcImpl((Exp)new DummyExp(LevelType.forType(type)), memberCalc);
        }
        assert (type instanceof LevelType);
        return (LevelCalc)this.compile(exp);
    }

    @Override
    public DimensionCalc compileDimension(Exp exp) {
        Type type = exp.getType();
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return new HierarchyDimensionFunDef.CalcImpl((Exp)new DummyExp(new DimensionType(type.getDimension())), hierarchyCalc);
        }
        assert (type instanceof DimensionType) : type;
        return (DimensionCalc)this.compile(exp);
    }

    @Override
    public HierarchyCalc compileHierarchy(Exp exp) {
        Type type = exp.getType();
        if (type instanceof DimensionType) {
            Dimension dimension = type.getDimension();
            if (dimension != null) {
                Hierarchy hierarchy = FunUtil.getDimensionDefaultHierarchy(dimension);
                if (hierarchy != null) {
                    return (HierarchyCalc)ConstantCalc.constantHierarchy(hierarchy);
                }
                throw MondrianResource.instance().CannotImplicitlyConvertDimensionToHierarchy.ex(dimension.getName());
            }
            DimensionCalc dimensionCalc = this.compileDimension(exp);
            return new DimensionHierarchyCalc((Exp)new DummyExp(HierarchyType.forType(type)), dimensionCalc);
        }
        if (type instanceof MemberType) {
            MemberCalc memberCalc = this.compileMember(exp);
            return new MemberHierarchyFunDef.CalcImpl((Exp)new DummyExp(HierarchyType.forType(type)), memberCalc);
        }
        if (type instanceof LevelType) {
            LevelCalc levelCalc = this.compileLevel(exp);
            return new LevelHierarchyFunDef.CalcImpl((Exp)new DummyExp(HierarchyType.forType(type)), levelCalc);
        }
        assert (type instanceof HierarchyType);
        return (HierarchyCalc)this.compile(exp);
    }

    @Override
    public IntegerCalc compileInteger(Exp exp) {
        Calc calc = this.compileScalar(exp, false);
        Type type = calc.getType();
        if (type instanceof DecimalType && ((DecimalType)type).getScale() == 0) {
            return (IntegerCalc)calc;
        }
        if (type instanceof NumericType) {
            if (calc instanceof ConstantCalc) {
                ConstantCalc constantCalc = (ConstantCalc)calc;
                return new ConstantCalc(new DecimalType(Integer.MAX_VALUE, 0), constantCalc.evaluateInteger(null));
            }
            if (calc instanceof DoubleCalc) {
                final DoubleCalc doubleCalc = (DoubleCalc)calc;
                return new AbstractIntegerCalc(exp, new Calc[]{doubleCalc}){

                    @Override
                    public int evaluateInteger(Evaluator evaluator) {
                        return (int)doubleCalc.evaluateDouble(evaluator);
                    }
                };
            }
        }
        return (IntegerCalc)calc;
    }

    @Override
    public StringCalc compileString(Exp exp) {
        return (StringCalc)this.compileScalar(exp, false);
    }

    @Override
    public DateTimeCalc compileDateTime(Exp exp) {
        return (DateTimeCalc)this.compileScalar(exp, false);
    }

    @Override
    public ListCalc compileList(Exp exp) {
        return this.compileList(exp, false);
    }

    @Override
    public ListCalc compileList(Exp exp, boolean mutable) {
        assert (exp.getType() instanceof SetType) : "must be a set: " + exp;
        List<ResultStyle> resultStyleList = mutable ? ResultStyle.MUTABLELIST_ONLY : ResultStyle.LIST_ONLY;
        Calc calc = this.compileAs(exp, null, resultStyleList);
        if (calc instanceof ListCalc) {
            return (ListCalc)calc;
        }
        if (calc == null) {
            calc = this.compileAs(exp, null, ResultStyle.ITERABLE_ANY);
            assert (calc != null);
        }
        if (!(calc instanceof ListCalc)) {
            return this.toList((IterCalc)calc);
        }
        throw Util.newInternal("Cannot convert calc to list: " + calc);
    }

    public ListCalc toList(IterCalc calc) {
        return new IterableListCalc(calc);
    }

    @Override
    public IterCalc compileIter(Exp exp) {
        IterCalc calc = (IterCalc)this.compileAs(exp, null, ResultStyle.ITERABLE_ONLY);
        if (calc == null) {
            calc = (IterCalc)this.compileAs(exp, null, ResultStyle.ANY_ONLY);
            assert (calc != null);
        }
        return calc;
    }

    @Override
    public BooleanCalc compileBoolean(Exp exp) {
        Calc calc = this.compileScalar(exp, false);
        if (calc instanceof BooleanCalc) {
            Object o;
            if (calc instanceof ConstantCalc && !((o = calc.evaluate(null)) instanceof Boolean)) {
                return ConstantCalc.constantBoolean(CastFunDef.toBoolean(o, new BooleanType()));
            }
            return (BooleanCalc)calc;
        }
        if (calc instanceof DoubleCalc) {
            final DoubleCalc doubleCalc = (DoubleCalc)calc;
            return new AbstractBooleanCalc(exp, new Calc[]{doubleCalc}){

                @Override
                public boolean evaluateBoolean(Evaluator evaluator) {
                    return doubleCalc.evaluateDouble(evaluator) != 0.0;
                }
            };
        }
        if (calc instanceof IntegerCalc) {
            final IntegerCalc integerCalc = (IntegerCalc)calc;
            return new AbstractBooleanCalc(exp, new Calc[]{integerCalc}){

                @Override
                public boolean evaluateBoolean(Evaluator evaluator) {
                    return integerCalc.evaluateInteger(evaluator) != 0;
                }
            };
        }
        return (BooleanCalc)calc;
    }

    @Override
    public DoubleCalc compileDouble(Exp exp) {
        Calc calc = this.compileScalar(exp, false);
        if (calc instanceof ConstantCalc && !(calc.evaluate(null) instanceof Double)) {
            return ConstantCalc.constantDouble(((ConstantCalc)calc).evaluateDouble(null));
        }
        if (calc instanceof DoubleCalc) {
            return (DoubleCalc)calc;
        }
        if (calc instanceof IntegerCalc) {
            final IntegerCalc integerCalc = (IntegerCalc)calc;
            return new AbstractDoubleCalc(exp, new Calc[]{integerCalc}){

                @Override
                public double evaluateDouble(Evaluator evaluator) {
                    int result = integerCalc.evaluateInteger(evaluator);
                    return result;
                }
            };
        }
        throw Util.newInternal("cannot cast " + exp);
    }

    @Override
    public TupleCalc compileTuple(Exp exp) {
        return (TupleCalc)this.compile(exp);
    }

    @Override
    public Calc compileScalar(Exp exp, boolean specific) {
        Type type = exp.getType();
        if (type instanceof MemberType) {
            MemberCalc calc = this.compileMember(exp);
            return this.memberToScalar(calc);
        }
        if (type instanceof DimensionType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return this.hierarchyToScalar(hierarchyCalc);
        }
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return this.hierarchyToScalar(hierarchyCalc);
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            TupleCalc tupleCalc = this.compileTuple(exp);
            TupleValueCalc scalarCalc = new TupleValueCalc(new DummyExp(tupleType.getValueType()), tupleCalc, this.getEvaluator().mightReturnNullForUnrelatedDimension());
            return scalarCalc.optimize();
        }
        if (type instanceof ScalarType) {
            if (specific) {
                if (type instanceof BooleanType) {
                    return this.compileBoolean(exp);
                }
                if (type instanceof NumericType) {
                    return this.compileDouble(exp);
                }
                if (type instanceof StringType) {
                    return this.compileString(exp);
                }
                return this.compile(exp);
            }
            return this.compile(exp);
        }
        return this.compile(exp);
    }

    private Calc hierarchyToScalar(HierarchyCalc hierarchyCalc) {
        MemberCalc memberCalc = this.hierarchyToMember(hierarchyCalc);
        return this.memberToScalar(memberCalc);
    }

    private Calc memberToScalar(MemberCalc memberCalc) {
        MemberType memberType = (MemberType)memberCalc.getType();
        return MemberValueCalc.create(new DummyExp(memberType.getValueType()), new MemberCalc[]{memberCalc}, this.getEvaluator().mightReturnNullForUnrelatedDimension());
    }

    @Override
    public ParameterSlot registerParameter(Parameter parameter) {
        Calc calc;
        ParameterSlot slot = this.parameterSlots.get(parameter);
        if (slot != null) {
            return slot;
        }
        int index = this.parameterSlots.size();
        ParameterSlotImpl slot2 = new ParameterSlotImpl(parameter, index);
        this.parameterSlots.put(parameter, slot2);
        slot2.value = parameter.getValue();
        Type type = parameter.getType();
        Exp defaultExp = parameter.getDefaultExp();
        if (type instanceof ScalarType) {
            if (!defaultExp.getType().equals(type)) {
                defaultExp = new UnresolvedFunCall("Cast", Syntax.Cast, new Exp[]{defaultExp, Literal.createSymbol(Category.instance.getName(TypeUtil.typeToCategory(type)))});
                defaultExp = this.getValidator().validate(defaultExp, true);
            }
            calc = this.compileScalar(defaultExp, true);
        } else {
            calc = this.compileAs(defaultExp, type, this.resultStyles);
        }
        slot2.setDefaultValueCalc(calc);
        return slot2;
    }

    @Override
    public List<ResultStyle> getAcceptableResultStyles() {
        return this.resultStyles;
    }

    private static class DimensionHierarchyCalc
    extends AbstractHierarchyCalc {
        private final DimensionCalc dimensionCalc;

        protected DimensionHierarchyCalc(Exp exp, DimensionCalc dimensionCalc) {
            super(exp, new Calc[]{dimensionCalc});
            this.dimensionCalc = dimensionCalc;
        }

        @Override
        public Hierarchy evaluateHierarchy(Evaluator evaluator) {
            Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
            Hierarchy hierarchy = FunUtil.getDimensionDefaultHierarchy(dimension);
            if (hierarchy != null) {
                return hierarchy;
            }
            throw FunUtil.newEvalException(MondrianResource.instance().CannotImplicitlyConvertDimensionToHierarchy.ex(dimension.getName()));
        }
    }

    private static class ParameterSlotImpl
    implements ParameterSlot {
        private final Parameter parameter;
        private final int index;
        private Calc defaultValueCalc;
        private Object value;
        private boolean assigned;
        private Object cachedDefaultValue;

        public ParameterSlotImpl(Parameter parameter, int index) {
            this.parameter = parameter;
            this.index = index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Calc getDefaultValueCalc() {
            return this.defaultValueCalc;
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        private void setDefaultValueCalc(Calc calc) {
            this.defaultValueCalc = calc;
        }

        @Override
        public void setParameterValue(Object value, boolean assigned) {
            this.value = value;
            this.assigned = assigned;
            assert (!(value instanceof List) || value instanceof TupleList);
            assert (!(value instanceof MemberExpr));
            assert (!(value instanceof Literal));
        }

        @Override
        public Object getParameterValue() {
            return this.value;
        }

        @Override
        public boolean isParameterSet() {
            return this.assigned;
        }

        @Override
        public void unsetParameterValue() {
            this.value = null;
            this.assigned = false;
        }

        @Override
        public void setCachedDefaultValue(Object value) {
            this.cachedDefaultValue = value;
        }

        @Override
        public Object getCachedDefaultValue() {
            return this.cachedDefaultValue;
        }
    }
}

