/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl.plugins;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.pentaho.requirejs.IRequireJsPackageConfiguration;
import org.pentaho.requirejs.IRequireJsPackageConfigurationPlugin;

public class ModulesInfoPluginConfig
implements IRequireJsPackageConfigurationPlugin {
    public void apply(IRequireJsPackageConfiguration requireJsPackageConfig, Function<String, IRequireJsPackageConfiguration> dependencyResolver, Function<String, String> resolveModuleId, Map<String, ?> requireConfig) {
        if (requireConfig.containsKey("config")) {
            Map config = (Map)requireConfig.get("config");
            config.forEach((moduleId, configuration) -> {
                if (moduleId.equals("pentaho/modules")) {
                    Map<String, ?> processedConfiguration = this.convertModulesConfigurations((Map<String, ?>)configuration, resolveModuleId);
                    config.put(moduleId, processedConfiguration);
                }
            });
        }
    }

    private Map<String, ?> convertModulesConfigurations(Map<String, ?> configuration, Function<String, String> resolveModuleId) {
        HashMap<String, Map> convertedConfiguration = new HashMap<String, Map>();
        for (String moduleId : configuration.keySet()) {
            String versionedModuleId = resolveModuleId.apply(moduleId);
            Map config = (Map)configuration.get(moduleId);
            config.forEach((key, value) -> {
                if ((key.equals("base") || key.equals("type")) && value != null) {
                    String versionedType = (String)resolveModuleId.apply((String)value);
                    config.put(key, versionedType);
                }
            });
            convertedConfiguration.put(versionedModuleId, config);
        }
        return convertedConfiguration;
    }
}

