/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.legacy.charts.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Second;
import org.jfree.data.time.Year;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DateTimeUnitPropertyEditor
implements PropertyEditor {
    private static final Map<Class, String> tagMap;
    private static final String MILLISECOND = "Millisecond";
    private static final String SECOND = "Second";
    private static final String MINUTE = "Minute";
    private static final String HOUR = "Hour";
    private static final String DAY = "Day";
    private static final String MONTH = "Month";
    private static final String YEAR = "Year";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Class value;

    @Override
    public void setValue(Object value) {
        Class oldValue = this.value;
        this.value = value instanceof Class ? (Class)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return tagMap.get(this.value);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        for (Map.Entry<Class, String> o : tagMap.entrySet()) {
            if (!ObjectUtilities.equal((Object)o.getValue(), (Object)text)) continue;
            this.setValue(o.getKey());
            return;
        }
        this.setValue(null);
    }

    @Override
    public String[] getTags() {
        return new String[]{null, MILLISECOND, SECOND, MINUTE, HOUR, DAY, MONTH, YEAR};
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    static {
        HashMap<Class<Year>, String> hashMap = new HashMap<Class<Year>, String>();
        hashMap.put(Millisecond.class, MILLISECOND);
        hashMap.put(Second.class, SECOND);
        hashMap.put(Minute.class, MINUTE);
        hashMap.put(Hour.class, HOUR);
        hashMap.put(Day.class, DAY);
        hashMap.put(Month.class, MONTH);
        hashMap.put(Year.class, YEAR);
        tagMap = Collections.unmodifiableMap(hashMap);
    }
}

