/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    private static RTFTransfer _instance = new RTFTransfer();
    private static final String CF_RTF = "Rich Text Format";
    private static final int CF_RTFID = RTFTransfer.registerType("Rich Text Format");

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int n = string.length();
        char[] cArray = new char[n + 1];
        string.getChars(0, n, cArray, 0);
        int n2 = OS.GetACP();
        int n3 = OS.WideCharToMultiByte(n2, 0, cArray, -1, null, 0, null, null);
        if (n3 == 0) {
            transferData.stgmedium = new STGMEDIUM();
            transferData.result = -2147221402;
            return;
        }
        int n4 = OS.GlobalAlloc(64, n3);
        OS.WideCharToMultiByte(n2, 0, cArray, -1, n4, n3, null, null);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = n4;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        FORMATETC fORMATETC = transferData.formatetc;
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int n = sTGMEDIUM.unionField;
        try {
            int n2;
            int n3;
            int n4;
            block12: {
                Object var9_10;
                n4 = OS.GlobalLock(n);
                if (n4 == 0) {
                    Object var7_7 = null;
                    return var7_7;
                }
                try {
                    n3 = OS.GetACP();
                    n2 = OS.MultiByteToWideChar(n3, 1, n4, -1, null, 0);
                    if (n2 != 0) break block12;
                    var9_10 = null;
                }
                catch (Throwable throwable) {
                    OS.GlobalUnlock(n);
                    throw throwable;
                }
                OS.GlobalUnlock(n);
                return var9_10;
            }
            char[] cArray = new char[n2 - 1];
            OS.MultiByteToWideChar(n3, 1, n4, -1, cArray, cArray.length);
            String string = new String(cArray);
            OS.GlobalUnlock(n);
            return string;
        }
        finally {
            OS.GlobalFree(n);
        }
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{CF_RTFID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{CF_RTF};
    }

    boolean checkRTF(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }
}

