/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.pentaho;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.engine.configuration.api.RunConfigurationDialog;
import org.pentaho.di.engine.configuration.api.RunConfigurationUI;
import org.pentaho.di.engine.configuration.impl.pentaho.DefaultRunConfiguration;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.spoon.Spoon;

public class DefaultRunConfigurationUI
implements RunConfigurationUI {
    private static final String CLUSTERED = "Clustered";
    private static Class<?> PKG = DefaultRunConfigurationUI.class;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private PropsUI props = PropsUI.getInstance();
    private DefaultRunConfiguration defaultRunConfiguration;
    private RunConfigurationDialog runConfigurationDialog;
    private CCombo wcSlaveServer;

    public DefaultRunConfigurationUI(DefaultRunConfiguration defaultRunConfiguration) {
        this.defaultRunConfiguration = defaultRunConfiguration;
    }

    public void attach(RunConfigurationDialog runConfigurationDialog) {
        this.runConfigurationDialog = runConfigurationDialog;
        FormLayout gformLayout = new FormLayout();
        gformLayout.marginWidth = 10;
        gformLayout.marginHeight = 10;
        runConfigurationDialog.getGroup().setLayout((Layout)gformLayout);
        Composite wTarget = new Composite((Composite)runConfigurationDialog.getGroup(), 0);
        wTarget.setLayout((Layout)new FormLayout());
        this.props.setLook((Control)wTarget);
        final Button wbLocal = new Button(wTarget, 16);
        this.props.setLook((Control)wbLocal);
        wbLocal.setText(BaseMessages.getString(PKG, (String)"DefaultRunConfigurationDialog.Label.Local", (String[])new String[0]));
        wbLocal.setSelection(this.defaultRunConfiguration.isLocal());
        FormData fdbLocal = new FormData();
        fdbLocal.top = new FormAttachment(0);
        fdbLocal.left = new FormAttachment(0);
        wbLocal.setLayoutData((Object)fdbLocal);
        final Button wbPentaho = new Button(wTarget, 16);
        this.props.setLook((Control)wbPentaho);
        boolean connectedToPentahoServer = this.spoonSupplier.get().getRepository() != null && this.spoonSupplier.get().getRepository().getRepositoryMeta().getId().equals("PentahoEnterpriseRepository");
        wbPentaho.setVisible(connectedToPentahoServer);
        if (connectedToPentahoServer) {
            wbPentaho.setText(BaseMessages.getString(PKG, (String)"DefaultRunConfigurationDialog.Label.Pentaho", (String[])new String[0]));
            wbPentaho.setSelection(this.defaultRunConfiguration.isPentaho());
            FormData fdbPentaho = new FormData();
            fdbPentaho.top = new FormAttachment((Control)wbLocal, 10);
            fdbPentaho.left = new FormAttachment(0);
            wbPentaho.setLayoutData((Object)fdbPentaho);
        }
        final Button wbRemote = new Button(wTarget, 16);
        this.props.setLook((Control)wbRemote);
        wbRemote.setText(BaseMessages.getString(PKG, (String)"DefaultRunConfigurationDialog.Label.Remote", (String[])new String[0]));
        wbRemote.setSelection(this.defaultRunConfiguration.isRemote() || this.defaultRunConfiguration.isClustered());
        FormData fdbRemote = new FormData();
        fdbRemote.top = new FormAttachment((Control)wbPentaho, 10);
        fdbRemote.left = new FormAttachment(0);
        wbRemote.setLayoutData((Object)fdbRemote);
        FormData fdTarget = new FormData();
        fdTarget.left = new FormAttachment(0);
        fdTarget.top = new FormAttachment(0);
        wTarget.setLayoutData((Object)fdTarget);
        Label vSpacer = new Label((Composite)runConfigurationDialog.getGroup(), 514);
        FormData fdvSpacer = new FormData();
        fdvSpacer.width = 1;
        fdvSpacer.left = new FormAttachment((Control)wTarget, 30);
        fdvSpacer.top = new FormAttachment(0, 0);
        fdvSpacer.bottom = new FormAttachment(100, 0);
        vSpacer.setLayoutData((Object)fdvSpacer);
        final Composite wcLocal = new Composite((Composite)runConfigurationDialog.getGroup(), 0);
        this.props.setLook((Control)wcLocal);
        wcLocal.setLayout((Layout)new GridLayout());
        Text wlLocal = new Text(wcLocal, 66);
        wlLocal.setEditable(false);
        this.props.setLook((Control)wlLocal);
        wlLocal.setText(BaseMessages.getString(PKG, (String)"DefaultRunConfigurationDialog.Text.Local", (String[])new String[0]));
        GridData gdlLocal = new GridData(768);
        gdlLocal.widthHint = 200;
        wlLocal.setLayoutData((Object)gdlLocal);
        FormData fdcLocal = new FormData();
        fdcLocal.left = new FormAttachment((Control)vSpacer, 10);
        fdcLocal.top = new FormAttachment(0);
        fdcLocal.right = new FormAttachment(100);
        fdcLocal.bottom = new FormAttachment(100);
        wcLocal.setLayoutData((Object)fdcLocal);
        final Composite wcPentaho = new Composite((Composite)runConfigurationDialog.getGroup(), 0);
        this.props.setLook((Control)wcPentaho);
        wcPentaho.setLayout((Layout)new GridLayout());
        Text wlPentaho = new Text(wcPentaho, 16450);
        wlPentaho.setEditable(false);
        this.props.setLook((Control)wlPentaho);
        wlPentaho.setText(BaseMessages.getString(PKG, (String)"DefaultRunConfigurationDialog.Text.Pentaho", (String[])new String[0]));
        GridData gdlPentaho = new GridData(768);
        gdlPentaho.widthHint = 200;
        wlPentaho.setLayoutData((Object)gdlPentaho);
        FormData fdcPentaho = new FormData();
        fdcPentaho.left = new FormAttachment((Control)vSpacer, 10);
        fdcPentaho.top = new FormAttachment(0);
        fdcPentaho.right = new FormAttachment(100);
        fdcPentaho.bottom = new FormAttachment(100);
        wcPentaho.setLayoutData((Object)fdcPentaho);
        final Composite wcRemote = new Composite((Composite)runConfigurationDialog.getGroup(), 0);
        this.props.setLook((Control)wcRemote);
        wcRemote.setLayout((Layout)new FormLayout());
        Label wlRemote = new Label(wcRemote, 16384);
        this.props.setLook((Control)wlRemote);
        wlRemote.setText(BaseMessages.getString(PKG, (String)"DefaultRunConfigurationDialog.Label.Location", (String[])new String[0]));
        FormData fdlRemote = new FormData();
        fdlRemote.left = new FormAttachment(0);
        fdlRemote.top = new FormAttachment(0);
        wlRemote.setLayoutData((Object)fdlRemote);
        this.wcSlaveServer = new CCombo(wcRemote, 2060);
        this.props.setLook((Control)this.wcSlaveServer);
        FormData fdSlaveServer = new FormData();
        fdSlaveServer.width = 150;
        fdSlaveServer.top = new FormAttachment((Control)wlRemote, 5);
        fdSlaveServer.left = new FormAttachment(0);
        this.wcSlaveServer.setLayoutData((Object)fdSlaveServer);
        final Button wbSendResources = new Button(wcRemote, 32);
        wbSendResources.setSelection(this.defaultRunConfiguration.isSendResources());
        wbSendResources.setVisible(!Utils.isEmpty((CharSequence)this.defaultRunConfiguration.getServer()) && !this.defaultRunConfiguration.isClustered());
        this.props.setLook((Control)wbSendResources);
        wbSendResources.setText(BaseMessages.getString(PKG, (String)"DefaultRunConfigurationDialog.Button.SendResources", (String[])new String[0]));
        FormData fdbSendResources = new FormData();
        fdbSendResources.top = new FormAttachment((Control)this.wcSlaveServer, 10);
        fdbSendResources.left = new FormAttachment(0);
        wbSendResources.setLayoutData((Object)fdbSendResources);
        wbSendResources.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setSendResources(wbSendResources.getSelection());
            }
        });
        final Button wbLogRemoteExecutionLocally = new Button(wcRemote, 32);
        wbLogRemoteExecutionLocally.setSelection(this.defaultRunConfiguration.isLogRemoteExecutionLocally());
        wbLogRemoteExecutionLocally.setVisible(this.defaultRunConfiguration.isClustered());
        this.props.setLook((Control)wbLogRemoteExecutionLocally);
        wbLogRemoteExecutionLocally.setText(BaseMessages.getString(PKG, (String)"DefaultRunConfigurationDialog.Checkbox.LogRemoteExecutionLocally", (String[])new String[0]));
        FormData fdbLogRemoteExecutionLocally = new FormData();
        fdbLogRemoteExecutionLocally.top = new FormAttachment((Control)this.wcSlaveServer, 10);
        fdbLogRemoteExecutionLocally.left = new FormAttachment(0);
        wbLogRemoteExecutionLocally.setLayoutData((Object)fdbLogRemoteExecutionLocally);
        wbLogRemoteExecutionLocally.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setLogRemoteExecutionLocally(wbLogRemoteExecutionLocally.getSelection());
            }
        });
        final Button wbShowTransformations = new Button(wcRemote, 32);
        wbShowTransformations.setSelection(this.defaultRunConfiguration.isShowTransformations());
        wbShowTransformations.setVisible(this.defaultRunConfiguration.isClustered());
        this.props.setLook((Control)wbShowTransformations);
        wbShowTransformations.setText(BaseMessages.getString(PKG, (String)"DefaultRunConfigurationDialog.Checkbox.ShowTransformation", (String[])new String[0]));
        FormData fdbShowTransformations = new FormData();
        fdbShowTransformations.top = new FormAttachment((Control)wbLogRemoteExecutionLocally, 10);
        fdbShowTransformations.left = new FormAttachment(0);
        wbShowTransformations.setLayoutData((Object)fdbShowTransformations);
        wbShowTransformations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setShowTransformations(wbShowTransformations.getSelection());
            }
        });
        FormData fdcRemote = new FormData();
        fdcRemote.left = new FormAttachment((Control)vSpacer, 20);
        fdcRemote.top = new FormAttachment(0);
        fdcRemote.right = new FormAttachment(100);
        fdcRemote.bottom = new FormAttachment(100);
        wcRemote.setLayoutData((Object)fdcRemote);
        final AbstractMeta meta = (AbstractMeta)this.spoonSupplier.get().getActiveMeta();
        if (meta instanceof TransMeta && !Utils.isEmpty((List)((TransMeta)meta).getClusterSchemas())) {
            this.wcSlaveServer.add(CLUSTERED);
        }
        for (int i = 0; i < meta.getSlaveServers().size(); ++i) {
            SlaveServer slaveServer = (SlaveServer)meta.getSlaveServers().get(i);
            this.wcSlaveServer.add(slaveServer.toString());
        }
        if (!Utils.isEmpty((CharSequence)this.defaultRunConfiguration.getServer())) {
            this.wcSlaveServer.setText(this.defaultRunConfiguration.getServer());
        }
        wcLocal.setVisible(this.defaultRunConfiguration.isLocal());
        wcPentaho.setVisible(this.defaultRunConfiguration.isPentaho());
        wcRemote.setVisible(this.defaultRunConfiguration.isRemote() || this.defaultRunConfiguration.isClustered());
        this.wcSlaveServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (DefaultRunConfigurationUI.this.wcSlaveServer.getText().equals(DefaultRunConfigurationUI.CLUSTERED)) {
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setClustered(true);
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setLocal(false);
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setRemote(false);
                    wbLogRemoteExecutionLocally.setVisible(true);
                    wbShowTransformations.setVisible(true);
                    wbSendResources.setVisible(false);
                } else {
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setRemote(true);
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setLocal(false);
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setClustered(false);
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setServer(DefaultRunConfigurationUI.this.wcSlaveServer.getText());
                    wbLogRemoteExecutionLocally.setVisible(false);
                    wbShowTransformations.setVisible(false);
                    wbSendResources.setVisible(true);
                }
                DefaultRunConfigurationUI.this.checkOKEnabled();
            }
        });
        wbLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                wcLocal.setVisible(wbLocal.getSelection());
                wcPentaho.setVisible(wbPentaho.getSelection());
                wcRemote.setVisible(wbRemote.getSelection());
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setLocal(true);
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setPentaho(false);
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setRemote(false);
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setClustered(false);
                DefaultRunConfigurationUI.this.checkOKEnabled();
            }
        });
        wbPentaho.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                wcLocal.setVisible(wbLocal.getSelection());
                wcPentaho.setVisible(wbPentaho.getSelection());
                wcRemote.setVisible(wbRemote.getSelection());
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setLocal(false);
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setPentaho(true);
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setRemote(false);
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setClustered(false);
                DefaultRunConfigurationUI.this.checkOKEnabled();
            }
        });
        wbRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                wcLocal.setVisible(wbLocal.getSelection());
                wcPentaho.setVisible(wbPentaho.getSelection());
                wcRemote.setVisible(wbRemote.getSelection());
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setLocal(false);
                DefaultRunConfigurationUI.this.defaultRunConfiguration.setPentaho(false);
                if (Utils.isEmpty((CharSequence)DefaultRunConfigurationUI.this.wcSlaveServer.getText())) {
                    if (meta instanceof TransMeta && !Utils.isEmpty((List)((TransMeta)meta).getClusterSchemas())) {
                        DefaultRunConfigurationUI.this.wcSlaveServer.setText(DefaultRunConfigurationUI.CLUSTERED);
                    } else if (meta.getSlaveServers().size() > 0) {
                        DefaultRunConfigurationUI.this.wcSlaveServer.setText(((SlaveServer)meta.getSlaveServers().get(0)).getName());
                    }
                }
                if (!DefaultRunConfigurationUI.this.wcSlaveServer.getText().equals(DefaultRunConfigurationUI.CLUSTERED)) {
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setRemote(true);
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setClustered(false);
                    wbSendResources.setVisible(true);
                    wbShowTransformations.setVisible(false);
                    wbLogRemoteExecutionLocally.setVisible(false);
                } else {
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setClustered(true);
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setRemote(false);
                    wbSendResources.setVisible(false);
                    wbShowTransformations.setVisible(true);
                    wbLogRemoteExecutionLocally.setVisible(true);
                }
                DefaultRunConfigurationUI.this.checkOKEnabled();
                if (!Utils.isEmpty((CharSequence)DefaultRunConfigurationUI.this.wcSlaveServer.getText())) {
                    DefaultRunConfigurationUI.this.defaultRunConfiguration.setServer(DefaultRunConfigurationUI.this.wcSlaveServer.getText());
                }
            }
        });
        if (this.defaultRunConfiguration.isClustered()) {
            this.wcSlaveServer.setText(CLUSTERED);
            wbSendResources.setVisible(false);
            wbShowTransformations.setVisible(true);
            wbLogRemoteExecutionLocally.setVisible(true);
        }
    }

    public void checkOKEnabled() {
        if (this.defaultRunConfiguration.isRemote() && Utils.isEmpty((CharSequence)this.wcSlaveServer.getText()) || Utils.isEmpty((CharSequence)this.runConfigurationDialog.getName().getText())) {
            this.runConfigurationDialog.getOKButton().setEnabled(false);
        } else {
            this.runConfigurationDialog.getOKButton().setEnabled(true);
        }
    }
}

