/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabFactHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class BeginCrosstabColumnAxisHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new BeginCrosstabColumnAxisHandler();

    private BeginCrosstabColumnAxisHandler() {
    }

    @Override
    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState next = state.deriveForAdvance();
        next.enterGroup();
        next.crosstabIncrementColumnCounter();
        next.fireReportEvent();
        next.enterPresentationGroup();
        return next;
    }

    @Override
    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        Group group = next.getReport().getGroup(next.getCurrentGroupIndex());
        GroupBody body = group.getBody();
        if (body instanceof CrosstabColumnGroupBody) {
            next.setAdvanceHandler(HANDLER);
        } else if (body instanceof CrosstabCellBody) {
            next.setAdvanceHandler(BeginCrosstabFactHandler.HANDLER);
        } else {
            throw new IllegalStateException("This report is totally messed up!");
        }
        return next;
    }

    @Override
    public boolean isFinish() {
        return false;
    }

    @Override
    public int getEventCode() {
        return 0x810008;
    }

    @Override
    public boolean isRestoreHandler() {
        return false;
    }
}

