/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.parameters.FormulaParameterEvaluator;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.Messages;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterUtils;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterValues;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationMessage;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.PerformanceLoggingStopWatch;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultReportParameterValidator
implements ReportParameterValidator {
    private static final Log logger = LogFactory.getLog(DefaultReportParameterValidator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidationResult validate(ValidationResult result, ReportParameterDefinition parameterDefinition, ParameterContext parameterContext) throws ReportProcessingException {
        if (parameterContext == null) {
            throw new NullPointerException();
        }
        if (parameterDefinition == null) {
            throw new NullPointerException();
        }
        if (result == null) {
            result = new ValidationResult();
        }
        try (PerformanceLoggingStopWatch sw = parameterContext.getPerformanceMonitorContext().createStopWatch("pentaho.report.parameter");){
            sw.start();
            TrustedParameterContext trustedParameterContext = new TrustedParameterContext(parameterContext);
            ParameterDefinitionEntry[] parameterDefinitionEntries = parameterDefinition.getParameterDefinitions();
            for (int i = 0; i < parameterDefinitionEntries.length; ++i) {
                ParameterDefinitionEntry parameterDefinitionEntry = parameterDefinitionEntries[i];
                String parameterName = parameterDefinitionEntry.getName();
                Object untrustedValue = parameterContext.getParameterData().get(parameterName);
                this.validateSingleParameter(result, trustedParameterContext, parameterDefinitionEntry, untrustedValue);
            }
            result.setParameterValues(trustedParameterContext.getTrustedValues());
            ValidationResult validationResult = result;
            return validationResult;
        }
    }

    private void validateSingleParameter(ValidationResult result, TrustedParameterContext trustedParameterContext, ParameterDefinitionEntry parameterDefinitionEntry, Object untrustedValue) throws ReportProcessingException {
        Class<Object> parameterType;
        Object[] values;
        boolean reevaluatePossible = untrustedValue != null;
        Object defaultValue = null;
        if (untrustedValue == null) {
            untrustedValue = defaultValue = parameterDefinitionEntry.getDefaultValue(trustedParameterContext);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("On Validate Single Parameter: " + parameterDefinitionEntry.getName()));
            logger.debug((Object)("On Validate Single Parameter: " + trustedParameterContext.getParameterData()));
            logger.debug((Object)("On Validate Single Parameter: " + untrustedValue));
            logger.debug((Object)"On Validate Single Parameter: ------------------------------");
        }
        String parameterName = parameterDefinitionEntry.getName();
        ReportParameterValues tempValue = new ReportParameterValues(trustedParameterContext.getTrustedValues());
        tempValue.put(parameterName, untrustedValue);
        Object computedValue = FormulaParameterEvaluator.computePostProcessingValue(result, trustedParameterContext, tempValue, parameterDefinitionEntry, untrustedValue, defaultValue);
        Locale locale = ParameterUtils.getLocale(trustedParameterContext.getReportEnvironment());
        if (this.isValueMissingForMandatoryParameterCheck(parameterDefinitionEntry, computedValue)) {
            trustedParameterContext.getTrustedValues().put(parameterName, null);
            result.addError(parameterName, new ValidationMessage(Messages.getInstance(locale).getString("DefaultReportParameterValidator.ParameterIsMandatory")));
            return;
        }
        if (!(parameterDefinitionEntry instanceof ListParameter)) {
            Class parameterType2;
            if (computedValue != null && !(parameterType2 = parameterDefinitionEntry.getValueType()).isInstance(computedValue)) {
                logger.warn((Object)("Parameter validation error: Value cannot be matched due to invalid value type '" + parameterDefinitionEntry.getName() + "' with value '" + computedValue + "'"));
                result.addError(parameterName, new ValidationMessage(Messages.getInstance(locale).getString("DefaultReportParameterValidator.ParameterIsInvalidType")));
                trustedParameterContext.getTrustedValues().put(parameterName, null);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("On Validate Single Parameter: = " + computedValue));
                logger.debug((Object)"On Validate Single Parameter: ------------------------------");
            }
            trustedParameterContext.getTrustedValues().put(parameterName, computedValue);
            return;
        }
        ListParameter listParameter = (ListParameter)parameterDefinitionEntry;
        if (listParameter.isAllowMultiSelection()) {
            if (computedValue == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"On Validate Single Parameter: = new Object[0]");
                    logger.debug((Object)"On Validate Single Parameter: ------------------------------");
                }
                trustedParameterContext.getTrustedValues().put(parameterName, new Object[0]);
                return;
            }
            if (!(computedValue instanceof Object[])) {
                result.addError(parameterName, new ValidationMessage(Messages.getInstance(locale).getString("DefaultReportParameterValidator.ParameterIsNotAnArray")));
                trustedParameterContext.getTrustedValues().put(parameterName, null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("On Validate Single Parameter: = " + null));
                    logger.debug((Object)"On Validate Single Parameter: ------------------------------");
                }
                return;
            }
            values = (Object[])computedValue;
            parameterType = listParameter.getValueType().isArray() ? listParameter.getValueType().getComponentType() : listParameter.getValueType();
        } else {
            values = new Object[]{computedValue};
            parameterType = listParameter.getValueType();
        }
        ValidationMessage message = this.computeValidListValue(listParameter, trustedParameterContext, parameterType, values, locale);
        if (message != null) {
            if (reevaluatePossible && "true".equals(listParameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "re-evaluate-on-failed-values", trustedParameterContext))) {
                this.validateSingleParameter(result, trustedParameterContext, listParameter, null);
            } else {
                result.addError(parameterName, message);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"On Validate Single Parameter: = null");
                    logger.debug((Object)"On Validate Single Parameter: ------------------------------");
                }
                trustedParameterContext.getTrustedValues().put(parameterName, null);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("On Validate Single Parameter: = " + computedValue));
                logger.debug((Object)"On Validate Single Parameter: ------------------------------");
            }
            trustedParameterContext.getTrustedValues().put(parameterName, computedValue);
        }
    }

    private ValidationMessage computeValidListValue(ListParameter listParameter, ParameterContext parameterContext, Class parameterType, Object[] values, Locale locale) throws ReportDataFactoryException {
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value != null) {
                if ("".equals(value)) {
                    value = null;
                } else if (!parameterType.isInstance(value)) {
                    logger.warn((Object)("Parameter validation error: Value cannot be matched due to invalid value type '" + listParameter.getName() + "' with value '" + value + "'"));
                    return new ValidationMessage(Messages.getInstance(locale).getString("DefaultReportParameterValidator.ParameterIsInvalidType"));
                }
            }
            if (!listParameter.isStrictValueCheck()) continue;
            try {
                ParameterValues parameterValues = listParameter.getValues(parameterContext);
                boolean found = this.isValueValid(parameterValues, value);
                if (found) continue;
                logger.warn((Object)("Parameter validation error: No such value in the result for '" + listParameter.getName() + "' with value '" + value + "'"));
                return new ValidationMessage(Messages.getInstance(locale).getString("DefaultReportParameterValidator.ParameterIsInvalidValue"));
            }
            catch (ReportDataFactoryException e) {
                throw e;
            }
            catch (Throwable e) {
                logger.warn((Object)"Unexpected Parameter validation error", e);
                return new ValidationMessage(Messages.getInstance(locale).getString("DefaultReportParameterValidator.GlobalError"));
            }
        }
        return null;
    }

    private boolean isValueMissingForMandatoryParameterCheck(ParameterDefinitionEntry entry, Object computedValue) {
        ListParameter listParameter;
        if (!entry.isMandatory()) {
            return false;
        }
        if (computedValue == null || "".equals(computedValue)) {
            return true;
        }
        if (entry instanceof ListParameter && (listParameter = (ListParameter)entry).isAllowMultiSelection()) {
            if (!(computedValue instanceof Object[])) {
                return false;
            }
            if (Array.getLength(computedValue) == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean isValueValid(ParameterValues parameterValues, Object o) {
        if (parameterValues == null) {
            throw new NullPointerException();
        }
        for (int row = 0; row < parameterValues.getRowCount(); ++row) {
            Object keyFromData = parameterValues.getKeyValue(row);
            if (o instanceof Number && keyFromData instanceof Number) {
                BigDecimal n2;
                BigDecimal n1 = new BigDecimal(String.valueOf(o));
                if (n1.compareTo(n2 = new BigDecimal(String.valueOf(keyFromData))) != 0) continue;
                return true;
            }
            if (o instanceof Date && keyFromData instanceof Date) {
                Date d1 = (Date)o;
                Date d2 = (Date)keyFromData;
                if (d1.getTime() != d2.getTime()) continue;
                return true;
            }
            if (!("".equals(keyFromData) ? o == null : ObjectUtilities.equal((Object)keyFromData, (Object)o))) continue;
            return true;
        }
        return false;
    }

    private static class TrustedParameterContext
    implements ParameterContext {
        private ParameterContext context;
        private ReportEnvironmentDataRow environmentDataRow;
        private ReportParameterValues trustedValues;

        private TrustedParameterContext(ParameterContext context) {
            this.context = context;
            this.environmentDataRow = new ReportEnvironmentDataRow(context.getReportEnvironment());
            this.trustedValues = new ReportParameterValues();
        }

        @Override
        public DataRow getParameterData() {
            return new CompoundDataRow(this.environmentDataRow, this.trustedValues);
        }

        public ReportParameterValues getTrustedValues() {
            return this.trustedValues;
        }

        @Override
        public DocumentMetaData getDocumentMetaData() {
            return this.context.getDocumentMetaData();
        }

        @Override
        public ReportEnvironment getReportEnvironment() {
            return this.context.getReportEnvironment();
        }

        @Override
        public DataFactory getDataFactory() {
            return this.context.getDataFactory();
        }

        @Override
        public ResourceBundleFactory getResourceBundleFactory() {
            return this.context.getResourceBundleFactory();
        }

        @Override
        public ResourceKey getContentBase() {
            return this.context.getContentBase();
        }

        @Override
        public ResourceManager getResourceManager() {
            return this.context.getResourceManager();
        }

        @Override
        public Configuration getConfiguration() {
            return this.context.getConfiguration();
        }

        @Override
        public void close() throws ReportDataFactoryException {
        }

        @Override
        public PerformanceMonitorContext getPerformanceMonitorContext() {
            return this.context.getPerformanceMonitorContext();
        }
    }
}

